package bigloo;

import java.lang.*;
import java.io.IOException;
import java.net.*;
import java.lang.reflect.*;

public abstract class JDK {
   private static JDK impl;
   static{
      // are we 1.6?
      try {
	 Class.forName("java.text.spi.BreakIteratorProvider");
	 impl = getImpl("bigloo.JDK16");
      } catch(Exception x) {}

      // are we 1.5?
      if (impl == null)
	 try {
	    Class.forName("java.lang.ProcessBuilder");
	    impl = getImpl("bigloo.JDK15");
	 } catch(Exception x) {}
      
      if (impl == null)
	 // try 1.4
	 try {
	    Class.forName("java.nio.Buffer");
	    impl = getImpl("bigloo.JDK14");
	 } catch(Exception x) {}
    
      // default is 1.3
      if (impl == null)
	 try {
	    impl = getImpl("bigloo.JDK13");
	 } catch(Exception x) {}
   }

   private static JDK getImpl(String classname) {
      try {
	 Class c = Class.forName(classname);
	 return (JDK)c.newInstance();
      } catch (Exception x) {
	 return null;
      }
   }

   // Static methods

   public static Method getDeclaredMethod(Class c, byte[] m)
      throws Exception {
      return impl.getDeclaredMethodImpl(c, m);
   }
   
   public static Object invoke(Method m)
      throws Exception {
      return impl.invokeImpl(m);
   }
   
   public static ServerSocket makeServerSocket(String name, int port)
      throws IOException {
      return impl.makeServerSocketImpl(name, port);
   }

   public static Socket accept(ServerSocket sock, boolean blocking)
      throws IOException {
      return impl.acceptImpl(sock, blocking);
   }
   
   public abstract Method getDeclaredMethodImpl(Class c, byte[] m) throws Exception;
   public abstract Object invokeImpl(Method m) throws Exception;
   public abstract ServerSocket makeServerSocketImpl(String name, int port) throws IOException;
   public abstract Socket acceptImpl(ServerSocket sock, boolean blocking) throws IOException;
}
