/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cthread.c               */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Oct  6 11:49:21 2004                          */
/*    Last change :  Tue May 16 10:09:40 2006 (serrano)                */
/*    Copyright   :  2004-06 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Thread tools (mutex, condition-variable, ...).                   */
/*    -------------------------------------------------------------    */
/*    This file does not presuppose any thread implementation.         */
/*    In particular, it does not presuppose that the underlying        */
/*    implementation is pthread nor pth. This implementation looks     */
/*    like an dummy implementation. It is just a kind of placeholder   */
/*    for Bigloo threads implementations.                              */
/*=====================================================================*/
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Default functions ...                                            */
/*---------------------------------------------------------------------*/
static obj_t bgl_init_default( obj_t o ) { return o; }

static void bgl_act0_default( void ) { return; }
static bool_t bgl_act_default( obj_t o ) { return 1; }
static bool_t bgl_act2_default( obj_t o1, obj_t o2 ) { return 1; }
static bool_t bgl_act2long_default( obj_t o1, long o2 ) { return 1; }
static bool_t bgl_act3long_default( obj_t o1, obj_t o2, long o3 ) { return 1; }

/*---------------------------------------------------------------------*/
/*    Single threaded dynamic environment ...                          */
/*---------------------------------------------------------------------*/
bgldenv_t single_thread_denv = 0L;

static bgldenv_t denv_get() { return 0; }

/*---------------------------------------------------------------------*/
/*    Thread registers                                                 */
/*---------------------------------------------------------------------*/
static obj_t (*bgl_mutex_init)( obj_t ) = &bgl_init_default;
static obj_t (*bgl_condvar_init)( obj_t ) = &bgl_init_default;

BGL_RUNTIME_DEF void (*bgl_gc_start_blocking)( void ) = &bgl_act0_default;
BGL_RUNTIME_DEF void (*bgl_gc_stop_blocking)( void ) = &bgl_act0_default;

BGL_RUNTIME_DEF bool_t (*bgl_mutex_lock)( obj_t ) = &bgl_act_default;
BGL_RUNTIME_DEF bool_t (*bgl_mutex_timed_lock)( obj_t, long ) = &bgl_act2long_default;
BGL_RUNTIME_DEF bool_t (*bgl_mutex_unlock)( obj_t ) = &bgl_act_default;

BGL_RUNTIME_DEF bool_t (*bgl_condvar_wait)( obj_t, obj_t ) = &bgl_act2_default;
BGL_RUNTIME_DEF bool_t (*bgl_condvar_timed_wait)( obj_t, obj_t, long ) = &bgl_act3long_default;
BGL_RUNTIME_DEF bool_t (*bgl_condvar_signal)( obj_t ) = &bgl_act_default;
BGL_RUNTIME_DEF bool_t (*bgl_condvar_broadcast)( obj_t ) = &bgl_act_default;

BGL_RUNTIME_DEF bgldenv_t (*bgl_multithread_dynamic_denv)() = &denv_get;

/*---------------------------------------------------------------------*/
/*    Register functions ...                                           */
/*---------------------------------------------------------------------*/
#define REGISTER_FUNCTION( id, res, proto ) \
  BGL_RUNTIME_DEF void id##_register( res (*f)proto ) { id = f; }

REGISTER_FUNCTION( bgl_mutex_init, obj_t, (obj_t) )
REGISTER_FUNCTION( bgl_mutex_lock, bool_t, (obj_t) )
REGISTER_FUNCTION( bgl_mutex_timed_lock, bool_t, (obj_t, long) )
REGISTER_FUNCTION( bgl_mutex_unlock, bool_t, (obj_t) )

REGISTER_FUNCTION( bgl_condvar_init, obj_t, (obj_t) )
REGISTER_FUNCTION( bgl_condvar_wait, bool_t, (obj_t, obj_t) )
REGISTER_FUNCTION( bgl_condvar_timed_wait, bool_t, (obj_t, obj_t, long) )
REGISTER_FUNCTION( bgl_condvar_signal, bool_t, (obj_t) )
REGISTER_FUNCTION( bgl_condvar_broadcast, bool_t, (obj_t) )

REGISTER_FUNCTION( bgl_multithread_dynamic_denv, bgldenv_t, (void) );
		   
/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_make_mutex ...                                               */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_make_mutex( obj_t name ) {
   obj_t m = GC_MALLOC( BGL_MUTEX_SIZE );

   m->mutex_t.header = MAKE_HEADER( MUTEX_TYPE, BGL_MUTEX_SIZE );
   m->mutex_t.name = name;
   m->mutex_t.mutex = 0L;

   bgl_mutex_init( m );

   return BREF( m );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_make_nil_mutex ...                                           */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_make_nil_mutex() {
   obj_t m = GC_MALLOC( BGL_MUTEX_SIZE );

   m->mutex_t.header = MAKE_HEADER( MUTEX_TYPE, BGL_MUTEX_SIZE );
   m->mutex_t.name = BUNSPEC;
   m->mutex_t.mutex = 0L;

   return BREF( m );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_make_condvar ...                                             */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_make_condvar( obj_t name ) {
   obj_t m = GC_MALLOC( BGL_CONDVAR_SIZE );

   m->condvar_t.header = MAKE_HEADER( CONDVAR_TYPE, BGL_CONDVAR_SIZE );
   m->condvar_t.name = name;
   m->condvar_t.condvar = 0L;

   bgl_condvar_init( m );

   return BREF( m );
}

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bgl_make_nil_condvar ...                                         */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
obj_t
bgl_make_nil_condvar() {
   obj_t m = GC_MALLOC( BGL_CONDVAR_SIZE );

   m->condvar_t.header = MAKE_HEADER( CONDVAR_TYPE, BGL_CONDVAR_SIZE );
   m->condvar_t.name = BUNSPEC;
   m->condvar_t.condvar = 0L;

   return BREF( m );
}

/*---------------------------------------------------------------------*/
/*    bgldenv_t                                                        */
/*    make_dynamic_env ...                                             */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bgldenv_t
make_dynamic_env() {
   bgldenv_t env = (bgldenv_t)GC_MALLOC( sizeof( struct bgldenv ) );

   env->current_output_port = BUNSPEC;
   env->current_error_port = BUNSPEC;
   env->current_input_port = BUNSPEC;
   
   env->current_display = BUNSPEC;

   env->exitd_top = BFALSE;
   env->exitd_val = MAKE_PAIR( BUNSPEC, BUNSPEC );
   SET_CAR( env->exitd_val, MAKE_PAIR( BUNSPEC, BUNSPEC ) );
   env->exitd_stamp = BINT( 0 );
   env->befored_top = 0L;

   env->mvalues_number = 1;
   env->mvalues[ 0 ] = BUNSPEC;
   env->mvalues[ 1 ] = BUNSPEC;
   env->mvalues[ 2 ] = BUNSPEC;
   env->mvalues[ 3 ] = BUNSPEC;
   env->mvalues[ 4 ] = BUNSPEC;
   env->mvalues[ 5 ] = BUNSPEC;
   env->mvalues[ 6 ] = BUNSPEC;
   env->mvalues[ 7 ] = BUNSPEC;

   env->error_handler = BNIL;
   env->uncaught_exception_handler = BNIL;
   env->error_notifiers = BNIL;
   
   env->interrupt_notifier = BNIL;
   
   env->top_of_frame = 0L;
   env->top.symbol = BUNSPEC;
   env->top.link = 0;

   env->debug_alist = BNIL;

   env->current_thread = 0L;

   env->lexical_stack = BNIL;

   env->bytecode = BUNSPEC;
   env->module = BUNSPEC;

   env->parameters = BNIL;
   env->user_data = BNIL;

   return env;
}

/*---------------------------------------------------------------------*/
/*    bgldenv_t                                                        */
/*    bgl_dup_dynamic_env ...                                          */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF
bgldenv_t
bgl_dup_dynamic_env( bgldenv_t o ) {
   bgldenv_t env = make_dynamic_env();

   env->current_output_port = o->current_output_port;
   env->current_error_port = o->current_error_port;
   env->current_input_port = o->current_input_port;

   env->current_display = o->current_display;

   env->interrupt_notifier = o->interrupt_notifier;
   
   env->current_thread = o->current_thread;
   
   env->module = o->module;
   
   return env;
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bgl_init_dynamic_env ...                                         */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DEF void
bgl_init_dynamic_env() {
   static bgl_dynamic_env_init = 0;

   if( bgl_dynamic_env_init == 0 ) {
      bgl_dynamic_env_init = 1;
      single_thread_denv = make_dynamic_env();
   }
}
