;*=====================================================================*/
;*    serrano/prgm/project/bigloo/api/sqlite/src/Llib/sqlite.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Erick Gallesio                                    */
;*    Creation    :  Thu Nov 10 13:55:46 2005                          */
;*    Last change :  Thu Mar 23 09:45:55 2006 (serrano)                */
;*    Copyright   :  2005-06 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    SQLITE Scheme binding                                            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __sqlite_sqlite
   
   (option  (set! *dlopen-init* #t))
   
   (include "sqlite.sch")
   
   (export  (class sqlite
	       (%setup-sqlite!)
	       (path::bstring read-only (default ":memory:"))
	       ($builtin::$sqlite (default (%sqlite-nil))))
   
	    (%setup-sqlite! ::sqlite)
	    (%sqlite-nil::$sqlite)
	    (sqlite-close ::sqlite)

	    (sqlite-exec ::sqlite ::bstring . args)
	    (sqlite-eval ::sqlite ::procedure ::bstring . args)
	    (sqlite-map::pair-nil ::sqlite ::procedure ::bstring . args)
	    
	    (sqlite-table-informations ::sqlite name)
	    (sqlite-table-number-of-rows ::sqlite name)
	    (sqlite-table-name-of-columns ::sqlite name)
	    (sqlite-name-of-tables ::sqlite)
	    
	    (sqlite-format ::bstring . ::obj)
	    (sqlite-last-insert-rowid ::sqlite)))

;*---------------------------------------------------------------------*/
;*    object-display ::sqlite ...                                      */
;*---------------------------------------------------------------------*/
(define-method (object-display o::sqlite . port)
   (with-output-to-port (if (pair? port) (car port) (current-output-port))
      (lambda ()
         (with-access::sqlite o (path)
            (display* "#<sqlite:" path ">")))))

;*---------------------------------------------------------------------*/
;*    object-write ::sqlite ...                                        */
;*---------------------------------------------------------------------*/
(define-method (object-write o::sqlite . port)
   (with-output-to-port (if (pair? port) (car port) (current-output-port))
      (lambda ()
         (with-access::sqlite o (path)
            (display* "#<sqlite:" path ">")))))

;*---------------------------------------------------------------------*/
;*    object-print ::sqlite ...                                        */
;*---------------------------------------------------------------------*/
(define-method (object-print o::sqlite port print-slot)
   (object-write o port))

;*---------------------------------------------------------------------*/
;*    %sqlite-nil ...                                                  */
;*---------------------------------------------------------------------*/
(define (%sqlite-nil)
   ($sqlite-nil))

;*---------------------------------------------------------------------*/
;*    %setup-sqlite! ...                                               */
;*---------------------------------------------------------------------*/
(define (%setup-sqlite! o::sqlite)
   (with-access::sqlite o ($builtin path)
      (set! $builtin ($sqlite-open path))))

;*---------------------------------------------------------------------*/
;*    sqlite-close ...                                                 */
;*---------------------------------------------------------------------*/
(define (sqlite-close o::sqlite)
   (with-access::sqlite o ($builtin)
      ($sqlite-close $builtin o)
      (set! $builtin ($sqlite-nil))))

;*---------------------------------------------------------------------*/
;*    sqlite-exec ...                                                  */
;*---------------------------------------------------------------------*/
(define (sqlite-exec o::sqlite fmt::bstring . args)
   (if (null? args)
       ($sqlite-exec (sqlite-$builtin o) fmt o)
       ($sqlite-exec (sqlite-$builtin o) (apply sqlite-format fmt args) o)))

;*---------------------------------------------------------------------*/
;*    sqlite-eval ...                                                  */
;*---------------------------------------------------------------------*/
(define (sqlite-eval o::sqlite p::procedure fmt::bstring . args)
   (if (null? args)
       ($sqlite-eval (sqlite-$builtin o) p fmt o)
       ($sqlite-eval (sqlite-$builtin o) p (apply sqlite-format fmt args) o)))

;*---------------------------------------------------------------------*/
;*    sqlite-map ...                                                   */
;*---------------------------------------------------------------------*/
(define (sqlite-map o::sqlite p::procedure fmt::bstring . args)
   (if (null? args)
       ($sqlite-map (sqlite-$builtin o) p fmt o)
       ($sqlite-map (sqlite-$builtin o) p (apply sqlite-format fmt args) o)))

;; ======================================================================
;;      sqlite-table-informations ...
;; ======================================================================
(define (sqlite-table-informations db name) 
   (sqlite-map db (lambda (x y) y) (format "PRAGMA table_info(~a)" name)))

;; ======================================================================
;;      sqlite-table-number-of-rows ...
;; ======================================================================
(define (sqlite-table-number-of-rows db name)
   (sqlite-eval db
		(lambda (x) (string->integer x))
		(format "SELECT rowid FROM ~A" name)))

;; ======================================================================
;;      sqlite-table-name-of-columns ...
;; ======================================================================
(define (sqlite-table-name-of-columns db name)
   (let ((infos (sqlite-table-informations db name)))
      infos))

;; ======================================================================
;;      sqlite-name-of-tables ...
;; ======================================================================
(define (sqlite-name-of-tables db)
   (sqlite-map db
	       (lambda (x) x)
	       "SELECT name FROM sqlite_master WHERE type='table'"))

;*---------------------------------------------------------------------*/
;*    sqlite-format ...                                                */
;*---------------------------------------------------------------------*/
(define (sqlite-format fmt . objs)
   (let ((p (open-output-string))
	 (len (string-length fmt)))
      (let loop ((i 0)
		 (os objs))
	 (define (next os fmt)
	    (if (null? os)
		(error 'sqlite-format "Insufficient number of arguments" fmt)
		(car os)))
	 (define (print-radix radix num)
	    (if (not (number? num))
		(error 'sqlite-format "Illegal number" num)
		(display (number->string num radix) p)))
	 (define (display-sqlite obj p)
	    (cond
	       ((string? obj)
		(write-char #\' p)
		(let ((len (string-length obj)))
		   (do ((i 0 (+fx i 1)))
		       ((=fx i len))
		       (let ((c (string-ref obj i)))
			  (write-char c p)
			  (when (char=? c #\') (write-char c p)))))
		(write-char #\' p))
	       ((date? obj)
		(display (date->seconds obj) p))
	       ((eq? obj #f)
		(display "NULL" p))
	       (else
		(display obj p))))
	 (define (display-sqlite-list obj p)
	    (cond
	       ((not (pair? obj))
		(error 'sqlite-format "Illegal list" obj))
	       ((null? obj)
		#unspecified)
	       ((null? (cdr obj))
		(display (car obj) p))
	       (else
		(let loop ((o obj))
		   (cond
		      ((pair? (cdr o))
		       (display (car o) p)
		       (display "," p)
		       (loop (cdr o)))
		      ((null? (cdr o))
		       (display (car o) p))
		      (else
		       (error 'sqlite-form "Illegal list" obj)))))))
	 (define (display-sqlite-quote-list obj p)
	    (cond
	       ((not (pair? obj))
		(error 'sqlite-format "Illegal list" obj))
	       ((null? obj)
		#unspecified)
	       ((null? (cdr obj))
		(display-sqlite (car obj) p))
	       (else
		(let loop ((o obj))
		   (cond
		      ((pair? (cdr o))
		       (display-sqlite (car o) p)
		       (display "," p)
		       (loop (cdr o)))
		      ((null? (cdr o))
		       (display-sqlite (car o) p))
		      (else
		       (error 'sqlite-form "Illegal list" obj)))))))
	 (if (<fx i len)
	     (let ((c (string-ref fmt i)))
		(if (char=? c #\~)
		    (if (=fx i (-fx len 1))
			(error 'sqlite-format
			       "Tag not allowd here"
			       (substring fmt i len))
			(let ((f (string-ref fmt (+fx i 1))))
			   (case f
			      ((#\a #\A)
			       (display (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\q #\Q)
			       (display-sqlite (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\l #\L)
			       (display-sqlite-list (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\k #\K)
			       (display-sqlite-quote-list (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\s #\S)
			       (write (next os f) p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\v #\V)
			       (display (next os f) p)
			       (newline p)
			       (loop (+fx i 2) (cdr os)))
			      ((#\c #\C)
			       (let ((o (next os f)))
				  (if (not (char? o))
				      (error sqlite-format "Illegal char" o)
				      (begin
					 (write-char o p)
					 (loop (+fx i 2) (cdr os))))))
			      ((#\x #\X)
			       (print-radix 16 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\o #\O)
			       (print-radix 8 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\b #\B)
			       (print-radix 2 (next os f))
			       (loop (+fx i 2) (cdr os)))
			      ((#\% #\n)
			       (newline p)
			       (loop (+fx i 2) os))
			      ((#\r)
			       (write-char #\return p)
			       (loop (+fx i 2) os))
			      ((#\~)
			       (write-char #\~ p)
			       (loop (+fx i 2) os))
			      (else
			       (error 'sqlite-format "Illegal tag" f)))))
		    (begin
		       (write-char c p)
		       (loop (+fx i 1) os))))
	     (close-output-port p)))))
			 
;*---------------------------------------------------------------------*/
;*    sqlite-last-insert-rowid ...                                     */
;*---------------------------------------------------------------------*/
(define (sqlite-last-insert-rowid db)
   (sqlite-exec db "SELECT last_insert_rowid()"))

