/*=====================================================================*/
/*    serrano/prgm/project/bigloo/fthread/src/Java/bglasync.java       */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Feb 11 13:45:20 2002                          */
/*    Last change :  Fri Mar 11 10:46:25 2005 (serrano)                */
/*    Copyright   :  2002-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    A class implementing asynchronous thread. An asynchronous thread */
/*    is implemented by the means of a Java thread that permantenly    */
/*    execute a thunk.                                                 */
/*=====================================================================*/

/*---------------------------------------------------------------------*/
/*    The package                                                      */
/*---------------------------------------------------------------------*/
package bigloo.fthread;
import java.lang.*;
import bigloo.*;

/*---------------------------------------------------------------------*/
/*    bglasync                                                         */
/*---------------------------------------------------------------------*/
public class bglasync extends Thread {
   private procedure thunk;
   private Object id;
   private bglfthread scdl;
   
   // public constructor
   public bglasync( bglfthread s, procedure proc, Object i ) {
      super();
      scdl = s;
      thunk = proc;
      id = i;
      start();
   }

   public bglasync() {
      scdl = null;
      thunk = null;
      id = null;
   }

   // The thread entry-point
   public void run() {
      try {
	 thunk.funcall0();
      } catch( Throwable e ) {
	 try {
	    foreign.internalerror( e );
	 } catch( Throwable _ ) {
	    System.exit( 1 );
	 }
      }
   }
      
   // Scheduler wait for an asynchronous event. This function must
   // always be called within the dynamic extent of a bglasync_synchronize   
   public static void scheduler_wait( bglfthread scdl ) {
      try {
	 scdl.wait();
      } catch( Throwable e ) {
	 try {
	    foreign.internalerror( e );
	 } catch( Throwable _ ) {
	    System.exit( 1 );
	 }
      }
   }

   // Notify a Scheduler of an asynchronous event. This function must
   // always be called within the dynamic extent of a bglasync_synchronize   
   public static void scheduler_notify( bglfthread scdl ) {
      scdl.notify();
   }

   // synchronized block
   public static Object synchronize( bglfthread scdl, procedure proc ) {
      synchronized( scdl ) {
	 return proc.funcall0();
      }
   }
}   
