/*
 * Copyright 2002 The Bakery team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BAKERY_CONFIGURATION_ASSOCIATION_H
#define BAKERY_CONFIGURATION_ASSOCIATION_H

#include "bakery/Configuration/AssociationBase.h"

namespace Bakery
{
namespace Conf
{
  
template< class T_Widget >
class Association : public AssociationBase
{
public:
  static const AssociationPtr create(const Glib::ustring& full_key, T_Widget& widget, bool instant)
  {
    return AssociationPtr(SigC::manage(new Association(full_key,widget,instant)));
  }

  virtual ~Association()
  {
  }

  /** These methods must be implemented explicitly for each
   * specialization of Association<T> to provide appropriate
   * behaviors based on the widget type.
   */
  virtual void connect_widget(Callback on_widget_changed);
  virtual void load_widget();
  virtual void save_widget();

protected:
  Association(const Glib::ustring& full_key, T_Widget& widget, bool instant)
  : AssociationBase(full_key,instant), m_widget(widget)
  {
  }

  Association(const Association& other); // Not implemented

private:
  T_Widget& m_widget;
};

} //namespace Conf

} //namespace Bakery

#endif //BAKERY_CONFIGURATION_ASSOCIATION_H
