------------------------------------------------------------------------------
--                                                                          --
--                            GNATELIM COMPONENTS                           --
--                                                                          --
--                       G N A T E L I M . E R R O R S                      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.9 $
--                                                                          --
--            Copyright (c) 1997-2000, Free Software Foundation, Inc.       --
--                                                                          --
-- Gnatelim is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnatelim is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Gnatelim is distributed as a part of the ASIS implementation for GNAT    --
-- (ASIS-for-GNAT).                                                         --
--                                                                          --
-- Gnatelim was originally developed by Alain Le Guennec                    --
--                                                                          --
-- Gnatelim  is  now  maintained  by  Ada  Core  Technologies  Inc          --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

with GNATELIM.Options; use GNATELIM.Options;

with Ada.Command_Line; use Ada.Command_Line;
with Ada.Wide_Text_IO; use Ada.Wide_Text_IO;
package body GNATELIM.Errors is

   Nb_Errors   : Natural := 0;
   Nb_Warnings : Natural := 0;
   --  Global variables used to keep the number of errors and warnings.
   --  Not used at the moment

   -------------
   --  Error  --
   -------------

   procedure Error (Msg : Wide_String) is
   begin
      Nb_Errors := Nb_Errors + 1;
      Set_Output (Standard_Error);
      Put_Line (Msg);
      Set_Output (Standard_Output);
      Set_Exit_Status (Failure);
      raise Fatal_Error;
   end Error;


   ---------------
   --  Warning  --
   ---------------

   procedure Warning (Msg : Wide_String; Force : Boolean := False) is
   begin

      if not Quiet_Mode then

         if Debug_Mode or else Force then
            Nb_Warnings := Nb_Warnings + 1;

            Set_Output (Standard_Error);
            Put_Line (Msg);
            Set_Output (Standard_Output);
         end if;

      end if;

   end Warning;


   ------------------------
   --  Number_Of_Errors  --
   ------------------------

   function Number_Of_Errors   return Natural is
   begin
      return Nb_Errors;
   end Number_Of_Errors;


   --------------------------
   --  Number_Of_Warnings  --
   --------------------------

   function Number_Of_Warnings return Natural is
   begin
      return Nb_Warnings;
   end Number_Of_Warnings;

end GNATELIM.Errors;
