// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package guarddutyiface provides an interface to enable mocking the Amazon GuardDuty service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package guarddutyiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/guardduty"
)

// GuardDutyAPI provides an interface to enable mocking the
// guardduty.GuardDuty service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon GuardDuty.
//    func myFunc(svc guarddutyiface.GuardDutyAPI) bool {
//        // Make svc.AcceptInvitation request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := guardduty.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockGuardDutyClient struct {
//        guarddutyiface.GuardDutyAPI
//    }
//    func (m *mockGuardDutyClient) AcceptInvitation(input *guardduty.AcceptInvitationInput) (*guardduty.AcceptInvitationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockGuardDutyClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type GuardDutyAPI interface {
	AcceptInvitation(*guardduty.AcceptInvitationInput) (*guardduty.AcceptInvitationOutput, error)
	AcceptInvitationWithContext(aws.Context, *guardduty.AcceptInvitationInput, ...request.Option) (*guardduty.AcceptInvitationOutput, error)
	AcceptInvitationRequest(*guardduty.AcceptInvitationInput) (*request.Request, *guardduty.AcceptInvitationOutput)

	ArchiveFindings(*guardduty.ArchiveFindingsInput) (*guardduty.ArchiveFindingsOutput, error)
	ArchiveFindingsWithContext(aws.Context, *guardduty.ArchiveFindingsInput, ...request.Option) (*guardduty.ArchiveFindingsOutput, error)
	ArchiveFindingsRequest(*guardduty.ArchiveFindingsInput) (*request.Request, *guardduty.ArchiveFindingsOutput)

	CreateDetector(*guardduty.CreateDetectorInput) (*guardduty.CreateDetectorOutput, error)
	CreateDetectorWithContext(aws.Context, *guardduty.CreateDetectorInput, ...request.Option) (*guardduty.CreateDetectorOutput, error)
	CreateDetectorRequest(*guardduty.CreateDetectorInput) (*request.Request, *guardduty.CreateDetectorOutput)

	CreateIPSet(*guardduty.CreateIPSetInput) (*guardduty.CreateIPSetOutput, error)
	CreateIPSetWithContext(aws.Context, *guardduty.CreateIPSetInput, ...request.Option) (*guardduty.CreateIPSetOutput, error)
	CreateIPSetRequest(*guardduty.CreateIPSetInput) (*request.Request, *guardduty.CreateIPSetOutput)

	CreateMembers(*guardduty.CreateMembersInput) (*guardduty.CreateMembersOutput, error)
	CreateMembersWithContext(aws.Context, *guardduty.CreateMembersInput, ...request.Option) (*guardduty.CreateMembersOutput, error)
	CreateMembersRequest(*guardduty.CreateMembersInput) (*request.Request, *guardduty.CreateMembersOutput)

	CreateSampleFindings(*guardduty.CreateSampleFindingsInput) (*guardduty.CreateSampleFindingsOutput, error)
	CreateSampleFindingsWithContext(aws.Context, *guardduty.CreateSampleFindingsInput, ...request.Option) (*guardduty.CreateSampleFindingsOutput, error)
	CreateSampleFindingsRequest(*guardduty.CreateSampleFindingsInput) (*request.Request, *guardduty.CreateSampleFindingsOutput)

	CreateThreatIntelSet(*guardduty.CreateThreatIntelSetInput) (*guardduty.CreateThreatIntelSetOutput, error)
	CreateThreatIntelSetWithContext(aws.Context, *guardduty.CreateThreatIntelSetInput, ...request.Option) (*guardduty.CreateThreatIntelSetOutput, error)
	CreateThreatIntelSetRequest(*guardduty.CreateThreatIntelSetInput) (*request.Request, *guardduty.CreateThreatIntelSetOutput)

	DeclineInvitations(*guardduty.DeclineInvitationsInput) (*guardduty.DeclineInvitationsOutput, error)
	DeclineInvitationsWithContext(aws.Context, *guardduty.DeclineInvitationsInput, ...request.Option) (*guardduty.DeclineInvitationsOutput, error)
	DeclineInvitationsRequest(*guardduty.DeclineInvitationsInput) (*request.Request, *guardduty.DeclineInvitationsOutput)

	DeleteDetector(*guardduty.DeleteDetectorInput) (*guardduty.DeleteDetectorOutput, error)
	DeleteDetectorWithContext(aws.Context, *guardduty.DeleteDetectorInput, ...request.Option) (*guardduty.DeleteDetectorOutput, error)
	DeleteDetectorRequest(*guardduty.DeleteDetectorInput) (*request.Request, *guardduty.DeleteDetectorOutput)

	DeleteIPSet(*guardduty.DeleteIPSetInput) (*guardduty.DeleteIPSetOutput, error)
	DeleteIPSetWithContext(aws.Context, *guardduty.DeleteIPSetInput, ...request.Option) (*guardduty.DeleteIPSetOutput, error)
	DeleteIPSetRequest(*guardduty.DeleteIPSetInput) (*request.Request, *guardduty.DeleteIPSetOutput)

	DeleteInvitations(*guardduty.DeleteInvitationsInput) (*guardduty.DeleteInvitationsOutput, error)
	DeleteInvitationsWithContext(aws.Context, *guardduty.DeleteInvitationsInput, ...request.Option) (*guardduty.DeleteInvitationsOutput, error)
	DeleteInvitationsRequest(*guardduty.DeleteInvitationsInput) (*request.Request, *guardduty.DeleteInvitationsOutput)

	DeleteMembers(*guardduty.DeleteMembersInput) (*guardduty.DeleteMembersOutput, error)
	DeleteMembersWithContext(aws.Context, *guardduty.DeleteMembersInput, ...request.Option) (*guardduty.DeleteMembersOutput, error)
	DeleteMembersRequest(*guardduty.DeleteMembersInput) (*request.Request, *guardduty.DeleteMembersOutput)

	DeleteThreatIntelSet(*guardduty.DeleteThreatIntelSetInput) (*guardduty.DeleteThreatIntelSetOutput, error)
	DeleteThreatIntelSetWithContext(aws.Context, *guardduty.DeleteThreatIntelSetInput, ...request.Option) (*guardduty.DeleteThreatIntelSetOutput, error)
	DeleteThreatIntelSetRequest(*guardduty.DeleteThreatIntelSetInput) (*request.Request, *guardduty.DeleteThreatIntelSetOutput)

	DisassociateFromMasterAccount(*guardduty.DisassociateFromMasterAccountInput) (*guardduty.DisassociateFromMasterAccountOutput, error)
	DisassociateFromMasterAccountWithContext(aws.Context, *guardduty.DisassociateFromMasterAccountInput, ...request.Option) (*guardduty.DisassociateFromMasterAccountOutput, error)
	DisassociateFromMasterAccountRequest(*guardduty.DisassociateFromMasterAccountInput) (*request.Request, *guardduty.DisassociateFromMasterAccountOutput)

	DisassociateMembers(*guardduty.DisassociateMembersInput) (*guardduty.DisassociateMembersOutput, error)
	DisassociateMembersWithContext(aws.Context, *guardduty.DisassociateMembersInput, ...request.Option) (*guardduty.DisassociateMembersOutput, error)
	DisassociateMembersRequest(*guardduty.DisassociateMembersInput) (*request.Request, *guardduty.DisassociateMembersOutput)

	GetDetector(*guardduty.GetDetectorInput) (*guardduty.GetDetectorOutput, error)
	GetDetectorWithContext(aws.Context, *guardduty.GetDetectorInput, ...request.Option) (*guardduty.GetDetectorOutput, error)
	GetDetectorRequest(*guardduty.GetDetectorInput) (*request.Request, *guardduty.GetDetectorOutput)

	GetFindings(*guardduty.GetFindingsInput) (*guardduty.GetFindingsOutput, error)
	GetFindingsWithContext(aws.Context, *guardduty.GetFindingsInput, ...request.Option) (*guardduty.GetFindingsOutput, error)
	GetFindingsRequest(*guardduty.GetFindingsInput) (*request.Request, *guardduty.GetFindingsOutput)

	GetFindingsStatistics(*guardduty.GetFindingsStatisticsInput) (*guardduty.GetFindingsStatisticsOutput, error)
	GetFindingsStatisticsWithContext(aws.Context, *guardduty.GetFindingsStatisticsInput, ...request.Option) (*guardduty.GetFindingsStatisticsOutput, error)
	GetFindingsStatisticsRequest(*guardduty.GetFindingsStatisticsInput) (*request.Request, *guardduty.GetFindingsStatisticsOutput)

	GetIPSet(*guardduty.GetIPSetInput) (*guardduty.GetIPSetOutput, error)
	GetIPSetWithContext(aws.Context, *guardduty.GetIPSetInput, ...request.Option) (*guardduty.GetIPSetOutput, error)
	GetIPSetRequest(*guardduty.GetIPSetInput) (*request.Request, *guardduty.GetIPSetOutput)

	GetInvitationsCount(*guardduty.GetInvitationsCountInput) (*guardduty.GetInvitationsCountOutput, error)
	GetInvitationsCountWithContext(aws.Context, *guardduty.GetInvitationsCountInput, ...request.Option) (*guardduty.GetInvitationsCountOutput, error)
	GetInvitationsCountRequest(*guardduty.GetInvitationsCountInput) (*request.Request, *guardduty.GetInvitationsCountOutput)

	GetMasterAccount(*guardduty.GetMasterAccountInput) (*guardduty.GetMasterAccountOutput, error)
	GetMasterAccountWithContext(aws.Context, *guardduty.GetMasterAccountInput, ...request.Option) (*guardduty.GetMasterAccountOutput, error)
	GetMasterAccountRequest(*guardduty.GetMasterAccountInput) (*request.Request, *guardduty.GetMasterAccountOutput)

	GetMembers(*guardduty.GetMembersInput) (*guardduty.GetMembersOutput, error)
	GetMembersWithContext(aws.Context, *guardduty.GetMembersInput, ...request.Option) (*guardduty.GetMembersOutput, error)
	GetMembersRequest(*guardduty.GetMembersInput) (*request.Request, *guardduty.GetMembersOutput)

	GetThreatIntelSet(*guardduty.GetThreatIntelSetInput) (*guardduty.GetThreatIntelSetOutput, error)
	GetThreatIntelSetWithContext(aws.Context, *guardduty.GetThreatIntelSetInput, ...request.Option) (*guardduty.GetThreatIntelSetOutput, error)
	GetThreatIntelSetRequest(*guardduty.GetThreatIntelSetInput) (*request.Request, *guardduty.GetThreatIntelSetOutput)

	InviteMembers(*guardduty.InviteMembersInput) (*guardduty.InviteMembersOutput, error)
	InviteMembersWithContext(aws.Context, *guardduty.InviteMembersInput, ...request.Option) (*guardduty.InviteMembersOutput, error)
	InviteMembersRequest(*guardduty.InviteMembersInput) (*request.Request, *guardduty.InviteMembersOutput)

	ListDetectors(*guardduty.ListDetectorsInput) (*guardduty.ListDetectorsOutput, error)
	ListDetectorsWithContext(aws.Context, *guardduty.ListDetectorsInput, ...request.Option) (*guardduty.ListDetectorsOutput, error)
	ListDetectorsRequest(*guardduty.ListDetectorsInput) (*request.Request, *guardduty.ListDetectorsOutput)

	ListDetectorsPages(*guardduty.ListDetectorsInput, func(*guardduty.ListDetectorsOutput, bool) bool) error
	ListDetectorsPagesWithContext(aws.Context, *guardduty.ListDetectorsInput, func(*guardduty.ListDetectorsOutput, bool) bool, ...request.Option) error

	ListFindings(*guardduty.ListFindingsInput) (*guardduty.ListFindingsOutput, error)
	ListFindingsWithContext(aws.Context, *guardduty.ListFindingsInput, ...request.Option) (*guardduty.ListFindingsOutput, error)
	ListFindingsRequest(*guardduty.ListFindingsInput) (*request.Request, *guardduty.ListFindingsOutput)

	ListFindingsPages(*guardduty.ListFindingsInput, func(*guardduty.ListFindingsOutput, bool) bool) error
	ListFindingsPagesWithContext(aws.Context, *guardduty.ListFindingsInput, func(*guardduty.ListFindingsOutput, bool) bool, ...request.Option) error

	ListIPSets(*guardduty.ListIPSetsInput) (*guardduty.ListIPSetsOutput, error)
	ListIPSetsWithContext(aws.Context, *guardduty.ListIPSetsInput, ...request.Option) (*guardduty.ListIPSetsOutput, error)
	ListIPSetsRequest(*guardduty.ListIPSetsInput) (*request.Request, *guardduty.ListIPSetsOutput)

	ListIPSetsPages(*guardduty.ListIPSetsInput, func(*guardduty.ListIPSetsOutput, bool) bool) error
	ListIPSetsPagesWithContext(aws.Context, *guardduty.ListIPSetsInput, func(*guardduty.ListIPSetsOutput, bool) bool, ...request.Option) error

	ListInvitations(*guardduty.ListInvitationsInput) (*guardduty.ListInvitationsOutput, error)
	ListInvitationsWithContext(aws.Context, *guardduty.ListInvitationsInput, ...request.Option) (*guardduty.ListInvitationsOutput, error)
	ListInvitationsRequest(*guardduty.ListInvitationsInput) (*request.Request, *guardduty.ListInvitationsOutput)

	ListInvitationsPages(*guardduty.ListInvitationsInput, func(*guardduty.ListInvitationsOutput, bool) bool) error
	ListInvitationsPagesWithContext(aws.Context, *guardduty.ListInvitationsInput, func(*guardduty.ListInvitationsOutput, bool) bool, ...request.Option) error

	ListMembers(*guardduty.ListMembersInput) (*guardduty.ListMembersOutput, error)
	ListMembersWithContext(aws.Context, *guardduty.ListMembersInput, ...request.Option) (*guardduty.ListMembersOutput, error)
	ListMembersRequest(*guardduty.ListMembersInput) (*request.Request, *guardduty.ListMembersOutput)

	ListMembersPages(*guardduty.ListMembersInput, func(*guardduty.ListMembersOutput, bool) bool) error
	ListMembersPagesWithContext(aws.Context, *guardduty.ListMembersInput, func(*guardduty.ListMembersOutput, bool) bool, ...request.Option) error

	ListThreatIntelSets(*guardduty.ListThreatIntelSetsInput) (*guardduty.ListThreatIntelSetsOutput, error)
	ListThreatIntelSetsWithContext(aws.Context, *guardduty.ListThreatIntelSetsInput, ...request.Option) (*guardduty.ListThreatIntelSetsOutput, error)
	ListThreatIntelSetsRequest(*guardduty.ListThreatIntelSetsInput) (*request.Request, *guardduty.ListThreatIntelSetsOutput)

	ListThreatIntelSetsPages(*guardduty.ListThreatIntelSetsInput, func(*guardduty.ListThreatIntelSetsOutput, bool) bool) error
	ListThreatIntelSetsPagesWithContext(aws.Context, *guardduty.ListThreatIntelSetsInput, func(*guardduty.ListThreatIntelSetsOutput, bool) bool, ...request.Option) error

	StartMonitoringMembers(*guardduty.StartMonitoringMembersInput) (*guardduty.StartMonitoringMembersOutput, error)
	StartMonitoringMembersWithContext(aws.Context, *guardduty.StartMonitoringMembersInput, ...request.Option) (*guardduty.StartMonitoringMembersOutput, error)
	StartMonitoringMembersRequest(*guardduty.StartMonitoringMembersInput) (*request.Request, *guardduty.StartMonitoringMembersOutput)

	StopMonitoringMembers(*guardduty.StopMonitoringMembersInput) (*guardduty.StopMonitoringMembersOutput, error)
	StopMonitoringMembersWithContext(aws.Context, *guardduty.StopMonitoringMembersInput, ...request.Option) (*guardduty.StopMonitoringMembersOutput, error)
	StopMonitoringMembersRequest(*guardduty.StopMonitoringMembersInput) (*request.Request, *guardduty.StopMonitoringMembersOutput)

	UnarchiveFindings(*guardduty.UnarchiveFindingsInput) (*guardduty.UnarchiveFindingsOutput, error)
	UnarchiveFindingsWithContext(aws.Context, *guardduty.UnarchiveFindingsInput, ...request.Option) (*guardduty.UnarchiveFindingsOutput, error)
	UnarchiveFindingsRequest(*guardduty.UnarchiveFindingsInput) (*request.Request, *guardduty.UnarchiveFindingsOutput)

	UpdateDetector(*guardduty.UpdateDetectorInput) (*guardduty.UpdateDetectorOutput, error)
	UpdateDetectorWithContext(aws.Context, *guardduty.UpdateDetectorInput, ...request.Option) (*guardduty.UpdateDetectorOutput, error)
	UpdateDetectorRequest(*guardduty.UpdateDetectorInput) (*request.Request, *guardduty.UpdateDetectorOutput)

	UpdateFindingsFeedback(*guardduty.UpdateFindingsFeedbackInput) (*guardduty.UpdateFindingsFeedbackOutput, error)
	UpdateFindingsFeedbackWithContext(aws.Context, *guardduty.UpdateFindingsFeedbackInput, ...request.Option) (*guardduty.UpdateFindingsFeedbackOutput, error)
	UpdateFindingsFeedbackRequest(*guardduty.UpdateFindingsFeedbackInput) (*request.Request, *guardduty.UpdateFindingsFeedbackOutput)

	UpdateIPSet(*guardduty.UpdateIPSetInput) (*guardduty.UpdateIPSetOutput, error)
	UpdateIPSetWithContext(aws.Context, *guardduty.UpdateIPSetInput, ...request.Option) (*guardduty.UpdateIPSetOutput, error)
	UpdateIPSetRequest(*guardduty.UpdateIPSetInput) (*request.Request, *guardduty.UpdateIPSetOutput)

	UpdateThreatIntelSet(*guardduty.UpdateThreatIntelSetInput) (*guardduty.UpdateThreatIntelSetOutput, error)
	UpdateThreatIntelSetWithContext(aws.Context, *guardduty.UpdateThreatIntelSetInput, ...request.Option) (*guardduty.UpdateThreatIntelSetOutput, error)
	UpdateThreatIntelSetRequest(*guardduty.UpdateThreatIntelSetInput) (*request.Request, *guardduty.UpdateThreatIntelSetOutput)
}

var _ GuardDutyAPI = (*guardduty.GuardDuty)(nil)
