// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetRepositories = "BatchGetRepositories"

// BatchGetRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetRepositories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetRepositories for more information on using the BatchGetRepositories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetRepositoriesRequest method.
//    req, resp := client.BatchGetRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories
func (c *CodeCommit) BatchGetRepositoriesRequest(input *BatchGetRepositoriesInput) (req *request.Request, output *BatchGetRepositoriesOutput) {
	op := &request.Operation{
		Name:       opBatchGetRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetRepositoriesInput{}
	}

	output = &BatchGetRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetRepositories API operation for AWS CodeCommit.
//
// Returns information about one or more repositories.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation BatchGetRepositories for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNamesRequiredException "RepositoryNamesRequiredException"
//   A repository names object is required but was not specified.
//
//   * ErrCodeMaximumRepositoryNamesExceededException "MaximumRepositoryNamesExceededException"
//   The maximum number of allowed repository names was exceeded. Currently, this
//   number is 25.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/BatchGetRepositories
func (c *CodeCommit) BatchGetRepositories(input *BatchGetRepositoriesInput) (*BatchGetRepositoriesOutput, error) {
	req, out := c.BatchGetRepositoriesRequest(input)
	return out, req.Send()
}

// BatchGetRepositoriesWithContext is the same as BatchGetRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) BatchGetRepositoriesWithContext(ctx aws.Context, input *BatchGetRepositoriesInput, opts ...request.Option) (*BatchGetRepositoriesOutput, error) {
	req, out := c.BatchGetRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBranch = "CreateBranch"

// CreateBranchRequest generates a "aws/request.Request" representing the
// client's request for the CreateBranch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBranch for more information on using the CreateBranch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBranchRequest method.
//    req, resp := client.CreateBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch
func (c *CodeCommit) CreateBranchRequest(input *CreateBranchInput) (req *request.Request, output *CreateBranchOutput) {
	op := &request.Operation{
		Name:       opCreateBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBranchInput{}
	}

	output = &CreateBranchOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateBranch API operation for AWS CodeCommit.
//
// Creates a new branch in a repository and points the branch to a commit.
//
// Calling the create branch operation does not set a repository's default branch.
// To do this, call the update default branch operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation CreateBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeBranchNameRequiredException "BranchNameRequiredException"
//   A branch name is required but was not specified.
//
//   * ErrCodeBranchNameExistsException "BranchNameExistsException"
//   The specified branch name already exists.
//
//   * ErrCodeInvalidBranchNameException "InvalidBranchNameException"
//   The specified reference name is not valid.
//
//   * ErrCodeCommitIdRequiredException "CommitIdRequiredException"
//   A commit ID was not specified.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateBranch
func (c *CodeCommit) CreateBranch(input *CreateBranchInput) (*CreateBranchOutput, error) {
	req, out := c.CreateBranchRequest(input)
	return out, req.Send()
}

// CreateBranchWithContext is the same as CreateBranch with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) CreateBranchWithContext(ctx aws.Context, input *CreateBranchInput, opts ...request.Option) (*CreateBranchOutput, error) {
	req, out := c.CreateBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePullRequest = "CreatePullRequest"

// CreatePullRequestRequest generates a "aws/request.Request" representing the
// client's request for the CreatePullRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePullRequest for more information on using the CreatePullRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePullRequestRequest method.
//    req, resp := client.CreatePullRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequest
func (c *CodeCommit) CreatePullRequestRequest(input *CreatePullRequestInput) (req *request.Request, output *CreatePullRequestOutput) {
	op := &request.Operation{
		Name:       opCreatePullRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePullRequestInput{}
	}

	output = &CreatePullRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePullRequest API operation for AWS CodeCommit.
//
// Creates a pull request in the specified repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation CreatePullRequest for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
//   * ErrCodeClientRequestTokenRequiredException "ClientRequestTokenRequiredException"
//   A client request token is required. A client request token is an unique,
//   client-generated idempotency token that when provided in a request, ensures
//   the request cannot be repeated with a changed parameter. If a request is
//   received with the same parameters and a token is included, the request will
//   return information about the initial request that used that token.
//
//   * ErrCodeInvalidClientRequestTokenException "InvalidClientRequestTokenException"
//   The client request token is not valid.
//
//   * ErrCodeIdempotencyParameterMismatchException "IdempotencyParameterMismatchException"
//   The client request token is not valid. Either the token is not in a valid
//   format, or the token has been used in a previous request and cannot be re-used.
//
//   * ErrCodeReferenceNameRequiredException "ReferenceNameRequiredException"
//   A reference name is required, but none was provided.
//
//   * ErrCodeInvalidReferenceNameException "InvalidReferenceNameException"
//   The specified reference name format is not valid. Reference names must conform
//   to the Git references format, for example refs/heads/master. For more information,
//   see Git Internals - Git References (https://git-scm.com/book/en/v2/Git-Internals-Git-References)
//   or consult your Git documentation.
//
//   * ErrCodeReferenceDoesNotExistException "ReferenceDoesNotExistException"
//   The specified reference does not exist. You must provide a full commit ID.
//
//   * ErrCodeReferenceTypeNotSupportedException "ReferenceTypeNotSupportedException"
//   The specified reference is not a supported type.
//
//   * ErrCodeTitleRequiredException "TitleRequiredException"
//   A pull request title is required. It cannot be empty or null.
//
//   * ErrCodeInvalidTitleException "InvalidTitleException"
//   The title of the pull request is not valid. Pull request titles cannot exceed
//   100 characters in length.
//
//   * ErrCodeInvalidDescriptionException "InvalidDescriptionException"
//   The pull request description is not valid. Descriptions are limited to 1,000
//   characters in length.
//
//   * ErrCodeTargetsRequiredException "TargetsRequiredException"
//   An array of target objects is required. It cannot be empty or null.
//
//   * ErrCodeInvalidTargetsException "InvalidTargetsException"
//   The targets for the pull request is not valid or not in a valid format. Targets
//   are a list of target objects. Each target object must contain the full values
//   for the repository name, source branch, and destination branch for a pull
//   request.
//
//   * ErrCodeTargetRequiredException "TargetRequiredException"
//   A pull request target is required. It cannot be empty or null. A pull request
//   target must contain the full values for the repository name, source branch,
//   and destination branch for the pull request.
//
//   * ErrCodeInvalidTargetException "InvalidTargetException"
//   The target for the pull request is not valid. A target must contain the full
//   values for the repository name, source branch, and destination branch for
//   the pull request.
//
//   * ErrCodeMultipleRepositoriesInPullRequestException "MultipleRepositoriesInPullRequestException"
//   You cannot include more than one repository in a pull request. Make sure
//   you have specified only one repository name in your request, and then try
//   again.
//
//   * ErrCodeMaximumOpenPullRequestsExceededException "MaximumOpenPullRequestsExceededException"
//   You cannot create the pull request because the repository has too many open
//   pull requests. The maximum number of open pull requests for a repository
//   is 1,000. Close one or more open pull requests, and then try again.
//
//   * ErrCodeSourceAndDestinationAreSameException "SourceAndDestinationAreSameException"
//   The source branch and the destination branch for the pull request are the
//   same. You must specify different branches for the source and destination.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreatePullRequest
func (c *CodeCommit) CreatePullRequest(input *CreatePullRequestInput) (*CreatePullRequestOutput, error) {
	req, out := c.CreatePullRequestRequest(input)
	return out, req.Send()
}

// CreatePullRequestWithContext is the same as CreatePullRequest with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePullRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) CreatePullRequestWithContext(ctx aws.Context, input *CreatePullRequestInput, opts ...request.Option) (*CreatePullRequestOutput, error) {
	req, out := c.CreatePullRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRepository for more information on using the CreateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRepositoryRequest method.
//    req, resp := client.CreateRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository
func (c *CodeCommit) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	output = &CreateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRepository API operation for AWS CodeCommit.
//
// Creates a new, empty repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation CreateRepository for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameExistsException "RepositoryNameExistsException"
//   The specified repository name already exists.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryDescriptionException "InvalidRepositoryDescriptionException"
//   The specified repository description is not valid.
//
//   * ErrCodeRepositoryLimitExceededException "RepositoryLimitExceededException"
//   A repository resource limit was exceeded.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/CreateRepository
func (c *CodeCommit) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	return out, req.Send()
}

// CreateRepositoryWithContext is the same as CreateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) CreateRepositoryWithContext(ctx aws.Context, input *CreateRepositoryInput, opts ...request.Option) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBranch = "DeleteBranch"

// DeleteBranchRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBranch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBranch for more information on using the DeleteBranch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBranchRequest method.
//    req, resp := client.DeleteBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteBranch
func (c *CodeCommit) DeleteBranchRequest(input *DeleteBranchInput) (req *request.Request, output *DeleteBranchOutput) {
	op := &request.Operation{
		Name:       opDeleteBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBranchInput{}
	}

	output = &DeleteBranchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBranch API operation for AWS CodeCommit.
//
// Deletes a branch from a repository, unless that branch is the default branch
// for the repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation DeleteBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeBranchNameRequiredException "BranchNameRequiredException"
//   A branch name is required but was not specified.
//
//   * ErrCodeInvalidBranchNameException "InvalidBranchNameException"
//   The specified reference name is not valid.
//
//   * ErrCodeDefaultBranchCannotBeDeletedException "DefaultBranchCannotBeDeletedException"
//   The specified branch is the default branch for the repository, and cannot
//   be deleted. To delete this branch, you must first set another branch as the
//   default branch.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteBranch
func (c *CodeCommit) DeleteBranch(input *DeleteBranchInput) (*DeleteBranchOutput, error) {
	req, out := c.DeleteBranchRequest(input)
	return out, req.Send()
}

// DeleteBranchWithContext is the same as DeleteBranch with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) DeleteBranchWithContext(ctx aws.Context, input *DeleteBranchInput, opts ...request.Option) (*DeleteBranchOutput, error) {
	req, out := c.DeleteBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCommentContent = "DeleteCommentContent"

// DeleteCommentContentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCommentContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCommentContent for more information on using the DeleteCommentContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCommentContentRequest method.
//    req, resp := client.DeleteCommentContentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteCommentContent
func (c *CodeCommit) DeleteCommentContentRequest(input *DeleteCommentContentInput) (req *request.Request, output *DeleteCommentContentOutput) {
	op := &request.Operation{
		Name:       opDeleteCommentContent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCommentContentInput{}
	}

	output = &DeleteCommentContentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCommentContent API operation for AWS CodeCommit.
//
// Deletes the content of a comment made on a change, file, or commit in a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation DeleteCommentContent for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCommentDoesNotExistException "CommentDoesNotExistException"
//   No comment exists with the provided ID. Verify that you have provided the
//   correct ID, and then try again.
//
//   * ErrCodeCommentIdRequiredException "CommentIdRequiredException"
//   The comment ID is missing or null. A comment ID is required.
//
//   * ErrCodeInvalidCommentIdException "InvalidCommentIdException"
//   The comment ID is not in a valid format. Make sure that you have provided
//   the full comment ID.
//
//   * ErrCodeCommentDeletedException "CommentDeletedException"
//   This comment has already been deleted. You cannot edit or delete a deleted
//   comment.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteCommentContent
func (c *CodeCommit) DeleteCommentContent(input *DeleteCommentContentInput) (*DeleteCommentContentOutput, error) {
	req, out := c.DeleteCommentContentRequest(input)
	return out, req.Send()
}

// DeleteCommentContentWithContext is the same as DeleteCommentContent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCommentContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) DeleteCommentContentWithContext(ctx aws.Context, input *DeleteCommentContentInput, opts ...request.Option) (*DeleteCommentContentOutput, error) {
	req, out := c.DeleteCommentContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRepository = "DeleteRepository"

// DeleteRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRepository for more information on using the DeleteRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRepositoryRequest method.
//    req, resp := client.DeleteRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepository
func (c *CodeCommit) DeleteRepositoryRequest(input *DeleteRepositoryInput) (req *request.Request, output *DeleteRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryInput{}
	}

	output = &DeleteRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepository API operation for AWS CodeCommit.
//
// Deletes a repository. If a specified repository was already deleted, a null
// repository ID will be returned.
//
// Deleting a repository also deletes all associated objects and metadata. After
// a repository is deleted, all future push calls to the deleted repository
// will fail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation DeleteRepository for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DeleteRepository
func (c *CodeCommit) DeleteRepository(input *DeleteRepositoryInput) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	return out, req.Send()
}

// DeleteRepositoryWithContext is the same as DeleteRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) DeleteRepositoryWithContext(ctx aws.Context, input *DeleteRepositoryInput, opts ...request.Option) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePullRequestEvents = "DescribePullRequestEvents"

// DescribePullRequestEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePullRequestEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePullRequestEvents for more information on using the DescribePullRequestEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePullRequestEventsRequest method.
//    req, resp := client.DescribePullRequestEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents
func (c *CodeCommit) DescribePullRequestEventsRequest(input *DescribePullRequestEventsInput) (req *request.Request, output *DescribePullRequestEventsOutput) {
	op := &request.Operation{
		Name:       opDescribePullRequestEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePullRequestEventsInput{}
	}

	output = &DescribePullRequestEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePullRequestEvents API operation for AWS CodeCommit.
//
// Returns information about one or more pull request events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation DescribePullRequestEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePullRequestDoesNotExistException "PullRequestDoesNotExistException"
//   The pull request ID could not be found. Make sure that you have specified
//   the correct repository name and pull request ID, and then try again.
//
//   * ErrCodeInvalidPullRequestIdException "InvalidPullRequestIdException"
//   The pull request ID is not valid. Make sure that you have provided the full
//   ID and that the pull request is in the specified repository, and then try
//   again.
//
//   * ErrCodePullRequestIdRequiredException "PullRequestIdRequiredException"
//   A pull request ID is required, but none was provided.
//
//   * ErrCodeInvalidPullRequestEventTypeException "InvalidPullRequestEventTypeException"
//   The pull request event type is not valid.
//
//   * ErrCodeInvalidActorArnException "InvalidActorArnException"
//   The Amazon Resource Name (ARN) is not valid. Make sure that you have provided
//   the full ARN for the user who initiated the change for the pull request,
//   and then try again.
//
//   * ErrCodeActorDoesNotExistException "ActorDoesNotExistException"
//   The specified Amazon Resource Name (ARN) does not exist in the AWS account.
//
//   * ErrCodeInvalidMaxResultsException "InvalidMaxResultsException"
//   The specified number of maximum results is not valid.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/DescribePullRequestEvents
func (c *CodeCommit) DescribePullRequestEvents(input *DescribePullRequestEventsInput) (*DescribePullRequestEventsOutput, error) {
	req, out := c.DescribePullRequestEventsRequest(input)
	return out, req.Send()
}

// DescribePullRequestEventsWithContext is the same as DescribePullRequestEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePullRequestEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) DescribePullRequestEventsWithContext(ctx aws.Context, input *DescribePullRequestEventsInput, opts ...request.Option) (*DescribePullRequestEventsOutput, error) {
	req, out := c.DescribePullRequestEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePullRequestEventsPages iterates over the pages of a DescribePullRequestEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePullRequestEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePullRequestEvents operation.
//    pageNum := 0
//    err := client.DescribePullRequestEventsPages(params,
//        func(page *DescribePullRequestEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) DescribePullRequestEventsPages(input *DescribePullRequestEventsInput, fn func(*DescribePullRequestEventsOutput, bool) bool) error {
	return c.DescribePullRequestEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePullRequestEventsPagesWithContext same as DescribePullRequestEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) DescribePullRequestEventsPagesWithContext(ctx aws.Context, input *DescribePullRequestEventsInput, fn func(*DescribePullRequestEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePullRequestEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePullRequestEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribePullRequestEventsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetBlob = "GetBlob"

// GetBlobRequest generates a "aws/request.Request" representing the
// client's request for the GetBlob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBlob for more information on using the GetBlob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBlobRequest method.
//    req, resp := client.GetBlobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlob
func (c *CodeCommit) GetBlobRequest(input *GetBlobInput) (req *request.Request, output *GetBlobOutput) {
	op := &request.Operation{
		Name:       opGetBlob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBlobInput{}
	}

	output = &GetBlobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBlob API operation for AWS CodeCommit.
//
// Returns the base-64 encoded content of an individual blob within a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetBlob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeBlobIdRequiredException "BlobIdRequiredException"
//   A blob ID is required but was not specified.
//
//   * ErrCodeInvalidBlobIdException "InvalidBlobIdException"
//   The specified blob is not valid.
//
//   * ErrCodeBlobIdDoesNotExistException "BlobIdDoesNotExistException"
//   The specified blob does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
//   * ErrCodeFileTooLargeException "FileTooLargeException"
//   The specified file exceeds the file size limit for AWS CodeCommit. For more
//   information about limits in AWS CodeCommit, see AWS CodeCommit User Guide
//   (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBlob
func (c *CodeCommit) GetBlob(input *GetBlobInput) (*GetBlobOutput, error) {
	req, out := c.GetBlobRequest(input)
	return out, req.Send()
}

// GetBlobWithContext is the same as GetBlob with the addition of
// the ability to pass a context and additional request options.
//
// See GetBlob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetBlobWithContext(ctx aws.Context, input *GetBlobInput, opts ...request.Option) (*GetBlobOutput, error) {
	req, out := c.GetBlobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBranch = "GetBranch"

// GetBranchRequest generates a "aws/request.Request" representing the
// client's request for the GetBranch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBranch for more information on using the GetBranch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBranchRequest method.
//    req, resp := client.GetBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranch
func (c *CodeCommit) GetBranchRequest(input *GetBranchInput) (req *request.Request, output *GetBranchOutput) {
	op := &request.Operation{
		Name:       opGetBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBranchInput{}
	}

	output = &GetBranchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBranch API operation for AWS CodeCommit.
//
// Returns information about a repository branch, including its name and the
// last commit ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeBranchNameRequiredException "BranchNameRequiredException"
//   A branch name is required but was not specified.
//
//   * ErrCodeInvalidBranchNameException "InvalidBranchNameException"
//   The specified reference name is not valid.
//
//   * ErrCodeBranchDoesNotExistException "BranchDoesNotExistException"
//   The specified branch does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetBranch
func (c *CodeCommit) GetBranch(input *GetBranchInput) (*GetBranchOutput, error) {
	req, out := c.GetBranchRequest(input)
	return out, req.Send()
}

// GetBranchWithContext is the same as GetBranch with the addition of
// the ability to pass a context and additional request options.
//
// See GetBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetBranchWithContext(ctx aws.Context, input *GetBranchInput, opts ...request.Option) (*GetBranchOutput, error) {
	req, out := c.GetBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComment = "GetComment"

// GetCommentRequest generates a "aws/request.Request" representing the
// client's request for the GetComment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComment for more information on using the GetComment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCommentRequest method.
//    req, resp := client.GetCommentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetComment
func (c *CodeCommit) GetCommentRequest(input *GetCommentInput) (req *request.Request, output *GetCommentOutput) {
	op := &request.Operation{
		Name:       opGetComment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCommentInput{}
	}

	output = &GetCommentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComment API operation for AWS CodeCommit.
//
// Returns the content of a comment made on a change, file, or commit in a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetComment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCommentDoesNotExistException "CommentDoesNotExistException"
//   No comment exists with the provided ID. Verify that you have provided the
//   correct ID, and then try again.
//
//   * ErrCodeCommentIdRequiredException "CommentIdRequiredException"
//   The comment ID is missing or null. A comment ID is required.
//
//   * ErrCodeInvalidCommentIdException "InvalidCommentIdException"
//   The comment ID is not in a valid format. Make sure that you have provided
//   the full comment ID.
//
//   * ErrCodeCommentDeletedException "CommentDeletedException"
//   This comment has already been deleted. You cannot edit or delete a deleted
//   comment.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetComment
func (c *CodeCommit) GetComment(input *GetCommentInput) (*GetCommentOutput, error) {
	req, out := c.GetCommentRequest(input)
	return out, req.Send()
}

// GetCommentWithContext is the same as GetComment with the addition of
// the ability to pass a context and additional request options.
//
// See GetComment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetCommentWithContext(ctx aws.Context, input *GetCommentInput, opts ...request.Option) (*GetCommentOutput, error) {
	req, out := c.GetCommentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCommentsForComparedCommit = "GetCommentsForComparedCommit"

// GetCommentsForComparedCommitRequest generates a "aws/request.Request" representing the
// client's request for the GetCommentsForComparedCommit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCommentsForComparedCommit for more information on using the GetCommentsForComparedCommit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCommentsForComparedCommitRequest method.
//    req, resp := client.GetCommentsForComparedCommitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit
func (c *CodeCommit) GetCommentsForComparedCommitRequest(input *GetCommentsForComparedCommitInput) (req *request.Request, output *GetCommentsForComparedCommitOutput) {
	op := &request.Operation{
		Name:       opGetCommentsForComparedCommit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCommentsForComparedCommitInput{}
	}

	output = &GetCommentsForComparedCommitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCommentsForComparedCommit API operation for AWS CodeCommit.
//
// Returns information about comments made on the comparison between two commits.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetCommentsForComparedCommit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeCommitIdRequiredException "CommitIdRequiredException"
//   A commit ID was not specified.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidMaxResultsException "InvalidMaxResultsException"
//   The specified number of maximum results is not valid.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForComparedCommit
func (c *CodeCommit) GetCommentsForComparedCommit(input *GetCommentsForComparedCommitInput) (*GetCommentsForComparedCommitOutput, error) {
	req, out := c.GetCommentsForComparedCommitRequest(input)
	return out, req.Send()
}

// GetCommentsForComparedCommitWithContext is the same as GetCommentsForComparedCommit with the addition of
// the ability to pass a context and additional request options.
//
// See GetCommentsForComparedCommit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetCommentsForComparedCommitWithContext(ctx aws.Context, input *GetCommentsForComparedCommitInput, opts ...request.Option) (*GetCommentsForComparedCommitOutput, error) {
	req, out := c.GetCommentsForComparedCommitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCommentsForComparedCommitPages iterates over the pages of a GetCommentsForComparedCommit operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCommentsForComparedCommit method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCommentsForComparedCommit operation.
//    pageNum := 0
//    err := client.GetCommentsForComparedCommitPages(params,
//        func(page *GetCommentsForComparedCommitOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) GetCommentsForComparedCommitPages(input *GetCommentsForComparedCommitInput, fn func(*GetCommentsForComparedCommitOutput, bool) bool) error {
	return c.GetCommentsForComparedCommitPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCommentsForComparedCommitPagesWithContext same as GetCommentsForComparedCommitPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetCommentsForComparedCommitPagesWithContext(ctx aws.Context, input *GetCommentsForComparedCommitInput, fn func(*GetCommentsForComparedCommitOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCommentsForComparedCommitInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCommentsForComparedCommitRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetCommentsForComparedCommitOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetCommentsForPullRequest = "GetCommentsForPullRequest"

// GetCommentsForPullRequestRequest generates a "aws/request.Request" representing the
// client's request for the GetCommentsForPullRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCommentsForPullRequest for more information on using the GetCommentsForPullRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCommentsForPullRequestRequest method.
//    req, resp := client.GetCommentsForPullRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest
func (c *CodeCommit) GetCommentsForPullRequestRequest(input *GetCommentsForPullRequestInput) (req *request.Request, output *GetCommentsForPullRequestOutput) {
	op := &request.Operation{
		Name:       opGetCommentsForPullRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCommentsForPullRequestInput{}
	}

	output = &GetCommentsForPullRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCommentsForPullRequest API operation for AWS CodeCommit.
//
// Returns comments made on a pull request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetCommentsForPullRequest for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePullRequestIdRequiredException "PullRequestIdRequiredException"
//   A pull request ID is required, but none was provided.
//
//   * ErrCodePullRequestDoesNotExistException "PullRequestDoesNotExistException"
//   The pull request ID could not be found. Make sure that you have specified
//   the correct repository name and pull request ID, and then try again.
//
//   * ErrCodeInvalidPullRequestIdException "InvalidPullRequestIdException"
//   The pull request ID is not valid. Make sure that you have provided the full
//   ID and that the pull request is in the specified repository, and then try
//   again.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeCommitIdRequiredException "CommitIdRequiredException"
//   A commit ID was not specified.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidMaxResultsException "InvalidMaxResultsException"
//   The specified number of maximum results is not valid.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
//   * ErrCodeRepositoryNotAssociatedWithPullRequestException "RepositoryNotAssociatedWithPullRequestException"
//   The repository does not contain any pull requests with that pull request
//   ID. Check to make sure you have provided the correct repository name for
//   the pull request.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommentsForPullRequest
func (c *CodeCommit) GetCommentsForPullRequest(input *GetCommentsForPullRequestInput) (*GetCommentsForPullRequestOutput, error) {
	req, out := c.GetCommentsForPullRequestRequest(input)
	return out, req.Send()
}

// GetCommentsForPullRequestWithContext is the same as GetCommentsForPullRequest with the addition of
// the ability to pass a context and additional request options.
//
// See GetCommentsForPullRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetCommentsForPullRequestWithContext(ctx aws.Context, input *GetCommentsForPullRequestInput, opts ...request.Option) (*GetCommentsForPullRequestOutput, error) {
	req, out := c.GetCommentsForPullRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCommentsForPullRequestPages iterates over the pages of a GetCommentsForPullRequest operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCommentsForPullRequest method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCommentsForPullRequest operation.
//    pageNum := 0
//    err := client.GetCommentsForPullRequestPages(params,
//        func(page *GetCommentsForPullRequestOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) GetCommentsForPullRequestPages(input *GetCommentsForPullRequestInput, fn func(*GetCommentsForPullRequestOutput, bool) bool) error {
	return c.GetCommentsForPullRequestPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCommentsForPullRequestPagesWithContext same as GetCommentsForPullRequestPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetCommentsForPullRequestPagesWithContext(ctx aws.Context, input *GetCommentsForPullRequestInput, fn func(*GetCommentsForPullRequestOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCommentsForPullRequestInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCommentsForPullRequestRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetCommentsForPullRequestOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetCommit = "GetCommit"

// GetCommitRequest generates a "aws/request.Request" representing the
// client's request for the GetCommit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCommit for more information on using the GetCommit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCommitRequest method.
//    req, resp := client.GetCommitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommit
func (c *CodeCommit) GetCommitRequest(input *GetCommitInput) (req *request.Request, output *GetCommitOutput) {
	op := &request.Operation{
		Name:       opGetCommit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCommitInput{}
	}

	output = &GetCommitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCommit API operation for AWS CodeCommit.
//
// Returns information about a commit, including commit message and committer
// information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetCommit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeCommitIdRequiredException "CommitIdRequiredException"
//   A commit ID was not specified.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeCommitIdDoesNotExistException "CommitIdDoesNotExistException"
//   The specified commit ID does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetCommit
func (c *CodeCommit) GetCommit(input *GetCommitInput) (*GetCommitOutput, error) {
	req, out := c.GetCommitRequest(input)
	return out, req.Send()
}

// GetCommitWithContext is the same as GetCommit with the addition of
// the ability to pass a context and additional request options.
//
// See GetCommit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetCommitWithContext(ctx aws.Context, input *GetCommitInput, opts ...request.Option) (*GetCommitOutput, error) {
	req, out := c.GetCommitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDifferences = "GetDifferences"

// GetDifferencesRequest generates a "aws/request.Request" representing the
// client's request for the GetDifferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDifferences for more information on using the GetDifferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDifferencesRequest method.
//    req, resp := client.GetDifferencesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences
func (c *CodeCommit) GetDifferencesRequest(input *GetDifferencesInput) (req *request.Request, output *GetDifferencesOutput) {
	op := &request.Operation{
		Name:       opGetDifferences,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDifferencesInput{}
	}

	output = &GetDifferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDifferences API operation for AWS CodeCommit.
//
// Returns information about the differences in a valid commit specifier (such
// as a branch, tag, HEAD, commit ID or other fully qualified reference). Results
// can be limited to a specified path.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetDifferences for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
//   * ErrCodeInvalidMaxResultsException "InvalidMaxResultsException"
//   The specified number of maximum results is not valid.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeCommitRequiredException "CommitRequiredException"
//   A commit was not specified.
//
//   * ErrCodeInvalidCommitException "InvalidCommitException"
//   The specified commit is not valid.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidPathException "InvalidPathException"
//   The specified path is not valid.
//
//   * ErrCodePathDoesNotExistException "PathDoesNotExistException"
//   The specified path does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetDifferences
func (c *CodeCommit) GetDifferences(input *GetDifferencesInput) (*GetDifferencesOutput, error) {
	req, out := c.GetDifferencesRequest(input)
	return out, req.Send()
}

// GetDifferencesWithContext is the same as GetDifferences with the addition of
// the ability to pass a context and additional request options.
//
// See GetDifferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetDifferencesWithContext(ctx aws.Context, input *GetDifferencesInput, opts ...request.Option) (*GetDifferencesOutput, error) {
	req, out := c.GetDifferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDifferencesPages iterates over the pages of a GetDifferences operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDifferences method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDifferences operation.
//    pageNum := 0
//    err := client.GetDifferencesPages(params,
//        func(page *GetDifferencesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) GetDifferencesPages(input *GetDifferencesInput, fn func(*GetDifferencesOutput, bool) bool) error {
	return c.GetDifferencesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDifferencesPagesWithContext same as GetDifferencesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetDifferencesPagesWithContext(ctx aws.Context, input *GetDifferencesInput, fn func(*GetDifferencesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDifferencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDifferencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*GetDifferencesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opGetMergeConflicts = "GetMergeConflicts"

// GetMergeConflictsRequest generates a "aws/request.Request" representing the
// client's request for the GetMergeConflicts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMergeConflicts for more information on using the GetMergeConflicts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMergeConflictsRequest method.
//    req, resp := client.GetMergeConflictsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts
func (c *CodeCommit) GetMergeConflictsRequest(input *GetMergeConflictsInput) (req *request.Request, output *GetMergeConflictsOutput) {
	op := &request.Operation{
		Name:       opGetMergeConflicts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMergeConflictsInput{}
	}

	output = &GetMergeConflictsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMergeConflicts API operation for AWS CodeCommit.
//
// Returns information about merge conflicts between the before and after commit
// IDs for a pull request in a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetMergeConflicts for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeMergeOptionRequiredException "MergeOptionRequiredException"
//   A merge option or stategy is required, and none was provided.
//
//   * ErrCodeInvalidMergeOptionException "InvalidMergeOptionException"
//   The specified merge option is not valid. The only valid value is FAST_FORWARD_MERGE.
//
//   * ErrCodeInvalidDestinationCommitSpecifierException "InvalidDestinationCommitSpecifierException"
//   The destination commit specifier is not valid. You must provide a valid branch
//   name, tag, or full commit ID.
//
//   * ErrCodeInvalidSourceCommitSpecifierException "InvalidSourceCommitSpecifierException"
//   The source commit specifier is not valid. You must provide a valid branch
//   name, tag, or full commit ID.
//
//   * ErrCodeCommitRequiredException "CommitRequiredException"
//   A commit was not specified.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidCommitException "InvalidCommitException"
//   The specified commit is not valid.
//
//   * ErrCodeTipsDivergenceExceededException "TipsDivergenceExceededException"
//   The divergence between the tips of the provided commit specifiers is too
//   great to determine whether there might be any merge conflicts. Locally compare
//   the specifiers using git diff or a diff tool.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetMergeConflicts
func (c *CodeCommit) GetMergeConflicts(input *GetMergeConflictsInput) (*GetMergeConflictsOutput, error) {
	req, out := c.GetMergeConflictsRequest(input)
	return out, req.Send()
}

// GetMergeConflictsWithContext is the same as GetMergeConflicts with the addition of
// the ability to pass a context and additional request options.
//
// See GetMergeConflicts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetMergeConflictsWithContext(ctx aws.Context, input *GetMergeConflictsInput, opts ...request.Option) (*GetMergeConflictsOutput, error) {
	req, out := c.GetMergeConflictsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPullRequest = "GetPullRequest"

// GetPullRequestRequest generates a "aws/request.Request" representing the
// client's request for the GetPullRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPullRequest for more information on using the GetPullRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPullRequestRequest method.
//    req, resp := client.GetPullRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequest
func (c *CodeCommit) GetPullRequestRequest(input *GetPullRequestInput) (req *request.Request, output *GetPullRequestOutput) {
	op := &request.Operation{
		Name:       opGetPullRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPullRequestInput{}
	}

	output = &GetPullRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPullRequest API operation for AWS CodeCommit.
//
// Gets information about a pull request in a specified repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetPullRequest for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePullRequestDoesNotExistException "PullRequestDoesNotExistException"
//   The pull request ID could not be found. Make sure that you have specified
//   the correct repository name and pull request ID, and then try again.
//
//   * ErrCodeInvalidPullRequestIdException "InvalidPullRequestIdException"
//   The pull request ID is not valid. Make sure that you have provided the full
//   ID and that the pull request is in the specified repository, and then try
//   again.
//
//   * ErrCodePullRequestIdRequiredException "PullRequestIdRequiredException"
//   A pull request ID is required, but none was provided.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetPullRequest
func (c *CodeCommit) GetPullRequest(input *GetPullRequestInput) (*GetPullRequestOutput, error) {
	req, out := c.GetPullRequestRequest(input)
	return out, req.Send()
}

// GetPullRequestWithContext is the same as GetPullRequest with the addition of
// the ability to pass a context and additional request options.
//
// See GetPullRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetPullRequestWithContext(ctx aws.Context, input *GetPullRequestInput, opts ...request.Option) (*GetPullRequestOutput, error) {
	req, out := c.GetPullRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepository = "GetRepository"

// GetRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the GetRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepository for more information on using the GetRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRepositoryRequest method.
//    req, resp := client.GetRepositoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepository
func (c *CodeCommit) GetRepositoryRequest(input *GetRepositoryInput) (req *request.Request, output *GetRepositoryOutput) {
	op := &request.Operation{
		Name:       opGetRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryInput{}
	}

	output = &GetRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepository API operation for AWS CodeCommit.
//
// Returns information about a repository.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetRepository for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepository
func (c *CodeCommit) GetRepository(input *GetRepositoryInput) (*GetRepositoryOutput, error) {
	req, out := c.GetRepositoryRequest(input)
	return out, req.Send()
}

// GetRepositoryWithContext is the same as GetRepository with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetRepositoryWithContext(ctx aws.Context, input *GetRepositoryInput, opts ...request.Option) (*GetRepositoryOutput, error) {
	req, out := c.GetRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositoryTriggers = "GetRepositoryTriggers"

// GetRepositoryTriggersRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositoryTriggers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepositoryTriggers for more information on using the GetRepositoryTriggers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRepositoryTriggersRequest method.
//    req, resp := client.GetRepositoryTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggers
func (c *CodeCommit) GetRepositoryTriggersRequest(input *GetRepositoryTriggersInput) (req *request.Request, output *GetRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opGetRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryTriggersInput{}
	}

	output = &GetRepositoryTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositoryTriggers API operation for AWS CodeCommit.
//
// Gets information about triggers configured for a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation GetRepositoryTriggers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/GetRepositoryTriggers
func (c *CodeCommit) GetRepositoryTriggers(input *GetRepositoryTriggersInput) (*GetRepositoryTriggersOutput, error) {
	req, out := c.GetRepositoryTriggersRequest(input)
	return out, req.Send()
}

// GetRepositoryTriggersWithContext is the same as GetRepositoryTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositoryTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) GetRepositoryTriggersWithContext(ctx aws.Context, input *GetRepositoryTriggersInput, opts ...request.Option) (*GetRepositoryTriggersOutput, error) {
	req, out := c.GetRepositoryTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBranches = "ListBranches"

// ListBranchesRequest generates a "aws/request.Request" representing the
// client's request for the ListBranches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBranches for more information on using the ListBranches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListBranchesRequest method.
//    req, resp := client.ListBranchesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches
func (c *CodeCommit) ListBranchesRequest(input *ListBranchesInput) (req *request.Request, output *ListBranchesOutput) {
	op := &request.Operation{
		Name:       opListBranches,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBranchesInput{}
	}

	output = &ListBranchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBranches API operation for AWS CodeCommit.
//
// Gets information about one or more branches in a repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation ListBranches for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListBranches
func (c *CodeCommit) ListBranches(input *ListBranchesInput) (*ListBranchesOutput, error) {
	req, out := c.ListBranchesRequest(input)
	return out, req.Send()
}

// ListBranchesWithContext is the same as ListBranches with the addition of
// the ability to pass a context and additional request options.
//
// See ListBranches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListBranchesWithContext(ctx aws.Context, input *ListBranchesInput, opts ...request.Option) (*ListBranchesOutput, error) {
	req, out := c.ListBranchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBranchesPages iterates over the pages of a ListBranches operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBranches method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListBranches operation.
//    pageNum := 0
//    err := client.ListBranchesPages(params,
//        func(page *ListBranchesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) ListBranchesPages(input *ListBranchesInput, fn func(*ListBranchesOutput, bool) bool) error {
	return c.ListBranchesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBranchesPagesWithContext same as ListBranchesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListBranchesPagesWithContext(ctx aws.Context, input *ListBranchesInput, fn func(*ListBranchesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBranchesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBranchesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListBranchesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListPullRequests = "ListPullRequests"

// ListPullRequestsRequest generates a "aws/request.Request" representing the
// client's request for the ListPullRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPullRequests for more information on using the ListPullRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPullRequestsRequest method.
//    req, resp := client.ListPullRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests
func (c *CodeCommit) ListPullRequestsRequest(input *ListPullRequestsInput) (req *request.Request, output *ListPullRequestsOutput) {
	op := &request.Operation{
		Name:       opListPullRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPullRequestsInput{}
	}

	output = &ListPullRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPullRequests API operation for AWS CodeCommit.
//
// Returns a list of pull requests for a specified repository. The return list
// can be refined by pull request status or pull request author ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation ListPullRequests for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidPullRequestStatusException "InvalidPullRequestStatusException"
//   The pull request status is not valid. The only valid values are OPEN and
//   CLOSED.
//
//   * ErrCodeInvalidAuthorArnException "InvalidAuthorArnException"
//   The Amazon Resource Name (ARN) is not valid. Make sure that you have provided
//   the full ARN for the author of the pull request, and then try again.
//
//   * ErrCodeAuthorDoesNotExistException "AuthorDoesNotExistException"
//   The specified Amazon Resource Name (ARN) does not exist in the AWS account.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidMaxResultsException "InvalidMaxResultsException"
//   The specified number of maximum results is not valid.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListPullRequests
func (c *CodeCommit) ListPullRequests(input *ListPullRequestsInput) (*ListPullRequestsOutput, error) {
	req, out := c.ListPullRequestsRequest(input)
	return out, req.Send()
}

// ListPullRequestsWithContext is the same as ListPullRequests with the addition of
// the ability to pass a context and additional request options.
//
// See ListPullRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListPullRequestsWithContext(ctx aws.Context, input *ListPullRequestsInput, opts ...request.Option) (*ListPullRequestsOutput, error) {
	req, out := c.ListPullRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPullRequestsPages iterates over the pages of a ListPullRequests operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPullRequests method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPullRequests operation.
//    pageNum := 0
//    err := client.ListPullRequestsPages(params,
//        func(page *ListPullRequestsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) ListPullRequestsPages(input *ListPullRequestsInput, fn func(*ListPullRequestsOutput, bool) bool) error {
	return c.ListPullRequestsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPullRequestsPagesWithContext same as ListPullRequestsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListPullRequestsPagesWithContext(ctx aws.Context, input *ListPullRequestsInput, fn func(*ListPullRequestsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPullRequestsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPullRequestsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListPullRequestsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListRepositories = "ListRepositories"

// ListRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositories for more information on using the ListRepositories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRepositoriesRequest method.
//    req, resp := client.ListRepositoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories
func (c *CodeCommit) ListRepositoriesRequest(input *ListRepositoriesInput) (req *request.Request, output *ListRepositoriesOutput) {
	op := &request.Operation{
		Name:       opListRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInput{}
	}

	output = &ListRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositories API operation for AWS CodeCommit.
//
// Gets information about one or more repositories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation ListRepositories for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidSortByException "InvalidSortByException"
//   The specified sort by value is not valid.
//
//   * ErrCodeInvalidOrderException "InvalidOrderException"
//   The specified sort order is not valid.
//
//   * ErrCodeInvalidContinuationTokenException "InvalidContinuationTokenException"
//   The specified continuation token is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/ListRepositories
func (c *CodeCommit) ListRepositories(input *ListRepositoriesInput) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	return out, req.Send()
}

// ListRepositoriesWithContext is the same as ListRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListRepositoriesWithContext(ctx aws.Context, input *ListRepositoriesInput, opts ...request.Option) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositoriesPages iterates over the pages of a ListRepositories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRepositories operation.
//    pageNum := 0
//    err := client.ListRepositoriesPages(params,
//        func(page *ListRepositoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CodeCommit) ListRepositoriesPages(input *ListRepositoriesInput, fn func(*ListRepositoriesOutput, bool) bool) error {
	return c.ListRepositoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositoriesPagesWithContext same as ListRepositoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) ListRepositoriesPagesWithContext(ctx aws.Context, input *ListRepositoriesInput, fn func(*ListRepositoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListRepositoriesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opMergePullRequestByFastForward = "MergePullRequestByFastForward"

// MergePullRequestByFastForwardRequest generates a "aws/request.Request" representing the
// client's request for the MergePullRequestByFastForward operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MergePullRequestByFastForward for more information on using the MergePullRequestByFastForward
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the MergePullRequestByFastForwardRequest method.
//    req, resp := client.MergePullRequestByFastForwardRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByFastForward
func (c *CodeCommit) MergePullRequestByFastForwardRequest(input *MergePullRequestByFastForwardInput) (req *request.Request, output *MergePullRequestByFastForwardOutput) {
	op := &request.Operation{
		Name:       opMergePullRequestByFastForward,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MergePullRequestByFastForwardInput{}
	}

	output = &MergePullRequestByFastForwardOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MergePullRequestByFastForward API operation for AWS CodeCommit.
//
// Closes a pull request and attempts to merge the source commit of a pull request
// into the specified destination branch for that pull request at the specified
// commit using the fast-forward merge option.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation MergePullRequestByFastForward for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeManualMergeRequiredException "ManualMergeRequiredException"
//   The pull request cannot be merged automatically into the destination branch.
//   You must manually merge the branches and resolve any conflicts.
//
//   * ErrCodePullRequestAlreadyClosedException "PullRequestAlreadyClosedException"
//   The pull request status cannot be updated because it is already closed.
//
//   * ErrCodePullRequestDoesNotExistException "PullRequestDoesNotExistException"
//   The pull request ID could not be found. Make sure that you have specified
//   the correct repository name and pull request ID, and then try again.
//
//   * ErrCodeInvalidPullRequestIdException "InvalidPullRequestIdException"
//   The pull request ID is not valid. Make sure that you have provided the full
//   ID and that the pull request is in the specified repository, and then try
//   again.
//
//   * ErrCodePullRequestIdRequiredException "PullRequestIdRequiredException"
//   A pull request ID is required, but none was provided.
//
//   * ErrCodeTipOfSourceReferenceIsDifferentException "TipOfSourceReferenceIsDifferentException"
//   The tip of the source branch in the destination repository does not match
//   the tip of the source branch specified in your request. The pull request
//   might have been updated. Make sure that you have the latest changes.
//
//   * ErrCodeReferenceDoesNotExistException "ReferenceDoesNotExistException"
//   The specified reference does not exist. You must provide a full commit ID.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/MergePullRequestByFastForward
func (c *CodeCommit) MergePullRequestByFastForward(input *MergePullRequestByFastForwardInput) (*MergePullRequestByFastForwardOutput, error) {
	req, out := c.MergePullRequestByFastForwardRequest(input)
	return out, req.Send()
}

// MergePullRequestByFastForwardWithContext is the same as MergePullRequestByFastForward with the addition of
// the ability to pass a context and additional request options.
//
// See MergePullRequestByFastForward for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) MergePullRequestByFastForwardWithContext(ctx aws.Context, input *MergePullRequestByFastForwardInput, opts ...request.Option) (*MergePullRequestByFastForwardOutput, error) {
	req, out := c.MergePullRequestByFastForwardRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPostCommentForComparedCommit = "PostCommentForComparedCommit"

// PostCommentForComparedCommitRequest generates a "aws/request.Request" representing the
// client's request for the PostCommentForComparedCommit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PostCommentForComparedCommit for more information on using the PostCommentForComparedCommit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PostCommentForComparedCommitRequest method.
//    req, resp := client.PostCommentForComparedCommitRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForComparedCommit
func (c *CodeCommit) PostCommentForComparedCommitRequest(input *PostCommentForComparedCommitInput) (req *request.Request, output *PostCommentForComparedCommitOutput) {
	op := &request.Operation{
		Name:       opPostCommentForComparedCommit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PostCommentForComparedCommitInput{}
	}

	output = &PostCommentForComparedCommitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PostCommentForComparedCommit API operation for AWS CodeCommit.
//
// Posts a comment on the comparison between two commits.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation PostCommentForComparedCommit for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeClientRequestTokenRequiredException "ClientRequestTokenRequiredException"
//   A client request token is required. A client request token is an unique,
//   client-generated idempotency token that when provided in a request, ensures
//   the request cannot be repeated with a changed parameter. If a request is
//   received with the same parameters and a token is included, the request will
//   return information about the initial request that used that token.
//
//   * ErrCodeInvalidClientRequestTokenException "InvalidClientRequestTokenException"
//   The client request token is not valid.
//
//   * ErrCodeIdempotencyParameterMismatchException "IdempotencyParameterMismatchException"
//   The client request token is not valid. Either the token is not in a valid
//   format, or the token has been used in a previous request and cannot be re-used.
//
//   * ErrCodeCommentContentRequiredException "CommentContentRequiredException"
//   The comment is empty. You must provide some content for a comment. The content
//   cannot be null.
//
//   * ErrCodeCommentContentSizeLimitExceededException "CommentContentSizeLimitExceededException"
//   The comment is too large. Comments are limited to 1,000 characters.
//
//   * ErrCodeInvalidFileLocationException "InvalidFileLocationException"
//   The location of the file is not valid. Make sure that you include the extension
//   of the file as well as the file name.
//
//   * ErrCodeInvalidRelativeFileVersionEnumException "InvalidRelativeFileVersionEnumException"
//   Either the enum is not in a valid format, or the specified file version enum
//   is not valid in respect to the current file version.
//
//   * ErrCodePathRequiredException "PathRequiredException"
//   The filePath for a location cannot be empty or null.
//
//   * ErrCodeInvalidFilePositionException "InvalidFilePositionException"
//   The position is not valid. Make sure that the line number exists in the version
//   of the file you want to comment on.
//
//   * ErrCodeCommitIdRequiredException "CommitIdRequiredException"
//   A commit ID was not specified.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
//   * ErrCodeBeforeCommitIdAndAfterCommitIdAreSameException "BeforeCommitIdAndAfterCommitIdAreSameException"
//   The before commit ID and the after commit ID are the same, which is not valid.
//   The before commit ID and the after commit ID must be different commit IDs.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidPathException "InvalidPathException"
//   The specified path is not valid.
//
//   * ErrCodePathDoesNotExistException "PathDoesNotExistException"
//   The specified path does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForComparedCommit
func (c *CodeCommit) PostCommentForComparedCommit(input *PostCommentForComparedCommitInput) (*PostCommentForComparedCommitOutput, error) {
	req, out := c.PostCommentForComparedCommitRequest(input)
	return out, req.Send()
}

// PostCommentForComparedCommitWithContext is the same as PostCommentForComparedCommit with the addition of
// the ability to pass a context and additional request options.
//
// See PostCommentForComparedCommit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) PostCommentForComparedCommitWithContext(ctx aws.Context, input *PostCommentForComparedCommitInput, opts ...request.Option) (*PostCommentForComparedCommitOutput, error) {
	req, out := c.PostCommentForComparedCommitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPostCommentForPullRequest = "PostCommentForPullRequest"

// PostCommentForPullRequestRequest generates a "aws/request.Request" representing the
// client's request for the PostCommentForPullRequest operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PostCommentForPullRequest for more information on using the PostCommentForPullRequest
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PostCommentForPullRequestRequest method.
//    req, resp := client.PostCommentForPullRequestRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForPullRequest
func (c *CodeCommit) PostCommentForPullRequestRequest(input *PostCommentForPullRequestInput) (req *request.Request, output *PostCommentForPullRequestOutput) {
	op := &request.Operation{
		Name:       opPostCommentForPullRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PostCommentForPullRequestInput{}
	}

	output = &PostCommentForPullRequestOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PostCommentForPullRequest API operation for AWS CodeCommit.
//
// Posts a comment on a pull request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation PostCommentForPullRequest for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePullRequestDoesNotExistException "PullRequestDoesNotExistException"
//   The pull request ID could not be found. Make sure that you have specified
//   the correct repository name and pull request ID, and then try again.
//
//   * ErrCodeInvalidPullRequestIdException "InvalidPullRequestIdException"
//   The pull request ID is not valid. Make sure that you have provided the full
//   ID and that the pull request is in the specified repository, and then try
//   again.
//
//   * ErrCodePullRequestIdRequiredException "PullRequestIdRequiredException"
//   A pull request ID is required, but none was provided.
//
//   * ErrCodeRepositoryNotAssociatedWithPullRequestException "RepositoryNotAssociatedWithPullRequestException"
//   The repository does not contain any pull requests with that pull request
//   ID. Check to make sure you have provided the correct repository name for
//   the pull request.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeClientRequestTokenRequiredException "ClientRequestTokenRequiredException"
//   A client request token is required. A client request token is an unique,
//   client-generated idempotency token that when provided in a request, ensures
//   the request cannot be repeated with a changed parameter. If a request is
//   received with the same parameters and a token is included, the request will
//   return information about the initial request that used that token.
//
//   * ErrCodeInvalidClientRequestTokenException "InvalidClientRequestTokenException"
//   The client request token is not valid.
//
//   * ErrCodeIdempotencyParameterMismatchException "IdempotencyParameterMismatchException"
//   The client request token is not valid. Either the token is not in a valid
//   format, or the token has been used in a previous request and cannot be re-used.
//
//   * ErrCodeCommentContentRequiredException "CommentContentRequiredException"
//   The comment is empty. You must provide some content for a comment. The content
//   cannot be null.
//
//   * ErrCodeCommentContentSizeLimitExceededException "CommentContentSizeLimitExceededException"
//   The comment is too large. Comments are limited to 1,000 characters.
//
//   * ErrCodeInvalidFileLocationException "InvalidFileLocationException"
//   The location of the file is not valid. Make sure that you include the extension
//   of the file as well as the file name.
//
//   * ErrCodeInvalidRelativeFileVersionEnumException "InvalidRelativeFileVersionEnumException"
//   Either the enum is not in a valid format, or the specified file version enum
//   is not valid in respect to the current file version.
//
//   * ErrCodePathRequiredException "PathRequiredException"
//   The filePath for a location cannot be empty or null.
//
//   * ErrCodeInvalidFilePositionException "InvalidFilePositionException"
//   The position is not valid. Make sure that the line number exists in the version
//   of the file you want to comment on.
//
//   * ErrCodeCommitIdRequiredException "CommitIdRequiredException"
//   A commit ID was not specified.
//
//   * ErrCodeInvalidCommitIdException "InvalidCommitIdException"
//   The specified commit ID is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
//   * ErrCodeCommitDoesNotExistException "CommitDoesNotExistException"
//   The specified commit does not exist or no commit was specified, and the specified
//   repository has no default branch.
//
//   * ErrCodeInvalidPathException "InvalidPathException"
//   The specified path is not valid.
//
//   * ErrCodePathDoesNotExistException "PathDoesNotExistException"
//   The specified path does not exist.
//
//   * ErrCodePathRequiredException "PathRequiredException"
//   The filePath for a location cannot be empty or null.
//
//   * ErrCodeBeforeCommitIdAndAfterCommitIdAreSameException "BeforeCommitIdAndAfterCommitIdAreSameException"
//   The before commit ID and the after commit ID are the same, which is not valid.
//   The before commit ID and the after commit ID must be different commit IDs.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentForPullRequest
func (c *CodeCommit) PostCommentForPullRequest(input *PostCommentForPullRequestInput) (*PostCommentForPullRequestOutput, error) {
	req, out := c.PostCommentForPullRequestRequest(input)
	return out, req.Send()
}

// PostCommentForPullRequestWithContext is the same as PostCommentForPullRequest with the addition of
// the ability to pass a context and additional request options.
//
// See PostCommentForPullRequest for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) PostCommentForPullRequestWithContext(ctx aws.Context, input *PostCommentForPullRequestInput, opts ...request.Option) (*PostCommentForPullRequestOutput, error) {
	req, out := c.PostCommentForPullRequestRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPostCommentReply = "PostCommentReply"

// PostCommentReplyRequest generates a "aws/request.Request" representing the
// client's request for the PostCommentReply operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PostCommentReply for more information on using the PostCommentReply
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PostCommentReplyRequest method.
//    req, resp := client.PostCommentReplyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentReply
func (c *CodeCommit) PostCommentReplyRequest(input *PostCommentReplyInput) (req *request.Request, output *PostCommentReplyOutput) {
	op := &request.Operation{
		Name:       opPostCommentReply,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PostCommentReplyInput{}
	}

	output = &PostCommentReplyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PostCommentReply API operation for AWS CodeCommit.
//
// Posts a comment in reply to an existing comment on a comparison between commits
// or a pull request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation PostCommentReply for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClientRequestTokenRequiredException "ClientRequestTokenRequiredException"
//   A client request token is required. A client request token is an unique,
//   client-generated idempotency token that when provided in a request, ensures
//   the request cannot be repeated with a changed parameter. If a request is
//   received with the same parameters and a token is included, the request will
//   return information about the initial request that used that token.
//
//   * ErrCodeInvalidClientRequestTokenException "InvalidClientRequestTokenException"
//   The client request token is not valid.
//
//   * ErrCodeIdempotencyParameterMismatchException "IdempotencyParameterMismatchException"
//   The client request token is not valid. Either the token is not in a valid
//   format, or the token has been used in a previous request and cannot be re-used.
//
//   * ErrCodeCommentContentRequiredException "CommentContentRequiredException"
//   The comment is empty. You must provide some content for a comment. The content
//   cannot be null.
//
//   * ErrCodeCommentContentSizeLimitExceededException "CommentContentSizeLimitExceededException"
//   The comment is too large. Comments are limited to 1,000 characters.
//
//   * ErrCodeCommentDoesNotExistException "CommentDoesNotExistException"
//   No comment exists with the provided ID. Verify that you have provided the
//   correct ID, and then try again.
//
//   * ErrCodeCommentIdRequiredException "CommentIdRequiredException"
//   The comment ID is missing or null. A comment ID is required.
//
//   * ErrCodeInvalidCommentIdException "InvalidCommentIdException"
//   The comment ID is not in a valid format. Make sure that you have provided
//   the full comment ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PostCommentReply
func (c *CodeCommit) PostCommentReply(input *PostCommentReplyInput) (*PostCommentReplyOutput, error) {
	req, out := c.PostCommentReplyRequest(input)
	return out, req.Send()
}

// PostCommentReplyWithContext is the same as PostCommentReply with the addition of
// the ability to pass a context and additional request options.
//
// See PostCommentReply for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) PostCommentReplyWithContext(ctx aws.Context, input *PostCommentReplyInput, opts ...request.Option) (*PostCommentReplyOutput, error) {
	req, out := c.PostCommentReplyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutFile = "PutFile"

// PutFileRequest generates a "aws/request.Request" representing the
// client's request for the PutFile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFile for more information on using the PutFile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutFileRequest method.
//    req, resp := client.PutFileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutFile
func (c *CodeCommit) PutFileRequest(input *PutFileInput) (req *request.Request, output *PutFileOutput) {
	op := &request.Operation{
		Name:       opPutFile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutFileInput{}
	}

	output = &PutFileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutFile API operation for AWS CodeCommit.
//
// Adds or updates a file in an AWS CodeCommit repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation PutFile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeParentCommitIdRequiredException "ParentCommitIdRequiredException"
//   A parent commit ID is required. To view the full commit ID of a branch in
//   a repository, use GetBranch or a Git command (for example, git pull or git
//   log).
//
//   * ErrCodeInvalidParentCommitIdException "InvalidParentCommitIdException"
//   The parent commit ID is not valid. The commit ID cannot be empty, and must
//   match the head commit ID for the branch of the repository where you want
//   to add or update a file.
//
//   * ErrCodeParentCommitDoesNotExistException "ParentCommitDoesNotExistException"
//   The parent commit ID is not valid. The specified parent commit ID does not
//   exist in the specified branch of the repository.
//
//   * ErrCodeParentCommitIdOutdatedException "ParentCommitIdOutdatedException"
//   The file could not be added because the provided parent commit ID is not
//   the current tip of the specified branch. To view the full commit ID of the
//   current head of the branch, use GetBranch.
//
//   * ErrCodeFileContentRequiredException "FileContentRequiredException"
//   The file cannot be added because it is empty. Empty files cannot be added
//   to the repository with this API.
//
//   * ErrCodeFileContentSizeLimitExceededException "FileContentSizeLimitExceededException"
//   The file cannot be added because it is too large. The maximum file size that
//   can be added using PutFile is 6 MB. For files larger than 6 MB but smaller
//   than 2 GB, add them using a Git client.
//
//   * ErrCodePathRequiredException "PathRequiredException"
//   The filePath for a location cannot be empty or null.
//
//   * ErrCodeInvalidPathException "InvalidPathException"
//   The specified path is not valid.
//
//   * ErrCodeBranchNameRequiredException "BranchNameRequiredException"
//   A branch name is required but was not specified.
//
//   * ErrCodeInvalidBranchNameException "InvalidBranchNameException"
//   The specified reference name is not valid.
//
//   * ErrCodeBranchDoesNotExistException "BranchDoesNotExistException"
//   The specified branch does not exist.
//
//   * ErrCodeBranchNameIsTagNameException "BranchNameIsTagNameException"
//   The specified branch name is not valid because it is a tag name. Type the
//   name of a current branch in the repository. For a list of valid branch names,
//   use ListBranches.
//
//   * ErrCodeInvalidFileModeException "InvalidFileModeException"
//   The specified file mode permission is not valid. For a list of valid file
//   mode permissions, see PutFile.
//
//   * ErrCodeNameLengthExceededException "NameLengthExceededException"
//   The file name is not valid because it has exceeded the character limit for
//   file names. File names, including the path to the file, cannot exceed the
//   character limit.
//
//   * ErrCodeInvalidEmailException "InvalidEmailException"
//   The specified email address either contains one or more characters that are
//   not allowed, or it exceeds the maximum number of characters allowed for an
//   email address.
//
//   * ErrCodeCommitMessageLengthExceededException "CommitMessageLengthExceededException"
//   The commit message is too long. Provide a shorter string.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
//   * ErrCodeSameFileContentException "SameFileContentException"
//   The file was not added or updated because the content of the file is exactly
//   the same as the content of that file in the repository and branch that you
//   specified.
//
//   * ErrCodeFileNameConflictsWithDirectoryNameException "FileNameConflictsWithDirectoryNameException"
//   A file cannot be added to the repository because the specified file name
//   has the same name as a directory in this repository. Either provide another
//   name for the file, or add the file in a directory that does not match the
//   file name.
//
//   * ErrCodeDirectoryNameConflictsWithFileNameException "DirectoryNameConflictsWithFileNameException"
//   A file cannot be added to the repository because the specified path name
//   has the same name as a file that already exists in this repository. Either
//   provide a different name for the file, or specify a different path for the
//   file.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutFile
func (c *CodeCommit) PutFile(input *PutFileInput) (*PutFileOutput, error) {
	req, out := c.PutFileRequest(input)
	return out, req.Send()
}

// PutFileWithContext is the same as PutFile with the addition of
// the ability to pass a context and additional request options.
//
// See PutFile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) PutFileWithContext(ctx aws.Context, input *PutFileInput, opts ...request.Option) (*PutFileOutput, error) {
	req, out := c.PutFileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRepositoryTriggers = "PutRepositoryTriggers"

// PutRepositoryTriggersRequest generates a "aws/request.Request" representing the
// client's request for the PutRepositoryTriggers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRepositoryTriggers for more information on using the PutRepositoryTriggers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRepositoryTriggersRequest method.
//    req, resp := client.PutRepositoryTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggers
func (c *CodeCommit) PutRepositoryTriggersRequest(input *PutRepositoryTriggersInput) (req *request.Request, output *PutRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opPutRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRepositoryTriggersInput{}
	}

	output = &PutRepositoryTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRepositoryTriggers API operation for AWS CodeCommit.
//
// Replaces all triggers for a repository. This can be used to create or delete
// triggers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation PutRepositoryTriggers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryTriggersListRequiredException "RepositoryTriggersListRequiredException"
//   The list of triggers for the repository is required but was not specified.
//
//   * ErrCodeMaximumRepositoryTriggersExceededException "MaximumRepositoryTriggersExceededException"
//   The number of triggers allowed for the repository was exceeded.
//
//   * ErrCodeInvalidRepositoryTriggerNameException "InvalidRepositoryTriggerNameException"
//   The name of the trigger is not valid.
//
//   * ErrCodeInvalidRepositoryTriggerDestinationArnException "InvalidRepositoryTriggerDestinationArnException"
//   The Amazon Resource Name (ARN) for the trigger is not valid for the specified
//   destination. The most common reason for this error is that the ARN does not
//   meet the requirements for the service type.
//
//   * ErrCodeInvalidRepositoryTriggerRegionException "InvalidRepositoryTriggerRegionException"
//   The region for the trigger target does not match the region for the repository.
//   Triggers must be created in the same region as the target for the trigger.
//
//   * ErrCodeInvalidRepositoryTriggerCustomDataException "InvalidRepositoryTriggerCustomDataException"
//   The custom data provided for the trigger is not valid.
//
//   * ErrCodeMaximumBranchesExceededException "MaximumBranchesExceededException"
//   The number of branches for the trigger was exceeded.
//
//   * ErrCodeInvalidRepositoryTriggerBranchNameException "InvalidRepositoryTriggerBranchNameException"
//   One or more branch names specified for the trigger is not valid.
//
//   * ErrCodeInvalidRepositoryTriggerEventsException "InvalidRepositoryTriggerEventsException"
//   One or more events specified for the trigger is not valid. Check to make
//   sure that all events specified match the requirements for allowed events.
//
//   * ErrCodeRepositoryTriggerNameRequiredException "RepositoryTriggerNameRequiredException"
//   A name for the trigger is required but was not specified.
//
//   * ErrCodeRepositoryTriggerDestinationArnRequiredException "RepositoryTriggerDestinationArnRequiredException"
//   A destination ARN for the target service for the trigger is required but
//   was not specified.
//
//   * ErrCodeRepositoryTriggerBranchNameListRequiredException "RepositoryTriggerBranchNameListRequiredException"
//   At least one branch name is required but was not specified in the trigger
//   configuration.
//
//   * ErrCodeRepositoryTriggerEventsListRequiredException "RepositoryTriggerEventsListRequiredException"
//   At least one event for the trigger is required but was not specified.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PutRepositoryTriggers
func (c *CodeCommit) PutRepositoryTriggers(input *PutRepositoryTriggersInput) (*PutRepositoryTriggersOutput, error) {
	req, out := c.PutRepositoryTriggersRequest(input)
	return out, req.Send()
}

// PutRepositoryTriggersWithContext is the same as PutRepositoryTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See PutRepositoryTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) PutRepositoryTriggersWithContext(ctx aws.Context, input *PutRepositoryTriggersInput, opts ...request.Option) (*PutRepositoryTriggersOutput, error) {
	req, out := c.PutRepositoryTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestRepositoryTriggers = "TestRepositoryTriggers"

// TestRepositoryTriggersRequest generates a "aws/request.Request" representing the
// client's request for the TestRepositoryTriggers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestRepositoryTriggers for more information on using the TestRepositoryTriggers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestRepositoryTriggersRequest method.
//    req, resp := client.TestRepositoryTriggersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggers
func (c *CodeCommit) TestRepositoryTriggersRequest(input *TestRepositoryTriggersInput) (req *request.Request, output *TestRepositoryTriggersOutput) {
	op := &request.Operation{
		Name:       opTestRepositoryTriggers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestRepositoryTriggersInput{}
	}

	output = &TestRepositoryTriggersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestRepositoryTriggers API operation for AWS CodeCommit.
//
// Tests the functionality of repository triggers by sending information to
// the trigger target. If real data is available in the repository, the test
// will send data from the last commit. If no data is available, sample data
// will be generated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation TestRepositoryTriggers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeRepositoryTriggersListRequiredException "RepositoryTriggersListRequiredException"
//   The list of triggers for the repository is required but was not specified.
//
//   * ErrCodeMaximumRepositoryTriggersExceededException "MaximumRepositoryTriggersExceededException"
//   The number of triggers allowed for the repository was exceeded.
//
//   * ErrCodeInvalidRepositoryTriggerNameException "InvalidRepositoryTriggerNameException"
//   The name of the trigger is not valid.
//
//   * ErrCodeInvalidRepositoryTriggerDestinationArnException "InvalidRepositoryTriggerDestinationArnException"
//   The Amazon Resource Name (ARN) for the trigger is not valid for the specified
//   destination. The most common reason for this error is that the ARN does not
//   meet the requirements for the service type.
//
//   * ErrCodeInvalidRepositoryTriggerRegionException "InvalidRepositoryTriggerRegionException"
//   The region for the trigger target does not match the region for the repository.
//   Triggers must be created in the same region as the target for the trigger.
//
//   * ErrCodeInvalidRepositoryTriggerCustomDataException "InvalidRepositoryTriggerCustomDataException"
//   The custom data provided for the trigger is not valid.
//
//   * ErrCodeMaximumBranchesExceededException "MaximumBranchesExceededException"
//   The number of branches for the trigger was exceeded.
//
//   * ErrCodeInvalidRepositoryTriggerBranchNameException "InvalidRepositoryTriggerBranchNameException"
//   One or more branch names specified for the trigger is not valid.
//
//   * ErrCodeInvalidRepositoryTriggerEventsException "InvalidRepositoryTriggerEventsException"
//   One or more events specified for the trigger is not valid. Check to make
//   sure that all events specified match the requirements for allowed events.
//
//   * ErrCodeRepositoryTriggerNameRequiredException "RepositoryTriggerNameRequiredException"
//   A name for the trigger is required but was not specified.
//
//   * ErrCodeRepositoryTriggerDestinationArnRequiredException "RepositoryTriggerDestinationArnRequiredException"
//   A destination ARN for the target service for the trigger is required but
//   was not specified.
//
//   * ErrCodeRepositoryTriggerBranchNameListRequiredException "RepositoryTriggerBranchNameListRequiredException"
//   At least one branch name is required but was not specified in the trigger
//   configuration.
//
//   * ErrCodeRepositoryTriggerEventsListRequiredException "RepositoryTriggerEventsListRequiredException"
//   At least one event for the trigger is required but was not specified.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/TestRepositoryTriggers
func (c *CodeCommit) TestRepositoryTriggers(input *TestRepositoryTriggersInput) (*TestRepositoryTriggersOutput, error) {
	req, out := c.TestRepositoryTriggersRequest(input)
	return out, req.Send()
}

// TestRepositoryTriggersWithContext is the same as TestRepositoryTriggers with the addition of
// the ability to pass a context and additional request options.
//
// See TestRepositoryTriggers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) TestRepositoryTriggersWithContext(ctx aws.Context, input *TestRepositoryTriggersInput, opts ...request.Option) (*TestRepositoryTriggersOutput, error) {
	req, out := c.TestRepositoryTriggersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComment = "UpdateComment"

// UpdateCommentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComment for more information on using the UpdateComment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCommentRequest method.
//    req, resp := client.UpdateCommentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateComment
func (c *CodeCommit) UpdateCommentRequest(input *UpdateCommentInput) (req *request.Request, output *UpdateCommentOutput) {
	op := &request.Operation{
		Name:       opUpdateComment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCommentInput{}
	}

	output = &UpdateCommentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateComment API operation for AWS CodeCommit.
//
// Replaces the contents of a comment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdateComment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCommentContentRequiredException "CommentContentRequiredException"
//   The comment is empty. You must provide some content for a comment. The content
//   cannot be null.
//
//   * ErrCodeCommentContentSizeLimitExceededException "CommentContentSizeLimitExceededException"
//   The comment is too large. Comments are limited to 1,000 characters.
//
//   * ErrCodeCommentDoesNotExistException "CommentDoesNotExistException"
//   No comment exists with the provided ID. Verify that you have provided the
//   correct ID, and then try again.
//
//   * ErrCodeCommentIdRequiredException "CommentIdRequiredException"
//   The comment ID is missing or null. A comment ID is required.
//
//   * ErrCodeInvalidCommentIdException "InvalidCommentIdException"
//   The comment ID is not in a valid format. Make sure that you have provided
//   the full comment ID.
//
//   * ErrCodeCommentNotCreatedByCallerException "CommentNotCreatedByCallerException"
//   You cannot modify or delete this comment. Only comment authors can modify
//   or delete their comments.
//
//   * ErrCodeCommentDeletedException "CommentDeletedException"
//   This comment has already been deleted. You cannot edit or delete a deleted
//   comment.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateComment
func (c *CodeCommit) UpdateComment(input *UpdateCommentInput) (*UpdateCommentOutput, error) {
	req, out := c.UpdateCommentRequest(input)
	return out, req.Send()
}

// UpdateCommentWithContext is the same as UpdateComment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdateCommentWithContext(ctx aws.Context, input *UpdateCommentInput, opts ...request.Option) (*UpdateCommentOutput, error) {
	req, out := c.UpdateCommentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDefaultBranch = "UpdateDefaultBranch"

// UpdateDefaultBranchRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDefaultBranch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDefaultBranch for more information on using the UpdateDefaultBranch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDefaultBranchRequest method.
//    req, resp := client.UpdateDefaultBranchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch
func (c *CodeCommit) UpdateDefaultBranchRequest(input *UpdateDefaultBranchInput) (req *request.Request, output *UpdateDefaultBranchOutput) {
	op := &request.Operation{
		Name:       opUpdateDefaultBranch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDefaultBranchInput{}
	}

	output = &UpdateDefaultBranchOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDefaultBranch API operation for AWS CodeCommit.
//
// Sets or changes the default branch name for the specified repository.
//
// If you use this operation to change the default branch name to the current
// default branch name, a success message is returned even though the default
// branch did not change.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdateDefaultBranch for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeBranchNameRequiredException "BranchNameRequiredException"
//   A branch name is required but was not specified.
//
//   * ErrCodeInvalidBranchNameException "InvalidBranchNameException"
//   The specified reference name is not valid.
//
//   * ErrCodeBranchDoesNotExistException "BranchDoesNotExistException"
//   The specified branch does not exist.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateDefaultBranch
func (c *CodeCommit) UpdateDefaultBranch(input *UpdateDefaultBranchInput) (*UpdateDefaultBranchOutput, error) {
	req, out := c.UpdateDefaultBranchRequest(input)
	return out, req.Send()
}

// UpdateDefaultBranchWithContext is the same as UpdateDefaultBranch with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDefaultBranch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdateDefaultBranchWithContext(ctx aws.Context, input *UpdateDefaultBranchInput, opts ...request.Option) (*UpdateDefaultBranchOutput, error) {
	req, out := c.UpdateDefaultBranchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePullRequestDescription = "UpdatePullRequestDescription"

// UpdatePullRequestDescriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePullRequestDescription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePullRequestDescription for more information on using the UpdatePullRequestDescription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePullRequestDescriptionRequest method.
//    req, resp := client.UpdatePullRequestDescriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestDescription
func (c *CodeCommit) UpdatePullRequestDescriptionRequest(input *UpdatePullRequestDescriptionInput) (req *request.Request, output *UpdatePullRequestDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdatePullRequestDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePullRequestDescriptionInput{}
	}

	output = &UpdatePullRequestDescriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePullRequestDescription API operation for AWS CodeCommit.
//
// Replaces the contents of the description of a pull request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdatePullRequestDescription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePullRequestDoesNotExistException "PullRequestDoesNotExistException"
//   The pull request ID could not be found. Make sure that you have specified
//   the correct repository name and pull request ID, and then try again.
//
//   * ErrCodeInvalidPullRequestIdException "InvalidPullRequestIdException"
//   The pull request ID is not valid. Make sure that you have provided the full
//   ID and that the pull request is in the specified repository, and then try
//   again.
//
//   * ErrCodePullRequestIdRequiredException "PullRequestIdRequiredException"
//   A pull request ID is required, but none was provided.
//
//   * ErrCodeInvalidDescriptionException "InvalidDescriptionException"
//   The pull request description is not valid. Descriptions are limited to 1,000
//   characters in length.
//
//   * ErrCodePullRequestAlreadyClosedException "PullRequestAlreadyClosedException"
//   The pull request status cannot be updated because it is already closed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestDescription
func (c *CodeCommit) UpdatePullRequestDescription(input *UpdatePullRequestDescriptionInput) (*UpdatePullRequestDescriptionOutput, error) {
	req, out := c.UpdatePullRequestDescriptionRequest(input)
	return out, req.Send()
}

// UpdatePullRequestDescriptionWithContext is the same as UpdatePullRequestDescription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePullRequestDescription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdatePullRequestDescriptionWithContext(ctx aws.Context, input *UpdatePullRequestDescriptionInput, opts ...request.Option) (*UpdatePullRequestDescriptionOutput, error) {
	req, out := c.UpdatePullRequestDescriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePullRequestStatus = "UpdatePullRequestStatus"

// UpdatePullRequestStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePullRequestStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePullRequestStatus for more information on using the UpdatePullRequestStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePullRequestStatusRequest method.
//    req, resp := client.UpdatePullRequestStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestStatus
func (c *CodeCommit) UpdatePullRequestStatusRequest(input *UpdatePullRequestStatusInput) (req *request.Request, output *UpdatePullRequestStatusOutput) {
	op := &request.Operation{
		Name:       opUpdatePullRequestStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePullRequestStatusInput{}
	}

	output = &UpdatePullRequestStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePullRequestStatus API operation for AWS CodeCommit.
//
// Updates the status of a pull request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdatePullRequestStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePullRequestDoesNotExistException "PullRequestDoesNotExistException"
//   The pull request ID could not be found. Make sure that you have specified
//   the correct repository name and pull request ID, and then try again.
//
//   * ErrCodeInvalidPullRequestIdException "InvalidPullRequestIdException"
//   The pull request ID is not valid. Make sure that you have provided the full
//   ID and that the pull request is in the specified repository, and then try
//   again.
//
//   * ErrCodePullRequestIdRequiredException "PullRequestIdRequiredException"
//   A pull request ID is required, but none was provided.
//
//   * ErrCodeInvalidPullRequestStatusUpdateException "InvalidPullRequestStatusUpdateException"
//   The pull request status update is not valid. The only valid update is from
//   OPEN to CLOSED.
//
//   * ErrCodeInvalidPullRequestStatusException "InvalidPullRequestStatusException"
//   The pull request status is not valid. The only valid values are OPEN and
//   CLOSED.
//
//   * ErrCodePullRequestStatusRequiredException "PullRequestStatusRequiredException"
//   A pull request status is required, but none was provided.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestStatus
func (c *CodeCommit) UpdatePullRequestStatus(input *UpdatePullRequestStatusInput) (*UpdatePullRequestStatusOutput, error) {
	req, out := c.UpdatePullRequestStatusRequest(input)
	return out, req.Send()
}

// UpdatePullRequestStatusWithContext is the same as UpdatePullRequestStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePullRequestStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdatePullRequestStatusWithContext(ctx aws.Context, input *UpdatePullRequestStatusInput, opts ...request.Option) (*UpdatePullRequestStatusOutput, error) {
	req, out := c.UpdatePullRequestStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePullRequestTitle = "UpdatePullRequestTitle"

// UpdatePullRequestTitleRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePullRequestTitle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePullRequestTitle for more information on using the UpdatePullRequestTitle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdatePullRequestTitleRequest method.
//    req, resp := client.UpdatePullRequestTitleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestTitle
func (c *CodeCommit) UpdatePullRequestTitleRequest(input *UpdatePullRequestTitleInput) (req *request.Request, output *UpdatePullRequestTitleOutput) {
	op := &request.Operation{
		Name:       opUpdatePullRequestTitle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePullRequestTitleInput{}
	}

	output = &UpdatePullRequestTitleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePullRequestTitle API operation for AWS CodeCommit.
//
// Replaces the title of a pull request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdatePullRequestTitle for usage and error information.
//
// Returned Error Codes:
//   * ErrCodePullRequestDoesNotExistException "PullRequestDoesNotExistException"
//   The pull request ID could not be found. Make sure that you have specified
//   the correct repository name and pull request ID, and then try again.
//
//   * ErrCodeInvalidPullRequestIdException "InvalidPullRequestIdException"
//   The pull request ID is not valid. Make sure that you have provided the full
//   ID and that the pull request is in the specified repository, and then try
//   again.
//
//   * ErrCodePullRequestIdRequiredException "PullRequestIdRequiredException"
//   A pull request ID is required, but none was provided.
//
//   * ErrCodeTitleRequiredException "TitleRequiredException"
//   A pull request title is required. It cannot be empty or null.
//
//   * ErrCodeInvalidTitleException "InvalidTitleException"
//   The title of the pull request is not valid. Pull request titles cannot exceed
//   100 characters in length.
//
//   * ErrCodePullRequestAlreadyClosedException "PullRequestAlreadyClosedException"
//   The pull request status cannot be updated because it is already closed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdatePullRequestTitle
func (c *CodeCommit) UpdatePullRequestTitle(input *UpdatePullRequestTitleInput) (*UpdatePullRequestTitleOutput, error) {
	req, out := c.UpdatePullRequestTitleRequest(input)
	return out, req.Send()
}

// UpdatePullRequestTitleWithContext is the same as UpdatePullRequestTitle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePullRequestTitle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdatePullRequestTitleWithContext(ctx aws.Context, input *UpdatePullRequestTitleInput, opts ...request.Option) (*UpdatePullRequestTitleOutput, error) {
	req, out := c.UpdatePullRequestTitleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRepositoryDescription = "UpdateRepositoryDescription"

// UpdateRepositoryDescriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRepositoryDescription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRepositoryDescription for more information on using the UpdateRepositoryDescription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRepositoryDescriptionRequest method.
//    req, resp := client.UpdateRepositoryDescriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescription
func (c *CodeCommit) UpdateRepositoryDescriptionRequest(input *UpdateRepositoryDescriptionInput) (req *request.Request, output *UpdateRepositoryDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateRepositoryDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRepositoryDescriptionInput{}
	}

	output = &UpdateRepositoryDescriptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRepositoryDescription API operation for AWS CodeCommit.
//
// Sets or changes the comment or description for a repository.
//
// The description field for a repository accepts all HTML characters and all
// valid Unicode characters. Applications that do not HTML-encode the description
// and display it in a web page could expose users to potentially malicious
// code. Make sure that you HTML-encode the description field in any application
// that uses this API to display the repository description on a web page.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdateRepositoryDescription for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
//   * ErrCodeInvalidRepositoryDescriptionException "InvalidRepositoryDescriptionException"
//   The specified repository description is not valid.
//
//   * ErrCodeEncryptionIntegrityChecksFailedException "EncryptionIntegrityChecksFailedException"
//   An encryption integrity check failed.
//
//   * ErrCodeEncryptionKeyAccessDeniedException "EncryptionKeyAccessDeniedException"
//   An encryption key could not be accessed.
//
//   * ErrCodeEncryptionKeyDisabledException "EncryptionKeyDisabledException"
//   The encryption key is disabled.
//
//   * ErrCodeEncryptionKeyNotFoundException "EncryptionKeyNotFoundException"
//   No encryption key was found.
//
//   * ErrCodeEncryptionKeyUnavailableException "EncryptionKeyUnavailableException"
//   The encryption key is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryDescription
func (c *CodeCommit) UpdateRepositoryDescription(input *UpdateRepositoryDescriptionInput) (*UpdateRepositoryDescriptionOutput, error) {
	req, out := c.UpdateRepositoryDescriptionRequest(input)
	return out, req.Send()
}

// UpdateRepositoryDescriptionWithContext is the same as UpdateRepositoryDescription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRepositoryDescription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdateRepositoryDescriptionWithContext(ctx aws.Context, input *UpdateRepositoryDescriptionInput, opts ...request.Option) (*UpdateRepositoryDescriptionOutput, error) {
	req, out := c.UpdateRepositoryDescriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRepositoryName = "UpdateRepositoryName"

// UpdateRepositoryNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRepositoryName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRepositoryName for more information on using the UpdateRepositoryName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRepositoryNameRequest method.
//    req, resp := client.UpdateRepositoryNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName
func (c *CodeCommit) UpdateRepositoryNameRequest(input *UpdateRepositoryNameInput) (req *request.Request, output *UpdateRepositoryNameOutput) {
	op := &request.Operation{
		Name:       opUpdateRepositoryName,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRepositoryNameInput{}
	}

	output = &UpdateRepositoryNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRepositoryName API operation for AWS CodeCommit.
//
// Renames a repository. The repository name must be unique across the calling
// AWS account. In addition, repository names are limited to 100 alphanumeric,
// dash, and underscore characters, and cannot include certain characters. The
// suffix ".git" is prohibited. For a full description of the limits on repository
// names, see Limits (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html)
// in the AWS CodeCommit User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CodeCommit's
// API operation UpdateRepositoryName for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeRepositoryDoesNotExistException "RepositoryDoesNotExistException"
//   The specified repository does not exist.
//
//   * ErrCodeRepositoryNameExistsException "RepositoryNameExistsException"
//   The specified repository name already exists.
//
//   * ErrCodeRepositoryNameRequiredException "RepositoryNameRequiredException"
//   A repository name is required but was not specified.
//
//   * ErrCodeInvalidRepositoryNameException "InvalidRepositoryNameException"
//   At least one specified repository name is not valid.
//
//   This exception only occurs when a specified repository name is not valid.
//   Other exceptions occur when a required repository parameter is missing, or
//   when a specified repository does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/UpdateRepositoryName
func (c *CodeCommit) UpdateRepositoryName(input *UpdateRepositoryNameInput) (*UpdateRepositoryNameOutput, error) {
	req, out := c.UpdateRepositoryNameRequest(input)
	return out, req.Send()
}

// UpdateRepositoryNameWithContext is the same as UpdateRepositoryName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRepositoryName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CodeCommit) UpdateRepositoryNameWithContext(ctx aws.Context, input *UpdateRepositoryNameInput, opts ...request.Option) (*UpdateRepositoryNameOutput, error) {
	req, out := c.UpdateRepositoryNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents the input of a batch get repositories operation.
type BatchGetRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The names of the repositories to get information about.
	//
	// RepositoryNames is a required field
	RepositoryNames []*string `locationName:"repositoryNames" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchGetRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetRepositoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetRepositoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetRepositoriesInput"}
	if s.RepositoryNames == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryNames sets the RepositoryNames field's value.
func (s *BatchGetRepositoriesInput) SetRepositoryNames(v []*string) *BatchGetRepositoriesInput {
	s.RepositoryNames = v
	return s
}

// Represents the output of a batch get repositories operation.
type BatchGetRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of repositories returned by the batch get repositories operation.
	Repositories []*RepositoryMetadata `locationName:"repositories" type:"list"`

	// Returns a list of repository names for which information could not be found.
	RepositoriesNotFound []*string `locationName:"repositoriesNotFound" type:"list"`
}

// String returns the string representation
func (s BatchGetRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetRepositoriesOutput) GoString() string {
	return s.String()
}

// SetRepositories sets the Repositories field's value.
func (s *BatchGetRepositoriesOutput) SetRepositories(v []*RepositoryMetadata) *BatchGetRepositoriesOutput {
	s.Repositories = v
	return s
}

// SetRepositoriesNotFound sets the RepositoriesNotFound field's value.
func (s *BatchGetRepositoriesOutput) SetRepositoriesNotFound(v []*string) *BatchGetRepositoriesOutput {
	s.RepositoriesNotFound = v
	return s
}

// Returns information about a specific Git blob object.
type BlobMetadata struct {
	_ struct{} `type:"structure"`

	// The full ID of the blob.
	BlobId *string `locationName:"blobId" type:"string"`

	// The file mode permissions of the blob. File mode permission codes include:
	//
	//    * 100644 indicates read/write
	//
	//    * 100755 indicates read/write/execute
	//
	//    * 160000 indicates a submodule
	//
	//    * 120000 indicates a symlink
	Mode *string `locationName:"mode" type:"string"`

	// The path to the blob and any associated file name, if any.
	Path *string `locationName:"path" type:"string"`
}

// String returns the string representation
func (s BlobMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlobMetadata) GoString() string {
	return s.String()
}

// SetBlobId sets the BlobId field's value.
func (s *BlobMetadata) SetBlobId(v string) *BlobMetadata {
	s.BlobId = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *BlobMetadata) SetMode(v string) *BlobMetadata {
	s.Mode = &v
	return s
}

// SetPath sets the Path field's value.
func (s *BlobMetadata) SetPath(v string) *BlobMetadata {
	s.Path = &v
	return s
}

// Returns information about a branch.
type BranchInfo struct {
	_ struct{} `type:"structure"`

	// The name of the branch.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The ID of the last commit made to the branch.
	CommitId *string `locationName:"commitId" type:"string"`
}

// String returns the string representation
func (s BranchInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BranchInfo) GoString() string {
	return s.String()
}

// SetBranchName sets the BranchName field's value.
func (s *BranchInfo) SetBranchName(v string) *BranchInfo {
	s.BranchName = &v
	return s
}

// SetCommitId sets the CommitId field's value.
func (s *BranchInfo) SetCommitId(v string) *BranchInfo {
	s.CommitId = &v
	return s
}

// Returns information about a specific comment.
type Comment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the person who posted the comment.
	AuthorArn *string `locationName:"authorArn" type:"string"`

	// A unique, client-generated idempotency token that when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// is received with the same parameters and a token is included, the request
	// will return information about the initial request that used that token.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The system-generated comment ID.
	CommentId *string `locationName:"commentId" type:"string"`

	// The content of the comment.
	Content *string `locationName:"content" type:"string"`

	// The date and time the comment was created, in timestamp format.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// A Boolean value indicating whether the comment has been deleted.
	Deleted *bool `locationName:"deleted" type:"boolean"`

	// The ID of the comment for which this comment is a reply, if any.
	InReplyTo *string `locationName:"inReplyTo" type:"string"`

	// The date and time the comment was most recently modified, in timestamp format.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Comment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Comment) GoString() string {
	return s.String()
}

// SetAuthorArn sets the AuthorArn field's value.
func (s *Comment) SetAuthorArn(v string) *Comment {
	s.AuthorArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *Comment) SetClientRequestToken(v string) *Comment {
	s.ClientRequestToken = &v
	return s
}

// SetCommentId sets the CommentId field's value.
func (s *Comment) SetCommentId(v string) *Comment {
	s.CommentId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *Comment) SetContent(v string) *Comment {
	s.Content = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Comment) SetCreationDate(v time.Time) *Comment {
	s.CreationDate = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *Comment) SetDeleted(v bool) *Comment {
	s.Deleted = &v
	return s
}

// SetInReplyTo sets the InReplyTo field's value.
func (s *Comment) SetInReplyTo(v string) *Comment {
	s.InReplyTo = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *Comment) SetLastModifiedDate(v time.Time) *Comment {
	s.LastModifiedDate = &v
	return s
}

// Returns information about comments on the comparison between two commits.
type CommentsForComparedCommit struct {
	_ struct{} `type:"structure"`

	// The full blob ID of the commit used to establish the 'after' of the comparison.
	AfterBlobId *string `locationName:"afterBlobId" type:"string"`

	// The full commit ID of the commit used to establish the 'after' of the comparison.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// The full blob ID of the commit used to establish the 'before' of the comparison.
	BeforeBlobId *string `locationName:"beforeBlobId" type:"string"`

	// The full commit ID of the commit used to establish the 'before' of the comparison.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// An array of comment objects. Each comment object contains information about
	// a comment on the comparison between commits.
	Comments []*Comment `locationName:"comments" type:"list"`

	// Location information about the comment on the comparison, including the file
	// name, line number, and whether the version of the file where the comment
	// was made is 'BEFORE' or 'AFTER'.
	Location *Location `locationName:"location" type:"structure"`

	// The name of the repository that contains the compared commits.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s CommentsForComparedCommit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommentsForComparedCommit) GoString() string {
	return s.String()
}

// SetAfterBlobId sets the AfterBlobId field's value.
func (s *CommentsForComparedCommit) SetAfterBlobId(v string) *CommentsForComparedCommit {
	s.AfterBlobId = &v
	return s
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *CommentsForComparedCommit) SetAfterCommitId(v string) *CommentsForComparedCommit {
	s.AfterCommitId = &v
	return s
}

// SetBeforeBlobId sets the BeforeBlobId field's value.
func (s *CommentsForComparedCommit) SetBeforeBlobId(v string) *CommentsForComparedCommit {
	s.BeforeBlobId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *CommentsForComparedCommit) SetBeforeCommitId(v string) *CommentsForComparedCommit {
	s.BeforeCommitId = &v
	return s
}

// SetComments sets the Comments field's value.
func (s *CommentsForComparedCommit) SetComments(v []*Comment) *CommentsForComparedCommit {
	s.Comments = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CommentsForComparedCommit) SetLocation(v *Location) *CommentsForComparedCommit {
	s.Location = v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CommentsForComparedCommit) SetRepositoryName(v string) *CommentsForComparedCommit {
	s.RepositoryName = &v
	return s
}

// Returns information about comments on a pull request.
type CommentsForPullRequest struct {
	_ struct{} `type:"structure"`

	// The full blob ID of the file on which you want to comment on the source commit.
	AfterBlobId *string `locationName:"afterBlobId" type:"string"`

	// he full commit ID of the commit that was the tip of the source branch at
	// the time the comment was made.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// The full blob ID of the file on which you want to comment on the destination
	// commit.
	BeforeBlobId *string `locationName:"beforeBlobId" type:"string"`

	// The full commit ID of the commit that was the tip of the destination branch
	// when the pull request was created. This commit will be superceded by the
	// after commit in the source branch when and if you merge the source branch
	// into the destination branch.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// An array of comment objects. Each comment object contains information about
	// a comment on the pull request.
	Comments []*Comment `locationName:"comments" type:"list"`

	// Location information about the comment on the pull request, including the
	// file name, line number, and whether the version of the file where the comment
	// was made is 'BEFORE' (destination branch) or 'AFTER' (source branch).
	Location *Location `locationName:"location" type:"structure"`

	// The system-generated ID of the pull request.
	PullRequestId *string `locationName:"pullRequestId" type:"string"`

	// The name of the repository that contains the pull request.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s CommentsForPullRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CommentsForPullRequest) GoString() string {
	return s.String()
}

// SetAfterBlobId sets the AfterBlobId field's value.
func (s *CommentsForPullRequest) SetAfterBlobId(v string) *CommentsForPullRequest {
	s.AfterBlobId = &v
	return s
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *CommentsForPullRequest) SetAfterCommitId(v string) *CommentsForPullRequest {
	s.AfterCommitId = &v
	return s
}

// SetBeforeBlobId sets the BeforeBlobId field's value.
func (s *CommentsForPullRequest) SetBeforeBlobId(v string) *CommentsForPullRequest {
	s.BeforeBlobId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *CommentsForPullRequest) SetBeforeCommitId(v string) *CommentsForPullRequest {
	s.BeforeCommitId = &v
	return s
}

// SetComments sets the Comments field's value.
func (s *CommentsForPullRequest) SetComments(v []*Comment) *CommentsForPullRequest {
	s.Comments = v
	return s
}

// SetLocation sets the Location field's value.
func (s *CommentsForPullRequest) SetLocation(v *Location) *CommentsForPullRequest {
	s.Location = v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *CommentsForPullRequest) SetPullRequestId(v string) *CommentsForPullRequest {
	s.PullRequestId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CommentsForPullRequest) SetRepositoryName(v string) *CommentsForPullRequest {
	s.RepositoryName = &v
	return s
}

// Returns information about a specific commit.
type Commit struct {
	_ struct{} `type:"structure"`

	// Any additional data associated with the specified commit.
	AdditionalData *string `locationName:"additionalData" type:"string"`

	// Information about the author of the specified commit. Information includes
	// the date in timestamp format with GMT offset, the name of the author, and
	// the email address for the author, as configured in Git.
	Author *UserInfo `locationName:"author" type:"structure"`

	// The full SHA of the specified commit.
	CommitId *string `locationName:"commitId" type:"string"`

	// Information about the person who committed the specified commit, also known
	// as the committer. Information includes the date in timestamp format with
	// GMT offset, the name of the committer, and the email address for the committer,
	// as configured in Git.
	//
	// For more information about the difference between an author and a committer
	// in Git, see Viewing the Commit History (http://git-scm.com/book/ch2-3.html)
	// in Pro Git by Scott Chacon and Ben Straub.
	Committer *UserInfo `locationName:"committer" type:"structure"`

	// The commit message associated with the specified commit.
	Message *string `locationName:"message" type:"string"`

	// A list of parent commits for the specified commit. Each parent commit ID
	// is the full commit ID.
	Parents []*string `locationName:"parents" type:"list"`

	// Tree information for the specified commit.
	TreeId *string `locationName:"treeId" type:"string"`
}

// String returns the string representation
func (s Commit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Commit) GoString() string {
	return s.String()
}

// SetAdditionalData sets the AdditionalData field's value.
func (s *Commit) SetAdditionalData(v string) *Commit {
	s.AdditionalData = &v
	return s
}

// SetAuthor sets the Author field's value.
func (s *Commit) SetAuthor(v *UserInfo) *Commit {
	s.Author = v
	return s
}

// SetCommitId sets the CommitId field's value.
func (s *Commit) SetCommitId(v string) *Commit {
	s.CommitId = &v
	return s
}

// SetCommitter sets the Committer field's value.
func (s *Commit) SetCommitter(v *UserInfo) *Commit {
	s.Committer = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Commit) SetMessage(v string) *Commit {
	s.Message = &v
	return s
}

// SetParents sets the Parents field's value.
func (s *Commit) SetParents(v []*string) *Commit {
	s.Parents = v
	return s
}

// SetTreeId sets the TreeId field's value.
func (s *Commit) SetTreeId(v string) *Commit {
	s.TreeId = &v
	return s
}

// Represents the input of a create branch operation.
type CreateBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the new branch to create.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// The ID of the commit to point the new branch to.
	//
	// CommitId is a required field
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// The name of the repository in which you want to create the new branch.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBranchInput"}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.CommitId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommitId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *CreateBranchInput) SetBranchName(v string) *CreateBranchInput {
	s.BranchName = &v
	return s
}

// SetCommitId sets the CommitId field's value.
func (s *CreateBranchInput) SetCommitId(v string) *CreateBranchInput {
	s.CommitId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateBranchInput) SetRepositoryName(v string) *CreateBranchInput {
	s.RepositoryName = &v
	return s
}

type CreateBranchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBranchOutput) GoString() string {
	return s.String()
}

type CreatePullRequestInput struct {
	_ struct{} `type:"structure"`

	// A unique, client-generated idempotency token that when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// is received with the same parameters and a token is included, the request
	// will return information about the initial request that used that token.
	//
	// The AWS SDKs prepopulate client request tokens. If using an AWS SDK, you
	// do not have to generate an idempotency token, as this will be done for you.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// A description of the pull request.
	Description *string `locationName:"description" type:"string"`

	// The targets for the pull request, including the source of the code to be
	// reviewed (the source branch), and the destination where the creator of the
	// pull request intends the code to be merged after the pull request is closed
	// (the destination branch).
	//
	// Targets is a required field
	Targets []*Target `locationName:"targets" type:"list" required:"true"`

	// The title of the pull request. This title will be used to identify the pull
	// request to other users in the repository.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePullRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePullRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePullRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePullRequestInput"}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreatePullRequestInput) SetClientRequestToken(v string) *CreatePullRequestInput {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePullRequestInput) SetDescription(v string) *CreatePullRequestInput {
	s.Description = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *CreatePullRequestInput) SetTargets(v []*Target) *CreatePullRequestInput {
	s.Targets = v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreatePullRequestInput) SetTitle(v string) *CreatePullRequestInput {
	s.Title = &v
	return s
}

type CreatePullRequestOutput struct {
	_ struct{} `type:"structure"`

	// Information about the newly created pull request.
	//
	// PullRequest is a required field
	PullRequest *PullRequest `locationName:"pullRequest" type:"structure" required:"true"`
}

// String returns the string representation
func (s CreatePullRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePullRequestOutput) GoString() string {
	return s.String()
}

// SetPullRequest sets the PullRequest field's value.
func (s *CreatePullRequestOutput) SetPullRequest(v *PullRequest) *CreatePullRequestOutput {
	s.PullRequest = v
	return s
}

// Represents the input of a create repository operation.
type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// A comment or description about the new repository.
	//
	// The description field for a repository accepts all HTML characters and all
	// valid Unicode characters. Applications that do not HTML-encode the description
	// and display it in a web page could expose users to potentially malicious
	// code. Make sure that you HTML-encode the description field in any application
	// that uses this API to display the repository description on a web page.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The name of the new repository to be created.
	//
	// The repository name must be unique across the calling AWS account. In addition,
	// repository names are limited to 100 alphanumeric, dash, and underscore characters,
	// and cannot include certain characters. For a full description of the limits
	// on repository names, see Limits (http://docs.aws.amazon.com/codecommit/latest/userguide/limits.html)
	// in the AWS CodeCommit User Guide. The suffix ".git" is prohibited.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryDescription sets the RepositoryDescription field's value.
func (s *CreateRepositoryInput) SetRepositoryDescription(v string) *CreateRepositoryInput {
	s.RepositoryDescription = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateRepositoryInput) SetRepositoryName(v string) *CreateRepositoryInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a create repository operation.
type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the newly created repository.
	RepositoryMetadata *RepositoryMetadata `locationName:"repositoryMetadata" type:"structure"`
}

// String returns the string representation
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryMetadata sets the RepositoryMetadata field's value.
func (s *CreateRepositoryOutput) SetRepositoryMetadata(v *RepositoryMetadata) *CreateRepositoryOutput {
	s.RepositoryMetadata = v
	return s
}

// Represents the input of a delete branch operation.
type DeleteBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch to delete.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// The name of the repository that contains the branch to be deleted.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBranchInput"}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *DeleteBranchInput) SetBranchName(v string) *DeleteBranchInput {
	s.BranchName = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteBranchInput) SetRepositoryName(v string) *DeleteBranchInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a delete branch operation.
type DeleteBranchOutput struct {
	_ struct{} `type:"structure"`

	// Information about the branch deleted by the operation, including the branch
	// name and the commit ID that was the tip of the branch.
	DeletedBranch *BranchInfo `locationName:"deletedBranch" type:"structure"`
}

// String returns the string representation
func (s DeleteBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBranchOutput) GoString() string {
	return s.String()
}

// SetDeletedBranch sets the DeletedBranch field's value.
func (s *DeleteBranchOutput) SetDeletedBranch(v *BranchInfo) *DeleteBranchOutput {
	s.DeletedBranch = v
	return s
}

type DeleteCommentContentInput struct {
	_ struct{} `type:"structure"`

	// The unique, system-generated ID of the comment. To get this ID, use GetCommentsForComparedCommit
	// or GetCommentsForPullRequest.
	//
	// CommentId is a required field
	CommentId *string `locationName:"commentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCommentContentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCommentContentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCommentContentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCommentContentInput"}
	if s.CommentId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommentId sets the CommentId field's value.
func (s *DeleteCommentContentInput) SetCommentId(v string) *DeleteCommentContentInput {
	s.CommentId = &v
	return s
}

type DeleteCommentContentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the comment you just deleted.
	Comment *Comment `locationName:"comment" type:"structure"`
}

// String returns the string representation
func (s DeleteCommentContentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCommentContentOutput) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *DeleteCommentContentOutput) SetComment(v *Comment) *DeleteCommentContentOutput {
	s.Comment = v
	return s
}

// Represents the input of a delete repository operation.
type DeleteRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository to delete.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *DeleteRepositoryInput) SetRepositoryName(v string) *DeleteRepositoryInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a delete repository operation.
type DeleteRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the repository that was deleted.
	RepositoryId *string `locationName:"repositoryId" type:"string"`
}

// String returns the string representation
func (s DeleteRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryId sets the RepositoryId field's value.
func (s *DeleteRepositoryOutput) SetRepositoryId(v string) *DeleteRepositoryOutput {
	s.RepositoryId = &v
	return s
}

type DescribePullRequestEventsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user whose actions resulted in the
	// event. Examples include updating the pull request with additional commits
	// or changing the status of a pull request.
	ActorArn *string `locationName:"actorArn" type:"string"`

	// A non-negative integer used to limit the number of returned results. The
	// default is 100 events, which is also the maximum number of events that can
	// be returned in a result.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Optional. The pull request event type about which you want to return information.
	PullRequestEventType *string `locationName:"pullRequestEventType" type:"string" enum:"PullRequestEventType"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePullRequestEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePullRequestEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePullRequestEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePullRequestEventsInput"}
	if s.PullRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActorArn sets the ActorArn field's value.
func (s *DescribePullRequestEventsInput) SetActorArn(v string) *DescribePullRequestEventsInput {
	s.ActorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribePullRequestEventsInput) SetMaxResults(v int64) *DescribePullRequestEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePullRequestEventsInput) SetNextToken(v string) *DescribePullRequestEventsInput {
	s.NextToken = &v
	return s
}

// SetPullRequestEventType sets the PullRequestEventType field's value.
func (s *DescribePullRequestEventsInput) SetPullRequestEventType(v string) *DescribePullRequestEventsInput {
	s.PullRequestEventType = &v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *DescribePullRequestEventsInput) SetPullRequestId(v string) *DescribePullRequestEventsInput {
	s.PullRequestId = &v
	return s
}

type DescribePullRequestEventsOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the pull request events.
	//
	// PullRequestEvents is a required field
	PullRequestEvents []*PullRequestEvent `locationName:"pullRequestEvents" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribePullRequestEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePullRequestEventsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribePullRequestEventsOutput) SetNextToken(v string) *DescribePullRequestEventsOutput {
	s.NextToken = &v
	return s
}

// SetPullRequestEvents sets the PullRequestEvents field's value.
func (s *DescribePullRequestEventsOutput) SetPullRequestEvents(v []*PullRequestEvent) *DescribePullRequestEventsOutput {
	s.PullRequestEvents = v
	return s
}

// Returns information about a set of differences for a commit specifier.
type Difference struct {
	_ struct{} `type:"structure"`

	// Information about an afterBlob data type object, including the ID, the file
	// mode permission code, and the path.
	AfterBlob *BlobMetadata `locationName:"afterBlob" type:"structure"`

	// Information about a beforeBlob data type object, including the ID, the file
	// mode permission code, and the path.
	BeforeBlob *BlobMetadata `locationName:"beforeBlob" type:"structure"`

	// Whether the change type of the difference is an addition (A), deletion (D),
	// or modification (M).
	ChangeType *string `locationName:"changeType" type:"string" enum:"ChangeTypeEnum"`
}

// String returns the string representation
func (s Difference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Difference) GoString() string {
	return s.String()
}

// SetAfterBlob sets the AfterBlob field's value.
func (s *Difference) SetAfterBlob(v *BlobMetadata) *Difference {
	s.AfterBlob = v
	return s
}

// SetBeforeBlob sets the BeforeBlob field's value.
func (s *Difference) SetBeforeBlob(v *BlobMetadata) *Difference {
	s.BeforeBlob = v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *Difference) SetChangeType(v string) *Difference {
	s.ChangeType = &v
	return s
}

// Represents the input of a get blob operation.
type GetBlobInput struct {
	_ struct{} `type:"structure"`

	// The ID of the blob, which is its SHA-1 pointer.
	//
	// BlobId is a required field
	BlobId *string `locationName:"blobId" type:"string" required:"true"`

	// The name of the repository that contains the blob.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetBlobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBlobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBlobInput"}
	if s.BlobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BlobId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlobId sets the BlobId field's value.
func (s *GetBlobInput) SetBlobId(v string) *GetBlobInput {
	s.BlobId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetBlobInput) SetRepositoryName(v string) *GetBlobInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get blob operation.
type GetBlobOutput struct {
	_ struct{} `type:"structure"`

	// The content of the blob, usually a file.
	//
	// Content is automatically base64 encoded/decoded by the SDK.
	//
	// Content is a required field
	Content []byte `locationName:"content" type:"blob" required:"true"`
}

// String returns the string representation
func (s GetBlobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBlobOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *GetBlobOutput) SetContent(v []byte) *GetBlobOutput {
	s.Content = v
	return s
}

// Represents the input of a get branch operation.
type GetBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch for which you want to retrieve information.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The name of the repository that contains the branch for which you want to
	// retrieve information.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBranchInput"}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *GetBranchInput) SetBranchName(v string) *GetBranchInput {
	s.BranchName = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetBranchInput) SetRepositoryName(v string) *GetBranchInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get branch operation.
type GetBranchOutput struct {
	_ struct{} `type:"structure"`

	// The name of the branch.
	Branch *BranchInfo `locationName:"branch" type:"structure"`
}

// String returns the string representation
func (s GetBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBranchOutput) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *GetBranchOutput) SetBranch(v *BranchInfo) *GetBranchOutput {
	s.Branch = v
	return s
}

type GetCommentInput struct {
	_ struct{} `type:"structure"`

	// The unique, system-generated ID of the comment. To get this ID, use GetCommentsForComparedCommit
	// or GetCommentsForPullRequest.
	//
	// CommentId is a required field
	CommentId *string `locationName:"commentId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCommentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCommentInput"}
	if s.CommentId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommentId sets the CommentId field's value.
func (s *GetCommentInput) SetCommentId(v string) *GetCommentInput {
	s.CommentId = &v
	return s
}

type GetCommentOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the comment.
	Comment *Comment `locationName:"comment" type:"structure"`
}

// String returns the string representation
func (s GetCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommentOutput) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *GetCommentOutput) SetComment(v *Comment) *GetCommentOutput {
	s.Comment = v
	return s
}

type GetCommentsForComparedCommitInput struct {
	_ struct{} `type:"structure"`

	// To establish the directionality of the comparison, the full commit ID of
	// the 'after' commit.
	//
	// AfterCommitId is a required field
	AfterCommitId *string `locationName:"afterCommitId" type:"string" required:"true"`

	// To establish the directionality of the comparison, the full commit ID of
	// the 'before' commit.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// A non-negative integer used to limit the number of returned results. The
	// default is 100 comments, and is configurable up to 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the repository where you want to compare commits.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCommentsForComparedCommitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommentsForComparedCommitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCommentsForComparedCommitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCommentsForComparedCommitInput"}
	if s.AfterCommitId == nil {
		invalidParams.Add(request.NewErrParamRequired("AfterCommitId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *GetCommentsForComparedCommitInput) SetAfterCommitId(v string) *GetCommentsForComparedCommitInput {
	s.AfterCommitId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *GetCommentsForComparedCommitInput) SetBeforeCommitId(v string) *GetCommentsForComparedCommitInput {
	s.BeforeCommitId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCommentsForComparedCommitInput) SetMaxResults(v int64) *GetCommentsForComparedCommitInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCommentsForComparedCommitInput) SetNextToken(v string) *GetCommentsForComparedCommitInput {
	s.NextToken = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetCommentsForComparedCommitInput) SetRepositoryName(v string) *GetCommentsForComparedCommitInput {
	s.RepositoryName = &v
	return s
}

type GetCommentsForComparedCommitOutput struct {
	_ struct{} `type:"structure"`

	// A list of comment objects on the compared commit.
	CommentsForComparedCommitData []*CommentsForComparedCommit `locationName:"commentsForComparedCommitData" type:"list"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetCommentsForComparedCommitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommentsForComparedCommitOutput) GoString() string {
	return s.String()
}

// SetCommentsForComparedCommitData sets the CommentsForComparedCommitData field's value.
func (s *GetCommentsForComparedCommitOutput) SetCommentsForComparedCommitData(v []*CommentsForComparedCommit) *GetCommentsForComparedCommitOutput {
	s.CommentsForComparedCommitData = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCommentsForComparedCommitOutput) SetNextToken(v string) *GetCommentsForComparedCommitOutput {
	s.NextToken = &v
	return s
}

type GetCommentsForPullRequestInput struct {
	_ struct{} `type:"structure"`

	// The full commit ID of the commit in the source branch that was the tip of
	// the branch at the time the comment was made.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// The full commit ID of the commit in the destination branch that was the tip
	// of the branch at the time the pull request was created.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// A non-negative integer used to limit the number of returned results. The
	// default is 100 comments. You can return up to 500 comments with a single
	// request.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`

	// The name of the repository that contains the pull request.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s GetCommentsForPullRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommentsForPullRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCommentsForPullRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCommentsForPullRequestInput"}
	if s.PullRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestId"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *GetCommentsForPullRequestInput) SetAfterCommitId(v string) *GetCommentsForPullRequestInput {
	s.AfterCommitId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *GetCommentsForPullRequestInput) SetBeforeCommitId(v string) *GetCommentsForPullRequestInput {
	s.BeforeCommitId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCommentsForPullRequestInput) SetMaxResults(v int64) *GetCommentsForPullRequestInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCommentsForPullRequestInput) SetNextToken(v string) *GetCommentsForPullRequestInput {
	s.NextToken = &v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *GetCommentsForPullRequestInput) SetPullRequestId(v string) *GetCommentsForPullRequestInput {
	s.PullRequestId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetCommentsForPullRequestInput) SetRepositoryName(v string) *GetCommentsForPullRequestInput {
	s.RepositoryName = &v
	return s
}

type GetCommentsForPullRequestOutput struct {
	_ struct{} `type:"structure"`

	// An array of comment objects on the pull request.
	CommentsForPullRequestData []*CommentsForPullRequest `locationName:"commentsForPullRequestData" type:"list"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetCommentsForPullRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommentsForPullRequestOutput) GoString() string {
	return s.String()
}

// SetCommentsForPullRequestData sets the CommentsForPullRequestData field's value.
func (s *GetCommentsForPullRequestOutput) SetCommentsForPullRequestData(v []*CommentsForPullRequest) *GetCommentsForPullRequestOutput {
	s.CommentsForPullRequestData = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCommentsForPullRequestOutput) SetNextToken(v string) *GetCommentsForPullRequestOutput {
	s.NextToken = &v
	return s
}

// Represents the input of a get commit operation.
type GetCommitInput struct {
	_ struct{} `type:"structure"`

	// The commit ID. Commit IDs are the full SHA of the commit.
	//
	// CommitId is a required field
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// The name of the repository to which the commit was made.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCommitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCommitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCommitInput"}
	if s.CommitId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommitId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommitId sets the CommitId field's value.
func (s *GetCommitInput) SetCommitId(v string) *GetCommitInput {
	s.CommitId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetCommitInput) SetRepositoryName(v string) *GetCommitInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get commit operation.
type GetCommitOutput struct {
	_ struct{} `type:"structure"`

	// A commit data type object that contains information about the specified commit.
	//
	// Commit is a required field
	Commit *Commit `locationName:"commit" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetCommitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCommitOutput) GoString() string {
	return s.String()
}

// SetCommit sets the Commit field's value.
func (s *GetCommitOutput) SetCommit(v *Commit) *GetCommitOutput {
	s.Commit = v
	return s
}

type GetDifferencesInput struct {
	_ struct{} `type:"structure"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit.
	//
	// AfterCommitSpecifier is a required field
	AfterCommitSpecifier *string `locationName:"afterCommitSpecifier" type:"string" required:"true"`

	// The file path in which to check differences. Limits the results to this path.
	// Can also be used to specify the changed name of a directory or folder, if
	// it has changed. If not specified, differences will be shown for all paths.
	AfterPath *string `locationName:"afterPath" type:"string"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit. For example, the full commit ID. Optional. If not specified, all
	// changes prior to the afterCommitSpecifier value will be shown. If you do
	// not use beforeCommitSpecifier in your request, consider limiting the results
	// with maxResults.
	BeforeCommitSpecifier *string `locationName:"beforeCommitSpecifier" type:"string"`

	// The file path in which to check for differences. Limits the results to this
	// path. Can also be used to specify the previous name of a directory or folder.
	// If beforePath and afterPath are not specified, differences will be shown
	// for all paths.
	BeforePath *string `locationName:"beforePath" type:"string"`

	// A non-negative integer used to limit the number of returned results.
	MaxResults *int64 `type:"integer"`

	// An enumeration token that when provided in a request, returns the next batch
	// of the results.
	NextToken *string `type:"string"`

	// The name of the repository where you want to get differences.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDifferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDifferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDifferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDifferencesInput"}
	if s.AfterCommitSpecifier == nil {
		invalidParams.Add(request.NewErrParamRequired("AfterCommitSpecifier"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterCommitSpecifier sets the AfterCommitSpecifier field's value.
func (s *GetDifferencesInput) SetAfterCommitSpecifier(v string) *GetDifferencesInput {
	s.AfterCommitSpecifier = &v
	return s
}

// SetAfterPath sets the AfterPath field's value.
func (s *GetDifferencesInput) SetAfterPath(v string) *GetDifferencesInput {
	s.AfterPath = &v
	return s
}

// SetBeforeCommitSpecifier sets the BeforeCommitSpecifier field's value.
func (s *GetDifferencesInput) SetBeforeCommitSpecifier(v string) *GetDifferencesInput {
	s.BeforeCommitSpecifier = &v
	return s
}

// SetBeforePath sets the BeforePath field's value.
func (s *GetDifferencesInput) SetBeforePath(v string) *GetDifferencesInput {
	s.BeforePath = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDifferencesInput) SetMaxResults(v int64) *GetDifferencesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDifferencesInput) SetNextToken(v string) *GetDifferencesInput {
	s.NextToken = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetDifferencesInput) SetRepositoryName(v string) *GetDifferencesInput {
	s.RepositoryName = &v
	return s
}

type GetDifferencesOutput struct {
	_ struct{} `type:"structure"`

	// A differences data type object that contains information about the differences,
	// including whether the difference is added, modified, or deleted (A, D, M).
	Differences []*Difference `locationName:"differences" type:"list"`

	// An enumeration token that can be used in a request to return the next batch
	// of the results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetDifferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDifferencesOutput) GoString() string {
	return s.String()
}

// SetDifferences sets the Differences field's value.
func (s *GetDifferencesOutput) SetDifferences(v []*Difference) *GetDifferencesOutput {
	s.Differences = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDifferencesOutput) SetNextToken(v string) *GetDifferencesOutput {
	s.NextToken = &v
	return s
}

type GetMergeConflictsInput struct {
	_ struct{} `type:"structure"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit. For example, a branch name or a full commit ID.
	//
	// DestinationCommitSpecifier is a required field
	DestinationCommitSpecifier *string `locationName:"destinationCommitSpecifier" type:"string" required:"true"`

	// The merge option or strategy you want to use to merge the code. The only
	// valid value is FAST_FORWARD_MERGE.
	//
	// MergeOption is a required field
	MergeOption *string `locationName:"mergeOption" type:"string" required:"true" enum:"MergeOptionTypeEnum"`

	// The name of the repository where the pull request was created.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The branch, tag, HEAD, or other fully qualified reference used to identify
	// a commit. For example, a branch name or a full commit ID.
	//
	// SourceCommitSpecifier is a required field
	SourceCommitSpecifier *string `locationName:"sourceCommitSpecifier" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMergeConflictsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMergeConflictsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMergeConflictsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMergeConflictsInput"}
	if s.DestinationCommitSpecifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationCommitSpecifier"))
	}
	if s.MergeOption == nil {
		invalidParams.Add(request.NewErrParamRequired("MergeOption"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.SourceCommitSpecifier == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceCommitSpecifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationCommitSpecifier sets the DestinationCommitSpecifier field's value.
func (s *GetMergeConflictsInput) SetDestinationCommitSpecifier(v string) *GetMergeConflictsInput {
	s.DestinationCommitSpecifier = &v
	return s
}

// SetMergeOption sets the MergeOption field's value.
func (s *GetMergeConflictsInput) SetMergeOption(v string) *GetMergeConflictsInput {
	s.MergeOption = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetMergeConflictsInput) SetRepositoryName(v string) *GetMergeConflictsInput {
	s.RepositoryName = &v
	return s
}

// SetSourceCommitSpecifier sets the SourceCommitSpecifier field's value.
func (s *GetMergeConflictsInput) SetSourceCommitSpecifier(v string) *GetMergeConflictsInput {
	s.SourceCommitSpecifier = &v
	return s
}

type GetMergeConflictsOutput struct {
	_ struct{} `type:"structure"`

	// The commit ID of the destination commit specifier that was used in the merge
	// evaluation.
	//
	// DestinationCommitId is a required field
	DestinationCommitId *string `locationName:"destinationCommitId" type:"string" required:"true"`

	// A Boolean value that indicates whether the code is mergable by the specified
	// merge option.
	//
	// Mergeable is a required field
	Mergeable *bool `locationName:"mergeable" type:"boolean" required:"true"`

	// The commit ID of the source commit specifier that was used in the merge evaluation.
	//
	// SourceCommitId is a required field
	SourceCommitId *string `locationName:"sourceCommitId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetMergeConflictsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMergeConflictsOutput) GoString() string {
	return s.String()
}

// SetDestinationCommitId sets the DestinationCommitId field's value.
func (s *GetMergeConflictsOutput) SetDestinationCommitId(v string) *GetMergeConflictsOutput {
	s.DestinationCommitId = &v
	return s
}

// SetMergeable sets the Mergeable field's value.
func (s *GetMergeConflictsOutput) SetMergeable(v bool) *GetMergeConflictsOutput {
	s.Mergeable = &v
	return s
}

// SetSourceCommitId sets the SourceCommitId field's value.
func (s *GetMergeConflictsOutput) SetSourceCommitId(v string) *GetMergeConflictsOutput {
	s.SourceCommitId = &v
	return s
}

type GetPullRequestInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPullRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPullRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPullRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPullRequestInput"}
	if s.PullRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *GetPullRequestInput) SetPullRequestId(v string) *GetPullRequestInput {
	s.PullRequestId = &v
	return s
}

type GetPullRequestOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified pull request.
	//
	// PullRequest is a required field
	PullRequest *PullRequest `locationName:"pullRequest" type:"structure" required:"true"`
}

// String returns the string representation
func (s GetPullRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPullRequestOutput) GoString() string {
	return s.String()
}

// SetPullRequest sets the PullRequest field's value.
func (s *GetPullRequestOutput) SetPullRequest(v *PullRequest) *GetPullRequestOutput {
	s.PullRequest = v
	return s
}

// Represents the input of a get repository operation.
type GetRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository to get information about.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryInput) SetRepositoryName(v string) *GetRepositoryInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get repository operation.
type GetRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the repository.
	RepositoryMetadata *RepositoryMetadata `locationName:"repositoryMetadata" type:"structure"`
}

// String returns the string representation
func (s GetRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepositoryMetadata sets the RepositoryMetadata field's value.
func (s *GetRepositoryOutput) SetRepositoryMetadata(v *RepositoryMetadata) *GetRepositoryOutput {
	s.RepositoryMetadata = v
	return s
}

// Represents the input of a get repository triggers operation.
type GetRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository for which the trigger is configured.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryTriggersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryTriggersInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositoryTriggersInput) SetRepositoryName(v string) *GetRepositoryTriggersInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a get repository triggers operation.
type GetRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID for the trigger.
	ConfigurationId *string `locationName:"configurationId" type:"string"`

	// The JSON block of configuration information for each trigger.
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s GetRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *GetRepositoryTriggersOutput) SetConfigurationId(v string) *GetRepositoryTriggersOutput {
	s.ConfigurationId = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *GetRepositoryTriggersOutput) SetTriggers(v []*RepositoryTrigger) *GetRepositoryTriggersOutput {
	s.Triggers = v
	return s
}

// Represents the input of a list branches operation.
type ListBranchesInput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the repository that contains the branches.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListBranchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBranchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBranchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBranchesInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListBranchesInput) SetNextToken(v string) *ListBranchesInput {
	s.NextToken = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *ListBranchesInput) SetRepositoryName(v string) *ListBranchesInput {
	s.RepositoryName = &v
	return s
}

// Represents the output of a list branches operation.
type ListBranchesOutput struct {
	_ struct{} `type:"structure"`

	// The list of branch names.
	Branches []*string `locationName:"branches" type:"list"`

	// An enumeration token that returns the batch of the results.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBranchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBranchesOutput) GoString() string {
	return s.String()
}

// SetBranches sets the Branches field's value.
func (s *ListBranchesOutput) SetBranches(v []*string) *ListBranchesOutput {
	s.Branches = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBranchesOutput) SetNextToken(v string) *ListBranchesOutput {
	s.NextToken = &v
	return s
}

type ListPullRequestsInput struct {
	_ struct{} `type:"structure"`

	// Optional. The Amazon Resource Name (ARN) of the user who created the pull
	// request. If used, this filters the results to pull requests created by that
	// user.
	AuthorArn *string `locationName:"authorArn" type:"string"`

	// A non-negative integer used to limit the number of returned results.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// An enumeration token that when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Optional. The status of the pull request. If used, this refines the results
	// to the pull requests that match the specified status.
	PullRequestStatus *string `locationName:"pullRequestStatus" type:"string" enum:"PullRequestStatusEnum"`

	// The name of the repository for which you want to list pull requests.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPullRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPullRequestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPullRequestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPullRequestsInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorArn sets the AuthorArn field's value.
func (s *ListPullRequestsInput) SetAuthorArn(v string) *ListPullRequestsInput {
	s.AuthorArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPullRequestsInput) SetMaxResults(v int64) *ListPullRequestsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPullRequestsInput) SetNextToken(v string) *ListPullRequestsInput {
	s.NextToken = &v
	return s
}

// SetPullRequestStatus sets the PullRequestStatus field's value.
func (s *ListPullRequestsInput) SetPullRequestStatus(v string) *ListPullRequestsInput {
	s.PullRequestStatus = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *ListPullRequestsInput) SetRepositoryName(v string) *ListPullRequestsInput {
	s.RepositoryName = &v
	return s
}

type ListPullRequestsOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that when provided in a request, returns the next batch
	// of the results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The system-generated IDs of the pull requests.
	//
	// PullRequestIds is a required field
	PullRequestIds []*string `locationName:"pullRequestIds" type:"list" required:"true"`
}

// String returns the string representation
func (s ListPullRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPullRequestsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPullRequestsOutput) SetNextToken(v string) *ListPullRequestsOutput {
	s.NextToken = &v
	return s
}

// SetPullRequestIds sets the PullRequestIds field's value.
func (s *ListPullRequestsOutput) SetPullRequestIds(v []*string) *ListPullRequestsOutput {
	s.PullRequestIds = v
	return s
}

// Represents the input of a list repositories operation.
type ListRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation. Batch sizes are 1,000 for list repository operations. When the
	// client sends the token back to AWS CodeCommit, another page of 1,000 records
	// is retrieved.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order in which to sort the results of a list repositories operation.
	Order *string `locationName:"order" type:"string" enum:"OrderEnum"`

	// The criteria used to sort the results of a list repositories operation.
	SortBy *string `locationName:"sortBy" type:"string" enum:"SortByEnum"`
}

// String returns the string representation
func (s ListRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoriesInput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesInput) SetNextToken(v string) *ListRepositoriesInput {
	s.NextToken = &v
	return s
}

// SetOrder sets the Order field's value.
func (s *ListRepositoriesInput) SetOrder(v string) *ListRepositoriesInput {
	s.Order = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListRepositoriesInput) SetSortBy(v string) *ListRepositoriesInput {
	s.SortBy = &v
	return s
}

// Represents the output of a list repositories operation.
type ListRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// An enumeration token that allows the operation to batch the results of the
	// operation. Batch sizes are 1,000 for list repository operations. When the
	// client sends the token back to AWS CodeCommit, another page of 1,000 records
	// is retrieved.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Lists the repositories called by the list repositories operation.
	Repositories []*RepositoryNameIdPair `locationName:"repositories" type:"list"`
}

// String returns the string representation
func (s ListRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRepositoriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesOutput) SetNextToken(v string) *ListRepositoriesOutput {
	s.NextToken = &v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *ListRepositoriesOutput) SetRepositories(v []*RepositoryNameIdPair) *ListRepositoriesOutput {
	s.Repositories = v
	return s
}

// Returns information about the location of a change or comment in the comparison
// between two commits or a pull request.
type Location struct {
	_ struct{} `type:"structure"`

	// The name of the file being compared, including its extension and subdirectory,
	// if any.
	FilePath *string `locationName:"filePath" type:"string"`

	// The position of a change within a compared file, in line number format.
	FilePosition *int64 `locationName:"filePosition" type:"long"`

	// In a comparison of commits or a pull request, whether the change is in the
	// 'before' or 'after' of that comparison.
	RelativeFileVersion *string `locationName:"relativeFileVersion" type:"string" enum:"RelativeFileVersionEnum"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// SetFilePath sets the FilePath field's value.
func (s *Location) SetFilePath(v string) *Location {
	s.FilePath = &v
	return s
}

// SetFilePosition sets the FilePosition field's value.
func (s *Location) SetFilePosition(v int64) *Location {
	s.FilePosition = &v
	return s
}

// SetRelativeFileVersion sets the RelativeFileVersion field's value.
func (s *Location) SetRelativeFileVersion(v string) *Location {
	s.RelativeFileVersion = &v
	return s
}

// Returns information about a merge or potential merge between a source reference
// and a destination reference in a pull request.
type MergeMetadata struct {
	_ struct{} `type:"structure"`

	// A Boolean value indicating whether the merge has been made.
	IsMerged *bool `locationName:"isMerged" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user who merged the branches.
	MergedBy *string `locationName:"mergedBy" type:"string"`
}

// String returns the string representation
func (s MergeMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeMetadata) GoString() string {
	return s.String()
}

// SetIsMerged sets the IsMerged field's value.
func (s *MergeMetadata) SetIsMerged(v bool) *MergeMetadata {
	s.IsMerged = &v
	return s
}

// SetMergedBy sets the MergedBy field's value.
func (s *MergeMetadata) SetMergedBy(v string) *MergeMetadata {
	s.MergedBy = &v
	return s
}

type MergePullRequestByFastForwardInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`

	// The name of the repository where the pull request was created.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The full commit ID of the original or updated commit in the pull request
	// source branch. Pass this value if you want an exception thrown if the current
	// commit ID of the tip of the source branch does not match this commit ID.
	SourceCommitId *string `locationName:"sourceCommitId" type:"string"`
}

// String returns the string representation
func (s MergePullRequestByFastForwardInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergePullRequestByFastForwardInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MergePullRequestByFastForwardInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MergePullRequestByFastForwardInput"}
	if s.PullRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *MergePullRequestByFastForwardInput) SetPullRequestId(v string) *MergePullRequestByFastForwardInput {
	s.PullRequestId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *MergePullRequestByFastForwardInput) SetRepositoryName(v string) *MergePullRequestByFastForwardInput {
	s.RepositoryName = &v
	return s
}

// SetSourceCommitId sets the SourceCommitId field's value.
func (s *MergePullRequestByFastForwardInput) SetSourceCommitId(v string) *MergePullRequestByFastForwardInput {
	s.SourceCommitId = &v
	return s
}

type MergePullRequestByFastForwardOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified pull request, including information about
	// the merge.
	PullRequest *PullRequest `locationName:"pullRequest" type:"structure"`
}

// String returns the string representation
func (s MergePullRequestByFastForwardOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergePullRequestByFastForwardOutput) GoString() string {
	return s.String()
}

// SetPullRequest sets the PullRequest field's value.
func (s *MergePullRequestByFastForwardOutput) SetPullRequest(v *PullRequest) *MergePullRequestByFastForwardOutput {
	s.PullRequest = v
	return s
}

type PostCommentForComparedCommitInput struct {
	_ struct{} `type:"structure"`

	// To establish the directionality of the comparison, the full commit ID of
	// the 'after' commit.
	//
	// AfterCommitId is a required field
	AfterCommitId *string `locationName:"afterCommitId" type:"string" required:"true"`

	// To establish the directionality of the comparison, the full commit ID of
	// the 'before' commit.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// A unique, client-generated idempotency token that when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// is received with the same parameters and a token is included, the request
	// will return information about the initial request that used that token.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The content of the comment you want to make.
	//
	// Content is a required field
	Content *string `locationName:"content" type:"string" required:"true"`

	// The location of the comparison where you want to comment.
	Location *Location `locationName:"location" type:"structure"`

	// The name of the repository where you want to post a comment on the comparison
	// between commits.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PostCommentForComparedCommitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostCommentForComparedCommitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PostCommentForComparedCommitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PostCommentForComparedCommitInput"}
	if s.AfterCommitId == nil {
		invalidParams.Add(request.NewErrParamRequired("AfterCommitId"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *PostCommentForComparedCommitInput) SetAfterCommitId(v string) *PostCommentForComparedCommitInput {
	s.AfterCommitId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *PostCommentForComparedCommitInput) SetBeforeCommitId(v string) *PostCommentForComparedCommitInput {
	s.BeforeCommitId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *PostCommentForComparedCommitInput) SetClientRequestToken(v string) *PostCommentForComparedCommitInput {
	s.ClientRequestToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *PostCommentForComparedCommitInput) SetContent(v string) *PostCommentForComparedCommitInput {
	s.Content = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *PostCommentForComparedCommitInput) SetLocation(v *Location) *PostCommentForComparedCommitInput {
	s.Location = v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PostCommentForComparedCommitInput) SetRepositoryName(v string) *PostCommentForComparedCommitInput {
	s.RepositoryName = &v
	return s
}

type PostCommentForComparedCommitOutput struct {
	_ struct{} `type:"structure"`

	// In the directionality you established, the blob ID of the 'after' blob.
	AfterBlobId *string `locationName:"afterBlobId" type:"string"`

	// In the directionality you established, the full commit ID of the 'after'
	// commit.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// In the directionality you established, the blob ID of the 'before' blob.
	BeforeBlobId *string `locationName:"beforeBlobId" type:"string"`

	// In the directionality you established, the full commit ID of the 'before'
	// commit.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// The content of the comment you posted.
	Comment *Comment `locationName:"comment" type:"structure"`

	// The location of the comment in the comparison between the two commits.
	Location *Location `locationName:"location" type:"structure"`

	// The name of the repository where you posted a comment on the comparison between
	// commits.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s PostCommentForComparedCommitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostCommentForComparedCommitOutput) GoString() string {
	return s.String()
}

// SetAfterBlobId sets the AfterBlobId field's value.
func (s *PostCommentForComparedCommitOutput) SetAfterBlobId(v string) *PostCommentForComparedCommitOutput {
	s.AfterBlobId = &v
	return s
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *PostCommentForComparedCommitOutput) SetAfterCommitId(v string) *PostCommentForComparedCommitOutput {
	s.AfterCommitId = &v
	return s
}

// SetBeforeBlobId sets the BeforeBlobId field's value.
func (s *PostCommentForComparedCommitOutput) SetBeforeBlobId(v string) *PostCommentForComparedCommitOutput {
	s.BeforeBlobId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *PostCommentForComparedCommitOutput) SetBeforeCommitId(v string) *PostCommentForComparedCommitOutput {
	s.BeforeCommitId = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *PostCommentForComparedCommitOutput) SetComment(v *Comment) *PostCommentForComparedCommitOutput {
	s.Comment = v
	return s
}

// SetLocation sets the Location field's value.
func (s *PostCommentForComparedCommitOutput) SetLocation(v *Location) *PostCommentForComparedCommitOutput {
	s.Location = v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PostCommentForComparedCommitOutput) SetRepositoryName(v string) *PostCommentForComparedCommitOutput {
	s.RepositoryName = &v
	return s
}

type PostCommentForPullRequestInput struct {
	_ struct{} `type:"structure"`

	// The full commit ID of the commit in the source branch that is the current
	// tip of the branch for the pull request when you post the comment.
	//
	// AfterCommitId is a required field
	AfterCommitId *string `locationName:"afterCommitId" type:"string" required:"true"`

	// The full commit ID of the commit in the destination branch that was the tip
	// of the branch at the time the pull request was created.
	//
	// BeforeCommitId is a required field
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string" required:"true"`

	// A unique, client-generated idempotency token that when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// is received with the same parameters and a token is included, the request
	// will return information about the initial request that used that token.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The content of your comment on the change.
	//
	// Content is a required field
	Content *string `locationName:"content" type:"string" required:"true"`

	// The location of the change where you want to post your comment. If no location
	// is provided, the comment will be posted as a general comment on the pull
	// request difference between the before commit ID and the after commit ID.
	Location *Location `locationName:"location" type:"structure"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`

	// The name of the repository where you want to post a comment on a pull request.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PostCommentForPullRequestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostCommentForPullRequestInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PostCommentForPullRequestInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PostCommentForPullRequestInput"}
	if s.AfterCommitId == nil {
		invalidParams.Add(request.NewErrParamRequired("AfterCommitId"))
	}
	if s.BeforeCommitId == nil {
		invalidParams.Add(request.NewErrParamRequired("BeforeCommitId"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.PullRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestId"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *PostCommentForPullRequestInput) SetAfterCommitId(v string) *PostCommentForPullRequestInput {
	s.AfterCommitId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *PostCommentForPullRequestInput) SetBeforeCommitId(v string) *PostCommentForPullRequestInput {
	s.BeforeCommitId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *PostCommentForPullRequestInput) SetClientRequestToken(v string) *PostCommentForPullRequestInput {
	s.ClientRequestToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *PostCommentForPullRequestInput) SetContent(v string) *PostCommentForPullRequestInput {
	s.Content = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *PostCommentForPullRequestInput) SetLocation(v *Location) *PostCommentForPullRequestInput {
	s.Location = v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *PostCommentForPullRequestInput) SetPullRequestId(v string) *PostCommentForPullRequestInput {
	s.PullRequestId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PostCommentForPullRequestInput) SetRepositoryName(v string) *PostCommentForPullRequestInput {
	s.RepositoryName = &v
	return s
}

type PostCommentForPullRequestOutput struct {
	_ struct{} `type:"structure"`

	// In the directionality of the pull request, the blob ID of the 'after' blob.
	AfterBlobId *string `locationName:"afterBlobId" type:"string"`

	// The full commit ID of the commit in the destination branch where the pull
	// request will be merged.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// In the directionality of the pull request, the blob ID of the 'before' blob.
	BeforeBlobId *string `locationName:"beforeBlobId" type:"string"`

	// The full commit ID of the commit in the source branch used to create the
	// pull request, or in the case of an updated pull request, the full commit
	// ID of the commit used to update the pull request.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// The content of the comment you posted.
	Comment *Comment `locationName:"comment" type:"structure"`

	// The location of the change where you posted your comment.
	Location *Location `locationName:"location" type:"structure"`

	// The system-generated ID of the pull request.
	PullRequestId *string `locationName:"pullRequestId" type:"string"`

	// The name of the repository where you posted a comment on a pull request.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s PostCommentForPullRequestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostCommentForPullRequestOutput) GoString() string {
	return s.String()
}

// SetAfterBlobId sets the AfterBlobId field's value.
func (s *PostCommentForPullRequestOutput) SetAfterBlobId(v string) *PostCommentForPullRequestOutput {
	s.AfterBlobId = &v
	return s
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *PostCommentForPullRequestOutput) SetAfterCommitId(v string) *PostCommentForPullRequestOutput {
	s.AfterCommitId = &v
	return s
}

// SetBeforeBlobId sets the BeforeBlobId field's value.
func (s *PostCommentForPullRequestOutput) SetBeforeBlobId(v string) *PostCommentForPullRequestOutput {
	s.BeforeBlobId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *PostCommentForPullRequestOutput) SetBeforeCommitId(v string) *PostCommentForPullRequestOutput {
	s.BeforeCommitId = &v
	return s
}

// SetComment sets the Comment field's value.
func (s *PostCommentForPullRequestOutput) SetComment(v *Comment) *PostCommentForPullRequestOutput {
	s.Comment = v
	return s
}

// SetLocation sets the Location field's value.
func (s *PostCommentForPullRequestOutput) SetLocation(v *Location) *PostCommentForPullRequestOutput {
	s.Location = v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *PostCommentForPullRequestOutput) SetPullRequestId(v string) *PostCommentForPullRequestOutput {
	s.PullRequestId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PostCommentForPullRequestOutput) SetRepositoryName(v string) *PostCommentForPullRequestOutput {
	s.RepositoryName = &v
	return s
}

type PostCommentReplyInput struct {
	_ struct{} `type:"structure"`

	// A unique, client-generated idempotency token that when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// is received with the same parameters and a token is included, the request
	// will return information about the initial request that used that token.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The contents of your reply to a comment.
	//
	// Content is a required field
	Content *string `locationName:"content" type:"string" required:"true"`

	// The system-generated ID of the comment to which you want to reply. To get
	// this ID, use GetCommentsForComparedCommit or GetCommentsForPullRequest.
	//
	// InReplyTo is a required field
	InReplyTo *string `locationName:"inReplyTo" type:"string" required:"true"`
}

// String returns the string representation
func (s PostCommentReplyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostCommentReplyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PostCommentReplyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PostCommentReplyInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.InReplyTo == nil {
		invalidParams.Add(request.NewErrParamRequired("InReplyTo"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *PostCommentReplyInput) SetClientRequestToken(v string) *PostCommentReplyInput {
	s.ClientRequestToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *PostCommentReplyInput) SetContent(v string) *PostCommentReplyInput {
	s.Content = &v
	return s
}

// SetInReplyTo sets the InReplyTo field's value.
func (s *PostCommentReplyInput) SetInReplyTo(v string) *PostCommentReplyInput {
	s.InReplyTo = &v
	return s
}

type PostCommentReplyOutput struct {
	_ struct{} `type:"structure"`

	// Information about the reply to a comment.
	Comment *Comment `locationName:"comment" type:"structure"`
}

// String returns the string representation
func (s PostCommentReplyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostCommentReplyOutput) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *PostCommentReplyOutput) SetComment(v *Comment) *PostCommentReplyOutput {
	s.Comment = v
	return s
}

// Returns information about a pull request.
type PullRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user who created the pull request.
	AuthorArn *string `locationName:"authorArn" type:"string"`

	// A unique, client-generated idempotency token that when provided in a request,
	// ensures the request cannot be repeated with a changed parameter. If a request
	// is received with the same parameters and a token is included, the request
	// will return information about the initial request that used that token.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The date and time the pull request was originally created, in timestamp format.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The user-defined description of the pull request. This description can be
	// used to clarify what should be reviewed and other details of the request.
	Description *string `locationName:"description" type:"string"`

	// The day and time of the last user or system activity on the pull request,
	// in timestamp format.
	LastActivityDate *time.Time `locationName:"lastActivityDate" type:"timestamp" timestampFormat:"unix"`

	// The system-generated ID of the pull request.
	PullRequestId *string `locationName:"pullRequestId" type:"string"`

	// The status of the pull request. Pull request status can only change from
	// OPEN to CLOSED.
	PullRequestStatus *string `locationName:"pullRequestStatus" type:"string" enum:"PullRequestStatusEnum"`

	// The targets of the pull request, including the source branch and destination
	// branch for the pull request.
	PullRequestTargets []*PullRequestTarget `locationName:"pullRequestTargets" type:"list"`

	// The user-defined title of the pull request. This title is displayed in the
	// list of pull requests to other users of the repository.
	Title *string `locationName:"title" type:"string"`
}

// String returns the string representation
func (s PullRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PullRequest) GoString() string {
	return s.String()
}

// SetAuthorArn sets the AuthorArn field's value.
func (s *PullRequest) SetAuthorArn(v string) *PullRequest {
	s.AuthorArn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *PullRequest) SetClientRequestToken(v string) *PullRequest {
	s.ClientRequestToken = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *PullRequest) SetCreationDate(v time.Time) *PullRequest {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PullRequest) SetDescription(v string) *PullRequest {
	s.Description = &v
	return s
}

// SetLastActivityDate sets the LastActivityDate field's value.
func (s *PullRequest) SetLastActivityDate(v time.Time) *PullRequest {
	s.LastActivityDate = &v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *PullRequest) SetPullRequestId(v string) *PullRequest {
	s.PullRequestId = &v
	return s
}

// SetPullRequestStatus sets the PullRequestStatus field's value.
func (s *PullRequest) SetPullRequestStatus(v string) *PullRequest {
	s.PullRequestStatus = &v
	return s
}

// SetPullRequestTargets sets the PullRequestTargets field's value.
func (s *PullRequest) SetPullRequestTargets(v []*PullRequestTarget) *PullRequest {
	s.PullRequestTargets = v
	return s
}

// SetTitle sets the Title field's value.
func (s *PullRequest) SetTitle(v string) *PullRequest {
	s.Title = &v
	return s
}

// Returns information about a pull request event.
type PullRequestEvent struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user whose actions resulted in the
	// event. Examples include updating the pull request with additional commits
	// or changing the status of a pull request.
	ActorArn *string `locationName:"actorArn" type:"string"`

	// The day and time of the pull request event, in timestamp format.
	EventDate *time.Time `locationName:"eventDate" type:"timestamp" timestampFormat:"unix"`

	// The type of the pull request event, for example a status change event (PULL_REQUEST_STATUS_CHANGED)
	// or update event (PULL_REQUEST_SOURCE_REFERENCE_UPDATED).
	PullRequestEventType *string `locationName:"pullRequestEventType" type:"string" enum:"PullRequestEventType"`

	// The system-generated ID of the pull request.
	PullRequestId *string `locationName:"pullRequestId" type:"string"`

	// Information about the change in mergability state for the pull request event.
	PullRequestMergedStateChangedEventMetadata *PullRequestMergedStateChangedEventMetadata `locationName:"pullRequestMergedStateChangedEventMetadata" type:"structure"`

	// Information about the updated source branch for the pull request event.
	PullRequestSourceReferenceUpdatedEventMetadata *PullRequestSourceReferenceUpdatedEventMetadata `locationName:"pullRequestSourceReferenceUpdatedEventMetadata" type:"structure"`

	// Information about the change in status for the pull request event.
	PullRequestStatusChangedEventMetadata *PullRequestStatusChangedEventMetadata `locationName:"pullRequestStatusChangedEventMetadata" type:"structure"`
}

// String returns the string representation
func (s PullRequestEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PullRequestEvent) GoString() string {
	return s.String()
}

// SetActorArn sets the ActorArn field's value.
func (s *PullRequestEvent) SetActorArn(v string) *PullRequestEvent {
	s.ActorArn = &v
	return s
}

// SetEventDate sets the EventDate field's value.
func (s *PullRequestEvent) SetEventDate(v time.Time) *PullRequestEvent {
	s.EventDate = &v
	return s
}

// SetPullRequestEventType sets the PullRequestEventType field's value.
func (s *PullRequestEvent) SetPullRequestEventType(v string) *PullRequestEvent {
	s.PullRequestEventType = &v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *PullRequestEvent) SetPullRequestId(v string) *PullRequestEvent {
	s.PullRequestId = &v
	return s
}

// SetPullRequestMergedStateChangedEventMetadata sets the PullRequestMergedStateChangedEventMetadata field's value.
func (s *PullRequestEvent) SetPullRequestMergedStateChangedEventMetadata(v *PullRequestMergedStateChangedEventMetadata) *PullRequestEvent {
	s.PullRequestMergedStateChangedEventMetadata = v
	return s
}

// SetPullRequestSourceReferenceUpdatedEventMetadata sets the PullRequestSourceReferenceUpdatedEventMetadata field's value.
func (s *PullRequestEvent) SetPullRequestSourceReferenceUpdatedEventMetadata(v *PullRequestSourceReferenceUpdatedEventMetadata) *PullRequestEvent {
	s.PullRequestSourceReferenceUpdatedEventMetadata = v
	return s
}

// SetPullRequestStatusChangedEventMetadata sets the PullRequestStatusChangedEventMetadata field's value.
func (s *PullRequestEvent) SetPullRequestStatusChangedEventMetadata(v *PullRequestStatusChangedEventMetadata) *PullRequestEvent {
	s.PullRequestStatusChangedEventMetadata = v
	return s
}

// Returns information about the change in the merge state for a pull request
// event.
type PullRequestMergedStateChangedEventMetadata struct {
	_ struct{} `type:"structure"`

	// The name of the branch that the pull request will be merged into.
	DestinationReference *string `locationName:"destinationReference" type:"string"`

	// Information about the merge state change event.
	MergeMetadata *MergeMetadata `locationName:"mergeMetadata" type:"structure"`

	// The name of the repository where the pull request was created.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s PullRequestMergedStateChangedEventMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PullRequestMergedStateChangedEventMetadata) GoString() string {
	return s.String()
}

// SetDestinationReference sets the DestinationReference field's value.
func (s *PullRequestMergedStateChangedEventMetadata) SetDestinationReference(v string) *PullRequestMergedStateChangedEventMetadata {
	s.DestinationReference = &v
	return s
}

// SetMergeMetadata sets the MergeMetadata field's value.
func (s *PullRequestMergedStateChangedEventMetadata) SetMergeMetadata(v *MergeMetadata) *PullRequestMergedStateChangedEventMetadata {
	s.MergeMetadata = v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PullRequestMergedStateChangedEventMetadata) SetRepositoryName(v string) *PullRequestMergedStateChangedEventMetadata {
	s.RepositoryName = &v
	return s
}

// Information about an update to the source branch of a pull request.
type PullRequestSourceReferenceUpdatedEventMetadata struct {
	_ struct{} `type:"structure"`

	// The full commit ID of the commit in the source branch that was the tip of
	// the branch at the time the pull request was updated.
	AfterCommitId *string `locationName:"afterCommitId" type:"string"`

	// The full commit ID of the commit in the destination branch that was the tip
	// of the branch at the time the pull request was updated.
	BeforeCommitId *string `locationName:"beforeCommitId" type:"string"`

	// The name of the repository where the pull request was updated.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s PullRequestSourceReferenceUpdatedEventMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PullRequestSourceReferenceUpdatedEventMetadata) GoString() string {
	return s.String()
}

// SetAfterCommitId sets the AfterCommitId field's value.
func (s *PullRequestSourceReferenceUpdatedEventMetadata) SetAfterCommitId(v string) *PullRequestSourceReferenceUpdatedEventMetadata {
	s.AfterCommitId = &v
	return s
}

// SetBeforeCommitId sets the BeforeCommitId field's value.
func (s *PullRequestSourceReferenceUpdatedEventMetadata) SetBeforeCommitId(v string) *PullRequestSourceReferenceUpdatedEventMetadata {
	s.BeforeCommitId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PullRequestSourceReferenceUpdatedEventMetadata) SetRepositoryName(v string) *PullRequestSourceReferenceUpdatedEventMetadata {
	s.RepositoryName = &v
	return s
}

// Information about a change to the status of a pull request.
type PullRequestStatusChangedEventMetadata struct {
	_ struct{} `type:"structure"`

	// The changed status of the pull request.
	PullRequestStatus *string `locationName:"pullRequestStatus" type:"string" enum:"PullRequestStatusEnum"`
}

// String returns the string representation
func (s PullRequestStatusChangedEventMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PullRequestStatusChangedEventMetadata) GoString() string {
	return s.String()
}

// SetPullRequestStatus sets the PullRequestStatus field's value.
func (s *PullRequestStatusChangedEventMetadata) SetPullRequestStatus(v string) *PullRequestStatusChangedEventMetadata {
	s.PullRequestStatus = &v
	return s
}

// Returns information about a pull request target.
type PullRequestTarget struct {
	_ struct{} `type:"structure"`

	// The full commit ID that is the tip of the destination branch. This is the
	// commit where the pull request was or will be merged.
	DestinationCommit *string `locationName:"destinationCommit" type:"string"`

	// The branch of the repository where the pull request changes will be merged
	// into. Also known as the destination branch.
	DestinationReference *string `locationName:"destinationReference" type:"string"`

	// Returns metadata about the state of the merge, including whether the merge
	// has been made.
	MergeMetadata *MergeMetadata `locationName:"mergeMetadata" type:"structure"`

	// The name of the repository that contains the pull request source and destination
	// branches.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`

	// The full commit ID of the tip of the source branch used to create the pull
	// request. If the pull request branch is updated by a push while the pull request
	// is open, the commit ID will change to reflect the new tip of the branch.
	SourceCommit *string `locationName:"sourceCommit" type:"string"`

	// The branch of the repository that contains the changes for the pull request.
	// Also known as the source branch.
	SourceReference *string `locationName:"sourceReference" type:"string"`
}

// String returns the string representation
func (s PullRequestTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PullRequestTarget) GoString() string {
	return s.String()
}

// SetDestinationCommit sets the DestinationCommit field's value.
func (s *PullRequestTarget) SetDestinationCommit(v string) *PullRequestTarget {
	s.DestinationCommit = &v
	return s
}

// SetDestinationReference sets the DestinationReference field's value.
func (s *PullRequestTarget) SetDestinationReference(v string) *PullRequestTarget {
	s.DestinationReference = &v
	return s
}

// SetMergeMetadata sets the MergeMetadata field's value.
func (s *PullRequestTarget) SetMergeMetadata(v *MergeMetadata) *PullRequestTarget {
	s.MergeMetadata = v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PullRequestTarget) SetRepositoryName(v string) *PullRequestTarget {
	s.RepositoryName = &v
	return s
}

// SetSourceCommit sets the SourceCommit field's value.
func (s *PullRequestTarget) SetSourceCommit(v string) *PullRequestTarget {
	s.SourceCommit = &v
	return s
}

// SetSourceReference sets the SourceReference field's value.
func (s *PullRequestTarget) SetSourceReference(v string) *PullRequestTarget {
	s.SourceReference = &v
	return s
}

type PutFileInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch where you want to add or update the file.
	//
	// BranchName is a required field
	BranchName *string `locationName:"branchName" min:"1" type:"string" required:"true"`

	// A message about why this file was added or updated. While optional, adding
	// a message is strongly encouraged in order to provide a more useful commit
	// history for your repository.
	CommitMessage *string `locationName:"commitMessage" type:"string"`

	// An email address for the person adding or updating the file.
	Email *string `locationName:"email" type:"string"`

	// The content of the file, in binary object format.
	//
	// FileContent is automatically base64 encoded/decoded by the SDK.
	//
	// FileContent is a required field
	FileContent []byte `locationName:"fileContent" type:"blob" required:"true"`

	// The file mode permissions of the blob. Valid file mode permissions are listed
	// below.
	FileMode *string `locationName:"fileMode" type:"string" enum:"FileModeTypeEnum"`

	// The name of the file you want to add or update, including the relative path
	// to the file in the repository.
	//
	// If the path does not currently exist in the repository, the path will be
	// created as part of adding the file.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" type:"string" required:"true"`

	// The name of the person adding or updating the file. While optional, adding
	// a name is strongly encouraged in order to provide a more useful commit history
	// for your repository.
	Name *string `locationName:"name" type:"string"`

	// The full commit ID of the head commit in the branch where you want to add
	// or update the file. If the commit ID does not match the ID of the head commit
	// at the time of the operation, an error will occur, and the file will not
	// be added or updated.
	ParentCommitId *string `locationName:"parentCommitId" type:"string"`

	// The name of the repository where you want to add or update the file.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutFileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFileInput"}
	if s.BranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.FileContent == nil {
		invalidParams.Add(request.NewErrParamRequired("FileContent"))
	}
	if s.FilePath == nil {
		invalidParams.Add(request.NewErrParamRequired("FilePath"))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *PutFileInput) SetBranchName(v string) *PutFileInput {
	s.BranchName = &v
	return s
}

// SetCommitMessage sets the CommitMessage field's value.
func (s *PutFileInput) SetCommitMessage(v string) *PutFileInput {
	s.CommitMessage = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *PutFileInput) SetEmail(v string) *PutFileInput {
	s.Email = &v
	return s
}

// SetFileContent sets the FileContent field's value.
func (s *PutFileInput) SetFileContent(v []byte) *PutFileInput {
	s.FileContent = v
	return s
}

// SetFileMode sets the FileMode field's value.
func (s *PutFileInput) SetFileMode(v string) *PutFileInput {
	s.FileMode = &v
	return s
}

// SetFilePath sets the FilePath field's value.
func (s *PutFileInput) SetFilePath(v string) *PutFileInput {
	s.FilePath = &v
	return s
}

// SetName sets the Name field's value.
func (s *PutFileInput) SetName(v string) *PutFileInput {
	s.Name = &v
	return s
}

// SetParentCommitId sets the ParentCommitId field's value.
func (s *PutFileInput) SetParentCommitId(v string) *PutFileInput {
	s.ParentCommitId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PutFileInput) SetRepositoryName(v string) *PutFileInput {
	s.RepositoryName = &v
	return s
}

type PutFileOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the blob, which is its SHA-1 pointer.
	//
	// BlobId is a required field
	BlobId *string `locationName:"blobId" type:"string" required:"true"`

	// The full SHA of the commit that contains this file change.
	//
	// CommitId is a required field
	CommitId *string `locationName:"commitId" type:"string" required:"true"`

	// Tree information for the commit that contains this file change.
	//
	// TreeId is a required field
	TreeId *string `locationName:"treeId" type:"string" required:"true"`
}

// String returns the string representation
func (s PutFileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutFileOutput) GoString() string {
	return s.String()
}

// SetBlobId sets the BlobId field's value.
func (s *PutFileOutput) SetBlobId(v string) *PutFileOutput {
	s.BlobId = &v
	return s
}

// SetCommitId sets the CommitId field's value.
func (s *PutFileOutput) SetCommitId(v string) *PutFileOutput {
	s.CommitId = &v
	return s
}

// SetTreeId sets the TreeId field's value.
func (s *PutFileOutput) SetTreeId(v string) *PutFileOutput {
	s.TreeId = &v
	return s
}

// Represents the input ofa put repository triggers operation.
type PutRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository where you want to create or update the trigger.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The JSON block of configuration information for each trigger.
	//
	// Triggers is a required field
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list" required:"true"`
}

// String returns the string representation
func (s PutRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRepositoryTriggersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRepositoryTriggersInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.Triggers == nil {
		invalidParams.Add(request.NewErrParamRequired("Triggers"))
	}
	if s.Triggers != nil {
		for i, v := range s.Triggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Triggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *PutRepositoryTriggersInput) SetRepositoryName(v string) *PutRepositoryTriggersInput {
	s.RepositoryName = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *PutRepositoryTriggersInput) SetTriggers(v []*RepositoryTrigger) *PutRepositoryTriggersInput {
	s.Triggers = v
	return s
}

// Represents the output of a put repository triggers operation.
type PutRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The system-generated unique ID for the create or update operation.
	ConfigurationId *string `locationName:"configurationId" type:"string"`
}

// String returns the string representation
func (s PutRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// SetConfigurationId sets the ConfigurationId field's value.
func (s *PutRepositoryTriggersOutput) SetConfigurationId(v string) *PutRepositoryTriggersOutput {
	s.ConfigurationId = &v
	return s
}

// Information about a repository.
type RepositoryMetadata struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account associated with the repository.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the repository.
	Arn *string `type:"string"`

	// The URL to use for cloning the repository over HTTPS.
	CloneUrlHttp *string `locationName:"cloneUrlHttp" type:"string"`

	// The URL to use for cloning the repository over SSH.
	CloneUrlSsh *string `locationName:"cloneUrlSsh" type:"string"`

	// The date and time the repository was created, in timestamp format.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"unix"`

	// The repository's default branch name.
	DefaultBranch *string `locationName:"defaultBranch" min:"1" type:"string"`

	// The date and time the repository was last modified, in timestamp format.
	LastModifiedDate *time.Time `locationName:"lastModifiedDate" type:"timestamp" timestampFormat:"unix"`

	// A comment or description about the repository.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The ID of the repository.
	RepositoryId *string `locationName:"repositoryId" type:"string"`

	// The repository's name.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s RepositoryMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryMetadata) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RepositoryMetadata) SetAccountId(v string) *RepositoryMetadata {
	s.AccountId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *RepositoryMetadata) SetArn(v string) *RepositoryMetadata {
	s.Arn = &v
	return s
}

// SetCloneUrlHttp sets the CloneUrlHttp field's value.
func (s *RepositoryMetadata) SetCloneUrlHttp(v string) *RepositoryMetadata {
	s.CloneUrlHttp = &v
	return s
}

// SetCloneUrlSsh sets the CloneUrlSsh field's value.
func (s *RepositoryMetadata) SetCloneUrlSsh(v string) *RepositoryMetadata {
	s.CloneUrlSsh = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *RepositoryMetadata) SetCreationDate(v time.Time) *RepositoryMetadata {
	s.CreationDate = &v
	return s
}

// SetDefaultBranch sets the DefaultBranch field's value.
func (s *RepositoryMetadata) SetDefaultBranch(v string) *RepositoryMetadata {
	s.DefaultBranch = &v
	return s
}

// SetLastModifiedDate sets the LastModifiedDate field's value.
func (s *RepositoryMetadata) SetLastModifiedDate(v time.Time) *RepositoryMetadata {
	s.LastModifiedDate = &v
	return s
}

// SetRepositoryDescription sets the RepositoryDescription field's value.
func (s *RepositoryMetadata) SetRepositoryDescription(v string) *RepositoryMetadata {
	s.RepositoryDescription = &v
	return s
}

// SetRepositoryId sets the RepositoryId field's value.
func (s *RepositoryMetadata) SetRepositoryId(v string) *RepositoryMetadata {
	s.RepositoryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *RepositoryMetadata) SetRepositoryName(v string) *RepositoryMetadata {
	s.RepositoryName = &v
	return s
}

// Information about a repository name and ID.
type RepositoryNameIdPair struct {
	_ struct{} `type:"structure"`

	// The ID associated with the repository.
	RepositoryId *string `locationName:"repositoryId" type:"string"`

	// The name associated with the repository.
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string"`
}

// String returns the string representation
func (s RepositoryNameIdPair) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryNameIdPair) GoString() string {
	return s.String()
}

// SetRepositoryId sets the RepositoryId field's value.
func (s *RepositoryNameIdPair) SetRepositoryId(v string) *RepositoryNameIdPair {
	s.RepositoryId = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *RepositoryNameIdPair) SetRepositoryName(v string) *RepositoryNameIdPair {
	s.RepositoryName = &v
	return s
}

// Information about a trigger for a repository.
type RepositoryTrigger struct {
	_ struct{} `type:"structure"`

	// The branches that will be included in the trigger configuration. If you specify
	// an empty array, the trigger will apply to all branches.
	//
	// While no content is required in the array, you must include the array itself.
	Branches []*string `locationName:"branches" type:"list"`

	// Any custom data associated with the trigger that will be included in the
	// information sent to the target of the trigger.
	CustomData *string `locationName:"customData" type:"string"`

	// The ARN of the resource that is the target for a trigger. For example, the
	// ARN of a topic in Amazon Simple Notification Service (SNS).
	//
	// DestinationArn is a required field
	DestinationArn *string `locationName:"destinationArn" type:"string" required:"true"`

	// The repository events that will cause the trigger to run actions in another
	// service, such as sending a notification through Amazon Simple Notification
	// Service (SNS).
	//
	// The valid value "all" cannot be used with any other values.
	//
	// Events is a required field
	Events []*string `locationName:"events" type:"list" required:"true"`

	// The name of the trigger.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s RepositoryTrigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryTrigger) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryTrigger) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepositoryTrigger"}
	if s.DestinationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationArn"))
	}
	if s.Events == nil {
		invalidParams.Add(request.NewErrParamRequired("Events"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranches sets the Branches field's value.
func (s *RepositoryTrigger) SetBranches(v []*string) *RepositoryTrigger {
	s.Branches = v
	return s
}

// SetCustomData sets the CustomData field's value.
func (s *RepositoryTrigger) SetCustomData(v string) *RepositoryTrigger {
	s.CustomData = &v
	return s
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *RepositoryTrigger) SetDestinationArn(v string) *RepositoryTrigger {
	s.DestinationArn = &v
	return s
}

// SetEvents sets the Events field's value.
func (s *RepositoryTrigger) SetEvents(v []*string) *RepositoryTrigger {
	s.Events = v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryTrigger) SetName(v string) *RepositoryTrigger {
	s.Name = &v
	return s
}

// A trigger failed to run.
type RepositoryTriggerExecutionFailure struct {
	_ struct{} `type:"structure"`

	// Additional message information about the trigger that did not run.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The name of the trigger that did not run.
	Trigger *string `locationName:"trigger" type:"string"`
}

// String returns the string representation
func (s RepositoryTriggerExecutionFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RepositoryTriggerExecutionFailure) GoString() string {
	return s.String()
}

// SetFailureMessage sets the FailureMessage field's value.
func (s *RepositoryTriggerExecutionFailure) SetFailureMessage(v string) *RepositoryTriggerExecutionFailure {
	s.FailureMessage = &v
	return s
}

// SetTrigger sets the Trigger field's value.
func (s *RepositoryTriggerExecutionFailure) SetTrigger(v string) *RepositoryTriggerExecutionFailure {
	s.Trigger = &v
	return s
}

// Returns information about a target for a pull request.
type Target struct {
	_ struct{} `type:"structure"`

	// The branch of the repository where the pull request changes will be merged
	// into. Also known as the destination branch.
	DestinationReference *string `locationName:"destinationReference" type:"string"`

	// The name of the repository that contains the pull request.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The branch of the repository that contains the changes for the pull request.
	// Also known as the source branch.
	//
	// SourceReference is a required field
	SourceReference *string `locationName:"sourceReference" type:"string" required:"true"`
}

// String returns the string representation
func (s Target) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Target) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Target) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Target"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.SourceReference == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceReference"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationReference sets the DestinationReference field's value.
func (s *Target) SetDestinationReference(v string) *Target {
	s.DestinationReference = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *Target) SetRepositoryName(v string) *Target {
	s.RepositoryName = &v
	return s
}

// SetSourceReference sets the SourceReference field's value.
func (s *Target) SetSourceReference(v string) *Target {
	s.SourceReference = &v
	return s
}

// Represents the input of a test repository triggers operation.
type TestRepositoryTriggersInput struct {
	_ struct{} `type:"structure"`

	// The name of the repository in which to test the triggers.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The list of triggers to test.
	//
	// Triggers is a required field
	Triggers []*RepositoryTrigger `locationName:"triggers" type:"list" required:"true"`
}

// String returns the string representation
func (s TestRepositoryTriggersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRepositoryTriggersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestRepositoryTriggersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestRepositoryTriggersInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.Triggers == nil {
		invalidParams.Add(request.NewErrParamRequired("Triggers"))
	}
	if s.Triggers != nil {
		for i, v := range s.Triggers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Triggers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *TestRepositoryTriggersInput) SetRepositoryName(v string) *TestRepositoryTriggersInput {
	s.RepositoryName = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *TestRepositoryTriggersInput) SetTriggers(v []*RepositoryTrigger) *TestRepositoryTriggersInput {
	s.Triggers = v
	return s
}

// Represents the output of a test repository triggers operation.
type TestRepositoryTriggersOutput struct {
	_ struct{} `type:"structure"`

	// The list of triggers that were not able to be tested. This list provides
	// the names of the triggers that could not be tested, separated by commas.
	FailedExecutions []*RepositoryTriggerExecutionFailure `locationName:"failedExecutions" type:"list"`

	// The list of triggers that were successfully tested. This list provides the
	// names of the triggers that were successfully tested, separated by commas.
	SuccessfulExecutions []*string `locationName:"successfulExecutions" type:"list"`
}

// String returns the string representation
func (s TestRepositoryTriggersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestRepositoryTriggersOutput) GoString() string {
	return s.String()
}

// SetFailedExecutions sets the FailedExecutions field's value.
func (s *TestRepositoryTriggersOutput) SetFailedExecutions(v []*RepositoryTriggerExecutionFailure) *TestRepositoryTriggersOutput {
	s.FailedExecutions = v
	return s
}

// SetSuccessfulExecutions sets the SuccessfulExecutions field's value.
func (s *TestRepositoryTriggersOutput) SetSuccessfulExecutions(v []*string) *TestRepositoryTriggersOutput {
	s.SuccessfulExecutions = v
	return s
}

type UpdateCommentInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the comment you want to update. To get this ID,
	// use GetCommentsForComparedCommit or GetCommentsForPullRequest.
	//
	// CommentId is a required field
	CommentId *string `locationName:"commentId" type:"string" required:"true"`

	// The updated content with which you want to replace the existing content of
	// the comment.
	//
	// Content is a required field
	Content *string `locationName:"content" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCommentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCommentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCommentInput"}
	if s.CommentId == nil {
		invalidParams.Add(request.NewErrParamRequired("CommentId"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommentId sets the CommentId field's value.
func (s *UpdateCommentInput) SetCommentId(v string) *UpdateCommentInput {
	s.CommentId = &v
	return s
}

// SetContent sets the Content field's value.
func (s *UpdateCommentInput) SetContent(v string) *UpdateCommentInput {
	s.Content = &v
	return s
}

type UpdateCommentOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated comment.
	Comment *Comment `locationName:"comment" type:"structure"`
}

// String returns the string representation
func (s UpdateCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCommentOutput) GoString() string {
	return s.String()
}

// SetComment sets the Comment field's value.
func (s *UpdateCommentOutput) SetComment(v *Comment) *UpdateCommentOutput {
	s.Comment = v
	return s
}

// Represents the input of an update default branch operation.
type UpdateDefaultBranchInput struct {
	_ struct{} `type:"structure"`

	// The name of the branch to set as the default.
	//
	// DefaultBranchName is a required field
	DefaultBranchName *string `locationName:"defaultBranchName" min:"1" type:"string" required:"true"`

	// The name of the repository to set or change the default branch for.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDefaultBranchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDefaultBranchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDefaultBranchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDefaultBranchInput"}
	if s.DefaultBranchName == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultBranchName"))
	}
	if s.DefaultBranchName != nil && len(*s.DefaultBranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DefaultBranchName", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultBranchName sets the DefaultBranchName field's value.
func (s *UpdateDefaultBranchInput) SetDefaultBranchName(v string) *UpdateDefaultBranchInput {
	s.DefaultBranchName = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UpdateDefaultBranchInput) SetRepositoryName(v string) *UpdateDefaultBranchInput {
	s.RepositoryName = &v
	return s
}

type UpdateDefaultBranchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDefaultBranchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDefaultBranchOutput) GoString() string {
	return s.String()
}

type UpdatePullRequestDescriptionInput struct {
	_ struct{} `type:"structure"`

	// The updated content of the description for the pull request. This content
	// will replace the existing description.
	//
	// Description is a required field
	Description *string `locationName:"description" type:"string" required:"true"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePullRequestDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePullRequestDescriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePullRequestDescriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePullRequestDescriptionInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.PullRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdatePullRequestDescriptionInput) SetDescription(v string) *UpdatePullRequestDescriptionInput {
	s.Description = &v
	return s
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *UpdatePullRequestDescriptionInput) SetPullRequestId(v string) *UpdatePullRequestDescriptionInput {
	s.PullRequestId = &v
	return s
}

type UpdatePullRequestDescriptionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated pull request.
	//
	// PullRequest is a required field
	PullRequest *PullRequest `locationName:"pullRequest" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdatePullRequestDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePullRequestDescriptionOutput) GoString() string {
	return s.String()
}

// SetPullRequest sets the PullRequest field's value.
func (s *UpdatePullRequestDescriptionOutput) SetPullRequest(v *PullRequest) *UpdatePullRequestDescriptionOutput {
	s.PullRequest = v
	return s
}

type UpdatePullRequestStatusInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`

	// The status of the pull request. The only valid operations are to update the
	// status from OPEN to OPEN, OPEN to CLOSED or from from CLOSED to CLOSED.
	//
	// PullRequestStatus is a required field
	PullRequestStatus *string `locationName:"pullRequestStatus" type:"string" required:"true" enum:"PullRequestStatusEnum"`
}

// String returns the string representation
func (s UpdatePullRequestStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePullRequestStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePullRequestStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePullRequestStatusInput"}
	if s.PullRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestId"))
	}
	if s.PullRequestStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *UpdatePullRequestStatusInput) SetPullRequestId(v string) *UpdatePullRequestStatusInput {
	s.PullRequestId = &v
	return s
}

// SetPullRequestStatus sets the PullRequestStatus field's value.
func (s *UpdatePullRequestStatusInput) SetPullRequestStatus(v string) *UpdatePullRequestStatusInput {
	s.PullRequestStatus = &v
	return s
}

type UpdatePullRequestStatusOutput struct {
	_ struct{} `type:"structure"`

	// Information about the pull request.
	//
	// PullRequest is a required field
	PullRequest *PullRequest `locationName:"pullRequest" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdatePullRequestStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePullRequestStatusOutput) GoString() string {
	return s.String()
}

// SetPullRequest sets the PullRequest field's value.
func (s *UpdatePullRequestStatusOutput) SetPullRequest(v *PullRequest) *UpdatePullRequestStatusOutput {
	s.PullRequest = v
	return s
}

type UpdatePullRequestTitleInput struct {
	_ struct{} `type:"structure"`

	// The system-generated ID of the pull request. To get this ID, use ListPullRequests.
	//
	// PullRequestId is a required field
	PullRequestId *string `locationName:"pullRequestId" type:"string" required:"true"`

	// The updated title of the pull request. This will replace the existing title.
	//
	// Title is a required field
	Title *string `locationName:"title" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdatePullRequestTitleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePullRequestTitleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePullRequestTitleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePullRequestTitleInput"}
	if s.PullRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("PullRequestId"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPullRequestId sets the PullRequestId field's value.
func (s *UpdatePullRequestTitleInput) SetPullRequestId(v string) *UpdatePullRequestTitleInput {
	s.PullRequestId = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *UpdatePullRequestTitleInput) SetTitle(v string) *UpdatePullRequestTitleInput {
	s.Title = &v
	return s
}

type UpdatePullRequestTitleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the updated pull request.
	//
	// PullRequest is a required field
	PullRequest *PullRequest `locationName:"pullRequest" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdatePullRequestTitleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePullRequestTitleOutput) GoString() string {
	return s.String()
}

// SetPullRequest sets the PullRequest field's value.
func (s *UpdatePullRequestTitleOutput) SetPullRequest(v *PullRequest) *UpdatePullRequestTitleOutput {
	s.PullRequest = v
	return s
}

// Represents the input of an update repository description operation.
type UpdateRepositoryDescriptionInput struct {
	_ struct{} `type:"structure"`

	// The new comment or description for the specified repository. Repository descriptions
	// are limited to 1,000 characters.
	RepositoryDescription *string `locationName:"repositoryDescription" type:"string"`

	// The name of the repository to set or change the comment or description for.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRepositoryDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryDescriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRepositoryDescriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRepositoryDescriptionInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRepositoryDescription sets the RepositoryDescription field's value.
func (s *UpdateRepositoryDescriptionInput) SetRepositoryDescription(v string) *UpdateRepositoryDescriptionInput {
	s.RepositoryDescription = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UpdateRepositoryDescriptionInput) SetRepositoryName(v string) *UpdateRepositoryDescriptionInput {
	s.RepositoryName = &v
	return s
}

type UpdateRepositoryDescriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRepositoryDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryDescriptionOutput) GoString() string {
	return s.String()
}

// Represents the input of an update repository description operation.
type UpdateRepositoryNameInput struct {
	_ struct{} `type:"structure"`

	// The new name for the repository.
	//
	// NewName is a required field
	NewName *string `locationName:"newName" min:"1" type:"string" required:"true"`

	// The existing name of the repository.
	//
	// OldName is a required field
	OldName *string `locationName:"oldName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRepositoryNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRepositoryNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRepositoryNameInput"}
	if s.NewName == nil {
		invalidParams.Add(request.NewErrParamRequired("NewName"))
	}
	if s.NewName != nil && len(*s.NewName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewName", 1))
	}
	if s.OldName == nil {
		invalidParams.Add(request.NewErrParamRequired("OldName"))
	}
	if s.OldName != nil && len(*s.OldName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OldName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNewName sets the NewName field's value.
func (s *UpdateRepositoryNameInput) SetNewName(v string) *UpdateRepositoryNameInput {
	s.NewName = &v
	return s
}

// SetOldName sets the OldName field's value.
func (s *UpdateRepositoryNameInput) SetOldName(v string) *UpdateRepositoryNameInput {
	s.OldName = &v
	return s
}

type UpdateRepositoryNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRepositoryNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRepositoryNameOutput) GoString() string {
	return s.String()
}

// Information about the user who made a specified commit.
type UserInfo struct {
	_ struct{} `type:"structure"`

	// The date when the specified commit was commited, in timestamp format with
	// GMT offset.
	Date *string `locationName:"date" type:"string"`

	// The email address associated with the user who made the commit, if any.
	Email *string `locationName:"email" type:"string"`

	// The name of the user who made the specified commit.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UserInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserInfo) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *UserInfo) SetDate(v string) *UserInfo {
	s.Date = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *UserInfo) SetEmail(v string) *UserInfo {
	s.Email = &v
	return s
}

// SetName sets the Name field's value.
func (s *UserInfo) SetName(v string) *UserInfo {
	s.Name = &v
	return s
}

const (
	// ChangeTypeEnumA is a ChangeTypeEnum enum value
	ChangeTypeEnumA = "A"

	// ChangeTypeEnumM is a ChangeTypeEnum enum value
	ChangeTypeEnumM = "M"

	// ChangeTypeEnumD is a ChangeTypeEnum enum value
	ChangeTypeEnumD = "D"
)

const (
	// FileModeTypeEnumExecutable is a FileModeTypeEnum enum value
	FileModeTypeEnumExecutable = "EXECUTABLE"

	// FileModeTypeEnumNormal is a FileModeTypeEnum enum value
	FileModeTypeEnumNormal = "NORMAL"

	// FileModeTypeEnumSymlink is a FileModeTypeEnum enum value
	FileModeTypeEnumSymlink = "SYMLINK"
)

const (
	// MergeOptionTypeEnumFastForwardMerge is a MergeOptionTypeEnum enum value
	MergeOptionTypeEnumFastForwardMerge = "FAST_FORWARD_MERGE"
)

const (
	// OrderEnumAscending is a OrderEnum enum value
	OrderEnumAscending = "ascending"

	// OrderEnumDescending is a OrderEnum enum value
	OrderEnumDescending = "descending"
)

const (
	// PullRequestEventTypePullRequestCreated is a PullRequestEventType enum value
	PullRequestEventTypePullRequestCreated = "PULL_REQUEST_CREATED"

	// PullRequestEventTypePullRequestStatusChanged is a PullRequestEventType enum value
	PullRequestEventTypePullRequestStatusChanged = "PULL_REQUEST_STATUS_CHANGED"

	// PullRequestEventTypePullRequestSourceReferenceUpdated is a PullRequestEventType enum value
	PullRequestEventTypePullRequestSourceReferenceUpdated = "PULL_REQUEST_SOURCE_REFERENCE_UPDATED"

	// PullRequestEventTypePullRequestMergeStateChanged is a PullRequestEventType enum value
	PullRequestEventTypePullRequestMergeStateChanged = "PULL_REQUEST_MERGE_STATE_CHANGED"
)

const (
	// PullRequestStatusEnumOpen is a PullRequestStatusEnum enum value
	PullRequestStatusEnumOpen = "OPEN"

	// PullRequestStatusEnumClosed is a PullRequestStatusEnum enum value
	PullRequestStatusEnumClosed = "CLOSED"
)

const (
	// RelativeFileVersionEnumBefore is a RelativeFileVersionEnum enum value
	RelativeFileVersionEnumBefore = "BEFORE"

	// RelativeFileVersionEnumAfter is a RelativeFileVersionEnum enum value
	RelativeFileVersionEnumAfter = "AFTER"
)

const (
	// RepositoryTriggerEventEnumAll is a RepositoryTriggerEventEnum enum value
	RepositoryTriggerEventEnumAll = "all"

	// RepositoryTriggerEventEnumUpdateReference is a RepositoryTriggerEventEnum enum value
	RepositoryTriggerEventEnumUpdateReference = "updateReference"

	// RepositoryTriggerEventEnumCreateReference is a RepositoryTriggerEventEnum enum value
	RepositoryTriggerEventEnumCreateReference = "createReference"

	// RepositoryTriggerEventEnumDeleteReference is a RepositoryTriggerEventEnum enum value
	RepositoryTriggerEventEnumDeleteReference = "deleteReference"
)

const (
	// SortByEnumRepositoryName is a SortByEnum enum value
	SortByEnumRepositoryName = "repositoryName"

	// SortByEnumLastModifiedDate is a SortByEnum enum value
	SortByEnumLastModifiedDate = "lastModifiedDate"
)
