# G.4 Why do social anarchists reject individualist anarchism?

As James J. Martin notes, _"paralleling"_ European social anarchism
_"chronologically was a kindred but nearly unconnected phenomenon in America,
seeking the same ends through individualistic rather than collectivistic
dynamics."_ [**Men Against the State**, p. ix]

When the two movements meet in America in the 1880s, the similarities and
differences of both came into sharp relief. While both social and
individualist anarchists reject capitalism as well as the state and seek an
end to the exploitation of labour by capital (i.e. to usury in all its forms),
both schools of anarchism rejected each others solutions to the social
problem. The vision of the social anarchists was more communally based, urging
social ownership of the means of life. In contrast, reflecting the pre-
dominantly pre-capitalist nature of post-revolution US society, the
Individualist Anarchists urged possession of the means of life and mutual
banking to end profit, interest and rent and ensure every worker access to the
capital they needed to work for themselves (if they so desired). While social
anarchists placed co-operatives (i.e., workers' self-management) at the centre
of their vision of a free society, many individualist anarchists did not as
they thought that mutual banking would end exploitation by ensuring that
workers received the full product of their labour.

Thus their vision of a free society and the means to achieve it were somewhat
different (although, we stress, **not** mutually exclusive as communist
anarchists supported artisan possession of the means of production for those
who rejected communism and the Individualist Anarchists supported voluntary
communism). Tucker argued that a communist could not be an anarchist and the
communist-anarchists argued that Individualist Anarchism could not end the
exploitation of capital by labour. Here we indicate why social anarchists
reject individualist anarchism (see [section G.2](secG2.html) for a summary of
why Individualist Anarchists reject social anarchism).

Malatesta summarises the essential points of difference as well as the source
of much of the misunderstandings:

> _"The individualists assume, or speak as if they assumed, that the
(anarchist) communists wish to impose communism, which of course would put
them right outside the ranks of anarchism. _

> _"The communists assume, or speak as if they assumed, that the (anarchist)
individualists reject every idea of association, want the struggle between
men, the domination of the strongest -- and this would put them not only
outside the anarchist movement but outside humanity. _

> _"In reality those who are communists are such because they see in communism
freely accepted the realisation of brotherhood, and the best guarantee for
individual freedom. And individualists, those who are really anarchists, are
anti-communist because they fear that communism would subject individuals
nominally to the tyranny of the collectivity and in fact to that of the party
or caste which, with the excuse of administering things, would succeed in
taking possession of the power to dispose of material things and thus of the
people who need them. Therefore they want each individual, or each group, to
be in a position to enjoy freely the product of their labour in conditions of
equality with other individuals and groups, with whom they would maintain
relations of justice and equity. _

> _"In which case it is clear that there is no basic difference between us.
But, according to the communists, justice and equity are, under natural
conditions impossible of attainment in an individualistic society, and thus
freedom too would not be attained. _

> _"If climatic conditions throughout the world were the same, if the land
were everywhere equally fertile, if raw materials were evenly distributed and
within reach of all who needed them, if social development were the same
everywhere in the world . . . then one could conceive of everyone . . .
finding the land, tools and raw materials needed to work and produce
independently, without exploiting or being exploited. But natural and
historical conditions being what they are, how is it possible to establish
equality and justice between he who by chance finds himself with a piece of
arid land which demands much labour for small returns with him who has a piece
of fertile and well sited land?" Of between the inhabitant of a village lost
in the mountains or in the middle of a marshy area, with the inhabitants of a
city which hundreds of generations of man have enriched with all the skill of
human genius and labour?_ [**Errico Malatesta: His Life and Ideas**, pp. 31-2]

The social anarchist opposition to individualist anarchism, therefore,
resolves around the issues of inequality, the limitations and negative impact
of markets and whether wage-labour is consistent with anarchist principles
(both in general and in terms of individualist anarchism itself). We discuss
the issue of wage labour and anarchist principles in the [next
section](secG4.html#secg41) and argue in [section G.4.2](secG4.html#secg42)
that Tucker's support for wage-labour, like any authoritarian social
relationship, ensures that this is an inconsistent form of anarchism. Here we
concentrate on issues of inequality and markets.

First, we must stress that individualist anarchism plays an important role in
reminding all socialists that capitalism does **not** equal the market.
Markets have existed before capitalism and may, if we believe market
socialists like David Schweickart and free market socialists like Benjamin
Tucker and Kevin Carson, even survive it. While some socialists (particularly
Leninists echoing, ironically, supporters of capitalism) equate capitalism
with the market, this is not the case. Capitalism is a specific form of market
economy based on certain kinds of property rights which result in generalised
wage labour and non-labour incomes (exploitation). This means that the
libertarian communist critique of capitalism is to a large degree independent
of its critique of markets and their negative impact. Equally, the libertarian
communist critique of markets, while applicable to capitalism, applies to
other kinds of economy. It is fair to say, though, that capitalism tends to
intensify and worsen the negative effects of markets.

Second, we must also note that social anarchists are a diverse grouping and
include the mutualism of Proudhon, Bakunin's collectivism and Kropotkin's
communism. All share a common hostility to wage labour and recognise, to
varying degrees, that markets tend to have negative aspects which can
undermine the libertarian nature of a society. While Proudhon was the social
anarchist most in favour of competition, he was well aware of the need for
self-managed workplaces to federate together to protect themselves from its
negative aspects -- aspects he discussed at length. His _"agro-industrial
federation"_ was seen as a means of socialising the market, of ensuring that
competition would not reach such levels as to undermine the freedom and
equality of those within it. Individualist anarchists, in contrast, tended not
to discuss the negative effects of markets in any great depth (if at all),
presumably because they thought that most of the negative effects would
disappear along with capitalism and the state. Other anarchists are not so
optimistic.

So, two key issues between social and individualist anarchism are the related
subjects of property and competition. As Voltairine de Cleyre put it when she
was an individualist anarchist:

> _"She and I hold many differing views on both Economy and Morals . . . Miss
Goldmann [sic] is a communist; I am an individualist. She wishes to destroy
the right of property, I wish to assert it. I make my war upon privilege and
authority, whereby the right of property, the true right in that which is
proper to the individual, is annihilated. She believes that co-operation would
entirely supplant competition; I hold that competition in one form or another
will always exist, and that it is highly desirable it should."_ [**The
Voltairine de Cleyre Reader**, p. 9]

The question of "property" is subject to much confusion and distortion. It
should be stressed that both social and individualist anarchists argue that
the only true property is that produced by labour (mental and physical) and
capitalism results in some of that being diverted to property owners in the
form of interest, rent and profits. Where they disagree is whether it is
possible and desirable to calculate an individual's contribution to social
production, particularly within a situation of joint labour. For Tucker, it
was a case of creating _"the economic law by which every man may get the
equivalent of his product."_ [quoted by George Woodcock and Ivan Avakumovic,
**The Anarchist Prince**, p. 279] Social anarchists, particularly communist
ones, question whether it is possible in reality to discover such a thing in
any society based on joint labour (_"which it would be difficult to imagine
could exist in any society where there is the least complexity of
production."_ [George Woodcock and Ivan Avakumovic, **Op. Cit.**, p. 280]).

This was the crux of Kropotkin's critique of the various schemes of "labour
money" and "labour vouchers" raised by other schools of socialism (like
mutualism, collectivism and various state socialist systems). They may abolish
wage labour (or, at worse, create state capitalism) but they did not abolish
the wages system, i.e., payment according to work done. This meant that a
system of individualist distribution was forced upon a fundamentally co-
operative system of production and so was illogical and unjust (see
Kropotkin's _"The Collectivist Wage System"_ in **The Conquest of Bread**).
Thus Daniel Guérin:

> _"This method of remuneration, derived from modified individualism, is in
contradiction to collective ownership of the means of production, and cannot
bring about a profound revolutionary change in man. It is incompatible with
anarchism; a new form of ownership requires a new form of remuneration.
Service to the community cannot be measured in units of money. Needs will have
to be given precedence over services, and all the products of the labour of
all must belong to all, each to take his share of them freely. **To each
according to his need** should be the motto of libertarian communism."_
[**Anarchism**, p. 50]

Simply put, wages rarely reflect the actual contribution of a specific person
to social well-being and production nor do they reflect their actual needs. To
try and get actual labour income to reflect the actual contribution to society
would be, communist-anarchists argued, immensely difficult. How much of a
product's price was the result of better land or more machinery, luck, the
willingness to externalise costs, and so on? Voltairine de Cleyre summarised
this problem and the obvious solution:

> _"I concluded that as to the question of exchange and money, it was so
exceedingly bewildering, so impossible of settlement among the professors
themselves, as to the nature of value, and the representation of value, and
the unit of value, and the numberless multiplications and divisions of the
subject, that the best thing ordinary workingmen or women could do was to
organise their industry so as to get rid of money altogether. I figured it
this way: I’m not any more a fool than the rest of ordinary humanity; I’ve
figured and figured away on this thing for years, and directly I thought
myself middling straight, there came another money reformer and showed me the
hole in that scheme, till, at last, it appears that between 'bills of credit,'
and 'labour notes' and 'time checks,' and 'mutual bank issues,' and 'the
invariable unit of value,' none of them have any sense. How many thousands of
years is it going to get this sort of thing into people’s heads by mere
preaching of theories. Let it be this way: Let there be an end of the special
monopoly on securities for money issues. Let every community go ahead and try
some member's money scheme if it wants; - let every individual try it if he
pleases. But better for the working people let them all go. Let them produce
together, co-operatively rather than as employer and employed; let them
fraternise group by group, let each use what he needs of his own product, and
deposit the rest in the storage-houses, and let those others who need goods
have them as occasion arises."_ [**Exquisite Rebel**, p. 62]

And, obviously, it must be stressed that "property" in the sense of personal
possessions would still exist in communist-anarchism. As the co-founder of
**Freedom** put it:

> _"Does Anarchism, then, it may be asked, acknowledge no **Meum** or
**Tuum**, no personal property? In a society in which every man is free to
take what he requires, it is hardly conceivable that personal necessaries and
conveniences will not be appropriated, and difficult to imagine why they
should not . . . When property is protected by no legal enactments, backed by
armed force, and is unable to buy personal service, its resuscitation on such
a scale as to be dangerous to society is little to be dreaded. The amount
appropriated by each individual, and the manner of his appropriation, must be
left to his own conscience, and the pressure exercised upon him by the moral
sense and distinct interests of his neighbours."_ [Charlotte Wilson,
**Anarchist Essays**, p. 24]

To use an appropriate example, public libraries are open to all local
residents and they are free to borrow books from the stock available. When the
book is borrowed, others cannot come along and take the books from a person's
home. Similarly, an individual in a communist society can take what they like
from the common stocks and use it as they see fit. They do not need permission
from others to do so, just as people freely go to public parks without
requiring a vote by the local community on whether to allow access or not.
Communism, in other words, does not imply community control of personal
consumption nor the denial of individuals to appropriate and use the common
stock of available goods. Socialised consumption does **not** mean "society"
telling people what to consume but rather ensuring that all individuals have
free access to the goods produced by all. As such, the issue is not about
"property" in the sense of personal property but rather "property" in the
sense of access to the means of life by those who use them. Will owner
occupiers be able to exclude others from, say, their land and workplaces
unless they agree to be their servants?

Which brings us to a key issue between certain forms of individualist
anarchism and social anarchism, namely the issue of wage labour. As capitalism
has progressed, the size of workplaces and firms have increased. This has lead
to a situation where ownership and use has divorced, with property being used
by a group of individuals distinct from the few who are legally proclaimed to
be its owners. The key problem arises in the case of workplaces and how do
non-possessors gain access to them. Under social anarchism, any new members of
the collective automatically become part of it, with the same rights and
ability to participate in decision making as the existing ones. In other
words, socialised production does **not** mean that "society" will allocate
individuals work tasks but rather it ensures that all individuals have free
access to the means of life. Under individualist anarchism, however, the
situation is not as clear with some (like Tucker) supporting wage labour. This
suggests that the holders of workplaces can exclude others from the means of
life they possess and only allow them access under conditions which create
hierarchical social relationships between them. Thus we could have a situation
in which the owners who actually manage their own workplaces are, in effect,
working capitalists who hire others to do specific tasks in return for a wage.

The problem is highlighted in Tucker's description of what would replace the
current system of statism (and note he calls it _"scientific socialism"_ thus
squarely placing his ideas in the anti-capitalist camp):

> _"we have something very tangible to offer , . . We offer non-compulsive
organisation. We offer associative combination. We offer every possible method
of voluntary social union by which men and women may act together for the
furtherance of well-being. In short, we offer voluntary scientific socialism
in place of the present compulsory, unscientific organisation which
characterises the State and all of its ramifications."_ [quoted by Martin,
**Op. Cit.**, p. 218]

Yet it is more than possible for voluntary social unions to be authoritarian
and exploitative (we see this every day under capitalism). In other words, not
every form of non-compulsive organisation is consistent with libertarian
principles. Given Tucker's egoism, it is not hard to conclude that those in
stronger positions on the market will seek to maximise their advantages and
exploit those who are subject to their will. As he put it, _"[s]o far as
inherent right is concerned, might is the only measure. Any man . . . and any
set of men . . . have the right, if they have the power, to kill or coerce
other men and to make the entire world subservient to their ends. Society's
right to enslave the individual and the individual's right to enslave society
are only unequal because their powers are unequal."_ In the market, all
contracts are based ownership of resources which exist before any specific
contracts is made. If one side of the contract has more economic power than
the other (say, because of their ownership of capital) then it staggers belief
that egoists will not seek to maximise said advantage and so the market will
tend to increase inequalities over time rather than reduce them. If, as Tucker
argued, _"Anarchic associations would recognise the right of individual
occupants to combine their holdings and work them under any system they might
agree upon, the arrangement being always terminable at will, with reversion to
original rights"_ then we have the unfortunate situation where inequalities
will undermine anarchism and defence associations arising which will defend
them against attempts by those subject to them to use direct action to rectify
the situation. [**The Individualist Anarchists**, p. 25 and p. 162]

Kropotkin saw the danger, arguing that such an idea _"runs against the
feelings of equality of most of us"_ and _"brings the would-be
'Individualists' dangerously near to those who imagine themselves to represent
a 'superior breed' -- those to whom we owe the State . . . and all other forms
of oppression."_ [**Evolution and Environment**, p. 84] As we discuss in the
[next section](secG4.html#secg41), it is clear that wage labour (like any
hierarchical organisation) is not consistent with general anarchist principles
and, furthermore, in direct contradiction to individualist anarchist
principles of "occupancy and use." Only if "occupancy and use" is consistently
applied and so wage labour replaced by workers associations can the
inequalities associated with market exchanges not become so great as to
destroy the equal freedom of all required for anarchism to work.

Individualist anarchists reply to this criticism by arguing that this is
derived from a narrow reading of Stirner's ideas and that they are in favour
of universal egoism. This universal egoism and the increase in competition
made possible by mutual banking will ensure that workers will have the upper-
hand in the market, with the possibility of setting up in business themselves
always available. In this way the ability of bosses to become autocrats is
limited, as is their power to exploit their workers as a result. Social
anarchists argue, in response, that the individualists tend to underestimate
the problems associated with natural barriers to entry in an industry. This
could help generate generalised wage labour (and so a new class of exploiters)
as workers face the unpleasant choice of working for a successful firm, being
unemployed or working for low wages in an industry with lower barriers to
entry. This process can be seen under capitalism when co-operatives hire wage
workers and not include them as members of the association (i.e. they exercise
their ownership rights to exclude others). As Proudhon argued:

> _"I have shown the entrepreneur, at the birth of industry, negotiating on
equal terms with his comrades, who have since become his workers. It is plain,
in fact, that this original equality was bound to disappear through the
advantageous position of the master and the dependence of the wage-workers. In
vain does the law assure the right of each to enterprise . . . When an
establishment has had leisure to develop itself, enlarge its foundations,
ballast itself with capital, and assure itself a body of patrons, what can a
workman do against a power so superior?"_ [**Property is Theft!**, p. 192]

Voltairine de Cleyre also came to this conclusion. Discussing the limitations
of the Single Tax land reform, she noted that _"the stubborn fact always came
up that no man would employ another to work for him unless he could get more
for his product than he had to pay for it, and that being the case, the
inevitable course of exchange and re-exchange would be that the man having
received less than the full amount, could buy back less than the full amount,
so that eventually the unsold products must again accumulate in the
capitalist's hands; and again the period of non-employment arrives."_ This
obviously applied to individualist anarchism. In response to objections like
this, individualists tend to argue that competition for labour would force
wages to equal output. Yet this ignores natural barriers to competition: _"it
is well enough to talk of his buying hand tools, or small machinery which can
be moved about; but what about the gigantic machinery necessary to the
operation of a mine, or a mill? It requires many to work it. If one owns it,
will he not make the others pay tribute for using it?"_ [**Op. Cit.**, p. 60
and p. 61]

As such, a free market based on wage labour would be extremely unlikely to
produce a non-exploitative society and, consequently, it would not be
socialist and so not anarchist. Moreover, the successful business person would
seek to secure his or her property and power and so employ police to do so.
_"I confess that I am not in love with all these little states,"_ proclaimed
de Cleyre, _"and it is . . . the thought of the anarchist policeman that has
driven me out of the individualist's camp, wherein I for some time resided."
_[quoted by Eugenia C. Delamotte, **Gates of Freedom**, p. 25] This outcome
can only be avoided by consistently applying "occupancy and use" in such as
way as to eliminate wage labour totally. Only this can achieve a society based
on freedom **of** association as well as freedom **within** association.

As we noted in [section G.2](secG2.html), one of the worries of individualist
anarchists is that social anarchism would subject individuals to group
pressures and concerns, violating individual autonomy in the name of
collective interests. Thus, it is argued, the individual will become of slave
of the group in practice if not in theory under social anarchism. However, an
inherent part of our humanity is that we associate with others, that we form
groups and communities. To suggest that there are no group issues within
anarchism seems at odds with reality. Taken literally, of course, this implies
that such a version of "anarchy" there would be no forms of association at
all. No groups, no families, no clubs: nothing bar the isolated individual. It
implies no economic activity beyond the level of peasant farming and one-
person artisan workplaces. Why? Simply because any form of organisation
implies "group issues." Two people deciding to live together or one hundred
people working together becomes a group, twenty people forming a football club
becomes a group. And these people have joint interests and so group issues. In
other words, to deny group issues is implying a social situation that has
never existed nor ever will. Thus Kropotkin:

> _"to reason in this way is to pay . . . too large a tribute to metaphysical
dialectics, and to ignore the facts of life. It is impossible to conceive a
society in which the affairs of any one of its members would not concern many
other members, if not all; still less a society in which a continual contact
between its members would not have established an interest of every one
towards all others, which would render it **impossible** to act without
thinking of the effects which our actions may have on others."_ [**Evolution
and Environment**, p. 85]

Once the reality of "group issues" is acknowledged, as most individualist
anarchists do, then the issue of collective decision making automatically
arises. There are two ways of having a group. You can be an association of
equals, governing yourselves collectively as regards collective issues. Or you
can have capitalists and wage slaves, bosses and servants, government and
governed. Only the first, for obvious reasons, is compatible with anarchist
principles. Freedom, in other words, is a product of how we interact with each
other, not of isolation. Simply put, anarchism is based on self-management of
group issues, not in their denial. Free association is, in this perspective, a
necessary but not sufficient to guarantee freedom. Therefore, social
anarchists reject the individualists' conception of anarchy, simply because it
can, unfortunately, allow hierarchy (i.e. government) back into a free society
in the name of "liberty" and "free contracts." Freedom is fundamentally a
social product, created in and by community. It is a fragile flower and does
not fare well when bought and sold on the market.

Moreover, without communal institutions, social anarchists argue, it would be
impossible to specify or supply group or public goods. In addition, occupancy
and use would, on the face of it, preclude such amenities which are utilised
by members of a community such as parks, roads or bridges -- anything which is
used but not occupied continually. In terms of roads and bridges, who actually
occupies and uses them? The drivers? Those who maintain them? The occupiers of
the houses which the road passes? Those who funded its construction? If the
last, then why does this not apply to housing and other buildings left on
land? And how are the owners to collect a return on their investment unless by
employing police to bar access to non-payers? And would such absentee owners
not also seek to extend their appropriations to other forms of property? Would
it not be far easier to simply communalise such forms of commonly used
"property" rather than seek to burden individuals and society with the costs
of policing and restricting access to them?

After all, social anarchists note, for Proudhon there was a series of
industries and services that he had no qualms about calling _"public works"_
and which he considered best handled by communes and their federations. Thus
_"the initiative of communes and departments as to works that operate within
their jurisdiction"_ with _"the initiative of the workers companies as to
carrying the works out."_ This was due to both their nature and libertarian
values and so the _"direct, sovereign initiative of localities, in arranging
for public works that belong to them, is a consequence of the democratic
principle and the free contract: their subordination to the State is . . . a
return to feudalism."_ Workers' self-management of such public works was,
again, a matter of libertarian principles for _"it becomes necessary for the
workers to form themselves into democratic societies, with equal conditions
for all members, on pain of a relapse into feudalism."_ [**Op. Cit.**, pp.
595-6]

In the case of a park, either it is open to all or it is fenced off and police
used to bar access. Taking "occupancy and use" as our starting point then it
becomes clear that, over time, either the community organises itself
communally or a park becomes private property. If a group of people frequent a
common area then they will have to discuss how to maintain it -- for example,
arrange for labour to be done on it, whether to have a play-ground for
children or to have a duck pond, whether to increase the numbers and types of
trees, and so forth. That implies the development of communal structures. In
the case of new people using the amenity, either they are excluded from it
(and have to pay for access) or they automatically join the users group and so
the park is, in effect, common property and socialised. In such circumstances,
it would be far easier simply to ignore the issue of individual contributions
and base access on need (i.e., communistic principles). However, as already
indicated in section G.2.1, social anarchists reject attempts to coerce other
workers into joining a co-operative or commune. Freedom cannot be given, it
must be taken and social anarchism, like all forms of anarchy, cannot be
imposed. How those who reject social anarchism will gain access to common
property will depend, undoubtedly, on specific circumstances and who exactly
is involved and how they wish to utilise it. As such, it will be difficult to
generalise as each commune will determine what is best and reach the
appropriate contracts with any individualist anarchists in their midst or
vicinity.

It should also be pointed out (and this may seem ironic), wage labour does
have the advantage that people can move to new locations and work without
having to sell their old means of living. Often moving somewhere can be a
hassle if one has to sell a shop or home. Many people prefer not to be tied
down to one place. This is a problem in a system based on "occupancy and use"
as permanently leaving a property means that it automatically becomes
abandoned and so its users may be forced to stay in one location until they
find a buyer for it. This is not an issue in social anarchism as access to the
means of life is guaranteed to all members of the free society.

Most social anarchists also are critical of the means which individualist
anarchists support to achieve anarchy, namely to abolish capitalism by the
creation of mutual banks which would compete exploitation and oppression away.
While mutual banks could aid the position of working class people under
capitalism (which is why Bakunin and other social anarchists recommended
them), they cannot undermine or eliminate it. This is because capitalism, due
to its need to accumulate, creates **natural** barriers to entry into a market
(see [section C.4](secC4.html)). Thus the physical size of the large
corporation would make it immune to the influence of mutual banking and so
usury could not be abolished. Even if we look at the claimed indirect impact
of mutual banking, namely an increase in the demand of labour and so wages,
the problem arises that if this happens then capitalism would soon go into a
slump (with obvious negative effects on small firms and co-operatives). In
such circumstances, the number of labourers seeking work would rise and so
wages would fall and profits rise. Then it is a case of whether the workers
would simply tolerate the slump and let capitalism continue or whether they
would seize their workplaces and practice the kind of expropriation
individualist anarchists tended to oppose.

This problem was recognised by many individualist anarchists themselves and it
played a significant role in its decline as a movement. By 1911 Tucker had
come to the same conclusions as communist-anarchists on whether capitalism
could be reformed away. As we noted in [section G.1.1](secG1.html#secg11), he
_"had come to believe that free banking and similar measures, even if
inaugurated, were no longer adequate to break the monopoly of capitalism or
weaken the authority of the state."_ [Paul Avrich, **Anarchist Voices**, p. 6]
While admitting that political or revolutionary action was required to destroy
the concentrations of capital which made anarchy impossible even with free
competition, he rejected the suggestion that individualist anarchists should
join in such activity. Voltairine de Cleyre came to similar conclusions
earlier and started working with Emma Goldman before becoming a communist-
anarchist sometime in 1908. Perhaps unsurprisingly, one historian argues that
as the _"native American variety of anarchism dissolved in the face of
increasing State repression and industrialisation, rationalisation, and
concentration of capital, American anarchists were forced either to acquiesce
or to seek a more militant strain of anarchism: this latter presented itself
in the form of Communist Anarchism . . . Faith in peaceful evolution toward an
anarchist society seemed archaic and gradually faded."_ [Kline, **The
Individualist Anarchists**, p. 83]

So while state action may increase the degree of monopoly in an industry, the
natural tendency for any market is to place barriers (natural ones) to new
entries in terms of set-up costs and so on. This applies just as much to co-
operatives as it does to companies based on wage-labour. It means that if the
relation between capital and labour was abolished **within** the workplace (by
their transformation into co-operatives) but they remained the property of
their workers, it would only be a matter of time before the separation of the
producers from their means of production reproduced itself. This is because,
within any market system, some firms fail and others succeed. Those which fail
will create a pool of unemployed workers who will need a job. The successful
co-operatives, safe behind their natural barriers to entry, would be in a
stronger position than the unemployed workers and so may hire them as wage
labourers -- in effect, the co-operative workers would become "collective
capitalists" hiring other workers. This would end workers' self-management (as
not all workers are involved in the decision making process) as well as
workers' ownership, i.e. _"occupancy and use,"_ (as not all workers' would own
the means of production they used). The individual workers involved may
"consent" to becoming wage slaves, but that is because it is the best option
available rather than what they really want. Which, of course, is the same as
under capitalism.

This was why Proudhon argued that _"every individual employed in the
association"_ must have _"an undivided share in the property of the company"_
in order to ensure workers' self-management. [**Op. Cit.**, p. 585] Only this
could ensure _"occupancy and use"_ and so self-management in a free society
(i.e. keep that society free). Thus in anarchism, as de Cleyre summarised, it
is _"a settled thing that to be free one must have liberty of access to the
sources and means of production"_ Without socialisation of the means of life,
liberty of access could be denied. Little wonder she argued that she had
become _"convinced that a number of the fundamental propositions of
individualistic economy would result in the destruction of equal liberty."_
The only logical anarchist position is _"that some settlement of the whole
labour question was needed which would not split up the people again into land
possessors and employed wage-earners."_ Hence her movement from individualism
towards, first, mutualism and then communism -- it was the only logical
position to take in a rapidly industrialising America which had made certain
concepts of individualism obsolete. It was her love of freedom which made her
sensitive to the possibility of any degeneration back into capitalism: _"the
instinct of liberty naturally revolted not only at economic servitude, but at
the outcome of it, class-lines."_ [**Op. Cit.**, p. 58, p. 105, p. 61 and p.
55] As we argue in [section G.4.2](secG4.html#secg42) such a possibility can
be avoided only by a consistent application of "occupancy and use" which, in
practice, would be nearly identical to the communalisation or socialisation of
the means of life.

This issue is related to the question of inequality within a market economy
and whether free exchanges tend to reduce or increase any initial
inequalities. While Individualist Anarchists argue for the _"cost principle"_
(i.e. cost being the limit of price) the cost of creating the same commodity
in different areas or by different people is not equal. Thus the market price
of a good **cannot** really equal the multitude of costs within it (and so
price can only equal a workers' labour in those few cases where that labour
was applied in average circumstances). This issue was recognised by Tucker,
who argued that _"economic rent . . . is one of nature's inequalities. It will
probably remain with us always. Complete liberty will very much lessen it; of
that I have no doubt."_ [**Why I am an Anarchist**, pp. 135-6] However, argue
social anarchists, the logic of market exchange produces a situation where the
stronger party to a contract seeks to maximise their advantage. Given this,
free exchange will tend to **increase** differences in wealth and income over
time, not eliminate them. As Daniel Guérin summarised:

> _"Competition and the so-called market economy inevitably produce inequality
and exploitation, and would do so even if one started from complete equality.
They could not be combined with workers' self-management unless it were on a
temporary basis, as a necessary evil, until (1) a psychology of 'honest
exchange' had developed among the workers; (2) most important, society as a
whole had passed from conditions of shortage to the stage of abundance, when
competition would lose its purpose . . . The libertarian communist would
condemn Proudhon's version of a collective economy as being based on a
principle of conflict; competitors would be in a position of equality at the
start, only to be hurled into a struggle which would inevitably produce
victors and vanquished, and where goods would end up by being exchanged
according to the principles of supply and demand."_ [**Op. Cit.**, pp. 53-4]

Thus, even a non-capitalist market could evolve towards inequality and away
from fair exchange. It was for this reason that Proudhon argued that a portion
of income from agricultural produce be paid into a central fund which would be
used to make equalisation payments to compensate farmers with less favourably
situated or less fertile land. As he put it, economic rent _"in agriculture
has no other cause than the inequality in the quality of land . . . if anyone
has a claim on account of this inequality . . . [it is] the other land workers
who hold inferior land. That is why in our scheme for liquidation [of
capitalism] we stipulated that every variety of cultivation should pay a
proportional contribution, destined to accomplish a balancing of returns among
farm workers and an assurance of products."_ [**Op. Cit.**, p. 582] His
advocacy of federations of workers' associations was, likewise, seen as a
means of abolishing inequalities.

Unlike Proudhon, however, individualist anarchists did not propose any scheme
to equalise income. Perhaps Tucker was correct and the differences would be
slight, but in a market situation exchanges tend to magnify differences,
**not** reduce them as the actions of self-interested individuals in unequal
positions will tend to exacerbate differences. Over time these slight
differences would become larger and larger, subjecting the weaker party to
relatively increasingly worse contracts. Without equality, individualist
anarchism would quickly become hierarchical and non-anarchist. As the
communist-anarchist paper **Freedom** argued in the 1880s:

> _"Are not the scandalous inequalities in the distribution of wealth today
merely the culminate effect of the principle that every man is justified in
securing to himself everything that his chances and capacities enable him to
lay hands on? _

> _"If the social revolution which we are living means anything, it means the
destruction of this detestable economic principle, which delivers over the
more social members of the community to the domination of the most unsocial
and self-interested."_ [**Freedom**, vol. 2, no. 19]

**Freedom**, it should be noted, is slightly misrepresenting the position of individualist anarchists. They did **not** argue that every person could appropriate all the property he or she could. Most obviously, in terms of land they were consistently opposed to a person owning more of it than they actually used. They also tended to apply this to what was on the land as well, arguing that any buildings on it were abandoned when the owner no longer used them. Given this, individualist anarchists have stressed that such a system would be unlikely to produce the inequalities associated with capitalism (as Kropotkin noted, equality was essential and was implicitly acknowledged by individualists themselves who argued that their system _"would offer no danger, because the rights of each individual would have been limited by the equal rights of all others."_ [**Evolution and Environment**, p. 85]). Thus contemporary individualist anarchist Joe Peacott:

> _"Although individualists envision a society based on private property, we
oppose the economic relationships of capitalism, whose supporters misuse words
like private enterprise and free markets to justify a system of monopoly
ownership in land and the means of production which allows some to skim off
part or even most of the wealth produced by the labour of others. Such a
system exists only because it is protected by the armed power of government,
which secures title to unjustly acquired and held land, monopolises the supply
of credit and money, and criminalises attempts by workers to take full
ownership of the means of production they use to create wealth. This state
intervention in economic transactions makes it impossible for most workers to
become truly independent of the predation of capitalists, banks, and
landlords. Individualists argue that without the state to enforce the rules of
the capitalist economy, workers would not allow themselves to be exploited by
these thieves and capitalism would not be able to exist . . . _

> _"One of the criticisms of individualist economic proposals raised by other
anarchists is that a system based on private ownership would result in some
level of difference among people in regard to the quality or quantity of
possessions they have. In a society where people are able to realise the full
value of their labour, one who works harder or better than another will
possess or have the ability to acquire more things than someone who works less
or is less skilled at a particular occupation . . . _

> _"The differences in wealth that arise in an individualist community would
likely be relatively small. Without the ability to profit from the labour of
others, generate interest from providing credit, or extort rent from letting
out land or property, individuals would not be capable of generating the huge
quantities of assets that people can in a capitalist system. Furthermore, the
anarchist with more things does not have them at the expense of another, since
they are the result of the owner's own effort. If someone with less wealth
wishes to have more, they can work more, harder, or better. There is no
injustice in one person working 12 hours a day and six days a week in order to
buy a boat, while another chooses to work three eight hour days a week and is
content with a less extravagant lifestyle. If one can generate income only by
hard work, there is an upper limit to the number and kind of things one can
buy and own."_ [**Individualism and Inequality**]

However, argue social anarchists, market forces may make such an ideal
impossible to achieve or maintain. Most would agree with Peter Marshall's
point that _"[u]ndoubtedly real difficulties exist with the economic position
of the individualists. If occupiers became owners overnight as Benjamin Tucker
recommended, it would mean in practice that those with good land or houses
would merely become better off than those with bad. Tucker's advocacy of
'competition everywhere and always' among occupying owners, subject to the
only moral law of minding your own business might will encourage individual
greed rather than fair play for all."_ [**Demanding the Impossible**, p. 653]

Few social anarchists are convinced that all the problems associated with
markets and competition are purely the result of state intervention. They
argue that it is impossible to have most of the underlying pre-conditions of a
competitive economy without the logical consequences of them. It is fair to
say that individualist anarchists tend to ignore or downplay the negative
effects of markets while stressing their positive ones.

While we discuss the limitations of markets in [section
I.1.3](secI1.html#seci13), suffice to say here that competition results in
economic forces developing which those within the market have to adjust to. In
other words, the market may be free but those within it are not. To survive on
the market, firms would seek to reduce costs and so implement a host of
dehumanising working practices in order to compete successfully on the market,
things which they would resist if bosses did it. Work hours could get longer
and longer, for example, in order to secure and maintain market position.
This, in turn, affects our quality of life and our relationship with our
partners, children, parents, friends, neighbours and so on. That the profits
do not go to the executives and owners of businesses may be a benefit, it
matters little if people are working longer and harder in order to invest in
machinery to ensure market survival. Hence **survival,** not **living,** would
be the norm within such a society, just as it is, unfortunately, in
capitalism.

Ultimately, Individualist Anarchists lose sight of the fact that success and
competition are not the same thing. One can set and reach goals without
competing. That we may loose more by competing than by co-operating is an
insight which social anarchists base their ideas on. In the end, a person can
become a success in terms of business but lose sight of their humanity and
individuality in the process. In contrast, social anarchists stress community
and co-operation in order to develop us as fully rounded individuals. As
Kropotkin put it, _"the **individualisation** they so highly praise is not
attainable by individual efforts."_ [**Anarchism**, p. 297]

As we noted in [section D.1](secD1.html), the capitalist state intervenes into
the economy and society to counteract the negative impact of market forces on
social life and the environment as well as, of course, protecting and
enhancing the position of itself and the capitalist class. As individualist
anarchism is based on markets (to some degree), it seems likely that market
forces would have similar negative impacts (albeit to a lesser degree due to
the reduced levels of inequality implied by the elimination of non-labour
incomes). Without communal institutions, social anarchists argue,
individualist anarchism has no means of counteracting the impact of such
forces except, perhaps, by means of continual court cases and juries. Thus
social issues would not be discussed by all affected but rather by small sub-
groups retroactively addressing individual cases.

Moreover, while state action may have given the modern capitalist an initial
advantage on the market, it does not follow that a truly free market will not
create similar advantages naturally over time. And if it did, then surely a
similar system would develop? As such, it does not follow that a non-
capitalist market system would remain such. In other words, it is true that
extensive state intervention was required to **create** capitalism but after a
time economic forces can usually be relied upon to allow wage workers to be
exploited. The key factor is that while markets have existed long before
capitalism, that system has placed them at the centre of economic activity. In
the past, artisans and farmers produced for local consumers, with the former
taking their surplus to markets. In contrast, capitalism has produced a system
where producers are primarily geared to exchanging **all** goods they create
on an extensive market rather simply a surplus locally. This implies that the
dynamics of a predominantly market system may be different from those in the
past in which the market played a much smaller role and where self-sufficiency
was always a possibility. It is difficult to see how, for example, car workers
or IT programmers could produce for their own consumption using their own
tools.

So in a market economy with a well-developed division of labour it is possible
for a separation of workers from their means of production to occur. This is
particularly the case when the predominant economic activity is not farming.
Thus the net effect of market transactions could be to re-introduce class
society simply by their negative long-term consequences. That such a system
developed without state aid would make it no less unfree and unjust. It is of
little use to point out that such a situation is **not** what the
Individualist Anarchists desired for it is a question of whether their ideas
would actually result in what they wanted. Social anarchists have fears that
they will not. Significantly, as we noted in [section G.3](secG3.html), Tucker
was sensible enough to argue that those subject to such developments should
rebel against them.

In response, individualist anarchists could argue that the alternative to
markets would be authoritarian (i.e., some form of central planning) and/or
inefficient as without markets to reward effort most people would not bother
to work well and provide for the consumer. So while markets do have problems
with them, the alternatives are worse. Moreover, when social anarchists note
that there is a remarkable correlation between competitiveness in a society
and the presence of clearly defined "have" and "have-not" groups individualist
anarchists would answer that the causation flows not from competitiveness to
inequality but from inequality to competitiveness. In a more equal society
people would be less inclined to compete as ruthlessly as under capitalism and
so the market would not generate as many problems as it does today. Moreover,
eliminating the artificial barriers erected by the state would allow a
universal competition to develop rather than the one sided form associated
with capitalism. With a balance of market power, competition would no longer
take the form it currently does.

Yet, as noted above, this position ignores natural barriers to competition The
accumulation needs of a competitive market economy do not disappear just
because capitalism has been replaced by co-operatives and mutual credit banks.
In any market economy, firms will try to improve their market position by
investing in new machinery, reducing prices by improving productivity and so
on. This creates barriers to new competitors who have to expend more money in
order to match the advantages of existing firms. Such amounts of money may not
be forthcoming from even the biggest mutual bank and so certain firms would
enjoy a privileged position on the market. Given that Tucker defined a
monopolist as _"any person, corporation, or institution whose right to engage
in any given pursuit of life is secured, either wholly or partially, by any
agency whatsoever -- whether the nature of things or the force of events or
the decree of arbitrary power -- against the influence of competition"_ we may
suggest that due to **natural** barriers, an individualist anarchist society
would not be free of monopolists and so of usury. [quoted by James J. Martin,
**Men Against the State**, p. 210]

For this reason, even in a mutualist market certain companies would receive a
bigger slice of profits than (and at the expense of) others. This means that
exploitation would still exist as larger companies could charge more than cost
for their products. It could be argued that the ethos of an anarchist society
would prevent such developments happening but, as Kropotkin noted, this has
problems, firstly because of _"the difficulty of estimating the **market**
value"_ of a product based on _"average time"_ or cost necessary to produce it
and, secondly, if that could be done then to get people _"to agree upon such
an estimation of their work would already require a deep penetration of the
Communist principles into their ideas."_ [**Environment and Evolution**, p.
84] In addition, the free market in banking would also result in **its**
market being dominated by a few big banks, with similar results. As such, it
is all fine and well to argue that with rising interest rates more competitors
would be drawn into the market and so the increased competition would
automatically reduce them but that is only possible if there are no serious
natural barriers to entry.

This obviously impacts on how we get from capitalism to anarchism. Natural
barriers to competition limit the ability to compete exploitation away. So as
to its means of activism, individualist anarchism exaggerates the potential of
mutual banks to fund co-operatives. While the creation of community-owned and
-managed mutual credit banks would help in the struggle for a free society,
such banks are not enough in themselves. Unless created as part of the social
struggle against capitalism and the state, and unless combined with community
and strike assemblies, mutual banks would quickly die, because the necessary
social support required to nurture them would not exist. Mutual banks must be
part of a network of other new socio-economic and political structures and
cannot be sustained in isolation from them. This is simply to repeat our
earlier point that, for most social anarchists, capitalism cannot be reformed
away. As such, social anarchists would tend to agree with the summary provided
by this historian:

> _"If [individualist anarchists] rejected private ownership of property, they
destroyed their individualism and 'levelled' mankind. If they accepted it,
they had the problem of offering a solution whereby the inequalities [of
wealth] would not amount to a tyranny over the individual. They meet the same
dilemma in 'method.' If they were consistent libertarian individualists they
could not force from 'those who had' what they had acquired justly or
unjustly, but if they did not force it from them, they perpetuated
inequalities. They met a stone wall."_ [Eunice Minette Schuster, **Native
American Anarchism**, p. 158]

So while Tucker believed in direct action, he opposed the "forceful"
expropriation of social capital by the working class, instead favouring the
creation of a mutualist banking system to replace capitalism with a non-
exploitative system. Tucker was therefore fundamentally a **reformist,**
thinking that anarchy would evolve from capitalism as mutual banks spread
across society, increasing the bargaining power of labour. And reforming
capitalism over time, by implication, always means tolerating boss's control
during that time. So, at its worst, this is a reformist position which becomes
little more than an excuse for tolerating landlord and capitalist domination.

Also we may note, in the slow transition towards anarchism, we would see the
rise of pro-capitalist "defence associations" which **would** collect rent
from land, break strikes, attempt to crush unions and so on. Tucker seemed to
have assumed that the anarchist vision of _"occupancy-and-use"_ would become
universal. Unfortunately, landlords and capitalists would resist it and so,
ultimately, an Individualist Anarchist society would have to either force the
minority to accept the majority wishes on land use (hence his comments on
there being _"no legal power to collect rent"_) or the majority are dictated
to by the minority who are in favour of collecting rent and hire "defence
associations" to enforce those wishes. With the head start big business and
the wealthy have in terms of resources, conflicts between pro- and anti-
capitalist "defence associations" would usually work against the anti-
capitalist ones (as trade unions often find out). In other words, reforming
capitalism would not be as non-violent or as simple as Tucker maintained. The
vested powers which the state defends will find other means to protect
themselves when required (for example, when capitalists and landlords backed
fascism and fascist squads in Italy after workers "occupied and used" their
workplaces and land-workers and peasants "occupied and used" the land in
1920). We are sure that economists will then rush to argue that the resulting
law system that defended the collection of rent and capitalist property
against "occupancy and use" was the most "economically efficient" result for
"society."

In addition, even if individualist mutualism **did** result in an increase in
wages by developing artisan and co-operative ventures that decreased the
supply of labour in relation to its demand, this would not eliminate the
subjective and objective pressures on profits that produce the business cycle
within capitalism (see [section C.7](secC7.html)). In fact, it would increase
the subjective pressures considerably as was the case under the social
Keynesianism of the post-war period. Unsurprisingly, business interests sought
the necessary "reforms" and ruthlessly fought the subsequent strikes and
protests to achieve a labour market more to their liking (see [section
C.8.2](secC8.html#secc82) for more on this). This means that an increase in
the bargaining power of labour would soon see capital moving to non-anarchist
areas and so deepening any recession caused by a lowering of profits and other
non-labour income. This could mean that during an economic slump, when
workers' savings and bargaining position were weak, the gains associated with
mutualism could be lost as co-operative firms go bust and mutual banks find it
hard to survive in a hostile environment.

Mutual banks would not, therefore, undermine modern capitalism, as recognised
by social anarchists from Bakunin onward. They placed their hopes in a social
revolution organised by workplace and community organisations, arguing that
the ruling class would be as unlikely to tolerate being competed away as they
would be voted away. The collapse of social Keynesianism into neo-liberalism
shows that even a moderately reformed capitalism which increased working class
power will not be tolerated for too long. In other words, there was a need for
social revolution which mutual banks do not, and could not, eliminate.

However, while social anarchists disagree with the proposals of individualist
anarchists, we do still consider them to be a form of anarchism -- one with
many flaws and one perhaps more suited to an earlier age when capitalism was
less developed and its impact upon society far less than it is now (see
[section G.1.4](secG1.html#secg14)). Individualist and social anarchism could
co-exist happily in a free society and neither believes in forcing the other
to subscribe to their system. As Paul Nursey-Bray notes _"linking all of these
approaches . . . is not just the belief in individual liberty and its
corollary, the opposition to central or state authority, but also a belief in
community, and an equality of community members."_ The _"discussion over forms
of property . . . should not be allowed to obscure the commonality of the idea
of the free community of self-regulating individuals."_ And so _"there are
meeting points in the crucial ideas of individual autonomy and community that
suggest, at least, a basis for the discussion of equality and property
relations."_ [**Anarchist Thinkers and Thought**, p. xvi]

## G.4.1 Is wage labour consistent with anarchist principles?

No, it is not. This can be seen from social anarchism, where opposition to
wage labour as hierarchical and exploitative is taken as an obvious and
logical aspect of anarchist principles. However, ironically, this conclusion
must also be drawn from the principles expounded by individualist anarchism.
However, as noted in [section G.1.3](secG1.html#secg13), while many
individualist anarchists opposed wage labour and sought its end not all did.
Benjamin Tucker was one of the latter. To requote him:

> _"Wages is not slavery. Wages is a form of voluntary exchange, and voluntary
exchange is a form of Liberty."_ [**Liberty**, no. 3, p. 1]

The question of wage labour was one of the key differences between Tucker and
communist-anarchist Johann Most. For Most, it signified that Tucker supported
the exploitation of labour. For Tucker, Most's opposition to it signified that
he was not a real anarchist, seeking to end freedom by imposing communism onto
all. In response to Most highlighting the fact that Tucker supported wage
labour, Tucker argued as followed:

> _"If the men who oppose wages -- that is, the purchase and sale of labour --
were capable of analysing their thought and feelings, they would see that what
really excites their anger is not the fact that labour is bought and sold, but
the fact that one class of men are dependent for their living upon the sale of
their labour, while another class of men are relieved of the necessity of
labour by being legally privileged to sell something that is not labour, and
that, but for the privilege, would be enjoyed by all gratuitously. And to such
a state of things I am as much opposed as any one. But the minute you remove
privilege, the class that now enjoy it will be forced to sell their labour,
and then, when there will be nothing but labour with which to buy labour, the
distinction between wage-payers and wage-receivers will be wiped out, and
every man will be a labourer exchanging with fellow-labourers. Not to abolish
wages, but to make every man dependent upon wages and secure to every man his
whole wages is the aim of Anarchistic Socialism. What Anarchistic Socialism
aims to abolish is usury. It does not want to deprive labour of its reward; it
wants to deprive capital of its reward. It does not hold that labour should
not be sold; it holds that capital should not be hired at usury."_
[**Liberty**, no. 123, p. 4]

Social anarchists, in reply, would argue that Tucker is missing the point. The
reason why almost all anarchists are against wage labour is because it
generates social relationships based on authority and, as such, it sets the
necessary conditions for the exploitation of labour to occur. If we take the
creation of employer-employee relationships within an anarchy, we see the
danger of private statism arising (as in "anarcho"-capitalism) and so the end
of anarchy. Such a development can be seen when Tucker argued that if, in an
anarchy, _"any labourers shall interfere with the rights of their employers,
or shall use force upon inoffensive 'scabs,' or shall attack their employers'
watchmen . . . I pledge myself that, as an Anarchist and in consequence of my
Anarchistic faith, I will be among the first to volunteer as a member of a
force to repress these disturbers of order, and, if necessary, sweep them from
the earth."_ [**Op. Cit.**, p. 455] Tucker's comments were provoked by the
Homestead strike of 1892, where the striking steelworkers fought with, and
defeated, their employer's Pinkerton thugs sent to break the strike (Tucker,
it should be stressed supported the strikers but not their methods and
considered the capitalist class as responsible for the strike by denying
workers a free market).

In such a situation, these defence associations would be indeed "private
states" and here Tucker's ideas unfortunately do parallel those of the
"anarcho"-capitalists (although, as Tucker thought that the employees would
not be exploited by the employer, this does not suggest that Tucker can be
considered a forefather of "anarcho"-capitalism). As Kropotkin warned, _"[f]or
their self-defence, both the citizen and group have a right to any violence
[within individualist anarchy] . . . Violence is also justified for enforcing
the duty of keeping an agreement. Tucker . . . opens . . . the way for
reconstructing under the heading of the 'defence' all the functions of the
State."_ [**Anarchism**, p. 297]

Such an outcome is easy to avoid, however, by simply consistently applying
individualist anarchist principles and analysis to wage labour. To see why, it
is necessary simply to compare private property with Tucker's definition of
the state.

How did Tucker define the state? All states have two common elements,
_"aggression"_ and _"the assumption of sole authority over a given area and
all within it, exercised generally for the double purpose of more complete
oppression of its subjects and extension of its boundaries."_ This monopoly of
authority is important, as _"I am not aware that any State has ever tolerated
a rival State within its borders."_ So the state, Tucker stated, is _"the
embodiment of the principle of invasion in an individual, or a band of
individuals, assuming to act as representatives or masters of the entire
people within a given area."_ The _"essence of government is control, or the
attempt to control. He who attempts to control another is a governor, an
aggressor, an invader . . . he who resists another's attempt to control is not
an aggressor, an invader, a governor, but simply a defender, a protector."_ In
short, _"the Anarchistic definition of government: the subjection of the non-
invasive individual to an external will."_ [**The Individualist Anarchists**,
p. 24]

The similarities with capitalist property (i.e., one based on wage labour) is
obvious. The employer assumes and exercises _"sole authority over a given area
and all within it,"_ they are the boss after all and so capitalists are the
_"masters of the entire people within a given area."_ That authority is used
to control the employees in order to maximise the difference between what they
produce and what they get paid (i.e., to ensure exploitation). As August
Spies, one of the Haymarket Martyrs, noted:

> _"I was amazed and was shocked when I became acquainted with the condition
of the wage-workers in the New World. _

> _"The factory: the ignominious regulations, the surveillance, the spy
system, the servility and lack of manhood among the workers and the arrogant
arbitrary behaviour of the boss and his associates -- all this made an
impression upon me that I have never been able to divest myself of. At first I
could not understand why the workers, among them many old men with bent backs,
silently and without a sign of protest bore every insult the caprice of the
foreman or boss would heap upon them. I was not then aware of the fact that
the opportunity to work was a privilege, a favour, and that it was in the
power of those who were in the possession of the factories and instruments of
labour to deny or grant this privilege. I did not then understand how
difficult it was to find a purchaser for ones labour, I did not know then that
there were thousands and thousands of idle human bodies in the market, ready
to hire out upon most any conditions, actually begging for employment. I
became conscious of this, very soon, however, and I knew then why these people
were so servile, whey suffered the humiliating dictates and capricious whims
of their employers."_ [**The Autobiographies of the Haymarket Martyrs**, pp.
66-7]

That this is a kind of state-like authority becomes clear when we consider
company towns. As Ward Churchill notes, the _"extent of company power over
workers included outright ownership of the towns in which they lived, a matter
enabling employers to garner additional profits by imposing exorbitant rates
of rent, prices for subsistence commodities, tools, and such health care as
was available. Conditions in these 'company towns' were such that, by 1915,
the Commission on Industrial Relations was led to observe that they displayed
'every aspect of feudalism except the recognition of special duties on the
part of the employer.' The job of the Pinkertons -- first for the railroads,
then more generally -- was to prevent workers from organising in a manner that
might enable them to improve their own circumstances, thus reducing corporate
profits."_ [_"From the Pinkertons to the PATRIOT Act: The Trajectory of
Political Policing in the United States, 1870 to the Present"_, pp. 1-72,
**CR: The New Centennial Review**, vol. 4, No. 1, pp. 11-2] In the words of
one historian of the Pinkerton Agency _"[b]y the mid-1850s a few businessmen
saw the need for greater control over their employees; their solution was to
sponsor a private detective system. In February 1855, Allan Pinkerton, after
consulting with six midwestern railroads, created such an agency in Chicago."_
[Frank Morn, quoted by Churchill, **Op. Cit.**, p. 4] As we have noted in
[section F.7.1](secF7.html#secf671), such regimes remained into the 1930s,
with corporations having their own well armed private police to enforce the
propertarian hierarchy (see also [section F.6.2](secF6.html#secf62)).

So, in terms of monopoly of authority over a given area the capitalist company
and the state share a common feature. The reason why wage labour violates
Individualist Anarchist principles is clear. If the workers who use a
workplace do not own it, then someone else will (i.e. the owner, the boss).
This in turn means that the owner can tell those who use the resource what to
do, how to do it and when. That is, they are the sole authority over the
workplace and those who use it. However, according to Tucker, the state can be
defined (in part) as _"the assumption of sole authority over a given area and
all within it."_ Tucker considered this element as _"common to all States"_
and so opposition to the state logically implies support for workers' self-
management for only in this case can people govern themselves during the
working day (see [section B.4](secB4.html) for more discussion). Even with
Tucker's other aspect, _"aggression"_, there are issues. Competition is
inherently aggressive, with companies seeking to expand their market share, go
into new markets, drive their competitors out of business, and so forth.
Within the firm itself, bosses always seek to make workers do more work for
less, threatening them with the sack if they object.

Tucker's comments on strikers brings to light an interesting contradiction in
his ideas. After all, he favoured a system of "property" generally defined by
use and occupancy, that is whoever uses and possesses is to be consider the
owner. As we indicated in [section G.1.2](secG1.html#secg12), this applied to
both the land and what was on it. In particular, Tucker pointed to the example
of housing and argued that rent would not be collected from tenants nor would
they be evicted for not paying it. Why should this position change when it is
a workplace rather than a house? Both are products of labour, so that cannot
be the criteria. Nor can it be because one is used for work as Tucker
explicitly includes the possibility that a house could be used as a workplace.

Thus we have a massive contradiction between Tucker's "occupancy and use"
perspective on land use and his support for wage labour. One letter to
**Liberty** (by "Egoist") pointed out this contradiction: _"if production is
carried on in groups, as it now is, who is the legal occupier of the land? The
employer, the manager, or the ensemble of those engaged in the co-operative
work? The latter appearing the only rational answer."_ [**Op. Cit.**, no. 143,
p. 4] Sadly, Tucker's reply did not address this particular question and so we
are left with an unresolved contradiction.

Looking at the Homestead strike which provoked Tucker's rant against strikers,
the similarities between wage labour and statism become even clearer. The
3,800 workers locked out by Carnegie at Homestead in 1892 definitely occupied
and used the works from which they were barred entry by the owners. The
owners, obviously, did not use the workplace themselves -- they hired
**others** to occupy and use it **for** them. Now, why should _"occupancy and
use"_ be acceptable for land and housing but not for workplaces? There is no
reason and so wage labour, logically, violates _"occupancy and use"_ \-- for
under wage labour, those who occupy and use a workplace do not own or control
it. Hence _"occupancy and use"_ logically implies workers' control and
ownership.

The Homestead lockout of 1892, ironically enough, occurred when the owners of
the steel mill provoked the union in order to break its influence in the
works. In other words, the property owners practised _"aggression"_ to ensure
their _"sole authority over a given area and all within it"_ (to use Tucker's
words). As such, the actions of the capitalist property owners meets Tucker's
definition of the state exactly. According to the Carnegie Steel Company, it
had _"a legal right to the enjoyment of our property, and to operate it as we
please . . . But for years our works have been managed . . . by men who do not
own a dollar in them. This will stop right here. The Carnegie Steel Company
will hereafter control their works in the employment of labour."_ Secretary
Lovejoy of the corporation was clear on this, and its wider impact, arguing
that _"[t]his outbreak will settle one matter forever, and that is that the
Homestead mill hereafter will be run non-union . . . other mills heretofore
union [will] become non-union and thus free their owners from the arbitrary
dictation of labour unions."_ [quoted by Peter Krause, **The Battle for
Homestead 1880-1892**, p. 12 and pp. 39-40]

In other words, the workers will henceforth be submit to the arbitrary
dictation of the owners, who would be free to exercise their authority without
hindrance of those subject to it. Unsurprisingly, for the workers, the strike
was over their freedom and independence, of their ability to control their own
labour. As one historian notes, the _"lockout crushed the largest trade union
in America . . . the victory at Homestead gave Carnegie and his fellow
steelmasters carte blanche in the administration of their works. The lockout
put 'the employers in the saddle' -- precisely where they would remain,
without union interference, for four decades."_ The Pinkerton agents _"were
preparing to enforce the authority putatively designated to them by Henry Clay
Frick"_ (although Frick _"had been counting on the ultimate authority of the
state from the outset."_). [Peter Krause, **Op. Cit.**, p. 13, p. 14 and p.
25]

Nor was the 1892 lockout an isolated event. There had been a long history of
labour disputes at Homestead. In 1882, for example, a strike occurred over the
_"question of complete and absolute submission on the part of manufacturers to
the demands of their men,"_ in the words of one ironmaster. [quoted by Krause,
**Op. Cit.**, p. 178] It was a question of power, whether bosses would have
sole and total authority over a given area and all within it. The workers won
that strike, considering it _"a fight for freedom."_ As such, the 1892 lockout
was the end result of years of management attempts to break the union and so
_"in creating and fortifying the system that had, over the years, produced the
conditions for this violence, Carnegie's role cannot be denied. What provoked
the apparently 'barbaric' and 'thankless' workers of Homestead was not, as an
account limited to that day might indicate, the sudden intrusion of Pinkerton
agents into their dispute but the slow and steady erosion of their rights and
their power, over which Carnegie and his associates in steel and politics had
presided for years, invisibly but no less violently."_ [Krause, **Op. Cit.**,
p. 181 and p. 43]

The conflict at Homestead was thus directly related to the issue of ensuring
that the _"sole authority over a given area and all within it"_ rested in the
hands of the capitalists. This required smashing the union for, as Tucker
noted, no state _"has ever tolerated a rival State within its borders."_ The
union was a democratic organisation, whose _"basic organisation . . . was the
lodge, which elected its own president and also appointed a mill committee to
enforce union rules within a given department of the steelworks. The union
maintained a joint committee of the entire works."_ Elected union officials
who _"act[ed] without the committee's authorisation"_ were _"replaced. Over
and above the Advisory Committee stood the mass meeting"_ which was _"often
open to all workers,"_ not just union members. This union democracy was the
key to the strike, as Carnegie and his associates _"were deeply troubled by
its effects in the workplace. So troubled, in fact, that beyond the issue of
wages or any issues related to it, it was unionism itself that was the primary
target of Carnegie's concern."_ [Krause, **Op. Cit.**, p. 293]

Instead of a relatively libertarian regime, in which those who did the work
managed it, the lockout resulted in the imposition of a totalitarian regime
for the _"purpose of more complete oppression of its subjects"_ and by its
competitive advantage on the market, the _"extension of its boundaries"_ (to
use Tucker's description of the state). _"Without the encumbrance of the
union,"_ notes Krause, _"Carnegie was able to slash wages, impose twelve-hour
workdays, eliminate five hundred jobs, and suitably assuage his republican
conscience with the endowment of a library."_ And so _"the labour difficulties
that precipitated the Homestead Lockout had less to do with quantifiable
matter such as wages and wage scales than with the politics of the workers'
claim to a franchise within the mill -- that is, the legitimacy, authority,
and power of the union."_ [**Op. Cit.**, p. 361 and p. 294]

The contradictions in wage labour become clear when Secretary Lovejoy stated
that with the lockout the owners had declared that _"we have decided to run
our Homestead Mill ourselves."_ [quoted by Krause, **Op. Cit.**, p. 294]
Except, of course, they did no such thing. The workers who occupied and used
the steel mills still did the work, but without even the smallest say in their
labour. A clearer example of why wage labour violates the individualist
anarchist principle of "occupancy and use" would be harder to find. As labour
historian David Montgomery put it, the Homestead lockout was a _"crisp and
firm declaration that workers' control was illegal -- that the group
discipline in the workplace and community by which workers enforced their code
of mutualism in opposition to the authority and power of the mill owners was
tantamount to insurrection against the republic -- clearly illuminated the
ideological and political dimensions of workplace struggles."_ [**The Fall of
the House of Labour**, p. 39] This defeat of America's most powerful trade
union was achieved by means of a private police, supported by the State
militia.

Thus we have numerous contradictions in Tucker's position. On the one hand,
occupancy and use precludes landlords renting land and housing but includes
capitalists hiring workers to "occupancy and use" their land and workplaces;
the state is attacked for being a monopoly of power over a given area while
the boss can have the same authority; opposing voluntary wage labour shows
that you are an authoritarian, but opposing voluntary landlordism is
libertarian. Yet, there is no logical reason for workplaces to be excluded
from "occupancy and use." As Tucker put it:

> _"Occupancy and use is the only title to land in which we will protect you;
if you attempt to use land which another is occupying and using, we will
protect him against you; if another attempts to use land to which you lay
claim, but which you are not occupying and using, we will not interfere with
him; but of such land as you occupy and use you are the sole master, and we
will not ourselves take from you, or allow anyone else to take from you,
whatever you may get out of such land."_ [**Liberty**, no. 252, p. 3]

Needless to say, neither Carnegie nor Frick were occupying and using the
Homestead steel-mills nor were any of the other shareholders. It was precisely
the autocratic authority of the owners which their private army and the state
militia sought to impose on those who used, but did not own, the steel-mills
(as the commander of the state troops noted, others _"can hardly believe the
actual communism of these people. They believe the works are theirs quite as
much as Carnegie's."_ [quoted by Jeremy Brecher, **Strike!**, p. 60]). As we
discuss in the [next section](secG4.html#secg42), this is precisely why most
anarchists have opposed wage labour as being incompatible with general
anarchist principles. In other words, a consistent anarchism precludes all
forms of authoritarian social relationships.

There is another reason why wage labour is at odds with anarchist principles.
This is to do with our opposition to exploitation and usury. Simply put, there
are the problems in determining what are the "whole wages" of the employer and
the employee. The employer, of course, does not simply get his "share" of the
collectively produced output, they get the whole amount. This would mean that
the employer's "wages" are simply the difference between the cost of inputs
and the price the goods were sold on the market. This would imply that the
market wage of the labour has to be considered as equalling the workers'
_"whole wage"_ and any profits equalling the bosses _"whole wage"_ (some early
defences of profit did argue precisely this, although the rise of shareholding
made such arguments obviously false). The problem arises in that the
employer's income is not determined independently of their ownership of
capital and their monopoly of power in the workplace. This means that the boss
can appropriate for themselves all the advantages of co-operation and self-
activity within the workplace simply because they owned it. Thus, "profits" do
not reflect the labour ("wages") of the employer.

It was this aspect of ownership which made Proudhon such a firm supporter of
workers associations. As he put it, a _"hundred men, uniting or combining
their forces, produce, in certain cases, not a hundred times, but two hundred,
three hundred, a thousand times as much. This is what I have called
**collective force**. I even drew from this an argument . . . against certain
forms of appropriation: that it is not sufficient to pay merely the wages of a
given number of workers, in order to acquire their product legitimately; that
they must be paid twice, thrice or ten times their wages, or an equivalent
service rendered to each one of them."_ This analysis of exploitation
occurring **within** production meant that the workplace must be self-managed
for as _"all labour must leave a surplus, all wages [must] be equal to
product"_ and _"[b]y virtue of the prin­ciple of collective force, workers are
the equals and associates of their leaders."_ Thus, _"all workers must
associate, inasmuch as collective force and division of labour exist
everywhere, to however slight a degree"_ because of _"the immoral­ity, tyranny
and theft suffered."_ Industrial democracy, in which _"all positions are
elective, and the by-laws subject to the approval of the members_,_"_ would
ensure that _"the collective force, which is a product of the community,
ceases to be a source of profit to a small number of managers"_ and becomes
_"the property of all the workers."_ [**Property is Theft!,** p. 554, p. 77,
p. 584 and p. 586]

Proudhon had first expounded this analysis in **What is Property?** in 1840
and, as K. Steven Vincent notes, this was _"[o]one of the reasons Proudhon
gave for rejecting 'property' [and] was to become an important motif of
subsequent socialist thought."_ Thus _"collective endeavours produced an
additional value"_ which was _"unjustly appropriated by the
**proprietaire.**"_ [**Pierre-Joseph Proudhon the Rise of French Republican
Socialism** p. 64 and p. 65] Marx, it should be noted, concurred. Without
mentioning Proudhon, he stressed how a capitalist buys the labour-power of 100
men and _"can set the 100 men to work. He pays them the value of 100
independent labour-powers, but does not pay them for the combined labour power
of the 100."_ [**Capital**, Vol. 1, p. 451] Only co-operative workplaces can
ensure that the benefits of co-operative labour are not monopolised by the few
who happen to own, and so control, the means of production.

If this is not done, then it becomes a case of simply renaming "profits" to
"wages" and saying that they are the result of the employers work rather than
their ownership of capital. However, this is not the case as some part of the
"wages" of the employer is derived purely from their owning capital (and is
usury, charging to allow use) while, for the workers, it is unlikely to equal
their product in the short run. Given that the major rationale for the
Homestead strike of 1892 **was** to secure the despotism of the property
owner, the results of breaking the union should be obvious. According to David
Brody in his work **The Steel Workers**, after the union was broken _"the
steel workers output doubled in exchange for an income rise of one-fifth . . .
The accomplishment was possible only with a labour force powerless to oppose
the decisions of the steel men."_ [quoted by Jeremy Brecher, **Op. Cit.**, p.
62] At Homestead, between 1892 and 1907 the daily earnings of highly-skilled
plate-mill workers fell by a fifth while their hours increased from eight to
twelve. [Brecher, **Op. Cit.**, p. 63] Who would dare claim that the profits
this increased exploitation created somehow reflected the labour of the
managers rather than their total monopoly of authority within the workplace?

The logic is simple -- which boss would employ a worker unless they expected
to get more out of their labour than they pay in wages? And why does the
capitalist get this reward? They own "capital" and, consequently, their
"labour" partly involves excluding others from using it and ordering about
those whom they do allow in -- in exchange for keeping the product of their
labour. Thus exploitation takes place within production and so a contract for
wages made beforehand simply cannot be expected to anticipate the use-value
extracted by the boss from the workers subjected to his authority. Thus wage
labour and exploitation would go hand-in-hand -- and so Most's horror at
Tucker's support for it.

As best, it could be argued that such "wages" would be minimal as workers
would be able to swap jobs to get higher wages and, possibly, set up co-
operatives in competition. However, this amounts to saying that, in the long
run, labour gets its full product and to say that is to admit in the short
term that labour **is** exploited. Yet nowhere did Tucker argue that labour
would get its full product **eventually** in a free society, rather he
stressed that liberty would result in the end of exploitation. Nor should we
be blind to the fact that a market economy is a dynamic one, making the long
run unlikely to ever appear (_"in the long run we are all dead"_ as Keynes
memorably put it). Combine this with the natural barriers to competition we
indicated in [section G.4](secG4.html) and we are left with problems of
usury/exploitation in an individualist anarchist system.

The obvious solution to these problems is to be found in Proudhon, namely the
use of co-operatives for any workplace which cannot be operated by an
individual. This was the also the position of the Haymarket anarchists, with
August Spies (for example) arguing that _"large factories and mines, and the
machinery of exchange and transportation . . . have become too vast for
private control. Individuals can no longer monopolise them."_ [contained in
Albert Parsons, **Anarchism: Its Philosophy and Scientific Basis**, pp. 60-1]
Proudhon denounced property as _"despotism"_, for Albert Parsons the _"wage
system of labour is a despotism."_ [**Op. Cit.**, p. 21]

As Frank H. Brooks notes, _"producer and consumer co-operatives were a staple
of American labour reform (and of Proudhonian anarchism)."_ This was because
they _"promised the full reward of labour to the producer, and commodities at
cost to the consumer."_ [**The Individualist Anarchists**, p. 110] This was
the position of Voltairine de Cleyre (during her individualist phase) as well
as her mentor Dyer Lum:

> _"Lum drew from the French anarchist Proudhon . . . a radical critique of
classical political economy and . . . a set of positive reforms in land tenure
and banking . . . Proudhon paralleled the native labour reform tradition in
several ways. Besides suggesting reforms in land and money, Proudhon urged
producer co-operation."_ [Frank H. Brooks, _"Ideology, Strategy, and
Organization: Dyer Lum and the American Anarchist Movement"_, pp. 57-83,
**Labor History**, Vol. 34, No. 1, p. 72]

So, somewhat ironically given his love of Proudhon, it was, in fact, Most who
was closer to the French anarchist's position on this issue than Tucker.
Kropotkin echoed Proudhon's analysis when he noted that _"the only guarantee
not to be robbed of the fruits of your labour is to possess the instruments of
labour."_ [**The Conquest of Bread**, p. 145] In other words, for a self-
proclaimed follower of Proudhon, Tucker ignored the French anarchist's
libertarian arguments against wage labour. The key difference between the
communist-anarchists and Proudhon was on the desirability of making the
product of labour communal or not (although both recognised the right of
people to share as they desired). However, it must be stressed that Proudhon's
analysis was not an alien one to the individualist anarchist tradition. Joshua
King Ingalls, for example, presented a similar analysis to Proudhon on the
issue of joint production as well as its solution in the form of co-operatives
(see [section G.1.3](secG1.html#secg13) for details) and Dyer Lum was a firm
advocator of the abolition of wage labour. So integrating the insights of
social anarchism on this issue with individualist anarchism would not be
difficult and would build upon existing tendencies within it.

In summary, social anarchists argue that individualist anarchism does not
solve the social question. If it did, then they would be individualists. They
argue that in spite of Tucker's claims, workers would still be exploited in
any form of individualist anarchism which retained significant amounts of wage
labour as well as being a predominantly hierarchical, rather than libertarian,
society. As we argue in the [next section](secG4.html#secg42), this is why
most anarchists consider individualist anarchism as being an inconsistent form
of anarchism.

## G.4.2 Why do social anarchists think individualism is inconsistent
anarchism?

From our discussion of wage labour in the [last section](secG4.html#secg41),
some may consider that Tucker's support for wage labour would place him
outside the ranks of anarchism. After all, this is one of the key reasons why
most anarchists reject "anarcho"-capitalism as a form of anarchism. Surely, it
could be argued, if Murray Rothbard is not an anarchist, then why is Tucker?

That is not the case and the reason is obvious -- Tucker's support for wage
labour is inconsistent with his ideas on "occupancy and use" while Rothbard's
are in line with his capitalist property rights. Given the key place self-
management holds in almost all anarchist thought, unsurprisingly we find
Chomsky summarising the anarchist position as follows:

> _"A consistent anarchist must oppose private ownership of the means of
production and the wage slavery which is a component of this system, as
incompatible with the principle that labour must be freely undertaken and
under the control of the producer . . . A consistent anarchist must oppose not
only alienated labour but also the stupefying specialisation of labour that
takes place when the means for developing production."_ [**Chomsky on
Anarchism**, p. 123]

Thus the _"consistent anarchist, then, will be a socialist, but a socialist of
a particular sort."_ [**Op. Cit.**, p. 125] Which suggests that Tucker's
position is one of inconsistent anarchism. While a socialist, he did not take
his libertarian positions to their logical conclusions -- the abolition of
wage labour. There is, of course, a certain irony in this. In response to
Johann Most calling his ideas _"Manchesterism"_, Tucker wrote _"what better
can a man who professes Anarchism want than that? For the principle of
Manchesterism is liberty, and consistent Manchesterism is consistent adherence
to liberty. The only inconsistency of the Manchester men lies in their
infidelity to liberty in some of its phases. And this infidelity to liberty in
some of its phases is precisely the fatal inconsistency of the 'Freiheit'
school . . . Yes, genuine Anarchism is consistent Manchesterism, and
Communistic or pseudo-Anarchism is inconsistent Manchesterism."_ [**Liberty**,
no. 123, p. 4]

In other words, if individualist anarchism is, as Tucker claimed, _"consistent
Manchesterism"_ then, argue social anarchists, individualist anarchism is
"inconsistent" anarchism. This means that some of Tucker's arguments
contradict some of his own fundamental principles, most obviously his
indifference to wage labour. This, as argued, violates "occupancy and use",
his opposition to exploitation and his anarchism as it is a form of hierarchy.

To see what we mean we must point out that certain individualist anarchists
are not the only "inconsistent" ones that have existed. The most obvious
example is Proudhon, whose sexism is well known, utterly disgraceful and is in
direct contradiction to his other ideas and principles. While Proudhon
attacked hierarchy in politics and economics, he fully supported patriarchy in
the home. This support for a form of archy does not refute claims that
Proudhon was an anarchist, it just means that certain of his ideas were
inconsistent with his key principles. As one French anarcha-feminist critic of
Proudhon put it in 1869: _"These so-called lovers of liberty, if they are
unable to take part in the direction of the state, at least they will be able
to have a little monarchy for their personal use, each in his own home . . .
Order in the family without hierarchy seems impossible to them -- well then,
what about in the state?"_ [André Léo, quoted by Carolyn J. Eichner, _"'Vive
La Commune!' Feminism, Socialism, and Revolutionary Revival in the Aftermath
of the 1871 Paris Commune,"_, pp. 68-98, **Journal of Women's History**, Vol.
15, No.2, p. 75] Rejecting monarchy and hierarchy on the state level and
within the workplace while supporting it -- in the form of rule by the father
-- on the family level was simply illogical and inconsistent. Subsequent
anarchists (from Bakunin onwards) solved this obvious contradiction by
consistently applying anarchist principles and opposing sexism and patriarchy.
In other words, by critiquing Proudhon's sexism by means of the very
principles he himself used to critique the state and capitalism.

Much the same applies to individualist anarchists. The key issue is that,
given their own principles, individualist anarchism can easily become
**consistent** anarchism. That is why it is a school of anarchism, unlike
"anarcho"-capitalism. All that is required is to consistently apply "occupancy
and use" to workplaces (as Proudhon advocated). By consistently applying this
principle they can finally end exploitation along with hierarchy, so bringing
all their ideas into line.

Tucker's position is also in direct opposition to Proudhon's arguments, which
is somewhat ironic since Tucker stressed being inspired by and following the
French anarchist and his ideas (Tucker referred to Proudhon as being both
_"the father of the Anarchistic school of socialism"_ as well as _"being the
Anarchist **par excellence**"_ [Tucker, **Instead of a Book**, p. 391]).
Tucker is distinctly at odds with Proudhon who consistently opposed wage-
labour and so, presumably, was also an advocate of _"pseudo-Anarchism"_
alongside Kropotkin and Most.

For Proudhon, the worker has _"sold and surrendered his liberty"_ to the
proprietor, with the proprietor being _"a man, who, having absolute control of
an instrument of production, claims the right to enjoy the product of the
instrument without using it himself."_ This leads to exploitation and if _"the
labourer is proprietor of the value which he creates, it follows"_ that _"all
production being necessarily collective, the labourer is entitled to a share
of the products and profits commensurate with his labour"_ and that, _"all
accumulated capital being social property, no one can be its exclusive
proprietor."_ With _"machinery and the workshop, divine right -- that is, the
principle of authority -- makes its entrance into political economy. Capital .
. . Property . . . are, in economic language, the various names of . . .
Power, Authority."_ Thus, under capitalism, the workplace has a _"hierarchical
organisation."_ There are three alternatives, capitalism (_"that is, monopoly
and what follows"_), state socialism (_"exploitation by the State"_) _"or else
. . . a solution based on equality, -- in other words, the organisation of
labour, which involves the negation of political economy and the end of
property."_ In short, _"all property becomes . . . collective and undivided."_
[**Property is Theft!**, p. 21, p. 139, p. 114, pp. 117-8, p. 193,  p. 202 and
p. 137] Indeed, in 1849 he angrily rejected the assertion that he wanted
_"individual ownership and non-organisation of the instruments of labour"_:

> _"I have never penned nor uttered any such thing: and have argued the
opposite a hundred times over . . . I deny all kinds of proprietary domain. I
deny it, precisely because I believe in an order wherein the instruments of
labour will cease to be appropriated and instead become shared."_ [**Op.
Cit.**, p. 499]

So _"under universal association, ownership of the land and of the
instru­ments of labour is **social** ownership."_ This was because wage-
workers were _"subordinated, exploited,"_ their _"permanent condition is one
of obedience"_ and so, therefore, a _"slave."_ Capitalist companies _"plunder
the bodies and souls of wage workers"_ and they are _"an outrage upon human
dignity and personality."_ However, in a co-operative the situation changes
and the worker is an _"associate"_ and _"forms a part of the producing
organisation"_ and _"forms a part of the sovereign power, of which he was
before but the subject."_ Without association, people _" would remain related
as subordinates and superiors, and there would ensue two industrial castes of
masters and wage-workers, which is repugnant to a free and democratic
society."_ [**Op. Cit.**, p. 377, p. 583, p. 584 and p. 583]

This analysis lead Proudhon to call for co-operatives to end wage labour and
it appears repeatedly in his work. Thus we find him arguing in 1851 that
socialism is _"the elimination of misery, the abolition of capitalism and of
wage-labour, the transformation of property, . . . the effective and direct
sovereignty of the workers, . . . the substitution of the contractual regime
for the legal regime."_ [quoted by John Ehrenberg, **Proudhon and his Age**,
p. 111] Fourteen years later, he argued the same, with the aim of his
mutualist ideas being _"the complete emancipation of the workers . . . the
abolition of the wage worker."_ [quoted by K. Steven Vincent, **Pierre-Joseph
Proudhon and the Rise of French Republican Socialism** p. 222] Thus a key idea
of Proudhon's politics is the abolition of wage labour: _"Industrial Democracy
must follow Industrial Feudalism."_  [**Property is Theft!**, p. 610]

(As an aside, it is deeply significant how different Proudhon's analysis of
hierarchy and wage-labour is to Murray Rothbard's. For Rothbard, both
_"hierarchy"_ and _"wage-work"_ were part of _"a whole slew of institutions
necessary to the triumph of liberty"_ (others included _"granting of funds by
libertarian millionaires, and a libertarian political party"_). He strenuously
objected to those _"indicting"_ such institutions _"as non-libertarian or non-
market"_. [**Konkin on Libertarian Strategy**] For Proudhon -- as well as
Bakunin, Kropotkin, and others -- both wage-labour and hierarchy were anti-
libertarian by their very nature. How could hier-archy be _"necessary"_ for
the triumph of an-archy? Logically, it makes no sense. An-**archy**, by
definition, means no-archy rather than wholehearted support for a specific
form of **archy**, namely hier-**archy**! At best, Rothbard was a "voluntary
archist" not an anarchist.)

As Charles A. Dana put it (in a work published by Tucker and described by him
as _"a really intelligent, forceful, and sympathetic exposition of mutual
banking"_), _"[b]y introducing mutualism into exchanges and credit we
introduce it everywhere, and labour will assume a new aspect and become truly
democratic."_ Labour _"must be reformed by means of association as well as
banking"_ for _"if labour be not organised, the labourers will be made to toil
for others to receive the fruit thereof as heretofore."_ These co-operatives
_"to a great extent abolish the exploitation of the employed worker by the
employing capitalist, and make the worker his own employer; but, in order to
completely gain that end, the associations must be associated, united in one
body for mutual aid."_ This is _"the Syndicate of Production."_ [**Proudhon
and His _"Bank of the People"_**, p. 45, p. 50 and p. 54] Tucker, however,
asserted that Proudhon included the syndicate of production _"to humour those
of his associates who placed stress on these features. He did not consider
them of any value."_ [**Op. Cit.**, pp. 51-2] However, he was simply
incorrect. Industrial democracy was a key aspect of Proudhon's ideas, as was
the creation of an _"agro-industrial federation"_ based on these self-managed
associations. This can be seen from Tucker's own comparison of Marx and
Proudhon made on the formers death:

> _"For Karl Marx, the 'egalitaire', we feel the profoundest respect; as for
Karl Marx, the 'authoritaire', we must consider him an enemy. . . . Proudhon
was years before Marx [in discussing the struggle of the classes and the
privileges and monopolies of capital]. . . . The vital difference between
Proudhon and Marx [was] to be found in their respective remedies which they
proposed. Marx would nationalise the productive and distributive forces;
Proudhon would individualise and associate them. Marx would make the labourers
political masters; Proudhon would abolish political mastership entirely . . .
Marx believed in compulsory majority rule; Proudhon believed in the voluntary
principle. In short, Marx was an 'authoritaire'; Proudhon was a champion of
Liberty."_ [**Liberty**, no. 35, p. 2]

Ironically, therefore, by Tucker placing so much stress in opposing capitalist
**exploitation,** instead of capitalist **oppression,** he was actually closer
to the _"authoritaire"_ Marx than Proudhon and, like Marx, opened the door to
various kinds of domination and restrictions on individual self-government
within anarchism. Again we see a support for contract theory creating
authoritarian, not libertarian, relationships between people. Simply put, the
social relationships produced by wage labour share far too much in common with
those created by the state **not** to be of concern to any genuine
libertarian. Arguing that it is based on consent is as unconvincing as those
who defend the state in similar terms.

And we must add that John Stuart Mill (who agreed with the Warrenite slogan
_"Individual Sovereignty"_) faced with the same problem that wage labour made
a mockery of individual liberty came to the same conclusion as Proudhon. He
thought that if _"mankind is to continue to improve"_ (and it can only improve
within liberty, we must add) then in the end one form of association will
predominate, _"not that which can exist between a capitalist as chief, and
workpeople without a voice in management, but the association of the labourers
themselves on terms of equality, collectively owning the capital with which
they carry on their operations, and working under managers elected and
removable by themselves."_ [quoted by Carole Pateman, **Participation and
Democratic Theory**, p. 34]

Tucker himself pointed out that _"the essence of government is control. . . He
who attempts to control another is a governor, an aggressor, an invader."_
[**Instead of a Book**, p. 23] So when Tucker suggests that (non-exploitative,
and so non-capitalist) wage labour could exist in individualist anarchy there
is a distinct contradiction. Unlike wage labour under capitalism, workers
would employ other workers and all would (in theory) receive the full product
of their labour. Be that as it may, such relationships are not libertarian and
so contradict Tucker's own theories on individual liberty (as Proudhon and
Mill recognised with their own, similar, positions). Wage labour is based on
the control of the worker by the employer; hence Tucker's contract theory can
lead to a form of "voluntary" and "private" government within the workplace.
This means that, while outside of a contract an individual is free, within it
he or she is governed. This violates Tucker's concept of _"equality of
liberty,"_ since the boss has obviously more liberty than the worker during
working hours.

Therefore, logically, individualist anarchism must follow Proudhon and support
co-operatives and self-employment in order to ensure the maximum individual
self-government and labour's _"natural wage."_ So Tucker's comments about
strikers and wage labour show a basic inconsistency in his basic ideas. This
conclusion is not surprising. As Malatesta argued:

> _"The individualists give the greatest importance to an abstract concept of
freedom and fail to take into account, or dwell on the fact, that real,
concrete freedom is the outcome of solidarity and voluntary co-operation . . .
They certainly believe that to work in isolation is fruitless and that an
individual, to ensure a living as a human being and to materially and morally
enjoy all the benefits of civilisation, must either exploit -- directly or
indirectly -- the labour of others . . . or associate with his [or her]
fellows and share their pains and the joys of life. And since, being
anarchists, they cannot allow the exploitation of one by another, they must
necessarily agree that to be free and live as human beings they have to accept
some degree and form of voluntary communism."_ [**The Anarchist Revolution**,
p. 16]

Occupancy and use, therefore, implies the collective ownership of resources
used by groups which, in turn, implies associative labour and self-management.
In other words, _"some degree and form of voluntary communism."_ Ultimately,
as John P. Clark summarised, opposition to authority which is limited to just
the state hardly makes much sense from a libertarian perspective:

> _"Neither . . . is there any reason to consider such a position a very
consistent or convincing form of anarchism . . . A view of anarchism which
seeks to eliminate coercion and the state, but which overlooks other ways in
which people dominate other people, is very incomplete and quite contradictory
type of anarchism. The most thorough-going and perceptive anarchist theories
have shown that all types of domination are interrelated, all are destructive,
and all must be eliminated . . . Anarchism may begin as a revolt against
political authority, but if followed to its logical conclusion it becomes an
all-encompassing critique of the will to dominate and all its
manifestations."_ [**Max Stirner's Egoism**, pp. 92-3]

Certain individualist anarchists were keenly aware of the fact that even free
association need not be based on freedom for both parties. Take, for example,
marriage. Marriage, correctly argued John Beverley Robinson, is based on _"the
promise to obey"_ and this results in _"a very real subordination."_ As part
of _"the general progress toward freedom in all things,"_ marriage will
_"become the union of those who are both equal and both free."_ [**Liberty**,
no. 287, p. 2] Why should property associated subordination be any better than
patriarchal subordination? Does the fact that one only lasts 8 or 12 hours
rather than 24 hours a day really make one consistent with libertarian
principles and the other not?

Thus Tucker's comments on wage labour indicates a distinct contradiction in
his ideas. It violates his support for _"occupancy and use"_ as well as his
opposition to the state and usury. It could, of course, be argued that the
contradiction is resolved because the worker consents to the authority of the
boss by taking the job. However, it can be replied that, by this logic, the
citizen consents to the authority of the state as a democratic state allows
people to leave its borders and join another one -- that the citizen does not
leave indicates they consent to the state (this flows from Locke). When it
came to the state, anarchists are well aware of the limited nature of this
argument (as one individualist anarchist put it: _"As well say that the
government of New York or even of the United States is voluntary, and, if you
don't like New York Sunday laws, etc., you can secede and go to -- South
Carolina."_ [A. H. Simpson, **The Individualist Anarchists**, p. 287]). In
other words, consent of and by itself does not justify hierarchy for if it
did, the current state system would be anarchistic. This indicates the
weakness of contract theory as a means of guaranteeing liberty and its
potential to generate, and justify, authoritarian social relationships rather
than libertarian and liberty enhancing ones.

This explains anarchist opposition to wage labour, it undermines liberty and,
as a result, allows exploitation to happen. Albert Parsons put it well. Under
capitalism labour _"is a commodity and wages is the price paid for it. The
owner of this commodity -- of labour -- sells it, that is himself, to the
owner of capital in order to live . . . The reward of the wage labourer's
activity is not the product of his labour -- far from it."_ This implies
exploitation and so class struggle as there is a _"irreconcilable conflict
between wage labourers and capitalists, between those who buy labour or sell
its products, and the wage worker who sells labour (himself) in order to
live."_ This is because the boss will seek to use their authority over the
worker to make them produce more for the agreed wage. Given this, during a
social revolution the workers _"first act will, of necessity, be the
application of communistic principles. They will expropriate all wealth; they
will take possession of all foundries, workshops, factories, mines, etc., for
in no other way could they be able to continue to produce what they require on
a basis of equality, and be, at the same time, independent of any authority."_
[**Anarchism: Its Philosophy and Scientific Basis**, p. 99, p. 104 and p. 166]
Hence Kropotkin's comment that _"anarchism . . . refuses all hierarchical
organisation and preaches free agreement."_ [**Anarchism**, p. 137] To do
otherwise is to contradict the basic ideas of anarchism.

Peter Kropotkin recognised the statist implications of some aspects of
anarchist individualism which Tucker's strike example highlights. Tucker's
anarchism, due to its uncritical support for contract theory, could result in
a few people dominating economic life, because _"no force"_ would result in
the perpetuation of authority structures, with freedom simply becoming the
_"right to full development"_ of _"privileged minorities."_ But, Kropotkin
argued, _"as such monopolies cannot be maintained otherwise than under the
protection of a monopolist legislation and an organised coercion by the State,
the claims of these individualists necessarily end up in a return to the State
idea and to that same coercion which they so fiercely attack themselves. Their
position is thus the same as that of Spencer and of the so-called 'Manchester
school' of economists, who also begin by a severe criticism of the State and
end up in its full recognition in order to maintain the property monopolies,
of which the State is the necessary stronghold."_ [**Op. Cit.**, p. 162]

Such would be the possible (perhaps probable) result of the individualists'
contract theory of freedom without a social background of communal self-
management and ownership. As can be seen from capitalism, a society based on
the abstract individualism associated with contract theory would, in practice,
produce social relationships based on power and authority (and so force --
which would be needed to back up that authority), **not** liberty. As we
argued in [section A.2.14](secA2.html#seca214), voluntarism is **not** enough
in itself to preserve freedom. This result, as noted in [section
A.3](secA3.html), could **only** be avoided by workers' control, which is in
fact the logical implication of Tucker's and other individualists' proposals.
This is hardly a surprising implication, since as we've seen, artisan
production was commonplace in 19th-century America and its benefits were
extolled by many individualists. Without workers' control, individualist
anarchism would soon become a form of capitalism and so statism -- a highly
unlikely intention of individualists like Tucker, who hated both.

Therefore, given the assumptions of individualist anarchism in both their
economic and political aspects, it is forced along the path of co-operative,
not wage, labour. In other words, individualist anarchism is a form of
socialism as workers receive the full product of their labour (i.e. there is
no non-labour income) and this, in turn, logically implies a society in which
self-managed firms compete against each other on the free market, with workers
selling the product of their labour and not the labour itself. As this unites
workers with the means of production they use, it is **not** capitalism and
instead a form of socialism based upon worker ownership and control of the
places they work.

For individualist anarchists not to support co-operatives results in a
contradiction, namely that the individualist anarchism which aims to secure
the worker's _"natural wage"_ cannot in fact do so, while dividing society
into a class of order givers and order takers which violates individual self-
government. It is this contradiction within Tucker's thought which the self-
styled "anarcho"-capitalists take advantage of in order to maintain that
individualist anarchism in fact implies capitalism (and so private-statism),
not workers' control. In order to reach this implausible conclusion, a few
individualist anarchist ideas are ripped from their social context and applied
in a way that makes a mockery of them.

Given this analysis, it becomes clear why few social anarchists exclude
individualist anarchism from the anarchist tradition while almost all do so
for "anarcho"-capitalism. The reason is simple and lies in the analysis that
any individualist anarchism which supports wage labour is **inconsistent**
anarchism. It **can** easily be made **consistent** anarchism by applying its
own principles consistently. In contrast, "anarcho"-capitalism rejects so many
of the basic, underlying, principles of anarchism and has consistently
followed the logical conclusions of such a rejection into private statism and
support for hierarchical authority associated with private property that it
cannot be made consistent with the ideals of anarchism. In contrast, given its
**own** principles, individualist anarchism can easily become **consistent**
anarchism. That is why it is a school of anarchism, unlike
"anarcho"-capitalism. All that is required is to consistently apply "occupancy
and use" to workplaces (as Proudhon advocated as did many individualist
anarchists). By consistently applying this principle it finally ends
exploitation along with hierarchy, so bringing all its ideals into line.

As Malatesta argued, _"anarchy, as understood by the anarchists and as only
they can interpret it, is based on socialism. Indeed were it not for those
schools of socialism which artificially divide the natural unity of the social
question, and consider some aspects out of context . . . we could say straight
out that anarchy is synonymous with socialism, for both stand for the
abolition of the domination and exploitation of man by man, whether exercised
at bayonet point or by a monopoly of the means of life."_ Without socialism,
liberty is purely _"liberty . . . for the strong and the property owners to
oppress and exploit the weak, those who have nothing . . . [so] lead[ing] to
exploitation and domination, in other words, to authority . . . for freedom is
not possible without equality, and real anarchy cannot exist without
solidarity, without socialism."_ [**Anarchy**, p. 48 and p. 47]

[‹ G.3 Is "anarcho"-capitalism a new form of individualist
anarchism?](/afaq/secG3.html "Go to previous page" ) [up](/afaq/secGcon.html
"Go to parent page" ) [G.5 Benjamin Tucker: Capitalist or Anarchist?
›](/afaq/secG5.html "Go to next page" )

