# F.8 What role did the state take in the creation of capitalism?

If the "anarcho"-capitalist is to claim with any plausibility that "real"
capitalism is non-statist or that it can exist without a state, it must be
shown that capitalism evolved naturally, in opposition to state intervention.
In reality, the opposite is the case. Capitalism was born from state
intervention. In the words of Kropotkin, _"the State . . . and capitalism . .
. developed side by side, mutually supporting and re-enforcing each other."_
[**Anarchism**, p. 181]

Numerous writers have made this point. For example, in Karl Polanyi's flawed
masterpiece **The Great Transformation** we read that _"the road to the free
market was opened and kept open by an enormous increase in continuous,
centrally organised and controlled interventionism"_ by the state. [p. 140]
This intervention took many forms -- for example, state support during
"mercantilism," which allowed the "manufactures" (i.e. industry) to survive
and develop, enclosures of common land, and so forth. In addition, the slave
trade, the invasion and brutal conquest of the Americas and other "primitive"
nations, and the looting of gold, slaves, and raw materials from abroad also
enriched the European economy, giving the development of capitalism an added
boost. Thus Kropotkin:

> _"The history of the genesis of capital has already been told by socialists
many times. They have described how it was born of war and pillage, of slavery
and serfdom, of modern fraud and exploitation. They have shown how it is
nourished by the blood of the worker, and how little by little it has
conquered the whole world . . . Law . . . has followed the same phases as
capital . . . they have advanced hand in hand, sustaining one another with the
suffering of mankind."_ [**Op. Cit.**, p. 207]

This process is what Karl Marx termed _**"primitive accumulation"**_ and was
marked by extensive state violence. Capitalism, as he memorably put it,
_"comes dripping from head to toe, from every pore, with blood and dirt"_ and
the _"starting-point of the development that gave rise both to the wage-
labourer and to the capitalist was the enslavement of the worker."_
[**Capital**, vol. 1, p. 926 and p. 875] Or, if Kropotkin and Marx seem too
committed to be fair, we have John Stuart Mill's summary that the _"social
arrangements of modern Europe commenced from a distribution of property which
was the result, not of just partition, or acquisition by industry, but of
conquest and violence."_ [**Principles of Political Economy**, p. 15]

The same can be said of all countries. As such, when supporters of
"libertarian" capitalism say they are against the "initiation of force," they
mean only **new** initiations of force: for the system they support was born
from numerous initiations of force in the past (moreover, it also requires
state intervention to keep it going -- [section D.1](secD1.html) addresses
this point in some detail). Indeed, many thinkers have argued that it was
precisely this state support and coercion (particularly the separation of
people from the land) that played the **key** role in allowing capitalism to
develop rather than the theory that _"previous savings"_ did so. As left-wing
German thinker Franz Oppenheimer (whom Murray Rothbard selectively quoted)
argued, _"the concept of a 'primitive accumulation,' or an original store of
wealth, in land and in movable property, brought about by means of purely
economic forces"_ while _"seem[ing] quite plausible"_ is in fact _"utterly
mistaken; it is a 'fairly tale,' or it is a class theory used to justify the
privileges of the upper classes."_ [**The State**, pp. 5-6] As Individualist
anarchist Kevin Carson summarised as part of his excellent overview of this
historic process:

> _ "Capitalism has never been established by means of the free market. It has
always been established by a revolution from above, imposed by a ruling class
with its origins in the Old Regime . . . by a pre-capitalist ruling class that
had been transformed in a capitalist manner. In England, it was the landed
aristocracy; in France, Napoleon III's bureaucracy; in Germany, the Junkers;
in Japan, the Meiji. In America, the closest approach to a 'natural' bourgeois
evolution, industrialisation was carried out by a mercantilist aristocracy of
Federalist shipping magnates and landlords."_ [_"Primitive Accumulation and
the Rise of Capitalism,"_ **Studies in Mutualist Political Economy**]

This, the actual history of capitalism, will be discussed in the following
sections. So it is ironic to hear right-"libertarians" sing the praises of a
capitalism that never existed and urge its adoption by all nations, in spite
of the historical evidence suggesting that only state intervention made
capitalist economies viable -- even in that Mecca of "free enterprise," the
United States. As Noam Chomsky argues, _"who but a lunatic could have opposed
the development of a textile industry in New England in the early nineteenth
century, when British textile production was so much more efficient that half
the New England industrial sector would have gone bankrupt without very high
protective tariffs, thus terminating industrial development in the United
States? Or the high tariffs that radically undermined economic efficiency to
allow the United States to develop steel and other manufacturing capacities?
Or the gross distortions of the market that created modern electronics?"_
[**World Orders, Old and New**, p. 168] Such state interference in the economy
is often denounced and dismissed by right-"libertarians" as mercantilism.
However, to claim that "mercantilism" is not capitalism makes little sense.
Without mercantilism, "proper" capitalism would never have developed, and any
attempt to divorce a social system from its roots is ahistoric and makes a
mockery of critical thought (particularly as "proper" capitalism turns to
mercantilism regularly).

Similarly, it is somewhat ironic when "anarcho"-capitalists and other right
"libertarians" claim that they support the freedom of individuals to choose
how to live. After all, the working class was not given **that** particular
choice when capitalism was developing. Instead, their right to choose their
own way of life was constantly violated and denied -- and justified by the
leading capitalist economists of the time. To achieve this, state violence had
one overall aim, to dispossess the labouring people from access to the means
of life (particularly the land) and make them dependent on landlords and
capitalists to earn a living. The state coercion _"which creates the capital-
relation can be nothing other than the process which divorces the worker from
the ownership of the conditions of his own labour; it is a process which
operates two transformations, whereby the social means of subsistence and
production are turned into capital, and the immediate producers are turned
into wage-labourers. So-called primitive accumulation, therefore, is nothing
else than the historical process of divorcing the producer from the means of
production."_ [Marx, **Op. Cit.**, pp. 874-5] So to claim that **now** (after
capitalism has been created) we get the chance to try and live as we like is
insulting in the extreme. The available options we have are not independent of
the society we live in and are decisively shaped by the past. To claim we are
"free" to live as we like (within the laws of capitalism, of course) is
basically to argue that we are able (in theory) to "buy" the freedom that
every individual is due from those who have stolen it from us in the first
place. It ignores the centuries of state violence required to produce the
"free" worker who makes a "voluntary" agreement which is compelled by the
social conditions that this created.

The history of state coercion and intervention is inseparable from the history
of capitalism: it is contradictory to celebrate the latter while claiming to
condemn the former. In practice capitalism has **always** meant intervention
in markets to aid business and the rich. That is, what has been called by
supporters of capitalism "laissez-faire" was nothing of the kind and
represented the political-economic program of a specific fraction of the
capitalist class rather than a set of principles of "hands off the market." As
individualist anarchist Kevin Carson summaries, _"what is nostalgically called
'laissez-faire' was in fact a system of continuing state intervention to
subsidise accumulation, guarantee privilege, and maintain work discipline."_
[**The Iron Fist behind the Invisible Hand**] Moreover, there is the apparent
unwillingness by such "free market" advocates (i.e. supporters of "free
market" capitalism) to distinguish between historically and currently unfree
capitalism and the other truly free market economy that they claim to desire.
It is common to hear "anarcho"-capitalists point to the state-based capitalist
system as vindication of their views (and even more surreal to see them point
to **pre**-capitalist systems as examples of their ideology). It should be
obvious that they cannot have it both ways.

In other words, Rothbard and other "anarcho"-capitalists treat capitalism as
if it were the natural order of things rather than being the product of
centuries of capitalist capture and use of state power to further their own
interests. The fact that past uses of state power have allowed capitalist
norms and assumptions to become the default system by their codification in
property law and justified by bourgeois economic does not make it natural. The
role of the state in the construction of a capitalist economy cannot be
ignored or downplayed as government has always been an instrument in creating
and developing such a system. As one critic of right-"libertarian" ideas put
it, Rothbard _"completely overlooks the role of the state in building and
maintaining a capitalist economy in the West. Privileged to live in the
twentieth century, long after the battles to establish capitalism have been
fought and won, Rothbard sees the state solely as a burden on the market and a
vehicle for imposing the still greater burden of socialism. He manifests a
kind of historical nearsightedness that allows him to collapse many centuries
of human experience into one long night of tyranny that ended only with the
invention of the free market and its 'spontaneous' triumph over the past. It
is pointless to argue, as Rothbard seems ready to do, that capitalism would
have succeeded without the bourgeois state; the fact is that all capitalist
nations have relied on the machinery of government to create and preserve the
political and legal environments required by their economic system."_ That, of
course, has not stopped him _"critis[ing] others for being unhistorical."_
[Stephen L. Newman, **Liberalism at Wit's End**, pp. 77-8 and p. 79]

Thus we have a key contradiction within "anarcho"-capitalism. While they
bemoan state intervention in the market, their underlying assumption is that
it had no real effect on how society has evolved over the centuries. By a
remarkable coincidence, the net effect of all this state intervention was to
produce a capitalist economy identical in all features as one which would have
been produced if society had been left alone to evolve naturally. It does seem
strange that state violence would happen to produce the same economic system
as that produced by right-"libertarians" and Austrian economists logically
deducing concepts from a few basic axioms and assumptions. Even more of a
coincidence, these conclusions also happen to be almost exactly the same as
what those who have benefited from previous state coercion want to hear --
namely, the private property is good, trade unions and strikes are bad, that
the state should not interfere with the power of the bosses and should not
even think about helping the working class (employed or unemployed). As such,
while their advice and rhetoric may have changed, the social role of
economists has not. State action was required to dispossess the direct
producers from the means of life (particularly the land) and to reduce the
real wage of workers so that they have to provide regular work in a obedient
manner. In this, it and the capitalists received much advice from the earliest
economists as Marxist economic historian Michael Perelman documents in great
detail. As he summarises, _"classical political economy was concerned with
promoting primitive accumulation in order to foster capitalist development,
even though the logic of primitive accumulation was in direct conflict with
the classical political economists' purported adherence to the values of
laissez-faire."_ [**The Invention of Capitalism**, p. 12] The turn to
"laissez-faire" was possible because direct state power could be mostly
replaced by economic power to ensure the dependency of the working class.

Needless to say, some right-"libertarians" recognise that the state played
**some** role in economic life in the rise and development of capitalism. So
they contrast "bad" business people (who took state aid) and "good" ones (who
did not). Thus Rothbard's comment that Marxists have _"made no particular
distinction between 'bourgeoisie' who made use of the state, and bourgeoisie
who acted on the free market."_ [**The Ethics of Liberty**, p. 72] But such an
argument is nonsense as it ignores the fact that the "free market" is a
network (and defined by the state by the property rights it enforces). This
means that state intervention in one part of the economy will have
ramifications in other parts, particularly if the state action in question is
the expropriation and/or protection of productive resources (land and
workplaces) or the skewing of the labour market in favour of the bosses. In
other words, the individualistic perspective of "anarcho"-capitalism blinds
its proponents to the obvious collective nature of working class exploitation
and oppression which flows from the collective and interconnected nature of
production and investment in any real economy. State action supported by
sectors of the capitalist class has, to use economic jargon, positive
externalities for the rest. They, in general, benefit from it **_as a class_**
just as working class people suffers from it collectively as it limits their
available choices to those desired by their economic and political masters
(usually the same people). As such, the right-"libertarian" fails to
understand the **class** basis of state intervention.

For example, the owners of the American steel and other companies who grew
rich and their companies big behind protectionist walls were obviously "bad"
bourgeoisie. But were the bourgeoisie who supplied the steel companies with
coal, machinery, food, "defence" and so on not also benefiting from state
action? And the suppliers of the luxury goods to the wealthy steel company
owners, did they not benefit from state action? Or the suppliers of
commodities to the workers that laboured in the steel factories that the
tariffs made possible, did they not benefit? And the suppliers to these
suppliers? And the suppliers to these suppliers? Did not the users of
technology first introduced into industry by companies protected by state
orders also not benefit? Did not the capitalists who had a large pool of
landless working class people to select from benefit from the "land monopoly"
even though they may not have, unlike other capitalists, directly advocated
it? It increased the pool of wage labour for **all** capitalists and increased
their bargaining position/power in the labour market at the expense of the
working class. In other words, such a policy helped maintain capitalist market
power, irrespective of whether individual capitalists encouraged politicians
to vote to create/maintain it. And, similarly, **all** American capitalists
benefited from the changes in common law to recognise and protect capitalist
private property and rights that the state enforced during the 19th century
(see [section B.2.5](secB2.html#secb25)).

Rothbard, in other words, ignores class theft and the accumulative effect of
stealing both productive property and the products of the workers who use it.
He considered the _"moral indignation"_ of socialism arose from the argument
_"that the capitalists have stolen the rightful property of the workers, and
therefore that existing titles to accumulated capital are unjust."_ He argued
that given _"this hypothesis, the remainder of the impetus for both Marxism
and anarchosyndicalism follow quite logically."_ However, Rothbard's
"solution" to the problem of past force seems to be (essentially) a
justification of existing property titles and not a serious attempt to
understand or correct past initiations of force that have shaped society into
a capitalist one and still shape it today. This is because he is simply
concerned with returning property which has been obviously stolen and can be
returned to those who have been directly dispossessed or their descendants
(for example, giving land back to peasants or tenant farmers). If this cannot
be done then the _"title to that property, belongs properly, justly and
ethically to its current possessors."_ [**Op. Cit.**, p. 52 and p. 57] At
best, he allows nationalised property and any corporation which has the bulk
of its income coming from the state to be "homesteaded" by their workers
(which, according to Rothbard's arguments for the end of Stalinism, means they
will get shares in the company). The end result of his theory is to leave
things pretty much as they are. This is because he could not understand that
the exploitation of the working class was/is collective in nature and, as
such, is simply impossible to redress it in his individualistic term of
reference.

To take an obvious example, if the profits of slavery in the Southern states
of America were used to invest in factories in the Northern states (as they
were), does giving the land to the freed slaves in 1865 **really** signify the
end of the injustice that situation produced? Surely the products of the
slaves work were stolen property just as much as the land was and, as a
result, so is any investment made from it? After all, investment elsewhere was
based on the profits extracted from slave labour and _"much of the profits
earned in the northern states were derived from the surplus originating on the
southern plantations."_ [Perelman, **Op. Cit.**, p. 246] In terms of the wage
workers in the North, they have been indirectly exploited by the existence of
slavery as the investment this allowed reduced their bargaining power on the
market as it reduced their ability to set up business for themselves by
increasing the fixed costs of so doing. And what of the investment generated
by the exploitation of these wage workers? As Mark Leier points out, the
capitalists and landlords _"may have purchased the land and machinery, but
this money represented nothing more than the expropriated labour of others."_
[**Bakunin**, p. 111] If the land should be returned to those who worked it as
Rothbard suggests, why not the industrial empires that were created on the
backs of the generations of slaves who worked it? And what of the profits made
from the generations of wage slaves who worked on these investments? And what
of the investments which these profits allowed? Surely if the land should be
given to those who worked it then so must any investments it generated? And
assuming that those currently employed can rightly seize their workplaces,
what about those previously employed and **their** descendants? Why should
they be excluded from the riches their ancestors helped create?

To talk in terms of individuals misses all this and the net result is to
ensure that the results of centuries of coercion and theft are undisturbed.
This is because it is the working class **as a whole** who have been
expropriated and whose labour has been exploited. The actual individuals
involved and their descendants would be impossible to identify nor would it be
possible to track down how the stolen fruits of their labour were invested. In
this way, the class theft of our planet and liberty as well as the products of
generations of working class people will continue safely.

Needless to say, some governments interfere in the economy more than others.
Corporations do not invest in or buy from suppliers based in authoritarian
regimes by accident. They do not just happen to be here, passively benefiting
from statism and authoritarianism. Rather they choose **between** states to
locate in based precisely on the cheapness of the labour supply. In other
words, they prefer to locate in dictatorships and authoritarian regimes in
Central America and Southeast Asia **because** those regimes interfere in the
labour market the most -- while, of course, talking about the very "free
market" and "economic liberty" those regimes deny to their subjects. For
Rothbard, this seems to be just a coincidence or a correlation rather than
systematic for the collusion between state and business is the fault, not of
capitalism, but simply of particular capitalists. The system, in other words,
is pure; only individuals are corrupt. But, for anarchists, the origins of the
modern capitalist system lies not in the individual qualities of capitalists
as such but in the dynamic and evolution of capitalism itself -- a complex
interaction of class interest, class struggle, social defence against the
destructive actions of the market, individual qualities and so forth. In other
words, Rothbard's claims are flawed -- they fail to understand capitalism as a
**system**, its dynamic nature and the authoritarian social relationships it
produces and the need for state intervention these produce and require.

So, when the right suggests that "we" be "left alone," what they mean by "we"
comes into clear focus when we consider how capitalism developed. Artisans and
peasants were only "left alone" to starve (sometimes not even that, as the
workhouse was invented to bring vagabonds to the joy of work), and the working
classes of industrial capitalism were only "left alone" outside work and for
only as long as they respected the rules of their "betters." As Marx memorably
put it, the _"newly freed men became sellers of themselves only after they had
been robbed of all their own means of production, and all the guarantees of
existence afforded by the old feudal arrangements. And this history, the
history of their expropriation, is written in the annals of mankind in letters
of blood and fire."_ [**Op. Cit.**, p. 875] As for the other side of the class
divide, they desired to be "left alone" to exercise their power over others as
we will see. That modern "capitalism" is, in effect, a kind of "corporate
mercantilism," with states providing the conditions that allow corporations to
flourish (e.g. tax breaks, subsidies, bailouts, anti-labour laws, etc.) says
more about the statist roots of capitalism than the ideologically correct
definition of capitalism used by its supporters.

In fact, if we look at the role of the state in creating capitalism we could
be tempted to rename "anarcho"-capitalism "marxian-capitalism". This is
because, given the historical evidence, a political theory can be developed by
which the "dictatorship of the bourgeoisie" is created and that this
capitalist state "withers away" into "anarchy". That this means replacing the
economic and social ideas of Marxism and their replacement by their direct
opposite should not mean that we should reject the idea (after all, that is
what "anarcho"-capitalism has done to Individualist Anarchism!). But we doubt
that many "anarcho"-capitalists will accept such a name change (even though
this would reflect their politics far better; after all they do not object to
past initiations of force, just current ones and many do seem to think that
the modern state **will** wither away due to market forces).

This is suggested by the fact that Rothbard did not advocate change from below
as the means of creating "anarchy." He helped found the so-called Libertarian
Party in 1971 which, like Marxists, stands for political office. With the fall
of Stalinism in 1989, Rothbard faced whole economies which could be
"homesteaded" and he argued that _"desocialisation"_ (i.e., de-nationalisation
as, like Leninists, he confused socialisation with nationalisation)
_"necessarily involves the action of that government surrendering its property
to its private subjects . . . In a deep sense, getting rid of the socialist
state requires that state to perform one final, swift, glorious act of self-
immolation, after which it vanishes from the scene."_ (compare to Engels'
comment that _"the taking possession of the means of production in the name of
society"_ is the state's _"last independent act as a state."_ [**Selected
Works**, p. 424]). He considered the _"capital goods built by the State"_ as
being _"philosophically unowned"_ yet failed to note whose labour was
exploited and taxed to build them in the first place (needless to say, he
rejected the ideas of shares to all as this would be _"egalitarian handouts .
. . to undeserving citizens,"_ presumably the ill, the unemployed, retirees,
mothers, children, and future generations). [**The Logic of Action II**, p.
213, p. 212 and p. 209]

Industrial plants would be transferred to workers currently employed there,
but not by their own direct action and direct expropriation. Rather, the state
would do so. This is understandable as, left to themselves, the workers may
not act quite as he desired. Thus we see him advocating the transfer of
industry from the state bureaucracy to workers by means of _"private,
negotiable shares"_ as ownership was _"not to be granted to collectives or co-
operatives or workers or peasants holistically, which would only bring back
the ills of socialism in a decentralised and chaotic syndicalist form."_ His
"homesteading" was not to be done by the workers themselves rather it was a
case of _"granting shares to workers"_ by the state. He also notes that it
should be a _"priority"_ for the government _"to return all stolen,
confiscated property to its original owners, or to their heirs."_ This would
involve _"finding original landowners"_ \-- i.e., the landlord class whose
wealth was based on exploiting the serfs and peasants. [**Op. Cit.**, p. 210
and pp. 211-2] Thus expropriated peasants would have their land returned but
not, apparently, any peasants working land which had been taken from their
feudal and aristocratic overlords by the state. Thus those who had just been
freed from Stalinist rule would have been subjected to "libertarian" rule to
ensure that the transition was done in the economically correct way. As it
was, the neo-classical economists who did oversee the transition ensured that
ownership and control transferred directly to a new ruling class rather than
waste time issuing "shares" which would eventually end up in a few hands due
to market forces (the actual way it was done could be considered a modern form
of "primitive accumulation" as it ensured that capital goods did not end up in
the hands of the workers).

But this is beside the point. The fact remains that state action was required
to create and maintain capitalism. Without state support it is doubtful that
capitalism would have developed at all. So the only "capitalism" that has
existed is a product of state support and intervention, and it has been
characterised by markets that are considerably less than free. Thus, serious
supporters of truly free markets (like the American Individualist Anarchists)
have not been satisfied with "capitalism" -- have, in fact, quite rightly and
explicitly opposed it. Their vision of a free society has always been at odds
with the standard capitalist one, a fact which "anarcho"-capitalists bemoan
and dismiss as "mistakes" and/or the product of "bad economics." Apparently
the net effect of all this state coercion has been, essentially, null. It has
**not**, as the critics of capitalism have argued, fundamentally shaped the
development of the economy as capitalism would have developed naturally by
itself. Thus an economy marked by inequalities of wealth and power, where the
bulk of the population are landless and resourceless and where interest, rent
and profits are extracted from the labour of working people would have
developed anyway regardless of the state coercion which marked the rise of
capitalism and the need for a subservient and dependent working class by the
landlords and capitalists which drove these policies simply accelerated the
process towards "economic liberty." However, it is more than mere coincidence
that capitalism and state coercion are so intertwined both in history and in
current practice.

In summary, like other apologists for capitalism, right-wing "libertarians"
advocate that system without acknowledging the means that were necessary to
create it. They tend to equate it with any market system, failing to
understand that it is a specific kind of market system where labour itself is
a commodity. It is ironic, of course, that most defenders of capitalism stress
the importance of markets (which have pre-dated capitalism) while downplaying
the importance of wage labour (which defines it) along with the violence which
created it. Yet as both anarchists and Marxists have stressed, money and
commodities do not define capitalism any more than private ownership of the
means of production. So it is important to remember that from a socialist
perspective capitalism is **not** identical to the market. As we stressed in
[section C.2](secC2.html), both anarchists and Marxists argue that where
people produce for themselves, is not capitalist production, i.e. when a
worker sells commodities this is not capitalist production. Thus the
supporters of capitalism fail to understand that a great deal of state
coercion was required to transform pre-capitalist societies of artisans and
peasant farmers selling the produce of their labour into a capitalist society
of wage workers selling themselves to bosses, bankers and landlords.

Lastly, it should be stressed that this process of primitive accumulation is
not limited to private capitalism. State capitalism has also had recourse to
such techniques. Stalin's forced collectivisation of the peasantry and the
brutal industrialisation involved in five-year plans in the 1930s are the most
obvious example). What took centuries in Britain was condensed into decades in
the Soviet Union and other state capitalist regimes, with a corresponding
impact on its human toil. However, we will not discuss these acts of state
coercion here as we are concerned primarily with the actions required to
create the conditions required for private capitalism.

Needless to say, this section cannot hope to go into all the forms of state
intervention across the globe which were used to create or impose capitalism
onto an unwilling population. All we can do is provide a glimpse into the
brutal history of capitalism and provide enough references for those
interested to pursue the issue further. The first starting point should be
Part VIII (_"So-Called Primitive Accumulation"_) of volume 1 of Marx's
**Capital**. This classic account of the origins of capitalism should be
supplemented by more recent accounts, but its basic analysis is correct.
Marxist writers have expanded on Marx's analysis, with Maurice Dobb's
**Studies in the Development of Capitalism** and David McNally's **Against the
Market** are worth consulting, as is Michael Perelman's **The Invention of
Capitalism**. Kropotkin's **Mutual Aid** has a short summary of state action
in destroying communal institutions and common ownership of land, as does his
**The State: It's Historic Role**. Rudolf Rocker's **Nationalism and Culture**
is also essential reading. Individualist Anarchist Kevin Carson's **Studies in
Mutualist Political Economy** provides an excellent summary (see part 2,
_"Capitalism and the State: Past, Present and Future"_) as does his essay
**The Iron Fist behind the Invisible Hand**.

## F.8.1 What social forces lay behind the rise of capitalism?

Capitalist society is a relatively recent development. For Marx, while markets
have existed for millennium _"the capitalist era dates from the sixteenth
century."_ [**Capital**, vol. 1, p. 876] As Murray Bookchin pointed out, for a
_"long era, perhaps spanning more than five centuries,"_ capitalism
_"coexisted with feudal and simple commodity relationships"_ in Europe. He
argues that this period _"simply cannot be treated as 'transitional' without
reading back the present into the past."_ [**From Urbanisation to Cities**, p.
179] In other words, capitalism was not a inevitable outcome of "history" or
social evolution.

Bookchin went on to note that capitalism existed _"with growing significance
in the mixed economy of the West from the fourteenth century up to the
seventeenth"_ but that it _"literally exploded into being in Europe,
particularly England, during the eighteenth and especially nineteenth
centuries."_ [**Op. Cit.**, p. 181] The question arises, what lay behind this
_"growing significance"_? Did capitalism _"explode"_ due to its inherently
more efficient nature or where there other, non-economic, forces at work? As
we will show, it was most definitely the second -- capitalism was born not
from economic forces but from the political actions of the social elites which
its usury enriched. Unlike artisan (simple commodity) production, wage labour
generates inequalities and wealth for the few and so will be selected,
protected and encouraged by those who control the state in their own economic
and social interests.

The development of capitalism in Europe was favoured by two social elites, the
rising capitalist class within the degenerating medieval cities and the
absolutist state. The medieval city was _"thoroughly changed by the gradual
increase in the power of commercial capital, due primarily to foreign trade .
. . By this the inner unity of the commune was loosened, giving place to a
growing caste system and leading necessarily to a progressive inequality of
social interests. The privileged minorities pressed ever more definitely
towards a centralisation of the political forces of the community. . .
Mercantilism in the perishing city republics led logically to a demand for
larger economic units [i.e. to nationalise the market]; and by this the desire
for stronger political forms was greatly strengthened . . . Thus the city
gradually became a small state, paving the way for the coming national
state."_ [Rudolf Rocker, **Nationalism and Culture**, p. 94] Kropotkin
stressed that in this destruction of communal self-organisation the state not
only served the interests of the rising capitalist class but also its own.
Just as the landlord and capitalist seeks a workforce and labour market made
up of atomised and isolated individuals, so does the state seek to eliminate
all potential rivals to its power and so opposes _"all coalitions and all
private societies, whatever their aim."_ [**The State: It's Historic role**,
p. 53]

The rising economic power of the proto-capitalists conflicted with that of the
feudal lords, which meant that the former required help to consolidate their
position. That aid came in the form of the monarchical state which, in turn,
needed support against the feudal lords. With the force of absolutism behind
it, capital could start the process of increasing its power and influence by
expanding the "market" through state action. This use of state coercion was
required because, as Bookchin noted, _"[i]n every pre-capitalist society,
countervailing forces . . . existed to restrict the market economy. No less
significantly, many pre-capitalist societies raised what they thought were
insuperable obstacles to the penetration of the State into social life."_ He
noted the _"power of village communities to resist the invasion of trade and
despotic political forms into society's abiding communal substrate."_ State
violence was required to break this resistance and, unsurprisingly the _"one
class to benefit most from the rising nation-state was the European
bourgeoisie . . . This structure . . . provided the basis for the next great
system of labour mobilisation: the factory."_ [**The Ecology of Freedom**, pp.
207-8 and p. 336] The absolutist state, noted Rocker, _"was dependent upon the
help of these new economic forces, and vice versa_ and so it _"at first
furthered the plans of commercial capital"_ as its coffers were filled by the
expansion of commerce. Its armies and fleets _"contributed to the expansion of
industrial production because they demanded a number of things for whose
large-scale production the shops of small tradesmen were no longer adapted.
Thus gradually arose the so-called manufactures, the forerunners of the later
large industries."_ [**Op. Cit.**, pp. 117-8] As such, it is impossible to
underestimate the role of state power in creating the preconditions for both
agricultural and industrial capitalism.

Some of the most important state actions from the standpoint of early industry
were the so-called Enclosure Acts, by which the "commons" -- the free farmland
shared communally by the peasants in most rural villages -- was "enclosed" or
incorporated into the estates of various landlords as private property (see
[section F.8.3](secF8.html#secf83)). This ensured a pool of landless workers
who had no option but to sell their labour to landlords and capitalists.
Indeed, the widespread independence caused by the possession of the majority
of households of land caused the rising class of capitalists to complain, as
one put it, _"that men who should work as wage-labourers cling to the soil,
and in the naughtiness of their hearts prefer independence as squatters to
employment by a master."_ [quoted by Allan Engler, **The Apostles of Greed**,
p. 12] Once in service to a master, the state was always on hand to repress
any signs of _"naughtiness"_ and _"independence"_ (such as strikes, riots,
unions and the like). For example, Seventeenth century France saw a _"number
of decrees . . . which forbade workers to change their employment or which
prohibited assemblies of workers or strikes on pain of corporal punishment or
even death. (Even the Theological Faculty of the University of Paris saw fit
to pronounce solemnly against the sin of workers' organisation)."_ [Maurice
Dobb, **Studies in Capitalism Development**, p. 160]

In addition, other forms of state aid ensured that capitalist firms got a head
start, so ensuring their dominance over other forms of work (such as co-
operatives). A major way of creating a pool of resources that could be used
for investment was the use of mercantilist policies which used protectionist
measures to enrich capitalists and landlords at the expense of consumers and
their workers. For example, one of most common complaints of early capitalists
was that workers could not turn up to work regularly. Once they had worked a
few days, they disappeared as they had earned enough money to live on. With
higher prices for food, caused by protectionist measures, workers had to work
longer and harder and so became accustomed to factory labour. In addition,
mercantilism allowed native industry to develop by barring foreign competition
and so allowed industrialists to reap excess profits which they could then use
to increase their investments. In the words of Marxist economic historian
Maurice Dobb:

> _"In short, the Mercantile System was a system of State-regulated
exploitation through trade which played a highly important rule in the
adolescence of capitalist industry: it was essentially the economic policy of
an age of primitive accumulation."_ [**Op. Cit.**, p. 209]

As Rocker summarises, _"when absolutism had victoriously overcome all
opposition to national unification, by its furthering of mercantilism and
economic monopoly it gave the whole social evolution a direction which could
only lead to capitalism."_ [**Op. Cit.**, pp. 116-7]

Mercantilist policies took many forms, including the state providing capital
to new industries, exempting them from guild rules and taxes, establishing
monopolies over local, foreign and colonial markets, and granting titles and
pensions to successful capitalists. In terms of foreign trade, the state
assisted home-grown capitalists by imposing tariffs, quotas, and prohibitions
on imports. They also prohibited the export of tools and technology as well as
the emigration of skilled workers to stop competition (this applied to any
colonies a specific state may have had). Other policies were applied as
required by the needs of specific states. For example, the English state
imposed a series of Navigation Acts which forced traders to use English ships
to visit its ports and colonies (this destroyed the commerce of Holland, its
chief rival). Nor should the impact of war be minimised, with the demand for
weapons and transportation (including ships) injecting government spending
into the economy. Unsurprisingly, given this favouring of domestic industry at
the expense of its rivals and the subject working class population the
mercantilist period was one of generally rapid growth, particularly in
England.

As we discussed in [section C.10](secC10.html), some kind of mercantilism has
always been required for a country to industrialise. Over all, as economist
Paul Ormerod puts it, the _"advice to follow pure free-market polices seems .
. . to be contrary to the lessons of virtually the whole of economic history
since the Industrial Revolution . . . every country which has moved into . . .
strong sustained growth . . . has done so in outright violation of pure, free-
market principles."_ These interventions include the use of _"tariff
barriers"_ to protect infant industries, _"government subsidies"_ and _"active
state intervention in the economy."_ He summarises: _"The model of
entrepreneurial activity in the product market, with judicious state support
plus repression in the labour market, seems to be a good model of economic
development."_ [**The Death of Economics**, p. 63]

Thus the social forces at work creating capitalism was a combination of
capitalist activity and state action. But without the support of the state, it
is doubtful that capitalist activity would have been enough to generate the
initial accumulation required to start the economic ball rolling. Hence the
necessity of Mercantilism in Europe and its modified cousin of state aid,
tariffs and "homestead acts" in America.

## F.8.2 What was the social context of the statement "laissez-faire?"

The honeymoon of interests between the early capitalists and autocratic kings
did not last long. _"This selfsame monarchy, which for weighty reasons sought
to further the aims of commercial capital and was. . . itself aided in its
development by capital, grew at last into a crippling obstacle to any further
development of European industry."_ [Rudolf Rocker, **Nationalism and
Culture**, p. 117]

This is the social context of the expression _"laissez-faire"_ \-- a system
which has outgrown the supports that protected it in its early stages. Just as
children eventually rebel against the protection and rules of their parents,
so the capitalists rebelled against the over-bearing support of the absolutist
state. Mercantilist policies favoured some industries and harmed the growth of
others. The rules and regulations imposed upon those it did favour reduced the
flexibility of capitalists to changing environments. As Rocker argues, _"no
matter how the absolutist state strove, in its own interest, to meet the
demands of commerce, it still put on industry countless fetters which became
gradually more and more oppressive . . . [it] became an unbearable burden . .
. which paralysed all economic and social life."_ [**Op. Cit.**, p. 119] All
in all, mercantilism became more of a hindrance than a help and so had to be
replaced. With the growth of economic and social power by the capitalist
class, this replacement was made easier. As Errico Malatesta notes:

> _"The development of production, the vast expansion of commerce, the
immeasurable power assumed by money . . . have guaranteed this supremacy [of
economic power over political power] to the capitalist class which, no longer
content with enjoying the support of the government, demanded that government
arise from its own ranks. A government which owed its origin to the right of
conquest . . . though subject by existing circumstances to the capitalist
class, went on maintaining a proud and contemptuous attitude towards its now
wealthy former slaves, and had pretensions to independence of domination. That
government was indeed the defender, the property owners' gendarme, but the
kind of gendarmes who think they are somebody, and behave in an arrogant
manner towards the people they have to escort and defend, when they don't rob
or kill them at the next street corner; and the capitalist class got rid of it
. . . and replac[ed] it by a government of its own choosing, at all times
under its control and specifically organised to defend that class against any
possible demands by the disinherited."_ [**Anarchy**, pp. 22-3]

Malatesta here indicates the true meaning of _"leave us alone,"_ or _"laissez-
faire."_ The **absolutist** state (not "the state" per se) began to interfere
with capitalists' profit-making activities and authority, so they determined
that it had to go -- which the rising capitalist class did when they utilised
such popular movements as the English, French and American revolutions. In
such circumstances, when the state is not fully controlled by the capitalist
class, then it makes perfect sense to oppose state intervention no matter how
useful it may have been in the past -- a state run by aristocratic and feudal
landlords does not produce class legislation in quite the right form. That
changes when members of the capitalist class hold state power and when the
landlords start acting more like rural capitalists and, unsurprisingly,
laissez-faire was quickly modified and then abandoned once capitalists could
rely on a **_capitalist_** state to support and protect its economic power
within society.

When capitalism had been rid of unwanted interference by the hostile use of
state power by non-capitalist classes then laissez-faire had its utility (just
as it has its utility today when attacking social welfare). Once this had been
accomplished then state intervention in society was encouraged and applauded
by capitalists. _"It is ironic that the main protagonists of the State, in its
political and administrative authority, were the middle-class Utilitarians, on
the other side of whose Statist banner were inscribed the doctrines of
economic Laissez Faire."_ [E.P. Thompson, **The Making of the English Working
Class**, p. 90] Capitalists simply wanted **capitalist** states to replace
monarchical states, so that heads of government would follow state economic
policies regarded by capitalists as beneficial to their class as a whole. And
as development economist Lance Taylor argues:

> _"In the long run, there are no laissez-faire transitions to modern economic
growth. The state has always intervened to create a capitalist class, and then
it has to regulate the capitalist class, and then the state has to worry about
being taken over by the capitalist class, but the state has always been
there."_ [quoted by Noam Chomsky, **Year 501**, p. 104]

In order to attack mercantilism, the early capitalists had to ignore the
successful impact of its policies in developing industry and a "store of
wealth" for future economic activity. As William Lazonick points out, _"the
political purpose of [Adam Smith's] the **Wealth of Nations** was to attack
the mercantilist institutions that the British economy had built up over the
previous two hundred years. Yet in proposing institutional change, Smith
lacked a dynamic historical analysis. In his attack on these institutions,
Smith might have asked why the extent of the world market available to Britain
in the late eighteenth century was **so uniquely under British control.** If
Smith had asked this 'big question,' he might have been forced to grant credit
for Britain's extent of the world market to the very mercantilist institutions
he was attacking."_ Moreover, he _"might have recognised the integral relation
between economic and political power in the rise of Britain to international
dominance."_ Overall, _"[w]hat the British advocates of laissez-faire
neglected to talk about was the role that a system of national power had
played in creating conditions for Britain to embark on its dynamic development
path . . . They did not bother to ask how Britain had attained th[e] position
[of 'workshop of the world'], while they conveniently ignored the on going
system of national power -- the British Empire -- that . . . continued to
support Britain's position."_ [**Business Organisation and the Myth of the
Market Economy**, p. 2, p. 3 and p.5]

Similar comments are applicable to American supporters of laissez faire who
fail to notice that the "traditional" American support for world-wide free
trade is quite a recent phenomenon. It started only at the end of the Second
World War (although, of course, **within** America military Keynesian policies
were utilised). While American industry was developing, the state and
capitalist class had no time for laissez-faire (see [section
F.8.5](secF8.html#secf85) for details). After it had grown strong, the United
States began preaching laissez-faire to the rest of the world -- and began to
kid itself about its own history, believing its slogans about laissez-faire as
the secret of its success. Yet like all other successful industrialisers, the
state could aid capitalists directly and indirectly (via tariffs, land policy,
repression of the labour movement, infrastructure subsidy and so on) and it
would "leave them alone" to oppress and exploit workers, exploit consumers,
build their industrial empires and so forth.

Takis Fotopoules indicates that the social forces at work in "freeing" the
market did not represent a "natural" evolution towards freedom:

> _"Contrary to what liberals and Marxists assert, marketisation of the
economy was not just an evolutionary process, following the expansion of trade
under mercantilism . . . modern [i.e. capitalist] markets did not evolve out
of local markets and/or markets for foreign goods . . . the nation-state,
which was just emerging at the end of the Middle Ages, played a crucial role
creating the conditions for the 'nationalisation' of the market . . . and . .
. by freeing the market from effective social control."_ [_"The Nation-state
and the Market"_, pp. 37-80 **Society and Nature**, Vol. 2, No. 2, pp. 44-45]

The "freeing" of the market means freeing those who "own" most of the market
(i.e. the wealthy elite) from _"effective social control,"_ but the rest of
society was not as lucky. Kropotkin makes a similar point: _"While giving the
capitalist any degree of free scope to amass his wealth at the expense of the
helpless labourers, the government has **nowhere** and **never** . . .
afforded the labourers the opportunity 'to do as they pleased'."_
[**Anarchism**, p. 182]

So, the expression "laissez-faire" dates from the period when capitalists were
objecting to the restrictions that helped create them in the first place. It
has little to do with freedom as such and far more to do with the needs of
capitalist power and profits. It should also be remembered that at this time
the state was run by the rich and for the rich. Elections, where they took
place, involved the wealthiest of male property owners. This meant there were
two aspects in the call for laissez-faire. On the one hand, by the elite to
eliminate regulations and interventions they found burdensome and felt
unnecessary as their social position was secure by their economic power
(mercantilism evolved into capitalism proper when market power was usually
sufficient to produce dependency and obedience as the working class had been
successfully dispossessed from the land and the means of production). On the
other, serious social reformers (like Adam Smith) who recognised that the
costs of such elite inspired state regulations generally fell on working class
people. The moral authority of the latter was used to bolster the desire of
the former to maximise their wealth by imposing costs of others (workers,
customers, society and the planet's eco-system) with the state waiting in the
wings to support them as and when required.

Unsurprising, working class people recognised the hypocrisy of this
arrangement (even if most modern-day right-"libertarians" do not and provide
their services justifying the actions and desires of repressive and
exploitative oligarchs seeking monopolistic positions). They turned to
political and social activism seeking to change a system which saw economic
and political power reinforce each other. Some (like the Chartists and
Marxists) argued for political reforms to generalise democracy into genuine
one person, one vote. In this way, political liberty would be used to end the
worse excesses of so-called "economic liberty" (i.e., capitalist privilege and
power). Others (like mutualists) aimed at economic reforms which ensure that
the capitalist class would be abolished by means of genuine economic freedom.
Finally, most other anarchists argued that revolutionary change was required
as the state and capitalism were so intertwined that both had to be ended at
the same time. However, the struggle against state power always came from the
general population. As Murray Bookchin argued, it is an error to depict this
_"revolutionary era and its democratic aspirations as 'bourgeois,' an imagery
that makes capitalism a system more committed to freedom, or even ordinary
civil liberties, than it was historically."_ [**From Urbanisation to Cities**,
p. 180f] While the capitalist class may have benefited from such popular
movements as the English, American and French revolutions but these
revolutions were not led, never mind started or fought, by the bourgeoisie.

Not much as changed as capitalists are today seeking maximum freedom from the
state to ensure maximum authority over their wage slaves and society. The one
essential form of support the "Libertarian" right wants the state (or
"defence" firms) to provide capitalism is the enforcement of property rights
-- the right of property owners to "do as they like" on their own property,
which can have obvious and extensive social impacts. What "libertarian"
capitalists object to is attempts by others -- workers, society as a whole,
the state, etc. -- to interfere with the authority of bosses. That this is
just the defence of privilege and power (and **not** freedom) has been
discussed in [section B](secBcon.html) and elsewhere in [section
F](secFcon.html), so we will not repeat ourselves here. Samuel Johnson once
observed that _"we hear the loudest **yelps** for liberty among the drivers of
Negroes."_ [quoted by Noam Chomsky, **Year 501**, p. 141] Our modern
"libertarian" capitalist drivers of wage-slaves are yelping for exactly the
same kind of "liberty."

## F.8.3 What other forms did state intervention in creating capitalism take?

Beyond being a paymaster for new forms of production and social relations as
well as defending the owners' power, the state intervened economically in
other ways as well. As we noted in [section B.2.5](secB2.html#secb25), the
state played a key role in transforming the law codes of society in a
capitalistic fashion, ignoring custom and common law when it was convenient to
do so. Similarly, the use of tariffs and the granting of monopolies to
companies played an important role in accumulating capital at the expense of
working people, as did the breaking of unions and strikes by force.

However, one of the most blatant of these acts was the enclosure of common
land. In Britain, by means of the Enclosure Acts, land that had been freely
used by poor peasants was claimed by large landlords as private property. As
socialist historian E.P. Thompson summarised, _"the social violence of
enclosure consisted . . . in the drastic, total imposition upon the village of
capitalist property-definitions."_ [**The Making of the English Working
Class**, pp. 237-8] Property rights, which favoured the rich, replaced the use
rights and free agreement that had governed peasants use of the commons.
Unlike use rights, which rest in the individual, property rights require state
intervention to create and maintain. _"Parliament and law imposed capitalist
definitions to exclusive property in land,"_ Thompson notes. This process
involved ignoring the wishes of those who used the commons and repressing
those who objected. Parliament was, of course, run by and for the rich who
then simply _"observed the rules which they themselves had made."_ [**Customs
in Common**, p. 163]

Unsurprisingly, many landowners would become rich through the enclosure of the
commons, heaths and downland while many ordinary people had a centuries old
right taken away. Land enclosure was a gigantic swindle on the part of large
landowners. In the words of one English folk poem written in 1764 as a protest
against enclosure:

_ They hang the man, and flog the woman,  
That steals the goose from off the common;  
But let the greater villain loose,  
That steals the common from the goose. _

It should be remembered that the process of enclosure was not limited to just
the period of the industrial revolution. As Colin Ward notes, _"in Tudor
times, a wave of enclosures by land-owners who sought to profit from the high
price of wool had deprived the commoners of their livelihood and obliged them
to seek work elsewhere or become vagrants or squatters on the wastes on the
edges of villages."_ [**Cotters and Squatters**, p. 30] This first wave
increased the size of the rural proletariat who sold their labour to
landlords. Nor should we forget that this imposition of capitalist property
rights did not imply that it was illegal. As Michael Perelman
notes,_"[f]ormally, this dispossession was perfectly legal. After all, the
peasants did not have property rights in the narrow sense. They only had
traditional rights. As markets evolved, first land-hungry gentry and later the
bourgeoisie used the state to create a legal structure to abrogate these
traditional rights."_ [**The Invention of Capitalism**, pp. 13-4]

While technically legal as the landlords made the law, the impact of this
stealing of the land should not be under estimated. Without land, you cannot
live and have to sell your liberty to others. This places those with capital
at an advantage, which will tend to increase, rather than decrease, the
inequalities in society (and so place the landless workers at an increasing
disadvantage over time). This process can be seen from early stages of
capitalism. With the enclosure of the land an agricultural workforce was
created which had to travel where the work was. This influx of landless ex-
peasants into the towns ensured that the traditional guild system crumbled and
was transformed into capitalistic industry with bosses and wage slaves rather
than master craftsmen and their journeymen. Hence the enclosure of land played
a key role, for _"it is clear that economic inequalities are unlikely to
create a division of society into an employing master class and a subject
wage-earning class, unless access to the means of production, including land,
is by some means or another barred to a substantial section of the
community."_ [Maurice Dobb, **Studies in Capitalist Development**, p. 253]

The importance of access to land is summarised by this limerick by the
followers of Henry George (a 19th century writer who argued for a _"single
tax"_ and the nationalisation of land). The Georgites got their basic argument
on the importance of land down these few, excellent, lines:

_ A college economist planned  
To live without access to land  
He would have succeeded  
But found that he needed  
Food, shelter and somewhere to stand. _

Thus anarchists concern over the _"land monopoly"_ of which the Enclosure Acts
were but one part. The land monopoly, to use Tucker's words, _"consists in the
enforcement by government of land titles which do not rest upon personal
occupancy and cultivation."_ [**The Anarchist Reader**, p. 150] So it should
be remembered that common land did **not** include the large holdings of
members of the feudal aristocracy and other landlords. This helped to
artificially limit available land and produce a rural proletariat just as much
as enclosures.

It is important to remember that wage labour first developed on the land and
it was the protection of land titles of landlords and nobility, combined with
enclosure, that meant people could not just work their own land. The pressing
economic circumstances created by enclosing the land and enforcing property
rights to large estates ensured that capitalists did not have to point a gun
at people's heads to get them to work long hours in authoritarian,
dehumanising conditions. In such circumstances, when the majority are
dispossessed and face the threat of starvation, poverty, homelessness and so
on, "initiation of force" is **not required.** But guns **were** required to
enforce the system of private property that created the labour market in the
first place, to enclosure common land and protect the estates of the nobility
and wealthy.

By decreasing the availability of land for rural people, the enclosures
destroyed working-class independence. Through these Acts, innumerable peasants
were excluded from access to their former means of livelihood, forcing them to
seek work from landlords or to migrate to the cities to seek work in the newly
emerging factories of the budding industrial capitalists who were thus
provided with a ready source of cheap labour. The capitalists, of course, did
not describe the results this way, but attempted to obfuscate the issue with
their usual rhetoric about civilisation and progress. Thus John Bellers, a
17th-century supporter of enclosures, claimed that commons were _"a hindrance
to Industry, and . . . Nurseries of Idleness and Insolence."_ The _"forests
and great Commons make the Poor that are upon them too much like the
**indians.**"_ [quoted by Thompson, **Op. Cit.**, p. 165] Elsewhere Thompson
argues that the commons _"were now seen as a dangerous centre of indiscipline
. . . Ideology was added to self-interest. It became a matter of public-
spirited policy for gentlemen to remove cottagers from the commons, reduce his
labourers to dependence."_ [**The Making of the English Working Class**, pp.
242-3] David McNally confirms this, arguing _"it was precisely these elements
of material and spiritual independence that many of the most outspoken
advocates of enclosure sought to destroy."_ Eighteenth-century proponents of
enclosure _"were remarkably forthright in this respect. Common rights and
access to common lands, they argued, allowed a degree of social and economic
independence, and thereby produced a lazy, dissolute mass of rural poor who
eschewed honest labour and church attendance . . . Denying such people common
lands and common rights would force them to conform to the harsh discipline
imposed by the market in labour."_ [**Against the Market**, p. 19]

The commons gave working-class people a degree of independence which allowed
them to be "insolent" to their betters. This had to be stopped, as it
undermined to the very roots of authority relationships within society. The
commons **increased** freedom for ordinary people and made them less willing
to follow orders and accept wage labour. The reference to "Indians" is
important, as the independence and freedom of Native Americans is well
documented. The common feature of both cultures was communal ownership of the
means of production and free access to it (usufruct). This is discussed
further in section I.7 ([Won't Libertarian Socialism destroy
individuality?](secI7.html)). As Bookchin stressed, the factory _"was not born
from a need to integrate labour with modern machinery,"_ rather it was to
regulate labour and make it regular. For the _"irregularity, or 'naturalness,'
in the rhythm and intensity of traditional systems of work contributed more
towards the bourgeoisie's craze for social control and its savagely anti-
naturalistic outlook than did the prices or earnings demanded by its
employees. More than any single technical factor, this irregularity led to the
rationalisation of labour under a single ensemble of rule, to a discipline of
work and regulation of time that yielded the modern factory . . . the initial
goal of the factory was to dominate labour and destroy the worker's
independence from capital."_ [**The Ecology of Freedom** p. 406]

Hence the pressing need to break the workers' ties with the land and so the
_"loss of this independence included the loss of the worker's contact with
food cultivation . . . To live in a cottage . . . often meant to cultivate a
family garden, possibly to pasture a cow, to prepare one's own bread, and to
have the skills for keeping a home in good repair. To utterly erase these
skills and means of a livelihood from the worker's life became an industrial
imperative."_ Thus the worker's _"complete dependence on the factory and on an
industrial labour market was a compelling precondition for the triumph of
industrial society . . . The need to destroy whatever independent means of
life the worker could garner . . . all involved the issue of reducing the
proletariat to a condition of total powerlessness in the face of capital. And
with that powerlessness came a supineness, a loss of character and community,
and a decline in moral fibre."_ [Bookchin, **Op. Cit.,**, pp. 406-7]
Unsurprisingly, there was a positive association between enclosure and
migration out of villages and a _"definite correlation . . . between the
extent of enclosure and reliance on poor rates . . . parliamentary enclosure
resulted in out-migration and a higher level of pauperisation."_ Moreover,
_"the standard of living was generally much higher in those areas where
labourer managed to combine industrial work with farming . . . Access to
commons meant that labourers could graze animals, gather wood, stones and
gravel, dig coal, hunt and fish. These rights often made the difference
between subsistence and abject poverty."_ [David McNally, **Op. Cit.**, p. 14
and p. 18] Game laws also ensured that the peasantry and servants could not
legally hunt for food as from the time of Richard II (1389) to 1831, no person
could kill game unless qualified by estate or social standing.

The enclosure of the commons (in whatever form it took -- see [section
F.8.5](secF8.html#secf85) for the US equivalent) solved both problems -- the
high cost of labour, and the freedom and dignity of the worker. The enclosures
perfectly illustrate the principle that capitalism requires a state to ensure
that the majority of people do not have free access to any means of livelihood
and so must sell themselves to capitalists in order to survive. There is no
doubt that if the state had "left alone" the European peasantry, allowing them
to continue their collective farming practices ("collective farming" because,
as Kropotkin shows, the peasants not only shared the land but much of the farm
labour as well), capitalism could not have taken hold (see **Mutual Aid** for
more on the European enclosures [pp. 184-189]). As Kropotkin notes,
_"[i]nstances of commoners themselves dividing their lands were rare,
everywhere the State coerced them to enforce the division, or simply favoured
the private appropriation of their lands"_ by the nobles and wealthy. Thus
_"to speak of the natural death of the village community [or the commons] in
virtue of economical law is as grim a joke as to speak of the natural death of
soldiers slaughtered on a battlefield."_ [**Mutual Aid**, p. 188 and p. 189]

Once a labour market **was** created by means of enclosure and the land
monopoly, the state did **not** passively let it work. When market conditions
favoured the working class, the state took heed of the calls of landlords and
capitalists and intervened to restore the "natural" order. The state actively
used the law to lower wages and ban unions of workers for centuries. In
Britain, for example, after the Black Death there was a "servant" shortage.
Rather than allow the market to work its magic, the landlords turned to the
state and the result was **_"the Statute of Labourers"_** of 1351:

> _ "Whereas late against the malice of servants, which were idle, and not
willing to serve after the pestilence, without taking excessive wages, it was
ordained by our lord the king . . . that such manner of servants . . . should
be bound to serve, receiving salary and wages, accustomed in places where they
ought to serve in the twentieth year of the reign of the king that now is, or
five or six years before; and that the same servants refusing to serve in such
manner should be punished by imprisonment of their bodies . . . now forasmuch
as it is given the king to understand in this present parliament, by the
petition of the commonalty, that the said servants having no regard to the
said ordinance, . . to the great damage of the great men, and impoverishing of
all the said commonalty, whereof the said commonalty prayeth remedy: wherefore
in the said parliament, by the assent of the said prelates, earls, barons, and
other great men, and of the same commonalty there assembled, to refrain the
malice of the said servants, be ordained and established the things
underwritten."_

Thus state action was required because labourers had increased bargaining
power and commanded higher wages which, in turn, led to inflation throughout
the economy. In other words, an early version of the NAIRU (see [section
C.9](secC9.html)). In one form or another this statute remained in force right
through to the 19th century (later versions made it illegal for employees to
"conspire" to fix wages, i.e., to organise to demand wage increases). Such
measures were particularly sought when the labour market occasionally favoured
the working class. For example, _"[a]fter the Restoration [of the English
Monarchy],"_ noted Dobb, _"when labour-scarcity had again become a serious
complaint and the propertied class had been soundly frightened by the
insubordination of the Commonwealth years, the clamour for legislative
interference to keep wages low, to drive the poor into employment and to
extend the system of workhouses and 'houses of correction' and the farming out
of paupers once more reached a crescendo."_ The same occurred on Continental
Europe. [**Op. Cit.**, p. 234]

So, time and again employers called on the state to provide force to suppress
the working class, artificially lower wages and bolster their economic power
and authority. While such legislation was often difficult to enforce and often
ineffectual in that real wages did, over time, increase, the threat and use of
state coercion would ensure that they did not increase as fast as they may
otherwise have done. Similarly, the use of courts and troops to break unions
and strikes helped the process of capital accumulation immensely. Then there
were the various laws used to control the free movement of workers. _"For
centuries,"_ notes Colin Ward, _"the lives of the poor majority in rural
England were dominated by the Poor law and its ramifications, like the
Settlement Act of 1697 which debarred strangers from entering a parish unless
they had a Settlement Certificate in which their home parish agreed to take
them back if they became in need of poor relief. Like the Workhouse, it was a
hated institution that lasted into the 20th century."_ [**Op. Cit.**, p. 31]

As Kropotkin stressed, _"it was the State which undertook to settle . . .
griefs"_ between workers and bosses _"so as to guarantee a 'convenient'
livelihood"_ (convenient for the masters, of course). It also acted _"severely
to prohibit all combinations . . . under the menace of severe punishments . .
. Both in the town and in the village the State reigned over loose
aggregations of individuals, and was ready to prevent by the most stringent
measures the reconstitution of any sort of separate unions among them."_
Workers who formed unions _"were prosecuted wholesale under the Master and
Servant Act -- workers being summarily arrested and condemned upon a mere
complaint of misbehaviour lodged by the master. Strikes were suppressed in an
autocratic way . . . to say nothing of the military suppression of strike
riots . . . To practice mutual support under such circumstances was anything
but an easy task . . . After a long fight, which lasted over a hundred years,
the right of combing together was conquered."_ [**Mutual Aid**, p. 210 and p.
211] It took until 1813 until the laws regulating wages were repealed while
the laws against combinations remained until 1825 (although that did not stop
the Tolpuddle Martyrs being convicted of "administering an illegal oath" and
deported to Tasmania in 1834). Fifty years later, the provisions of the
statues of labourers which made it a civil action if the boss broke his
contract but a criminal action if the worker broke it were repealed. Trade
unions were given legal recognition in 1871 while, at the same time, another
law limited what the workers could do in a strike or lockout. The British
ideals of free trade never included freedom to organise.

(Luckily, by then, economists were at hand to explain to the workers that
organising to demand higher wages was against their own self-interest. By a
strange coincidence, all those laws against unions had actually **helped** the
working class by enforcing the necessary conditions for perfect competition in
labour market! What are the chances of that? Of course, while considered
undesirable from the perspective of mainstream economists -- and, by strange
co-incidence, the bosses -- unions are generally not banned these days but
rather heavily regulated. The freedom loving, deregulating Thatcherites passed
six Employment Acts between 1980 and 1993 restricting industrial action by
requiring pre-strike ballots, outlawing secondary action, restricting
picketing and giving employers the right to seek injunctions where there is
doubt about the legality of action -- in the workers' interest, of course as,
for some reason, politicians, bosses and economists have always known what
best for trade unionists rather than the trade unionists themselves. And if
they objected, well, that was what the state was for.)

So to anyone remotely familiar with working class history the notion that
there could be an economic theory which ignores power relations between bosses
and workers is a particularly self-serving joke. Economic relations always
have a power element, even if only to protect the property and power of the
wealthy -- the Invisible Hand always counts on a very visible Iron Fist when
required. As Kropotkin memorably put it, the rise of capitalism has always
seen the State _"tighten the screw for the worker"_ and _"impos[ing]
industrial serfdom."_ So what the bourgeoisie _"swept away as harmful to
industry"_ was anything considered as _"useless and harmful"_ but that class
_"was at pains not to sweep away was the power of the State over industry,
over the factory serf."_ Nor should the role of public schooling be
overlooked, within which _"the spirit of voluntary servitude was always
cleverly cultivated in the minds of the young, and still is, in order to
perpetuate the subjection of the individual to the State."_ [**The State: Its
Historic Role**, pp. 52-3 and p. 55] Such education also ensured that children
become used to the obedience and boredom required for wage slavery.

Like the more recent case of fascist Chile, "free market" capitalism was
imposed on the majority of society by an elite using the authoritarian state.
This was recognised by Adam Smith when he opposed state intervention in **The
Wealth of Nations**. In Smith's day, the government was openly and unashamedly
an instrument of wealth owners. Less than 10 per cent of British men (and no
women) had the right to vote. When Smith opposed state interference, he was
opposing the imposition of wealth owners' interests on everybody else (and, of
course, how "liberal", never mind "libertarian", is a political system in
which the many follow the rules and laws set-down in the so-called interests
of all by the few? As history shows, any minority given, or who take, such
power **will** abuse it in their own interests). Today, the situation is
reversed, with neo-liberals and right-"libertarians" opposing state
interference in the economy (e.g. regulation of Big Business) so as to prevent
the public from having even a minor impact on the power or interests of the
elite. The fact that "free market" capitalism always requires introduction by
an authoritarian state should make all honest "Libertarians" ask: How "free"
is the "free market"?

## F.8.4 Aren't the enclosures a socialist myth?

The short answer is no, they are not. While a lot of historical analysis has
been spent in trying to deny the extent and impact of the enclosures, the
simple fact is (in the words of noted historian E.P. Thompson) enclosure _"was
a plain enough case of class robbery, played according to the fair rules of
property and law laid down by a parliament of property-owners and lawyers."_
[**The Making of the English Working Class**, pp. 237-8]

The enclosures were one of the ways that the _"land monopoly"_ was created.
The land monopoly referred to feudal and capitalist property rights and
ownership of land by (among others) the Individualist Anarchists. Instead of
an _"occupancy and use"_ regime advocated by anarchists, the land monopoly
allowed a few to bar the many from the land -- so creating a class of people
with nothing to sell but their labour. While this monopoly is less important
these days in developed nations (few people know how to farm) it was essential
as a means of consolidating capitalism. Given the choice, most people
preferred to become independent farmers rather than wage workers (see [next
section](secF8.html#secf85)). As such, the _"land monopoly"_ involves more
than simply enclosing common land but also enforcing the claims of landlords
to areas of land greater than they can work by their own labour.

Needless to say, the titles of landlords and the state are generally ignored
by supporters of capitalism who tend to concentrate on the enclosure movement
in order to downplay its importance. Little wonder, for it is something of an
embarrassment for them to acknowledge that the creation of capitalism was
somewhat less than "immaculate" -- after all, capitalism is portrayed as an
almost ideal society of freedom. To find out that an idol has feet of clay and
that we are still living with the impact of its origins is something pro-
capitalists must deny. So **are** the enclosures a socialist myth? Most claims
that it is flow from the work of the historian J.D. Chambers' famous essay
_"Enclosures and the Labour Supply in the Industrial Revolution."_ [**Economic
History Review**, 2nd series, no. 5, August 1953] In this essay, Chambers
attempts to refute Karl Marx's account of the enclosures and the role it
played in what Marx called _"primitive accumulation."_

We cannot be expected to provide an extensive account of the debate that has
raged over this issue (Colin Ward notes that _"a later series of scholars have
provided locally detailed evidence that reinforces"_ the traditional socialist
analysis of enclosure and its impact. [**Cotters and Squatters**, p. 143]).
All we can do is provide a summary of the work of William Lazonick who
presented an excellent reply to those who claim that the enclosures were an
unimportant historical event (see his _"Karl Marx and Enclosures in England."_
[**Review of Radical Political Economy**, no. 6, pp. 1-32]). Here, we draw
upon his subsequent summarisation of his critique provided in his books
**Competitive Advantage on the Shop Floor** and **Business Organisation and
the Myth of the Market Economy**.

There are three main claims against the socialist account of the enclosures.
We will cover each in turn.

Firstly, it is often claimed that the enclosures drove the uprooted cottager
and small peasant into industry. However, this was never claimed. As Lazonick
stresses while some economic historians _"have attributed to Marx the notion
that, in one fell swoop, the enclosure movement drove the peasants off the
soil and into the factories. Marx did not put forth such a simplistic view of
the rise of a wage-labour force . . . Despite gaps and omission in Marx's
historical analysis, his basic arguments concerning the creation of a landless
proletariat are both important and valid. The transformations of social
relations of production and the emergence of a wage-labour force in the
agricultural sector were the critical preconditions for the Industrial
Revolution."_ [**Competitive Advantage on the Shop Floor**, pp. 12-3]

It is correct, as the critics of Marx stress, that the agricultural revolution
associated with the enclosures **increased** the demand for farm labour as
claimed by Chambers and others. And this is the whole point -- enclosures
created a pool of dispossessed labourers who had to sell their time/liberty to
survive and whether this was to a landlord or an industrialist is irrelevant
(as Marx himself stressed). As such, the account by Chambers, ironically,
_"confirms the broad outlines of Marx's arguments"_ as it implicitly
acknowledges that _"over the long run the massive reallocation of access to
land that enclosures entailed resulted in the separation of the mass of
agricultural producers from the means of production."_ So the _"critical
transformation was not the level of agricultural employment before and after
enclosure but the changes in employment relations caused by the reorganisation
of landholdings and the reallocation of access to land."_ [**Op. Cit.**, p.
29, pp. 29-30 and p. 30] Thus the key feature of the enclosures was that it
created a supply for farm labour, a supply that had no choice but to work for
another. Once freed from the land, these workers could later move to the towns
in search for better work:

> _ "Critical to the Marxian thesis of the origins of the industrial labour
force is the transformation of the social relations of agriculture and the
creation, in the first instance, of an agricultural wage-labour force that
might eventually, perhaps through market incentives, be drawn into the
industrial labour force."_ [**Business Organisation and the Myth of the Market
Economy**, p. 273]

In summary, when the critics argue that enclosures increased the demand for
farm labour they are not refuting Marx but confirming his analysis. This is
because the enclosures had resulted in a transformation in employment
relations in agriculture with the peasants and farmers turned into wage
workers for landlords (i.e., rural capitalists). For if wage labour is the
defining characteristic of capitalism then it matters little if the boss is a
farmer or an industrialist. This means that the _"critics, it turns out, have
not differed substantially with Marx on the facts of agricultural
transformation. But by ignoring the historical and theoretical significance of
the resultant changes in the social relations of **agricultural** production,
the critics have missed Marx's main point."_ [**Competitive Advantage on the
Shop Floor**, p. 30]

Secondly, it is argued that the number of small farm owners increased, or at
least did not greatly decline, and so the enclosure movement was unimportant.
Again, this misses the point. Small farm owners can still employ wage workers
(i.e. become capitalist farmers as opposed to "yeomen" -- an independent
peasant proprietor). As Lazonick notes, _"[i]t is true that after 1750 some
petty proprietors continued to occupy and work their own land. But in a world
of capitalist agriculture, the yeomanry no longer played an important role in
determining the course of capitalist agriculture. As a social class that could
influence the evolution of British economy society, the yeomanry had
disappeared."_ Moreover, Chambers himself acknowledged that for the poor
without legal rights in land, then enclosure injured them. For _"the majority
of the agricultural population . . . had only customary rights. To argue that
these people were not treated unfairly because they did not possess legally
enforceable property rights is irrelevant to the fact that they were
dispossessed by enclosures. Again, Marx's critics have failed to address the
issue of the transformation of access to the means of production as a
precondition for the Industrial Revolution."_ [**Op. Cit.**, p. 32 and p. 31]

Thirdly, it is often claimed that it was population growth, rather than
enclosures, that caused the supply of wage workers. So was population growth
more important than enclosures? Given that enclosure impacted on the
individuals and social customs of the time, it is impossible to separate the
growth in population from the social context in which it happened. As such,
the population argument ignores the question of whether the changes in society
caused by enclosures and the rise of capitalism have an impact on the observed
trends towards earlier marriage and larger families after 1750. Lazonick
argues that _"[t]here is reason to believe that they did."_ [**Op. Cit.**, p.
33] Overall, Lazonick notes that _"[i]t can even be argued that the changed
social relations of agriculture altered the constraints on early marriage and
incentives to childbearing that contributed to the growth in population. The
key point is that transformations in social relations in production can
influence, and have influenced, the quantity of wage labour supplied on both
agricultural and industrial labour markets. To argue that population growth
created the industrial labour supply is to ignore these momentous social
transformations"_ associated with the rise of capitalism. [**Business
Organisation and the Myth of the Market Economy**, p. 273]

In other words, there is good reason to think that the enclosures, far from
being some kind of socialist myth, in fact played a key role in the
development of capitalism. As Lazonick notes, _"Chambers misunderstood"_ the
_"argument concerning the 'institutional creation' of a proletarianised (i.e.
landless) workforce. Indeed, Chamber's own evidence and logic tend to support
the Marxian [and anarchist!] argument, when it is properly understood."_
[**Op. Cit.**, p. 273]

Lastly, it must be stressed that this process of dispossession happened over
hundreds of years. It was not a case of simply driving peasants off their land
and into factories. In fact, the first acts of expropriation took place in
agriculture and created a rural proletariat which had to sell their
labour/liberty to landlords and it was the second wave of enclosures, in the
eighteenth and nineteenth centuries, that was closely connected with the
process of industrialisation. The enclosure movement, moreover, was imposed in
an uneven way, affecting different areas at different times, depending on the
power of peasant resistance and the nature of the crops being grown (and other
objective conditions). Nor was it a case of an instant transformation -- for a
long period this rural proletariat was not totally dependent on wages, still
having some access to the land and wastes for fuel and food. So while rural
wage workers did exist throughout the period from 1350 to the 1600s,
capitalism was not fully established in Britain yet as such people comprised
only a small proportion of the labouring classes. The acts of enclosure were
just one part of a long process by which a proletariat was created.

## F.8.5 What about the lack of enclosures in the Americas?

The enclosure movement was but one part of a wide-reaching process of state
intervention in creating capitalism. Moreover, it is just one way of creating
the _"land monopoly"_ which ensured the creation of a working class. The
circumstances facing the ruling class in the Americas were distinctly
different than in the Old World and so the "land monopoly" took a different
form there. In the Americas, enclosures were unimportant as customary land
rights did not really exist (at least once the Native Americans were
eliminated by violence). Here the problem was that (after the original users
of the land were eliminated) there were vast tracts of land available for
people to use. Other forms of state intervention were similar to that applied
under mercantilism in Europe (such as tariffs, government spending, use of
unfree labour and state repression of workers and their organisations and so
on). All had one aim, to enrich and power the masters and dispossess the
actual producers of the means of life (land and means of production).

Unsurprisingly, due to the abundance of land, there was a movement towards
independent farming in the early years of the American colonies and subsequent
Republic and this pushed up the price of remaining labour on the market by
reducing the supply. Capitalists found it difficult to find workers willing to
work for them at wages low enough to provide them with sufficient profits. It
was due to the difficulty in finding cheap enough labour that capitalists in
America turned to slavery. All things being equal, wage labour **is** more
productive than slavery but in early America all things were **not** equal.
Having access to cheap (indeed, free) land meant that working people had a
choice, and few desired to become wage slaves and so because of this,
capitalists turned to slavery in the South and the "land monopoly" in the
North.

This was because, in the words of Maurice Dobb, it _"became clear to those who
wished to reproduce capitalist relations of production in the new country that
the foundation-stone of their endeavour must be the restriction of land-
ownership to a minority and the exclusion of the majority from any share in
[productive] property."_ [**Studies in Capitalist Development**, pp. 221-2] As
one radical historian puts it, _"[w]hen land is 'free' or 'cheap'. as it was
in different regions of the United States before the 1830s, there was no
compulsion for farmers to introduce labour-saving technology. As a result,
'independent household production' . . . hindered the development of
capitalism . . . [by] allowing large portions of the population to escape wage
labour."_ [Charlie Post, _"The 'Agricultural Revolution' in the United
States"_, pp. 216-228, **Science and Society**, vol. 61, no. 2, p. 221]

It was precisely this option (i.e. of independent production) that had to be
destroyed in order for capitalist industry to develop. The state had to
violate the holy laws of "supply and demand" by controlling the access to land
in order to ensure the normal workings of "supply and demand" in the labour
market (i.e. that the bargaining position favoured employer over employee).
Once this situation became the typical one (i.e., when the option of self-
employment was effectively eliminated) a more (protectionist based) "laissez-
faire" approach could be adopted, with state action used indirectly to favour
the capitalists and landlords (and readily available to protect private
property from the actions of the dispossessed).

So how was this transformation of land ownership achieved?

Instead of allowing settlers to appropriate their own farms as was often the
case before the 1830s, the state stepped in once the army had cleared out
(usually by genocide) the original users. Its first major role was to enforce
legal rights of property on unused land. Land stolen from the Native Americans
was sold at auction to the highest bidders, namely speculators, who then sold
it on to farmers. This process started right _"after the revolution, [when]
huge sections of land were bought up by rich speculators"_ and their claims
supported by the law. [Howard Zinn, **A People's History of the United
States**, p. 125] Thus land which should have been free was sold to land-
hungry farmers and the few enriched themselves at the expense of the many. Not
only did this increase inequality within society, it also encouraged the
development of wage labour -- having to pay for land would have ensured that
many immigrants remained on the East Coast until they had enough money. Thus a
pool of people with little option but to sell their labour was increased due
to state protection of unoccupied land. That the land usually ended up in the
hands of farmers did not (could not) countermand the shift in class forces
that this policy created.

This was also the essential role of the various "Homesteading Acts" and, in
general, the _"Federal land law in the 19th century provided for the sale of
most of the public domain at public auction to the higher bidder . . . Actual
settlers were forced to buy land from speculators, at prices considerably
above the federal minimal price."_ (which few people could afford anyway).
[Charlie Post, **Op. Cit.**, p. 222] This is confirmed by Howard Zinn who
notes that 1862 Homestead Act _"gave 160 acres of western land, unoccupied and
publicly owned, to anyone who would cultivate it for five years . . . Few
ordinary people had the $200 necessary to do this; speculators moved in and
bought up much of the land. Homestead land added up to 50 million acres. But
during the Civil War, over 100 million acres were given by Congress and the
President to various railroads, free of charge."_ [**Op. Cit.**, p. 233]
Little wonder the Individualist Anarchists supported an _"occupancy and use"_
system of land ownership as a key way of stopping capitalist and landlord
usury as well as the development of capitalism itself.

This change in the appropriation of land had significant effects on
agriculture and the desirability of taking up farming for immigrants. As Post
notes, _"[w]hen the social conditions for obtaining and maintaining possession
of land change, as they did in the Midwest between 1830 and 1840, pursuing the
goal of preserving [family ownership and control] . . . produced very
different results. In order to pay growing mortgages, debts and taxes, family
farmers were compelled to specialise production toward cash crops and to
market more and more of their output."_ [**Op. Cit.**, p. 221-2]

So, in order to pay for land which was formerly free, farmers got themselves
into debt and increasingly turned to the market to pay it off. Thus, the
_"Federal land system, by transforming land into a commodity and stimulating
land speculation, made the Midwestern farmers dependent upon markets for the
continual possession of their farms."_ Once on the market, farmers had to
invest in new machinery and this also got them into debt. In the face of a bad
harvest or market glut, they could not repay their loans and their farms had
to be sold to so do so. By 1880, 25% of all farms were rented by tenants, and
the numbers kept rising. In addition, the _"transformation of social property
relations in northern agriculture set the stage for the 'agricultural
revolution' of the 1840s and 1850s . . . [R]ising debts and taxes forced
Midwestern family farmers to compete as commodity producers in order to
maintain their land-holding . . . The transformation . . . was the central
precondition for the development of industrial capitalism in the United
States."_ [Charlie Post, **Op. Cit.**, p. 223 and p. 226]

It should be noted that feudal land owning was enforced in many areas of the
colonies and the early Republic. Landlords had their holdings protected by the
state and their demands for rent had the full backing of the state. This lead
to numerous anti-rent conflicts. [Howard Zinn, **A People's History of the
United States**, p. 84 and pp. 206-11] Such struggles helped end such
arrangements, with landlords being "encouraged" to allow the farmers to buy
the land which was rightfully theirs. The wealth appropriated from the farmers
in the form of rent and the price of the land could then be invested in
industry so transforming feudal relations on the land into capitalist
relations in industry (and, eventually, back on the land when the farmers
succumbed to the pressures of the capitalist market and debt forced them to
sell).

This means that Murray Rothbard's comment that _"once the land was purchased
by the settler, the injustice disappeared"_ is nonsense -- the injustice was
transmitted to other parts of society and this, the wider legacy of the
original injustice, lived on and helped transform society towards capitalism.
In addition, his comment about _"the establishment in North America of a truly
libertarian land system"_ would be one the Individualist Anarchists of the
period would have seriously disagreed with! [**The Ethics of Liberty**, p. 73]
Rothbard, at times, seems to be vaguely aware of the importance of land as the
basis of freedom in early America. For example, he notes in passing that _"the
abundance of fertile virgin land in a vast territory enabled individualism to
come to full flower in many areas."_ [**Conceived in Liberty**, vol. 2, p.
186] Yet he did not ponder the transformation in social relationships which
would result when that land was gone. In fact, he was blasé about it. _"If
latecomers are worse off,"_ he opined, _"well then that is their proper
assumption of risk in this free and uncertain world. There is no longer a vast
frontier in the United States, and there is no point crying over the fact."_
[**The Ethics of Liberty**, p. 240] Unsurprisingly we also find Murray
Rothbard commenting that Native Americans _"lived under a collectivistic
regime that, for land allocation, was scarcely more just than the English
governmental land grab."_ [**Conceived in Liberty**, vol. 1, p. 187] That such
a regime made for **increased** individual liberty and that it was precisely
the independence from the landlord and bosses this produced which made
enclosure and state land grabs such appealing prospects for the ruling class
was lost on him.

Unlike capitalist economists, politicians and bosses at the time, Rothbard
seemed unaware that this _"vast frontier"_ (like the commons) was viewed as a
major problem for maintaining labour discipline and appropriate state action
was taken to reduce it by restricting free access to the land in order to
ensure that workers were dependent on wage labour. Many early economists
recognised this and advocated such action. Edward Wakefield was typical when
he complained that _"where land is cheap and all are free, where every one who
so pleases can easily obtain a piece of land for himself, not only is labour
dear, as respects the labourer's share of the product, but the difficulty is
to obtain combined labour at any price."_ This resulted in a situation were
few _"can accumulate great masses of wealth"_ as workers _"cease . . . to be
labourers for hire; they . . . become independent landowners, if not
competitors with their former masters in the labour market."_ Unsurprisingly,
Wakefield urged state action to reduce this option and ensure that labour
become cheap as workers had little choice but to seek a master. One key way
was for the state to seize the land and then sell it to the population. This
would ensure that _"no labourer would be able to procure land until he had
worked for money"_ and this _"would produce capital for the employment of more
labourers."_ [quoted by Marx, **Op. Cit., **, p. 935, p. 936 and p. 939] Which
is precisely what did occur.

At the same time that it excluded the working class from virgin land, the
state granted large tracts of land to the privileged classes: to land
speculators, logging and mining companies, planters, railroads, and so on. In
addition to seizing the land and distributing it in such a way as to benefit
capitalist industry, the _"government played its part in helping the bankers
and hurting the farmers; it kept the amount of money -- based in the gold
supply -- steady while the population rose, so there was less and less money
in circulation. The farmer had to pay off his debts in dollars that were
harder to get. The bankers, getting loans back, were getting dollars worth
more than when they loaned them out -- a kind of interest on top of interest.
That was why so much of the talk of farmers' movements in those days had to do
with putting more money in circulation."_ [Zinn, **Op. Cit.**, p. 278] This
was the case with the Individualist Anarchists at the same time, we must add.

Overall, therefore, state action ensured the transformation of America from a
society of independent workers to a capitalist one. By creating and enforcing
the "land monopoly" (of which state ownership of unoccupied land and its
enforcement of landlord rights were the most important) the state ensured that
the balance of class forces tipped in favour of the capitalist class. By
removing the option of farming your own land, the US government created its
own form of enclosure and the creation of a landless workforce with little
option but to sell its liberty on the "free market". They was nothing
"natural" about it. Little wonder the Individualist Anarchist J.K. Ingalls
attacked the "land monopoly" with the following words:

> _"The earth, with its vast resources of mineral wealth, its spontaneous
productions and its fertile soil, the free gift of God and the common
patrimony of mankind, has for long centuries been held in the grasp of one set
of oppressors by right of conquest or right of discovery; and it is now held
by another, through the right of purchase from them. All of man's natural
possessions . . . have been claimed as property; nor has man himself escaped
the insatiate jaws of greed. The invasion of his rights and possessions has
resulted . . . in clothing property with a power to accumulate an income."_
[quoted by James Martin, **Men Against the State**, p. 142]

Marx, correctly, argued that _"the capitalist mode of production and
accumulation, and therefore capitalist private property, have for their
fundamental condition the annihilation of that private property which rests on
the labour of the individual himself; in other words, the expropriation of the
worker."_ [**Capital**, Vol. 1, p. 940] He noted that to achieve this, the
state is used:

> _"How then can the anti-capitalistic cancer of the colonies be healed? . . .
Let the Government set an artificial price on the virgin soil, a price
independent of the law of supply and demand, a price that compels the
immigrant to work a long time for wages before he can earn enough money to buy
land, and turn himself into an independent farmer."_ [**Op. Cit.**, p. 938]

Moreover, tariffs were introduced with _"the objective of manufacturing
capitalists artificially"_ for the _"system of protection was an artificial
means of manufacturing manufacturers, or expropriating independent workers, of
capitalising the national means of production and subsistence, and of forcibly
cutting short the transition . . . to the modern mode of production,"_ to
capitalism [**Op. Cit.**, p. 932 and pp. 921-2]

So mercantilism, state aid in capitalist development, was also seen in the
United States of America. As Edward Herman points out, the _"level of
government involvement in business in the United States from the late
eighteenth century to the present has followed a U-shaped pattern: There was
extensive government intervention in the pre-Civil War period (major
subsidies, joint ventures with active government participation and direct
government production), then a quasi-laissez faire period between the Civil
War and the end of the nineteenth century [a period marked by "the aggressive
use of tariff protection" and state supported railway construction, a key
factor in capitalist expansion in the USA], followed by a gradual upswing of
government intervention in the twentieth century, which accelerated after
1930."_ [**Corporate Control, Corporate Power**, p. 162]

Such intervention ensured that income was transferred from workers to
capitalists. Under state protection, America industrialised by forcing the
consumer to enrich the capitalists and increase their capital stock.
_"According to one study, if the tariff had been removed in the 1830s 'about
half the industrial sector of New England would have been bankrupted' . . .
the tariff became a near-permanent political institution representing
government assistance to manufacturing. It kept price levels from being driven
down by foreign competition and thereby shifted the distribution of income in
favour of owners of industrial property to the disadvantage of workers and
customers."_ This protection was essential, for the _"end of the European wars
in 1814 . . . reopened the United States to a flood of British imports that
drove many American competitors out of business. Large portions of the newly
expanded manufacturing base were wiped out, bringing a decade of near-
stagnation."_ Unsurprisingly, the _"era of protectionism began in 1816, with
northern agitation for higher tariffs."_ [Richard B. Du Boff, **Accumulation
and Power**, p. 56, p. 14 and p. 55] Combined with ready repression of the
labour movement and government "homesteading" acts (see [section
F.8.5](secF8.html#secf85)), tariffs were the American equivalent of
mercantilism (which, after all, was above all else a policy of protectionism,
i.e. the use of government to stimulate the growth of native industry). Only
once America was at the top of the economic pile did it renounce state
intervention (just as Britain did, we must note).

This is **not** to suggest that government aid was limited to tariffs. The
state played a key role in the development of industry and manufacturing. As
John Zerzan notes, the _"role of the State is tellingly reflected by the fact
that the 'armoury system' now rivals the older 'American system of
manufactures' term as the more accurate to describe the new system of
production methods"_ developed in the early 1800s. [**Elements of Refusal**,
p. 100] By the middle of the nineteenth century _"a distinctive 'American
system of manufactures' had emerged . . . The lead in technological innovation
[during the US Industrial Revolution] came in armaments where assured
government orders justified high fixed-cost investments in special-pursue
machinery and managerial personnel. Indeed, some of the pioneering effects
occurred in government-owned armouries."_ Other forms of state aid were used,
for example the textile industry _"still required tariffs to protect [it] from
. . . British competition."_ [William Lazonick, **Competitive Advantage on the
Shop Floor**, p. 218 and p. 219] The government also _"actively furthered this
process [of 'commercial revolution'] with public works in transportation and
communication."_ In addition to this "physical" aid, _"state government
provided critical help, with devices like the chartered corporation"_ [Richard
B. Du Boff, **Op. Cit.**, p. 15] As we noted in [section
B.2.5](secB2.html#secb25), there were changes in the legal system which
favoured capitalist interests over the rest of society.

Nineteenth-century America also went in heavily for industrial planning --
occasionally under that name but more often in the name of national defence.
The military was the excuse for what is today termed rebuilding
infrastructure, picking winners, promoting research, and co-ordinating
industrial growth (as it still is, we should add). As Richard B. Du Boff
points out, the "anti-state" backlash of the 1840s onwards in America was
highly selective, as the general opinion was that _"[h]enceforth, if
governments wished to subsidise private business operations, there would be no
objection. But if public power were to be used to control business actions or
if the public sector were to undertake economic initiatives on its own, it
would run up against the determined opposition of private capital."_ [**Op.
Cit.**, p. 26]

State intervention was not limited to simply reducing the amount of available
land or enforcing a high tariff. _"Given the independent spirit of workers in
the colonies, capital understood that great profits required the use of unfree
labour."_ [Michael Perelman, **The Invention of Capitalism**, p. 246] It was
also applied in the labour market as well. Most obviously, it enforced the
property rights of slave owners (until the civil war, produced when the pro-
free trade policies of the South clashed with the pro-tariff desires of the
capitalist North). The evil and horrors of slavery are well documented, as is
its key role in building capitalism in America and elsewhere so we will
concentrate on other forms of obviously unfree labour. Convict labour in
Australia, for example, played an important role in the early days of
colonisation while in America indentured servants played a similar role.

Indentured service was a system whereby workers had to labour for a specific
number of years usually in return for passage to America with the law
requiring the return of runaway servants. In theory, of course, the person was
only selling their labour. In practice, indentured servants were basically
slaves and the courts enforced the laws that made it so. The treatment of
servants was harsh and often as brutal as that inflicted on slaves. Half the
servants died in the first two years and unsurprisingly, runaways were
frequent. The courts realised this was a problem and started to demand that
everyone have identification and travel papers.

It should also be noted that the practice of indentured servants also shows
how state intervention in one country can impact on others. This is because
people were willing to endure indentured service in the colonies because of
how bad their situation was at home. Thus the effects of primitive
accumulation in Britain impacted on the development of America as most
indentured servants were recruited from the growing number of unemployed
people in urban areas there. Dispossessed from their land and unable to find
work in the cities, many became indentured servants in order to take passage
to the Americas. In fact, between one half to two thirds of all immigrants to
Colonial America arrived as indentured servants and, at times, three-quarters
of the population of some colonies were under contracts of indenture. That
this allowed the employing class to overcome their problems in hiring "help"
should go without saying, as should its impact on American inequality and the
ability of capitalists and landlords to enrich themselves on their servants
labour and to invest it profitably.

As well as allowing unfree labour, the American state intervened to ensure
that the freedom of wage workers was limited in similar ways as we indicated
in [section F.8.3](secF8.html#secf83). _"The changes in social relations of
production in artisan trades that took place in the thirty years after 1790,"_
notes one historian, _"and the . . . trade unionism to which . . . it gave
rise, both replicated in important respects the experience of workers in the
artisan trades in Britain over a rather longer period . . . The juridical
responses they provoked likewise reproduced English practice. Beginning in
1806, American courts consciously seized upon English common law precedent to
combat journeymen's associations."_ Capitalists in this era tried to _"secure
profit . . . through the exercise of disciplinary power over their
employees."_ To achieve this _"employers made a bid for legal aid"_ and it is
here _"that the key to law's role in the process of creating an industrial
economy in America lies."_ As in the UK, the state invented laws and issues
proclamations against workers' combinations, calling them conspiracies and
prosecuting them as such. Trade unionists argued that laws which declared
unions as illegal combinations should be repealed as against the Constitution
of the USA while _"the specific cause of trademens protestations of their
right to organise was, unsurprisingly, the willingness of local authorities to
renew their resort to conspiracy indictments to countermand the growing power
of the union movement."_ Using criminal conspiracy to counter combinations
among employees was commonplace, with the law viewing a _"collective quitting
of employment [as] a criminal interference"_ and combinations to raise the
rate of labour _"indictable at common law."_ [Christopher L. Tomlins, **Law,
Labor, and Ideology in the Early American Republic**, p. 113, p. 295, p. 159
and p. 213] By the end of the nineteenth century, state repression for
conspiracy was replaced by state repression for acting like a trust while
actual trusts were ignored and so laws, ostensibly passed (with the help of
the unions themselves) to limit the power of capital, were turned against
labour (this should be unsurprising as it was a capitalist state which passed
them). [Howard Zinn, **A People's History of the United States**, p. 254]

Another key means to limit the freedom of workers was denying departing
workers their wages for the part of the contract they had completed. This
_"underscored the judiciary's tendency to articulate their approval"_ of the
hierarchical master/servant relationship in terms of its _"social utility: It
was a necessary and desirable feature of the social organisation of work . . .
that the employer's authority be reinforced in this way."_ Appeals courts held
that _"an employment contract was an entire contract, and therefore that no
obligation to pay wages existed until the employee had completed the agreed
term."_ Law suits _"by employers seeking damages for an employee's departure
prior to the expiry of an agreed term or for other forms of breach of contract
constituted one form of legally sanctioned economic discipline of some
importance in shaping the employment relations of the nineteenth century."_
Thus the boss could fire the worker without paying their wages while if the
worker left the boss he would expect a similar outcome. This was because the
courts had decided that the _"employer was entitled not only to receipt of the
services contracted for in their entirety prior to payment but also to the
obedience of the employee in the process of rendering them."_ [Tomlins, **Op.
Cit.**, pp. 278-9, p. 274, p. 272 and pp. 279-80] The ability of workers to
seek self-employment on the farm or workplace or even better conditions and
wages were simply abolished by employers turning to the state.

So, in summary, the state could remedy the shortage of cheap wage labour by
controlling access to the land, repressing trade unions as conspiracies or
trusts and ensuring that workers had to obey their bosses for the full term of
their contract (while the bosses could fire them at will). Combine this with
the extensive use of tariffs, state funding of industry and infrastructure
among many other forms of state aid to capitalists and we have a situation
were capitalism was imposed on a pre-capitalist nation at the behest of the
wealthy elite by the state, as was the case with all other countries.

## F.8.6 How did working people view the rise of capitalism?

The best example of how hated capitalism was can be seen by the rise and
spread of the labour and socialist movements, in all their many forms, across
the world. It is no coincidence that the development of capitalism also saw
the rise of socialist theories. Nor was it a coincidence that the rising
workers movement was subjected to extensive state repression, with unions,
strikes and other protests being systematically repressed. Only once capital
was firmly entrenched in its market position could economic power come to
replace political force (although, of course, that always remained ready in
the background to defend capitalist property and power).

The rise of unions, socialism and other reform movements and their repression
was a feature of **all** capitalist countries. While America is sometime
portrayed as an exception to this, in reality that country was also marked by
numerous popular movements which challenged the rise of capitalism and the
transformation of social relationships within the economy from artisanal self-
management to capitalist wage slavery. As in other countries, the state was
always quick to support the capitalist class against their rebellious wage
slaves, using first conspiracy and then anti-trust laws against working class
people and their organisations. So, in order to fully understand how different
capitalism was from previous economic systems, we will consider early
capitalism in the US, which for many right-"libertarians" is **the** example
of the "capitalism-equals-freedom" argument.

Early America was pervaded by artisan production -- individual ownership of
the means of production. Unlike capitalism, this system is **not** marked by
the separation of the worker from the means of life. Most people did not have
to work for another, and so did not. As Jeremy Brecher notes, in 1831 the
_"great majority of Americans were farmers working their own land, primarily
for their own needs. Most of the rest were self-employed artisans, merchants,
traders, and professionals. Other classes -- employees and industrialists in
the North, slaves and planters in the South -- were relatively small. The
great majority of Americans were independent and free from anybody's
command."_ [**Strike!**, p. xxi] So the availability of land ensured that in
America, slavery and indentured servants were the only means by which
capitalists could get people to work for them. This was because slaves and
servants were not able to leave their masters and become self-employed farmers
or artisans. As noted in the [last section](secF8.html#secf85) this material
base was, ironically, acknowledged by Rothbard but the implications for
freedom when it disappeared was not. While he did not ponder what would happen
when that supply of land ended and whether the libertarian aspects of early
American society would survive, contemporary politicians, bosses, and
economists did. Unsurprisingly, they turned to the state to ensure that
capitalism grew on the grave of artisan and farmer property.

Toward the middle of the 19th century the economy began to change. Capitalism
began to be imported into American society as the infrastructure was improved
by state aid and tariff walls were constructed which allowed home-grown
manufacturing companies to develop. Soon, due to (state-supported) capitalist
competition, artisan production was replaced by wage labour. Thus "evolved"
modern capitalism. Many workers understood, resented, and opposed their
increasing subjugation to their employers, which could not be reconciled with
the principles of freedom and economic independence that had marked American
life and had sunk deeply into mass consciousness during the days of the early
economy. In 1854, for example, a group of skilled piano makers hoped that
_"the day is far distant when they [wage earners] will so far forget what is
due to manhood as to glory in a system forced upon them by their necessity and
in opposition to their feelings of independence and self-respect. May the
piano trade be spared such exhibitions of the degrading power of the day
[wage] system."_ [quoted by Brecher and Costello, **Common Sense for Hard
Times**, p. 26]

Clearly the working class did not consider working for a daily wage, in
contrast to working for themselves and selling their own product, to be a step
forward for liberty or individual dignity. The difference between selling the
product of one's labour and selling one's labour (i.e. oneself) was seen and
condemned (_"[w]hen the producer . . . sold his product, he retained himself.
But when he came to sell his labour, he sold himself . . . the extension [of
wage labour] to the skilled worker was regarded by him as a symbol of a deeper
change."_ [Norman Ware, **The Industrial Worker, 1840-1860**, p. xiv]).
Indeed, one group of workers argued that they were _"slaves in the strictest
sense of the word"_ as they had _"to toil from the rising of the sun to the
going down of the same for our masters -- aye, masters, and for our daily
bread."_ [quoted by Ware, **Op. Cit.**, p. 42] Another group argued that _"the
factory system contains in itself the elements of slavery, we think no sound
reasoning can deny, and everyday continues to add power to its incorporate
sovereignty, while the sovereignty of the working people decreases in the same
degree."_ [quoted by Brecher and Costello, **Op. Cit.**, p. 29] For working
class people, free labour meant something radically different than that
subscribed to by employers and economists. For workers, free labour meant
economic independence through the ownership of productive equipment or land.
For bosses, it meant workers being free of any alternative to consenting to
authoritarian organisations within their workplaces -- if that required state
intervention (and it did), then so be it.

The courts, of course, did their part in ensuring that the law reflected and
bolstered the power of the boss rather than the worker. _"Acting piecemeal,"_
summarises Tomlins, _"the law courts and law writers of the early republic
built their approach to the employment relationship on the back of English
master/servant law. In the process, they vested in the generality of
nineteenth-century employers a controlling authority over the employees
founded upon the pre-industrial master's claim to property in his servant's
personal services."_ Courts were _"having recourse to master/servant's
language of power and control"_ as the _"preferred strategy for dealing with
the employment relation"_ and so advertised their conclusion that _"employment
relations were properly to be conceived of as generically hierarchical."_
[**Op. Cit.**, p. 231 and p. 225] As we noted in [ last
section](secF8.html#secf85) the courts, judges and jurists acted to outlaw
unions as conspiracies and force workers to work the full length of their
contracts. In addition, they also reduced employer liability in industrial
accidents (which, of course, helped lower the costs of investment as well as
operating costs).

Artisans and farmers correctly saw this as a process of downward mobility
toward wage labour and almost as soon as there were wage workers, there were
strikes, machine breaking, riots, unions and many other forms of resistance.
John Zerzan's argument that there was a _"relentless assault on the worker's
historical rights to free time, self-education, craftsmanship, and play was at
the heart of the rise of the factory system"_ is extremely accurate.
[**Elements of Refusal**, p. 105] And it was an assault that workers resisted
with all their might. In response to being subjected to the wage labour,
workers rebelled and tried to organise themselves to fight the powers that be
and to replace the system with a co-operative one. As the printer's union
argued, its members _"regard such an organisation [a union] not only as an
agent of immediate relief, but also as an essential to the ultimate
destruction of those unnatural relations at present subsisting between the
interests of the employing and the employed classes . . . when labour
determines to sell itself no longer to speculators, but to become its own
employer, to own and enjoy itself and the fruit thereof, the necessity for
scales of prices will have passed away and labour will be forever rescued from
the control of the capitalist."_ [quoted by Brecher and Costello, **Op.
Cit.**, pp. 27-28]

Little wonder, then, why wage labourers considered capitalism as a modified
form of slavery and why the term _"wage slavery"_ became so popular in the
labour and anarchist movements. It was just reflecting the feelings of those
who experienced the wages system at first hand and who created the labour and
socialist movements in response. As labour historian Norman Ware notes, the
_"term 'wage slave' had a much better standing in the forties [of the 19th
century] than it has today. It was not then regarded as an empty shibboleth of
the soap-box orator. This would suggest that it has suffered only the normal
degradation of language, has become a **cliche**, not that it is a grossly
misleading characterisation."_ [**Op. Cit.**, p. xvf] It is no coincidence
that, in America, the first manufacturing complex in Lowell was designed to
symbolise its goals and its hierarchical structure nor that its design was
emulated by many of the penitentiaries, insane asylums, orphanages and
reformatories of the period. [Bookchin, **The Ecology of Freedom**, p. 392]

These responses of workers to the experience of wage labour is important as
they show that capitalism is by no means "natural." The fact is the first
generation of workers tried to avoid wage labour is at all possible -- they
hated the restrictions of freedom it imposed upon them. Unlike the
bourgeoisie, who positively eulogised the discipline they imposed on others.
As one put it with respect to one corporation in Lowell, New England, the
factories at Lowell were _"a new world, in its police it is **imperium in
imperio**. It has been said that an absolute despotism, justly administered .
. . would be a perfect government . . . For at the same time that it is an
absolute despotism, it is a most perfect democracy. Any of its subjects can
depart from it at pleasure . . . Thus all the philosophy of mind which enter
vitally into government by the people . . . is combined with a set of rule
which the operatives have no voice in forming or administering, yet of a
nature not merely perfectly just, but human, benevolent, patriarchal in a high
degree."_ Those actually subjected to this _"benevolent"_ dictatorship had a
somewhat different perspective. Workers, in contrast, were perfectly aware
that wage labour was wage slavery -- that they were decidedly **unfree**
during working hours and subjected to the will of another. The workers
therefore attacked capitalism precisely because it was despotism
(_"monarchical principles on democratic soil"_) and thought they _"who work in
the mills ought to own them."_ Unsurprisingly, when workers did revolt against
the benevolent despots, the workers noted how the bosses responded by marking
_"every person with intelligence and independence . . . He is a suspected
individual and must be either got rid of or broken in. Hundreds of honest
labourers have been dismissed from employment . . . because they have been
suspected of knowing their rights and daring to assert them."_ [quoted by
Ware, **Op. Cit.**, p. 78, p. 79 and p. 110]

While most working class people now are accustomed to wage labour (while often
hating their job) the actual process of resistance to the development of
capitalism indicates well its inherently authoritarian nature and that people
were not inclined to accept it as "economic freedom." Only once other options
were closed off and capitalists given an edge in the "free" market by state
action did people accept and become accustomed to wage labour. As E. P.
Thompson notes, for British workers at the end of the 18th and beginning of
the 19th centuries, the _"gap in status between a 'servant,' a hired wage-
labourer subject to the orders and discipline of the master, and an artisan,
who might 'come and go' as he pleased, was wide enough for men to shed blood
rather than allow themselves to be pushed from one side to the other. And, in
the value system of the community, those who resisted degradation were in the
right."_ [**The Making of the English Working Class**, p. 599]

Opposition to wage labour and factory fascism was/is widespread and seems to
occur wherever it is encountered. _"Research has shown"_, summarises William
Lazonick, _"that the 'free-born Englishman' of the eighteenth century -- even
those who, by force of circumstance, had to submit to agricultural wage labour
-- tenaciously resisted entry into the capitalist workshop."_ [**Competitive
Advantage on the Shop Floor**, p. 37] British workers shared the dislike of
wage labour of their American cousins. A _"Member of the Builders' Union"_ in
the 1830s argued that the trade unions _"will not only strike for less work,
and more wages, but will ultimately **abolish wages**, become their own
masters and work for each other; labour and capital will no longer be separate
but will be indissolubly joined together in the hands of workmen and work-
women."_ [quoted by E. P. Thompson, **Op. Cit.**, p. 912] This perspective
inspired the **Grand National Consolidated Trades Union** of 1834 which had
the _"two-fold purpose of syndicalist unions -- the protection of the workers
under the existing system and the formation of the nuclei of the future
society"_ when the unions _"take over the whole industry of the country."_
[Geoffrey Ostergaard, **The Tradition of Workers' Control**, p. 133] As
Thompson noted, _"industrial syndicalism"_ was a major theme of this time in
the labour movement. _"When Marx was still in his teens,"_ he noted, British
trade unionists had _"developed, stage by stage, a theory of syndicalism"_ in
which the _"unions themselves could solve the problem of political power"_
along with wage slavery. This vision was lost _"in the terrible defeats of
1834 and 1835."_ [**Op. Cit.**, p. 912 and p. 913] In France, the mutualists
of Lyons had come to the same conclusions, seeking _"the formation of a series
of co-operative associations"_ which would _"return to the workers control of
their industry."_ Proudhon would take up this theme, as would the anarchist
movement he helped create. [K. Steven Vincent, **Pierre-Jospeh Proudhon and
the Rise of French Republican Socialism**, pp. 162-3] Similar movements and
ideas developed elsewhere, as capitalism was imposed (subsequent developments
were obviously influenced by the socialist ideas which had arisen earlier and
so were more obviously shaped by anarchist and Marxist ideas).

This is unsurprising, the workers then, who had not been swallowed up whole by
the industrial revolution, could make critical comparisons between the factory
system and what preceded it. _"Today, we are so accustomed to this method of
production [capitalism] and its concomitant, the wage system, that it requires
quite an effort of imagination to appreciate the significance of the change in
terms of the lives of ordinary workers . . . the worker became **alienated** .
. . from the means of production and the products of his labour . . . In these
circumstances, it is not surprising that the new socialist theories proposed
an alternative to the capitalist system which would avoid this alienation."_
While wage slavery may seem "natural" today, the first generation of wage
labourers saw the transformation of the social relationships they experienced
in work, from a situation in which they controlled their own work (and so
themselves) to one in which **others** controlled them, and they did not like
it. However, while many modern workers instinctively hate wage labour and
having bosses, without the awareness of some other method of working, many put
up with it as "inevitable." The first generation of wage labourers had the
awareness of something else (although a flawed and limited something else as
it existed in a hierarchical and class system) and this gave then a deep
insight into the nature of capitalism and produced a deeply radical response
to it and its authoritarian structures. Anarchism (like other forms of
socialism) was born of the demand for liberty and resistance to authority
which capitalism had provoked in its wage slaves. With our support for
workers' self-management of production, _"as in so many others, the anarchists
remain guardians of the libertarian aspirations which moved the first rebels
against the slavery inherent in the capitalist mode of production."_
[Ostergaard, **Op. Cit.**, p. 27 and p. 90]

State action was required produce and protect the momentous changes in social
relations which are central to the capitalist system. However, once capital
**has** separated the working class from the means of life, then it no longer
had to rely as much on state coercion. With the choice now between wage
slavery or starving, then the appearance of voluntary choice could be
maintained as economic power was/is usually effective enough to ensure that
state violence could be used as a last resort. Coercive practices are still
possible, of course, but market forces are usually sufficient as the market is
usually skewed against the working class. However, the role of the state
remains a key to understanding capitalism as a system rather than just
specific periods of it. This is because, as we stressed in [section
D.1](secD1.html), state action is not associated only with the past, with the
transformation from feudalism to capitalism. It happens today and it will
continue to happen as long as capitalism continues.

Far from being a "natural" development, then, capitalism was imposed on a
society by state action, by and on behalf of ruling elites. Those working
class people alive at the time viewed it as _"unnatural relations"_ and
organised to overcome it. It is from such movements that all the many forms of
socialism sprang, including anarchism. This is the case with the European
anarchism associated with Proudhon, Bakunin and Kropotkin as well as the
American individualist anarchism of Warren and Tucker. The links between
anarchism and working class rebellion against the autocracy of capital and the
state is reflected not only in our theory and history, but also in our
anarchist symbols. The Black Flag, for example, was first raised by rebel
artisans in France and its association with labour insurrection was the reason
why anarchists took it up as our symbol (see the appendix on ["The Symbols of
Anarchy"](append2.html)). So given both the history of capitalism and
anarchism, it becomes obvious any the latter has always opposed the former. It
is why anarchists today still seek to encourage the desire and hope for
political **and** economic freedom rather than the changing of masters we have
under capitalism. Anarchism will continue as long as these feelings and hopes
still exist and they will remain until such time as we organise and abolish
capitalism and the state.

[‹ F.7 How does the history of "anarcho"-capitalism show that it is not
anarchist?](/afaq/secF7.html "Go to previous page" ) [up](/afaq/secFcon.html
"Go to parent page" ) [Section G - Is individualist anarchism capitalistic?
›](/afaq/secGcon.html "Go to next page" )

