# C.6 Can market dominance by Big Business change?

Capital concentration, of course, does not mean that in a given market,
dominance will continue forever by the same firms, no matter what. However,
the fact that the companies that dominate a market can change over time is no
great cause for joy (no matter what supporters of free market capitalism
claim). This is because when market dominance changes between companies all it
means is that **old** Big Business is replaced by **new** Big Business:

> _ "Once oligopoly emerges in an industry, one should not assume that
sustained competitive advantage will be maintained forever. . . once achieved
in any given product market, oligopoly creates barriers to entry that can be
overcome only by the development of even more powerful forms of business
organisation that can plan and co-ordinate even more complex specialised
divisions of labour."_ [William Lazonick, **Business Organisation and the Myth
of the Market Economy**, p. 173]

The assumption that the "degree of monopoly" will rise over time is an obvious
one to make and, in general, the history of capitalism has tended to support
doing so. While periods of rising concentration will be interspersed with
periods of constant or falling levels, the general trend will be upwards (we
would expect the degree of monopoly to remain the same or fall during booms
and rise to new levels in slumps). Yet even if the "degree of monopoly" falls
or new competitors replace old ones, it is hardly a great improvement as
changing the company hardly changes the impact of capital concentration or Big
Business on the economy. While the faces may change, the system itself remains
the same. As such, it makes little real difference if, for a time, a market is
dominated by 6 large firms rather than, say, 4. While the **relative** level
of barriers may fall, the **absolute** level may increase and so restrict
competition to established big business (either national or foreign) and it is
the absolute level which maintains the class monopoly of capital over labour.

Nor should we expect the "degree of monopoly" to constantly increase, there
will be cycles of expansion and contraction in line with the age of the market
and the business cycle. It is obvious that at the start of a specific market,
there will be a relative high "degree of monopoly" as a few pioneering create
a new industry. Then the level of concentration will fall as competitors entry
the market. Over time, the numbers of firms will drop due to failure and
mergers. This process is accelerated during booms and slumps. In the boom,
more companies feel able to try setting up or expanding in a specific market,
so driving the "degree of monopoly" down. However, in the slump the level of
concentration will rise as more and more firms go to the wall or try and merge
to survive (for example, there were 100 car producers in the USA in 1929, ten
years later there were only three). So our basic point is **not** dependent on
any specific tendency of the degree of monopoly. It can fall somewhat as, say,
five large firms come to dominate a market rather than, say, three over a
period of a few years. The fact remains that barriers to competition remain
strong and deny any claims that any real economy reflects the "perfect
competition" of the textbooks.

So even in a in a well-developed market, one with a high degree of monopoly
(i.e. high market concentration and capital costs that create barriers to
entry into it), there can be decreases as well as increases in the level of
concentration. However, how this happens is significant. New companies can
usually only enter under four conditions:

1) They have enough capital available to them to pay for set-up costs and any
initial losses. This can come from two main sources, from other parts of their
company (e.g. Virgin going into the cola business) or large firms from other
areas/nations enter the market. The former is part of the diversification
process associated with Big Business and the second is the globalisation of
markets resulting from pressures on national oligopolies (see [section
C.4](secC4.html)). Both of which increases competition within a given market
for a period as the number of firms in its oligopolistic sector has increased.
Over time, however, market forces will result in mergers and growth,
increasing the degree of monopoly again.

2) They get state aid to protect them against foreign competition until such
time as they can compete with established firms and, critically, expand into
foreign markets: _"Historically,"_ notes Lazonick, _"political strategies to
develop national economies have provided critical protection and support to
overcome . . . barriers to entry."_ [**Op. Cit.**, p. 87] An obvious example
of this process is, say, the 19th century US economy or, more recently the
South East Asian "Tiger" economies (these having _"an intense and almost
unequivical commitment on the part of government to build up the international
competitiveness of domestic industry"_ by creating _"policies and
organisations for governing the market."_ [Robert Wade, **Governing the
Market**, p. 7]).

3) Demand exceeds supply, resulting in a profit level which tempts other big
companies into the market or gives smaller firms already there excess profits,
allowing them to expand. Demand still plays a limiting role in even the most
oligopolistic market (but this process hardly decreases barriers to
entry/mobility or oligopolistic tendencies in the long run).

4) The dominant companies raise their prices too high or become complacent and
make mistakes, so allowing other big firms to undermine their position in a
market (and, sometimes, allow smaller companies to expand and do the same).
For example, many large US oligopolies in the 1970s came under pressure from
Japanese oligopolies because of this. However, as noted in [section
C.4.2](secC4.html#secc42), these declining oligopolies can see their market
control last for decades and the resulting market will still be dominated by
oligopolies (as big firms are generally replaced by similar sized, or bigger,
ones).

Usually some or all of these processes are at work at once and some can have
contradictory results. Take, for example, the rise of "globalisation" and its
impact on the "degree of monopoly" in a given national market. On the national
level, "degree of monopoly" may fall as foreign companies invade a given
market, particularly one where the national producers are in decline (which
has happened to a small degree in UK manufacturing in the 1990s, for example).
However, on the international level the degree of concentration may well have
risen as only a few companies can actually compete on a global level.
Similarly, while the "degree of monopoly" within a specific national market
may fall, the balance of (economic) power within the economy may shift towards
capital and so place labour in a weaker position to advance its claims (this
has, undoubtedly, been the case with "globalisation" -- see [section
D.5.3](seD5.html#secd53)).

Let us consider the US steel industry as an example. The 1980s saw the rise of
the so-called "mini-mills" with lower capital costs. The mini-mills, a new
industry segment, developed only after the US steel industry had gone into
decline due to Japanese competition. The creation of Nippon Steel, matching
the size of US steel companies, was a key factor in the rise of the Japanese
steel industry, which invested heavily in modern technology to increase steel
output by 2,216% in 30 years (5.3 million tons in 1950 to 122.8 million by
1980). By the mid 1980s, the mini-mills and imports each had a quarter of the
US market, with many previously steel-based companies diversifying into new
markets.

Only by investing $9 billion to increase technological competitiveness,
cutting workers wages to increase labour productivity, getting relief from
stringent pollution control laws and (very importantly) the US government
restricting imports to a quarter of the total home market could the US steel
industry survive. The fall in the value of the dollar also helped by making
imports more expensive. In addition, US steel firms became increasingly linked
with their Japanese "rivals," resulting in increased centralisation (and so
concentration) of capital.

Therefore, only because competition from foreign capital created space in a
previously dominated market, driving established capital out, combined with
state intervention to protect and aid home producers, was a new segment of the
industry able to get a foothold in the local market. With many established
companies closing down and moving to other markets, and once the value of the
dollar fell which forced import prices up and state intervention reduced
foreign competition, the mini-mills were in an excellent position to increase
US market share. It should also be noted that this period in the US steel
industry was marked by increased "co-operation" between US and Japanese
companies, with larger companies the outcome. This meant, in the case of the
mini-mills, that the cycle of capital formation and concentration would start
again, with bigger companies driving out the smaller ones through competition.

Nor should we assume that an oligopolistic markets mean the end of all small
businesses. Far from it. Not only do small firms continue to exist, big
business itself may generate same scale industry around it (in the form of
suppliers or as providers of services to its workers). We are not arguing that
small businesses do not exist, but rather than their impact is limited
compared to the giants of the business world. In fact, within an oligopolistic
market, existing small firms always present a problem as some might try to
grow beyond their established niches. However, the dominant firms will often
simply purchase the smaller one firm, use its established relationships with
customers or suppliers to limit its activities or stand temporary losses and
so cut its prices below the cost of production until it runs competitors out
of business or establishes its price leadership, before raising prices again.

As such, our basic point is **not** dependent on any specific tendency of the
degree of monopoly. It can fall somewhat as, say, six large firms come to
dominate a market rather than, say, four. The fact remains that barriers to
competition remain strong and deny any claims that any real economy reflects
the "perfect competition" of the textbooks. So, while the actual companies
involved may change over time, the economy as a whole will always be marked by
Big Business due to the nature of capitalism. That's the way capitalism works
-- profits for the few at the expense of the many.

[‹ C.5 Why does Big Business get a bigger slice of profits?](/afaq/secC5.html
"Go to previous page" ) [up](/afaq/secCcon.html "Go to parent page" ) [C.7
What causes the capitalist business cycle? ›](/afaq/secC7.html "Go to next
page" )

