/*--- adesklets.h --------------------------------------------------------------
Copyright (C) 2004, 2005, 2006 Sylvain Fourmanoit <syfou@users.sourceforge.net>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.   
------------------------------------------------------------------------------*/
#ifndef HAVE_ADESKLETS_H
#define HAVE_ADESKLETS_H

#ifndef HAVE_CONFIG_H
#error Autogenerated config.h should be used.
#endif

/*----------------------------------------------------------------------------*/
#include "config.h"			/* Autoconf */

#include "command.h"			/* ID related includes  */
#include "event.h"

#include "xwindow.h"			/* All graphics-related includes */

#ifdef HAVE_SYS_TYPES_H			/* stat() */
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_UNISTD_H			/* Fork(), exec*(), isatty(), */
#include <unistd.h>                     /* getppid() and other system calls */
#endif

#ifdef HAVE_SIGNAL_H			/* kill() */
#include <signal.h>
#endif 

#ifdef HAVE_TIME_H
#include <time.h>
#endif

#ifdef HAVE_LIBGEN_H			/* basename() */
#include <libgen.h>
#endif

#ifdef HAVE_STRING_H			/* strncpy(), strlen(), etc */
#include <string.h>
#endif

#ifdef HAVE_STDARG_H			/* va_start(), va_arg(), etc */
#include <stdarg.h>
#endif

#ifdef HAVE_MATH_H			/* lrint(), lrintf(), round() */
#include <math.h>
#endif

#include "types.h"			/* Various typedef */
#include "error.h"			/* Error wrapper */
#include "vector.h"			/* Small vector API */
#include "vector_free.h"                /* Vector free functions */
#include "tree.h"                       /* Small tree API */

#include "xmenu.h"			/* X Windows menu API */

#include "cfgfile.h"			/* Configuration file management */
#include "variable.h"			/* Textual variable functions */

/*----------------------------------------------------------------------------*/
#define MENU(i) ((xmenu*)adesklets.menus->content[i])

/*----------------------------------------------------------------------------*/
typedef struct s_adesklets {
  pid_t          ppid;                 /* Parent process ID */
  Display      * display;              /* Display handle */
  Visual       * visual;	       /* Visual handle */
  Window         root;                 /* Root window */
  Window         window;	       /* Window ID */
  int            depth;                /* Visual depth */
  int            transparency;         /* Set up auto transparency */
  int            background_grab;      /* Set up auto background grab */
  int            user_background_image;/* Set up user background image */
  int            managed;              /* Set up managed/unmanaged status */
  long           event_mask;           /* Main window event mask */
  long           user_event_mask;      /* Mask of events sent back to user */
  cfgfile_item * params;               /* Configuration information: 
					  id, screen,x,y */ 
  vector       * menus;                /* Vector of menus ref. */
  vector       * images;               /* Vector of Imlib_Images ref. */
  vector       * fonts;                /* Vector of Imlib_Font ref. */
  vector       * color_ranges;         /* Vector of Imlib_Color_Range ref. */
  vector       * color_modifiers;      /* Vector of Imlib_Color_Modifier */
  vector       * filters;              /* Vector of Imlib_Filter */
  vector       * polygons;             /* Vector of ImlibPolygon ref. */
  vector       * variables;            /* Vector of var_item ref. */
  char           
    lock_filename[CFGFILE_NAME_SIZE];  /* File name of the lock */
  FILE         * lock;                 /* Lock file */
  int            quit_flag;	       /* Signal urge to quit */
  int            restart_flag; 	       /* Signal urge to restart */
  int            user_quit_flag;       /* Signal quit was triggered 
					  by the user */
} t_adesklets;

/*----------------------------------------------------------------------------*/
extern t_adesklets adesklets;

/*----------------------------------------------------------------------------*/
/* Global interpreter initialisation: display, window, fonts
 */
int adesklets_init(int,char**);

/*----------------------------------------------------------------------------*/
/* Event loop for the main window.
   NOTE: this function is espected to be run if an only if adesklets_init()
   has been successful.
*/
void adesklets_events_loop(void);

/*----------------------------------------------------------------------------*/
/* Global interpreter cleanup: display, lock file, window, fonts
   The restart flag passed to this function makes adesklets
   send a SIG_KILL to parent process if applicable (presence
   of a lock file).
 */
int adesklets_free(void);

/*----------------------------------------------------------------------------*/
/* Test if a given filename is referring to an existing, 
   executable file for current user; if integer flag is given,
   also verify that filename is absolute.
   Returns 1 on success, 0 on failure.

   Warning: This function requires the file to be r+x for adesklets: 
            this is a simple way to avoid executable but unreadable scripts.
 */
int adesklets_valid_desklet(char*,int);

/*----------------------------------------------------------------------------*/
#endif
