// $Id: ClientApp.h 76591 2007-01-25 18:17:52Z elliott_c $
#ifndef CLIENTAPP_H
#define CLIENTAPP_H

#include "TestAppBase.h"
#include "ClientEngine.h"
#include "ServantList_T.h"
#include "Callback_i.h"
#include "ClientTask.h"
#include "tao/CSD_ThreadPool/CSD_TP_Strategy.h"
#include "tao/ORB.h"
#include "ace/SString.h"


class ClientApp : public TestAppBase
{
  public:

    ClientApp();
    virtual ~ClientApp();

  protected:

    virtual int run_i(int argc, char* argv[]);


  private:

    // These are all called, in order, by the run_i() method.
    int init(int argc, char* argv[]);
    void poa_setup(void);
    void csd_setup(void);
    void client_setup(void);
    void poa_activate(void);
    void run_clients(void);
    void run_orb_event_loop(void);
    bool check_validity ();
    void cleanup();

    // Helper methods used by the methods above.
    int parse_args(int argc, char* argv[]);

    int set_arg(unsigned&   value,
                 const char* arg,
                 char        opt,
                 const char* name,
                 int         min = 0);

    void usage_statement();
    int arg_dependency_checks();

    PortableServer::POA_ptr create_poa(CORBA::ORB_ptr orb,
                                       const char* poa_name);


    typedef ServantList<Callback_i> ServantListType;

    CORBA::ORB_var               orb_;
    PortableServer::POA_var      poa_;
    TAO::CSD::TP_Strategy_Handle tp_strategy_;

    ServantListType servants_;

    ClientTask client_task_;

    ACE_CString exe_name_;

    unsigned num_servants_;
    unsigned num_csd_threads_;
    unsigned num_orb_threads_;

    ACE_CString         ior_;
    unsigned            client_kind_;
    unsigned            client_id_;
};

#endif
