// Timer_Reactor.cpp,v 1.6 2005/01/05 11:47:20 jwillemsen Exp

#include "Timer_Reactor.h"

ACE_RCSID(Notify, TAO_Notify_Timer_Reactor, "Timer_Reactor.cpp,v 1.6 2005/01/05 11:47:20 jwillemsen Exp")

#include "ace/Reactor.h"
#include "tao/ORB_Core.h"
#include "Properties.h"

TAO_Notify_Timer_Reactor::TAO_Notify_Timer_Reactor (void)
  :reactor_ (0)
{
  // Get the ORB
  CORBA::ORB_var orb = TAO_Notify_PROPERTIES::instance()->orb ();

  this->reactor_ =  orb->orb_core ()->reactor ();
}

TAO_Notify_Timer_Reactor::~TAO_Notify_Timer_Reactor ()
{
}

void
TAO_Notify_Timer_Reactor::release (void)
{
  delete this;
  //@@ inform factory
}

long
TAO_Notify_Timer_Reactor::schedule_timer (ACE_Event_Handler *handler,
                               const ACE_Time_Value &delay_time,
                               const ACE_Time_Value &interval)
{
  return  this->reactor_->schedule_timer (handler, 0, delay_time, interval);
}

int
TAO_Notify_Timer_Reactor::cancel_timer (long timer_id)
{
  return this->reactor_->cancel_timer (timer_id);
}
