// FT_Endpoint_Selector_Factory.cpp,v 1.7 2003/11/17 22:56:13 wilson_d Exp

#include "FT_Endpoint_Selector_Factory.h"
#include "FT_Invocation_Endpoint_Selectors.h"
#include "tao/Exception.h"
#include "tao/Environment.h"

ACE_RCSID(FaultTolerance, FT_Endpoint_Selector_Factory, "FT_Endpoint_Selector_Factory.cpp,v 1.7 2003/11/17 22:56:13 wilson_d Exp")

TAO_FT_Endpoint_Selector_Factory::TAO_FT_Endpoint_Selector_Factory (void)
  :ft_endpoint_selector_ (0)
{
}

TAO_FT_Endpoint_Selector_Factory::~TAO_FT_Endpoint_Selector_Factory (void)
{
  if (this->ft_endpoint_selector_)
    delete this->ft_endpoint_selector_;
}


TAO_Invocation_Endpoint_Selector *
TAO_FT_Endpoint_Selector_Factory::get_selector (
    ACE_ENV_SINGLE_ARG_DECL)
{
    if (this->ft_endpoint_selector_ == 0)
    {
      ACE_MT (ACE_GUARD_RETURN  (TAO_SYNCH_MUTEX,
                                 guard,
                                 this->mutex_,
                                 0));

      // Double checked locking..
      if (this->ft_endpoint_selector_ == 0)
        {
          ACE_NEW_THROW_EX (ft_endpoint_selector_,
                            TAO_FT_Invocation_Endpoint_Selector (),
                            CORBA::NO_MEMORY ());
        }
    }

  return this->ft_endpoint_selector_;
}

// ****************************************************************

ACE_STATIC_SVC_DEFINE (TAO_FT_Endpoint_Selector_Factory,
                       ACE_TEXT ("FT_Endpoint_Selector_Factory"),
                       ACE_SVC_OBJ_T,
                       &ACE_SVC_NAME (TAO_FT_Endpoint_Selector_Factory),
                       ACE_Service_Type::DELETE_THIS | ACE_Service_Type::DELETE_OBJ,
                       0)
ACE_FACTORY_DEFINE (TAO_FT_ClientORB, TAO_FT_Endpoint_Selector_Factory)
