/*********************************************************
 * Copyright (C) 2007 VMware, Inc. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2 and no later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 *
 *********************************************************/

/* upt1_defs.h
 *
 *      Definitions for UPTv1
 */

#ifndef _UPT1_DEFS_H
#define _UPT1_DEFS_H

#define UPT1_MAX_TX_QUEUES  64
#define UPT1_MAX_RX_QUEUES  64

#define UPT1_MAX_INTRS  (UPT1_MAX_TX_QUEUES + UPT1_MAX_RX_QUEUES)

typedef
#include "vmware_pack_begin.h"
struct UPT1_RingDesc {
   uint64 basePA;    /* physical addr of the ring */
   uint16 size;      /* # of descriptors */
   uint16 prodIdx;   /* index of the descriptor the producer of the ring 
                      * will write to next */
   uint16 consIdx;   /* index of the descriptor the consumer of the ring 
                      * will read next */
   uint16 pad;
}
#include "vmware_pack_end.h"
UPT1_RingDesc;

typedef
#include "vmware_pack_begin.h"
struct UPT1_TxStats {
   uint64 TSOPktsTxOK;  /* TSO pkts post-segmentation */
   uint64 TSOBytesTxOK;
   uint64 ucastPktsTxOK;
   uint64 ucastBytesTxOK;
   uint64 mcastPktsTxOK;
   uint64 mcastBytesTxOK;
   uint64 bcastPktsTxOK;
   uint64 bcastBytesTxOK;
   uint64 pktsTxError;
   uint64 pktsTxDiscard;
}
#include "vmware_pack_end.h"
UPT1_TxStats;

typedef
#include "vmware_pack_begin.h"
struct UPT1_TxQueueState {
   UPT1_RingDesc txRing;
   UPT1_RingDesc dataRing;
   UPT1_RingDesc compRing;
   uint8         tcGen;    /* value of the TCGEN register */
   uint8         intrIdx;  /* which MSI/MSI-X vector to use for the tx queue */
   Bool          stopped;  /* is the queue stopped? */
   uint8         pad;
   uint32        error;    /* error code if the queue is stopped due to error */
   UPT1_TxStats  stats;    /* stats for the tx queue */
}
#include "vmware_pack_end.h"
UPT1_TxQueueState;

typedef
#include "vmware_pack_begin.h"
struct UPT1_RxStats {
   uint64 LROPktsRxOK;    /* LRO pkts */
   uint64 LROBytesRxOK;   /* bytes from LRO pkts */
   /* the following counters are for pkts from the wire, i.e., pre-LRO */
   uint64 ucastPktsRxOK;
   uint64 ucastBytesRxOK;
   uint64 mcastPktsRxOK;
   uint64 mcastBytesRxOK;
   uint64 bcastPktsRxOK;
   uint64 bcastBytesRxOK;
   uint64 pktsRxOutOfBuf;
   uint64 pktsRxError;
}
#include "vmware_pack_end.h"
UPT1_RxStats;

typedef
#include "vmware_pack_begin.h"
struct UPT1_RxQueueState {
   UPT1_RingDesc rxRing[2];
   UPT1_RingDesc compRing;
   uint8         rcGen;     /* value of the RCGEN register */
   uint8         intrIdx;   /* which MSI/MSI-X vector to use for the rx queue */
   Bool          stopped;   /* is the queue stopped? */
   uint8         pad;
   uint32        error;     /* error code if the queue is stopped due to error */
   UPT1_RxStats  stats;     /* stats for the rx queue */
}
#include "vmware_pack_end.h"
UPT1_RxQueueState;

/* physical dev intr type */
typedef enum {
   UPT1_IT_MSI = 1,
   UPT1_IT_MSIX
} UPT1_IntrType;

/* interrupt moderation level */
#define UPT1_IML_NONE     0 /* no interrupt moderation */
#define UPT1_IML_HIGHEST  7 /* least intr generated */
#define UPT1_IML_ADAPTIVE 8 /* adpative intr moderation */

typedef struct UPT1_IntrState {
   UPT1_IntrType type;
   Bool  autoMask;
   uint8 numIntrs;      /* # of MSI/MSI-X vectors allocated */
   uint8 *modLevels;    /* interrupt moderation level */
   uint8 *imr;          /* IMR register values */
} UPT1_IntrState;

/* values for UPT1_RSSConf.hashFunc */
#define UPT1_RSS_HASH_TYPE_NONE      0x0
#define UPT1_RSS_HASH_TYPE_IPV4      0x01
#define UPT1_RSS_HASH_TYPE_TCP_IPV4  0x02
#define UPT1_RSS_HASH_TYPE_IPV6      0x04
#define UPT1_RSS_HASH_TYPE_TCP_IPV6  0x08

#define UPT1_RSS_HASH_FUNC_NONE      0x0
#define UPT1_RSS_HASH_FUNC_TOEPLITZ  0x01

#define UPT1_RSS_MAX_KEY_SIZE        40
#define UPT1_RSS_MAX_IND_TABLE_SIZE  128

typedef 
#include "vmware_pack_begin.h"
struct UPT1_RSSConf {
   uint16   hashType;
   uint16   hashFunc;
   uint16   hashKeySize;
   uint16   indTableSize;
   uint8    hashKey[UPT1_RSS_MAX_KEY_SIZE];
   uint8    indTable[UPT1_RSS_MAX_IND_TABLE_SIZE];
}
#include "vmware_pack_end.h"
UPT1_RSSConf;

/* features */
#define UPT1_F_RXCSUM      0x0001   /* rx csum verification */
#define UPT1_F_RSS         0x0002
#define UPT1_F_RXVLAN      0x0004   /* VLAN tag stripping */
#define UPT1_F_LRO         0x0008

#endif
