/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.MergingMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class UpToDate
extends MatchingTask {
    private String _property;
    private File _targetFile;
    private Vector sourceFileSets = new Vector();
    protected Mapper mapperElement = null;

    public void setProperty(String string) {
        this._property = string;
    }

    public void setTargetFile(File file) {
        this._targetFile = file;
    }

    public void addSrcfiles(FileSet fileSet) {
        this.sourceFileSets.addElement(fileSet);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.location);
        }
        this.mapperElement = new Mapper(this.project);
        return this.mapperElement;
    }

    public void execute() throws BuildException {
        if (this.sourceFileSets.size() == 0) {
            throw new BuildException("At least one <srcfiles> element must be set");
        }
        if (this._targetFile == null && this.mapperElement == null) {
            throw new BuildException("The targetfile attribute or a nested mapper element must be set");
        }
        if (this._targetFile != null && !this._targetFile.exists()) {
            return;
        }
        Enumeration enumeration = this.sourceFileSets.elements();
        boolean bl = true;
        while (bl && enumeration.hasMoreElements()) {
            FileSet fileSet = (FileSet)enumeration.nextElement();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            boolean bl2 = bl = bl && this.scanDir(fileSet.getDir(this.project), directoryScanner.getIncludedFiles());
        }
        if (bl) {
            this.project.setProperty(this._property, "true");
            if (this.mapperElement == null) {
                this.log("File \"" + this._targetFile.getAbsolutePath() + "\" is up to date.", 3);
            } else {
                this.log("All target files have been up to date.", 3);
            }
        }
    }

    protected boolean scanDir(File file, String[] stringArray) {
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        FileNameMapper fileNameMapper = null;
        if (this.mapperElement == null) {
            MergingMapper mergingMapper = new MergingMapper();
            mergingMapper.setTo(this._targetFile.getAbsolutePath());
            fileNameMapper = mergingMapper;
        } else {
            fileNameMapper = this.mapperElement.getImplementation();
        }
        return sourceFileScanner.restrict(stringArray, file, null, fileNameMapper).length == 0;
    }
}

