/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Reference;

public abstract class DataType {
    protected String description = null;
    protected Reference ref = null;
    protected boolean checked = true;

    protected BuildException circularReference() {
        return new BuildException("This data type contains a circular reference.");
    }

    protected void dieOnCircularReference(Stack stk, Project p) throws BuildException {
        if (this.checked || !this.isReference()) {
            return;
        }
        Object o = this.ref.getReferencedObject(p);
        if (o instanceof DataType) {
            if (stk.contains(o)) {
                throw this.circularReference();
            }
            stk.push(o);
            ((DataType)o).dieOnCircularReference(stk, p);
            stk.pop();
        }
        this.checked = true;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isReference() {
        return this.ref != null;
    }

    protected BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested elements when using refid");
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setRefid(Reference ref) {
        this.ref = ref;
        this.checked = false;
    }

    protected BuildException tooManyAttributes() {
        return new BuildException("You must not specify more than one attribute when using refid");
    }
}

