/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PathTokenizer {
    private StringTokenizer tokenizer;
    private String lookahead = null;
    private boolean dosStyleFilesystem;

    public PathTokenizer(String path) {
        this.tokenizer = new StringTokenizer(path, ":;", false);
        this.dosStyleFilesystem = File.pathSeparatorChar == ';';
    }

    public boolean hasMoreTokens() {
        if (this.lookahead != null) {
            return true;
        }
        return this.tokenizer.hasMoreTokens();
    }

    public String nextToken() throws NoSuchElementException {
        String token = null;
        if (this.lookahead != null) {
            token = this.lookahead;
            this.lookahead = null;
        } else {
            token = this.tokenizer.nextToken().trim();
        }
        if (token.length() == 1 && Character.isLetter(token.charAt(0)) && this.dosStyleFilesystem && this.tokenizer.hasMoreTokens()) {
            String nextToken = this.tokenizer.nextToken().trim();
            if (nextToken.startsWith("\\") || nextToken.startsWith("/")) {
                token = String.valueOf(token) + ":" + nextToken;
            } else {
                this.lookahead = nextToken;
            }
        }
        return token;
    }
}

