/* GrinvinUtilities.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.util;

import java.awt.Font;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;

/**
 * A collection of utility methods for GrInvIn.
 */
public class GrinvinUtilities {
    
    /**
     * Returns true if the mouse event specifies a multiple select.
     * This means that the left mouse button is used and the control key
     * is down on Windows or the command key is down on Mac.
     *
     * @param anEvent  a MouseEvent object
     * @return true if this event specifies a multiple select
     */
    public static boolean isMultipleSelectionEvent(MouseEvent anEvent) {
         return (anEvent.getButton() == anEvent.BUTTON1) && ((anEvent.isControlDown() && !anEvent.isPopupTrigger()) || anEvent.isMetaDown());   
    }
    
    /**
     * Returns a string containing a style sheet that sets the font to
     * the font specified by the given key in the defaults table.
     *
     * @param fontKey a String that is the key of a certain font in the defaults table
     * @return a String containing the content of a style sheet
     */
    public static String getStyleSheetForFont(String fontKey){
        Font font = UIManager.getFont(fontKey);
        StringBuilder style = new StringBuilder();
        if(font!=null){
            //set font-family
            style.append("font-family: ");
            style.append(font.getFamily());
            style.append(";");
            
            //set font-size
            style.append("font-size: ");
            style.append(font.getSize());
            style.append(";");

            //set font-weight
            if(font.isBold())
                style.append("font-weight: bold;");

            //set font-style
            if(font.isItalic())
                style.append("font-style: italic;");
        }
        return style.toString();
    }
}
