/* AnnotationLoader.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io.graphs;

import java.io.IOException;
import java.io.InputStream;

import org.grinvin.graphs.Annotation;
import org.grinvin.graphs.GraphView;
import org.grinvin.io.IOFormatException;
import org.grinvin.io.LoaderSaverHelper;

import org.jdom.Element;

/**
 *
 */
public class AnnotationLoader {
    
    //
    private AnnotationLoader() { }
    
    /**
     * Construct the annotation for the current graph from the given JDOM element.
     */
    private static void toAnnotation(Annotation annotation, Element element) throws IOFormatException {
        GraphView graph = annotation.getPeer();
        //vertices
        for (Object obj: element.getChildren("vertex")) {
            Element c = (Element)obj;
            int id = Integer.parseInt(c.getAttributeValue("id"));
            String text = c.getAttributeValue("text");
            annotation.setAnnotation(graph.getVertex(id), text);
        }
        
        //edges
        for (Object obj: element.getChildren("edge")) {
            Element c = (Element)obj;
            int from = Integer.parseInt(c.getAttributeValue("from"));
            int to = Integer.parseInt(c.getAttributeValue("to"));
            String text = c.getAttributeValue("text");
            annotation.setAnnotation(graph.getEdge(graph.getVertex(from), graph.getVertex(to)), text);
        }
    }
    
    /**
     * Load the annotation from the input stream.
     */
    public static void load(Annotation annotation, InputStream input) throws IOException {
        toAnnotation(annotation, LoaderSaverHelper.loadElement(input));
    }

    public static void load(Annotation annotation, Element element) throws IOException {
        toAnnotation(annotation, LoaderSaverHelper.checkElement(element, "annotation"));
    }

}
