/* GeneratorMap.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.grinvin.factories.FactoryManager;
import org.grinvin.generators.graphs.GraphGenerator;

/**
 * Provides the mapping of the context-sensitive help ID of generators and
 * the URL for their help page.
 */
public class GeneratorMap extends DefaultMap {
    
    private static final GeneratorMap SINGLETON = new GeneratorMap();
    
    public static GeneratorMap getInstance() {
        return SINGLETON;
    }
    
    /**
     * Maps a generator identifier to the corresponding name of the generator.
     */
    private final java.util.Map<String, String> generatornames;
    
    public String getGeneratorNameForID(String id) {
        return generatornames.get(id);
    }
    
    private GeneratorMap(){
        List<String> generatorids = new ArrayList<String>();
        generatornames = new HashMap<String, String>();
        for (String id: FactoryManager.getGeneratorBroker().getIds()) {
            GraphGenerator generator = FactoryManager.getGeneratorBroker().get(id);
            generatorids.add(id);
            generatornames.put(id, generator.getLongName());
        }
        setIDList(generatorids);
        setURLPrefix("generator:");
    }
}
