package com.icl.saxon.fop;
import com.icl.saxon.output.ContentHandlerProxy;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import javax.xml.transform.TransformerException;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.Options;
import org.apache.fop.apps.FOPException;
import java.util.Properties;
import java.io.File;

/**
  * FOPEmitter: This class acts as a SAXON output emitter that feeds data into Apache
  * FOP (see http://xml.apache.org/fop).
  * March 2001: repackaged into a new package, com.icl.saxon.fop, and excluded from the
  * JAR file, to avoid problems with external references. The class is now loaded
  * dynamically when required.
  * Sept 2001: changed to cope with the latest FOP API changes in FOP 0.20.1
  */
  
public class FOPEmitter extends ContentHandlerProxy 
{
    public static String FOP_RENDERER = "{http://icl.com/saxon/fop}renderer";
    public static String FOP_CONFIGURATION = "{http://icl.com/saxon/fop}configuration";

    private Driver fop;

    /**
    * Determine whether the Emitter wants a Writer for character output or
    * an OutputStream for binary output: FOPEmitter wants an OutputStream
    */
    
    public boolean usesWriter() {
        return false;
    }

    /**
    * Start of document processing
    */

    public void startDocument() throws TransformerException {
        fop = new Driver();

        ContentHandler ch = fop.getContentHandler();
        
        Properties props = getOutputProperties();
        String renderer = props.getProperty(FOP_RENDERER);
        if (renderer == null) {
	        fop.setRenderer(Driver.RENDER_PDF);
	    } else {
	        fop.setRenderer(renderer);
	    }
	    // next statement needed by FOP 0.20.1
	    ((org.apache.fop.fo.FOTreeBuilder)ch).setStreamRenderer(
	        new org.apache.fop.apps.StreamRenderer(outputStream, fop.getRenderer()));
	    
	    String options = props.getProperty(FOP_CONFIGURATION);
	    if (options != null) {
	        try {
	            System.setProperty("org.xml.sax.parser", "com.icl.saxon.aelfred.SAXDriver");
	            Options fopOptions = new Options(new File(options));
	            // instantiating this class updates FOP's static configuration data
	        } catch (org.apache.fop.apps.FOPException err) {
	            throw new TransformerException(err);
	        }
	    }

        setUnderlyingContentHandler(ch);
        super.startDocument();
    }

    /**
    * End of document processing
    */

    public void endDocument() throws TransformerException {
        super.endDocument();
        // following code no longer needed: FOP 0.20.1 deals with endDocument() automatically.
        //try {
        //    fop.setOutputStream(outputStream);
        //    fop.format();
        //    fop.render();
        //} catch (FOPException err) {
        //    throw new TransformerException("Error from FOP: ", err);
        //} catch (java.io.IOException err) {
        //    throw new TransformerException("I/O Error from FOP: ", err);
        //} catch (Throwable err) {
        //    throw new TransformerException("FOP processing error: " + err.getMessage());
        //}
    }

}

//
// The contents of this file are subject to the Mozilla Public License Version 1.0 (the "License");
// you may not use this file except in compliance with the License. You may obtain a copy of the
// License at http://www.mozilla.org/MPL/ 
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the License for the specific language governing rights and limitations under the License. 
//
// The Original Code is: all this file. 
//
// The Initial Developer of the Original Code is
// Michael Kay of International Computers Limited (mhkay@iclway.co.uk).
//
// Portions created by (your name) are Copyright (C) (your legal entity). All Rights Reserved. 
//
// Contributor(s): none. 
//
