package org.apache.commons.httpclient;

import java.io.*;
import org.apache.commons.logging.*;

/**
 * Logs all data read to the wire log.
 *
 * @author Ortwin Glck
 * @since 2.0
 */

public class WireLogInputStream extends FilterInputStream {
    /** Log for any wire messages. */
    private static final Log wireLog = LogFactory.getLog("httpclient.wire");

    public WireLogInputStream(InputStream in) {
        super(in);
    }

    public int read(byte[] b, int off, int len) throws java.io.IOException {
        int l = super.read(b,  off,  len);
        wireLog.debug("<< "+ new String(b, off, len));
        return l;
    }

    public int read() throws java.io.IOException {
        int l = super.read();
        if (l > 0) wireLog.debug("<< "+ (char) l);
        return l;
    }

    public int read(byte[] b) throws java.io.IOException {
        int l = super.read(b);
        wireLog.debug("<< "+ new String(b));
        return l;
    }
}