/*
 * $Header: /home/cvspublic/jakarta-commons/httpclient/src/java/org/apache/commons/httpclient/HttpSharedState.java,v 1.4 2002/07/28 18:08:57 jsdever Exp $
 * $Revision: 1.4 $
 * $Date: 2002/07/28 18:08:57 $
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "HttpClient", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

package org.apache.commons.httpclient;

import java.util.Date;

/**
 * HttpSharedState provides synchronized access to HttpState so
 * that the state can be used in calls to HttpMultiClient.executeMethod()
 * on multiple threads.
 *
 * @author Marc A. Saegesser
 */
public class HttpSharedState extends HttpState {
    /**
     * No-args constructor.
     */
    public HttpSharedState() {
        super();
    }

    /**
     * Synchronizes HttpState.addCookie().
     *
     * @param cookie - the Cookie to add.
     */
    public synchronized void addCookie(Cookie cookie) {
        super.addCookie(cookie);
    }

    /**
     * Synchronizes HttpState.addCookies().
     *
     * @param newCookies - an array of cookies to add.
     */
    public synchronized void addCookies(Cookie[] newCookies) {
        super.addCookies(newCookies);
    }

    /**
     * Synchronizes HttpState.getCookies().
     *
     * @return an array containing all the cookies
     */
    public synchronized Cookie[] getCookies() {
        return super.getCookies();
    }

    /**
     * Synchronizes HttpState.getCookies().
     *
     * @return all cookies matching the given parameters.
     */
    public synchronized Cookie[] getCookies(String domain, int port, 
        String path, boolean secure, Date now) {
        return super.getCookies(domain, port, path, secure, now);
    }

    /**
     * Synchronizes HttpState.purgeExpiredCookies(Date).
     * 
     * @param date - purge cookies prior to this date.
     * @return true if at least one cookie was purged.
     */
    public synchronized boolean purgeExpiredCookies(Date date) {
        return super.purgeExpiredCookies(date);
    }

    /**
     * Synchronizes HttpState.setCredentials().
     *
     * @param realm - the authentication realm
     * @param credentials - the authentication credentials
     */
    public synchronized void setCredentials(String realm, 
        Credentials credentials) {
        super.setCredentials(realm, credentials);
    }


    /**
     * Synchronizes HttpState.getCredentials().
     * 
     * @param realm - the authorization realm.
     * @return the authorizations credentials for the given realm
     */
    public synchronized Credentials getCredentials(String realm) {
        return super.getCredentials(realm);
    }

}
