/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.io.StringReader;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.parser.LengthHandler;
import org.apache.batik.parser.LengthParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.util.resources.Messages;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGElement;

public abstract class UnitProcessor {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;

    protected UnitProcessor() {
    }

    public static float cssToUserSpace(short s, float f, SVGElement sVGElement, short s2, Context context) throws RuntimeException {
        if (s == 1) {
            return f;
        }
        float f2 = context.getPixelToMM();
        switch (s) {
            case 5: {
                return f;
            }
            case 7: {
                return f / f2;
            }
            case 6: {
                return f * 10.0f / f2;
            }
            case 8: {
                return f * 25.4f / f2;
            }
            case 9: {
                return f * 25.4f / (72.0f * f2);
            }
            case 10: {
                return f * 25.4f / (6.0f * f2);
            }
            case 3: {
                return UnitProcessor.emsToPixels(f, sVGElement, s2, context);
            }
            case 4: {
                return UnitProcessor.exsToPixels(f, sVGElement, s2, context);
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(f, sVGElement, s2, context);
            }
        }
        throw new IllegalArgumentException(Messages.formatMessage("invalid.css.unit", new Object[]{new Integer(s)}));
    }

    public static float userSpaceToSVG(short s, float f, SVGElement sVGElement, short s2, Context context) throws RuntimeException {
        if (s == 1) {
            return f;
        }
        float f2 = context.getPixelToMM();
        switch (s) {
            case 5: {
                return f;
            }
            case 7: {
                return f * f2;
            }
            case 6: {
                return f * f2 / 10.0f;
            }
            case 8: {
                return f * f2 / 25.4f;
            }
            case 9: {
                return f * (72.0f * f2) / 25.4f;
            }
            case 10: {
                return f * (6.0f * f2) / 25.4f;
            }
            case 3: {
                return UnitProcessor.pixelsToEms(f, sVGElement, s2, context);
            }
            case 4: {
                return UnitProcessor.pixelsToExs(f, sVGElement, s2, context);
            }
            case 2: {
                return UnitProcessor.pixelsToPercentages(f, sVGElement, s2, context);
            }
        }
        throw new IllegalArgumentException(Messages.formatMessage("invalid.svg.unit", new Object[]{new Integer(s)}));
    }

    public static float svgToUserSpace(short s, float f, SVGElement sVGElement, short s2, Context context) throws RuntimeException {
        if (s == 1) {
            return f;
        }
        float f2 = context.getPixelToMM();
        switch (s) {
            case 5: {
                return f;
            }
            case 7: {
                return f / f2;
            }
            case 6: {
                return f * 10.0f / f2;
            }
            case 8: {
                return f * 25.4f / f2;
            }
            case 9: {
                return f * 25.4f / (72.0f * f2);
            }
            case 10: {
                return f * 25.4f / (6.0f * f2);
            }
            case 3: {
                return UnitProcessor.emsToPixels(f, sVGElement, s2, context);
            }
            case 4: {
                return UnitProcessor.exsToPixels(f, sVGElement, s2, context);
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(f, sVGElement, s2, context);
            }
        }
        throw new IllegalArgumentException(Messages.formatMessage("invalid.svg.unit", new Object[]{new Integer(s)}));
    }

    protected static float pixelsToEms(float f, SVGElement sVGElement, short s, Context context) {
        if (sVGElement == null) {
            throw new RuntimeException(Messages.formatMessage("element.needed", null));
        }
        CSSPrimitiveValue cSSPrimitiveValue = context.getFontSize(sVGElement);
        short s2 = cSSPrimitiveValue.getPrimitiveType();
        return f / UnitProcessor.cssToUserSpace(s2, cSSPrimitiveValue.getFloatValue(s2), (SVGElement)HiddenChildElementSupport.getParentElement(sVGElement), s, context);
    }

    protected static float emsToPixels(float f, SVGElement sVGElement, short s, Context context) {
        if (sVGElement == null) {
            throw new RuntimeException(Messages.formatMessage("element.needed", null));
        }
        CSSPrimitiveValue cSSPrimitiveValue = context.getFontSize(sVGElement);
        short s2 = cSSPrimitiveValue.getPrimitiveType();
        return f * UnitProcessor.cssToUserSpace(s2, cSSPrimitiveValue.getFloatValue(s2), (SVGElement)HiddenChildElementSupport.getParentElement(sVGElement), s, context);
    }

    protected static float pixelsToExs(float f, SVGElement sVGElement, short s, Context context) {
        if (sVGElement == null) {
            throw new RuntimeException(Messages.formatMessage("element.needed", null));
        }
        CSSPrimitiveValue cSSPrimitiveValue = context.getFontSize(sVGElement);
        short s2 = cSSPrimitiveValue.getPrimitiveType();
        float f2 = UnitProcessor.cssToUserSpace(s2, cSSPrimitiveValue.getFloatValue(s2), (SVGElement)HiddenChildElementSupport.getParentElement(sVGElement), s, context);
        float f3 = context.getXHeight(sVGElement);
        return f / f3 / f2;
    }

    protected static float exsToPixels(float f, SVGElement sVGElement, short s, Context context) {
        if (sVGElement == null) {
            throw new RuntimeException(Messages.formatMessage("element.needed", null));
        }
        CSSPrimitiveValue cSSPrimitiveValue = context.getFontSize(sVGElement);
        short s2 = cSSPrimitiveValue.getPrimitiveType();
        float f2 = UnitProcessor.cssToUserSpace(s2, cSSPrimitiveValue.getFloatValue(s2), (SVGElement)HiddenChildElementSupport.getParentElement(sVGElement), s, context);
        float f3 = context.getXHeight(sVGElement);
        return f * f3 * f2;
    }

    protected static float pixelsToPercentages(float f, SVGElement sVGElement, short s, Context context) {
        if (sVGElement == null) {
            throw new RuntimeException(Messages.formatMessage("element.needed", null));
        }
        if (s == 2) {
            float f2 = context.getViewportWidth();
            return f * 100.0f / f2;
        }
        if (s == 1) {
            float f3 = context.getViewportHeight();
            return f * 100.0f / f3;
        }
        double d = context.getViewportWidth();
        double d2 = context.getViewportHeight();
        double d3 = Math.sqrt(d * d + d2 * d2) / Math.sqrt(2.0);
        return (float)((double)(f * 100.0f) / d3);
    }

    protected static float percentagesToPixels(float f, SVGElement sVGElement, short s, Context context) {
        if (sVGElement == null) {
            throw new RuntimeException(Messages.formatMessage("element.needed", null));
        }
        if (s == 2) {
            float f2 = context.getViewportWidth();
            return f2 * f / 100.0f;
        }
        if (s == 1) {
            float f3 = context.getViewportHeight();
            return f3 * f / 100.0f;
        }
        double d = context.getViewportWidth();
        double d2 = context.getViewportHeight();
        double d3 = Math.sqrt(d * d + d2 * d2) / Math.sqrt(2.0);
        return (float)(d3 * (double)f / 100.0);
    }

    public static CSSPrimitiveValue getFontSize(SVGElement sVGElement, CSSStyleDeclaration cSSStyleDeclaration) {
        return (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("font-size");
    }

    public static float svgToUserSpace(String string, SVGElement sVGElement, short s, Context context) {
        if (string.length() == 0) {
            return 0.0f;
        }
        LengthParser lengthParser = new LengthParser();
        UnitResolver unitResolver = new UnitResolver();
        lengthParser.setLengthHandler(unitResolver);
        lengthParser.parse(new StringReader(string));
        return UnitProcessor.svgToUserSpace(unitResolver.unit, unitResolver.value, sVGElement, s, context);
    }

    public static interface Context {
        public float getPixelToMM();

        public float getMediumFontSize();

        public CSSPrimitiveValue getFontSize(SVGElement var1);

        public float getXHeight(SVGElement var1);

        public float getViewportWidth();

        public float getViewportHeight();
    }

    public static class UnitResolver
    implements LengthHandler {
        public float value;
        public short unit = 1;

        public void startLength() throws ParseException {
        }

        public void lengthValue(float f) throws ParseException {
            this.value = f;
        }

        public void em() throws ParseException {
            this.unit = (short)3;
        }

        public void ex() throws ParseException {
            this.unit = (short)4;
        }

        public void in() throws ParseException {
            this.unit = (short)8;
        }

        public void cm() throws ParseException {
            this.unit = (short)6;
        }

        public void mm() throws ParseException {
            this.unit = (short)7;
        }

        public void pc() throws ParseException {
            this.unit = (short)10;
        }

        public void pt() throws ParseException {
            this.unit = (short)9;
        }

        public void px() throws ParseException {
            this.unit = (short)5;
        }

        public void percentage() throws ParseException {
            this.unit = (short)2;
        }

        public void endLength() throws ParseException {
        }
    }
}

