/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.BuilderException;
import org.apache.batik.bridge.ConcreteGVTBuilder;
import org.apache.batik.bridge.DefaultUserAgent;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.gvt.GraphicsNodeTreeIterator;
import org.apache.batik.gvt.Selectable;
import org.apache.batik.gvt.Selector;
import org.apache.batik.gvt.event.AWTEventDispatcher;
import org.apache.batik.gvt.event.SelectionEvent;
import org.apache.batik.gvt.event.SelectionListener;
import org.apache.batik.gvt.renderer.DynamicRendererFactory;
import org.apache.batik.gvt.renderer.Renderer;
import org.apache.batik.gvt.renderer.RendererFactory;
import org.apache.batik.gvt.text.ConcreteTextSelector;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class JSVGCanvas
extends JComponent
implements ActionMap,
SelectionListener {
    public static final String UNZOOM_ACTION = "UnzoomAction";
    public static final String ZOOM_IN_ACTION = "ZoomInAction";
    public static final String ZOOM_OUT_ACTION = "ZoomOutAction";
    public static final Cursor PAN_CURSOR = new Cursor(13);
    public static final Cursor ZOOM_CURSOR = new Cursor(0);
    public static final Cursor ROTATE_CURSOR = new Cursor(0);
    public static final Cursor NORMAL_CURSOR = new Cursor(0);
    public static final Cursor WAIT_CURSOR = new Cursor(3);
    public static final Cursor TEXT_CURSOR = new Cursor(2);
    public Cursor requestedCursor = NORMAL_CURSOR;
    protected BufferedImage globalBuffer;
    protected BufferedImage buffer;
    protected GraphicsNode gvtRoot;
    protected RendererFactory rendererFactory;
    protected GVTBuilder builder;
    protected SVGDocument document;
    protected boolean bufferNeedsRendering;
    protected boolean isLoadPending = false;
    protected UserAgent userAgent;
    protected AffineTransform transform = new AffineTransform();
    protected AffineTransform panTransform;
    protected AffineTransform rotateTransform;
    protected AffineTransform previousRotateTransform;
    protected Shape docBBox = null;
    protected Line2D markerTop;
    protected Line2D markerLeft;
    protected Line2D markerBottom;
    protected Line2D markerRight;
    protected Shape rotateMarker;
    protected Shape selectionHighlightShape = null;
    private Shape canvasSpaceHighlightShape = null;
    protected ThumbnailCanvas thumbnailCanvas = null;
    protected Selector textSelector;
    protected ZoomHandler zoomHandler;
    protected double rotateAngle;
    protected double rotateCos = 1.0;
    protected double initialScale = 1.0;
    protected boolean progressiveRenderingEnabled = true;
    protected boolean documentTransformed;
    protected BasicStroke markerStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);
    protected Object loadPendingLock = new Object();
    private Thread backgroundRenderThread = null;
    private Thread backgroundBuilderThread = null;
    protected Map listeners = new HashMap();
    protected static Color selectionXORColor = Color.black;
    private static final int REPAINT_DONE = 0;
    private static final int REPAINT_THUMBNAIL_PENDING = 1;
    private RepaintState repaintState = new RepaintState(0);

    public JSVGCanvas() {
        this(new DefaultUserAgent());
    }

    public JSVGCanvas(UserAgent userAgent) {
        this.userAgent = userAgent;
        AWTEventDispatcher aWTEventDispatcher = (AWTEventDispatcher)this.userAgent.getEventDispatcher();
        if (aWTEventDispatcher != null) {
            this.addKeyListener(aWTEventDispatcher);
        }
        this.rendererFactory = new DynamicRendererFactory();
        this.builder = new ConcreteGVTBuilder();
        this.addComponentListener(new CanvasListener());
        MouseListener mouseListener = new MouseListener();
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.listeners.put(UNZOOM_ACTION, new UnzoomAction());
        this.listeners.put(ZOOM_IN_ACTION, new ZoomInAction());
        this.listeners.put(ZOOM_OUT_ACTION, new ZoomOutAction());
    }

    public void setRendererFactory(RendererFactory rendererFactory) {
        this.rendererFactory = rendererFactory;
        this.repaint();
    }

    public void setProgressiveRenderingEnabled(boolean bl) {
        this.progressiveRenderingEnabled = bl;
    }

    public boolean isProgressiveRenderingEnabled() {
        return this.progressiveRenderingEnabled;
    }

    public void setIsLoadPending(boolean bl) {
        Object object = this.loadPendingLock;
        synchronized (object) {
            this.isLoadPending = bl;
        }
    }

    public boolean isLoadPending() {
        Object object = this.loadPendingLock;
        synchronized (object) {
            boolean bl = this.isLoadPending;
            return bl;
        }
    }

    public void setZoomHandler(ZoomHandler zoomHandler) {
        this.zoomHandler = zoomHandler;
    }

    public RendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public void setSVGDocument(final SVGDocument sVGDocument) {
        if (this.backgroundRenderThread != null && this.backgroundRenderThread.isAlive()) {
            this.backgroundRenderThread.interrupt();
        }
        if (this.backgroundBuilderThread != null && this.backgroundBuilderThread.isAlive()) {
            this.backgroundBuilderThread.interrupt();
        }
        if (this.document != null) {
            Event event = this.document.createEvent("SVGEvents");
            event.initEvent("SVGUnload", false, false);
            this.document.getRootElement().dispatchEvent(event);
        }
        this.documentTransformed = false;
        if (sVGDocument == null) {
            this.document = sVGDocument;
            this.setRootNode(null, null, null);
            this.clearSelection();
        } else {
            this.setIsLoadPending(true);
            this.requestCursor(WAIT_CURSOR);
            this.setCursor(WAIT_CURSOR);
            this.backgroundBuilderThread = new Thread(){

                public void run() {
                    GraphicsNode graphicsNode = null;
                    try {
                        BridgeContext bridgeContext = JSVGCanvas.this.createBridgeContext();
                        long l = System.currentTimeMillis();
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                        try {
                            graphicsNode = JSVGCanvas.this.builder.build(bridgeContext, sVGDocument);
                            JSVGCanvas.this.initSelectors(graphicsNode);
                        }
                        catch (BuilderException builderException) {
                            JSVGCanvas.this.userAgent.displayError(builderException);
                            graphicsNode = builderException.getRootGraphicsNode();
                        }
                        bridgeContext.getDocumentLoader().dispose();
                        long l2 = System.currentTimeMillis();
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                        EventQueue.invokeAndWait(new RootNodeChangedRunnable(graphicsNode, bridgeContext, sVGDocument));
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.backgroundBuilderThread.setPriority(1);
            this.backgroundBuilderThread.start();
        }
    }

    public void setRootNode(GraphicsNode graphicsNode, BridgeContext bridgeContext, SVGDocument sVGDocument) {
        this.gvtRoot = graphicsNode;
        this.document = sVGDocument;
        if (this.userAgent.getEventDispatcher() != null) {
            this.userAgent.getEventDispatcher().setRootNode(this.gvtRoot);
        }
        if (graphicsNode != null) {
            this.computeTransform();
            Event event = sVGDocument.createEvent("SVGEvents");
            event.initEvent("SVGLoad", false, false);
            sVGDocument.getRootElement().dispatchEvent(event);
            ((EventTarget)((Object)sVGDocument)).addEventListener("DOMAttrModified", new MutationListener(bridgeContext), false);
        }
        this.rotateAngle = 0.0;
        this.rotateCos = 1.0;
        this.previousRotateTransform = null;
        this.rotateTransform = null;
        if (this.zoomHandler != null) {
            this.zoomHandler.zoomChanged(1.0f);
        }
        this.bufferNeedsRendering = true;
        if (this.thumbnailCanvas != null) {
            this.thumbnailCanvas.fullRepaint();
        }
        this.repaint();
    }

    protected synchronized void requestCursor(Cursor cursor) {
        this.requestedCursor = cursor;
    }

    protected synchronized Cursor getRequestedCursor() {
        return this.requestedCursor;
    }

    protected BridgeContext createBridgeContext() {
        GraphicsNodeRenderContext graphicsNodeRenderContext = this.getRendererFactory().getRenderContext();
        BridgeContext bridgeContext = new BridgeContext(this.userAgent, graphicsNodeRenderContext);
        return bridgeContext;
    }

    public JComponent getThumbnail() {
        if (this.thumbnailCanvas == null) {
            this.thumbnailCanvas = new ThumbnailCanvas();
        }
        return this.thumbnailCanvas;
    }

    public void initSelectors(GraphicsNode graphicsNode) {
        GraphicsNodeTreeIterator graphicsNodeTreeIterator = new GraphicsNodeTreeIterator(graphicsNode);
        if (this.textSelector == null) {
            this.textSelector = new ConcreteTextSelector(this.getRendererFactory().getRenderContext());
            this.textSelector.addSelectionListener(this);
        }
        while (graphicsNodeTreeIterator.hasNext()) {
            GraphicsNode graphicsNode2 = (GraphicsNode)graphicsNodeTreeIterator.next();
            if (!(graphicsNode2 instanceof Selectable)) continue;
            graphicsNode2.addGraphicsNodeMouseListener(this.textSelector);
        }
        this.clearSelection();
    }

    public void selectionDone(SelectionEvent selectionEvent) {
        Graphics graphics = this.getGraphics();
        this.paintOverlays(graphics);
        this.selectionHighlightShape = selectionEvent.getHighlightShape();
        this.canvasSpaceHighlightShape = this.transform.createTransformedShape(this.selectionHighlightShape);
        String string = this.getSelectionDescription(selectionEvent.getSelection());
        if (string != null) {
            this.userAgent.displayMessage("Selection: " + string);
        }
        this.repaint();
    }

    public void selectionCleared(SelectionEvent selectionEvent) {
        Graphics graphics = this.getGraphics();
        this.paintOverlays(graphics);
        this.userAgent.displayMessage("");
        this.canvasSpaceHighlightShape = null;
        this.selectionHighlightShape = null;
        this.repaint();
    }

    public void selectionStarted(SelectionEvent selectionEvent) {
        Graphics graphics = this.getGraphics();
        this.paintOverlays(graphics);
        this.setCursor(TEXT_CURSOR);
        this.userAgent.displayMessage("");
        this.canvasSpaceHighlightShape = null;
        this.selectionHighlightShape = null;
    }

    public void selectionChanged(SelectionEvent selectionEvent) {
        Graphics graphics = this.getGraphics();
        this.paintOverlays(graphics);
        this.selectionHighlightShape = selectionEvent.getHighlightShape();
        this.canvasSpaceHighlightShape = this.transform.createTransformedShape(this.selectionHighlightShape);
        this.paintOverlays(graphics);
    }

    private void clearSelection() {
        this.selectionCleared(new SelectionEvent(null, 3, null));
    }

    private String getSelectionDescription(Object object) {
        String string = null;
        if (object instanceof CharacterIterator) {
            CharacterIterator characterIterator = (CharacterIterator)object;
            char[] cArray = new char[characterIterator.getEndIndex() - characterIterator.getBeginIndex()];
            if (cArray.length > 0) {
                cArray[0] = characterIterator.first();
            }
            int n = 1;
            while (n < cArray.length) {
                cArray[n] = characterIterator.next();
                ++n;
            }
            string = new String(cArray);
        }
        return string;
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    protected void clearBuffer(int n, int n2) {
        Graphics2D graphics2D = this.buffer.createGraphics();
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
    }

    protected void clearBuffer(Shape shape) {
        Graphics2D graphics2D = this.buffer.createGraphics();
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setClip(shape.getBounds());
        graphics2D.setPaint(Color.white);
        graphics2D.fill(shape);
        graphics2D.dispose();
    }

    protected void clearBuffer(BufferedImage bufferedImage, int n, int n2) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setClip(0, 0, n, n2);
        graphics2D.setPaint(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
    }

    protected Shape getAreaOfInterest(Shape shape) {
        AffineTransform affineTransform = null;
        try {
            affineTransform = this.transform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new Error(noninvertibleTransformException.getMessage());
        }
        return affineTransform.createTransformedShape(shape);
    }

    public void paintComponent(Graphics graphics) {
        if (!EventQueue.isDispatchThread()) {
            System.err.println("ERROR: JSVGCanvas paintComponent() called outside AWT thread!");
        }
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (n < 1 || n2 < 1) {
            return;
        }
        Cursor cursor = this.getRequestedCursor();
        if (this.getCursor() != cursor) {
            this.setCursor(cursor);
        }
        this.updateBuffer(n, n2);
        Renderer renderer = null;
        if (this.bufferNeedsRendering) {
            renderer = this.rendererFactory.createRenderer(this.buffer);
            renderer.setTransform(this.transform);
        }
        if (renderer != null && this.gvtRoot != null && renderer.getTree() != this.gvtRoot) {
            renderer.setTree(this.gvtRoot);
            this.bufferNeedsRendering = true;
        }
        if (this.bufferNeedsRendering) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.panTransform != null) {
                int n3 = (int)this.panTransform.getTranslateX();
                int n4 = (int)this.panTransform.getTranslateY();
                this.paintPanRegions(graphics2D, n3, n4, n, n2);
                graphics2D.transform(this.panTransform);
                this.panTransform = null;
                graphics2D.drawImage(this.buffer, null, 0, 0);
            } else {
                graphics2D.setComposite(AlphaComposite.SrcOver);
                graphics2D.setClip(0, 0, n, n2);
                graphics2D.setPaint(Color.white);
                graphics2D.fillRect(0, 0, n, n2);
            }
            this.clearBuffer(n, n2);
            renderer.setTransform(this.transform);
            this.repaintAOI(renderer, dimension, this.buffer);
            this.bufferNeedsRendering = false;
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.panTransform != null) {
            int n5 = (int)this.panTransform.getTranslateX();
            int n6 = (int)this.panTransform.getTranslateY();
            this.paintPanRegions(graphics2D, n5, n6, n, n2);
            graphics2D.transform(this.panTransform);
        }
        graphics2D.drawRenderedImage(this.buffer, new AffineTransform());
        this.paintOverlays(graphics);
    }

    protected void paintOverlays(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setXORMode(Color.white);
        if (this.markerTop != null) {
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(this.markerStroke);
            graphics2D.draw(this.markerTop);
            graphics2D.draw(this.markerLeft);
            graphics2D.draw(this.markerBottom);
            graphics2D.draw(this.markerRight);
        } else if (this.rotateMarker != null) {
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(this.markerStroke);
            graphics2D.draw(this.rotateMarker);
        } else if (this.panTransform != null && this.docBBox != null) {
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(this.markerStroke);
        }
        if (this.canvasSpaceHighlightShape != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setColor(selectionXORColor);
            graphics2D.fill(this.canvasSpaceHighlightShape);
        }
        graphics2D.setXORMode(Color.white);
    }

    protected void paintPanRegions(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setPaint(Color.white);
        if (n > 0) {
            if (n2 > 0) {
                graphics2D.fillRect(0, 0, n3, n2);
                graphics2D.fillRect(0, n2, n, n4 - n2);
            } else {
                graphics2D.fillRect(0, 0, n, n4);
                graphics2D.fillRect(n, n4 + n2, n3 - n, -n2);
            }
        } else if (n2 > 0) {
            graphics2D.fillRect(0, 0, n3, n2);
            graphics2D.fillRect(n3 + n, n2, -n, n4 - n2);
        } else {
            graphics2D.fillRect(0, n4 + n2, n3, -n2);
            graphics2D.fillRect(n3 + n, 0, -n, n4 + n2);
        }
    }

    protected void updateBuffer(int n, int n2) {
        if (this.globalBuffer == null || this.globalBuffer.getWidth() < n || this.globalBuffer.getHeight() < n2) {
            if (this.globalBuffer != null) {
                this.globalBuffer.flush();
            }
            this.buffer = this.globalBuffer = new BufferedImage(n, n2, 1);
            this.bufferNeedsRendering = true;
        } else if (this.buffer.getWidth() != n || this.buffer.getHeight() != n2) {
            this.buffer = this.globalBuffer.getSubimage(0, 0, n, n2);
            this.bufferNeedsRendering = true;
        }
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    protected void computeTransform() {
        SVGSVGElement sVGSVGElement = this.document.getRootElement();
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        this.transform = SVGUtilities.getPreserveAspectRatioTransform(sVGSVGElement, n, n2);
        this.initialScale = this.transform.getScaleX();
        this.updateBaseTransform();
    }

    protected void updateBaseTransform() {
        this.canvasSpaceHighlightShape = this.transform.createTransformedShape(this.selectionHighlightShape);
        AWTEventDispatcher aWTEventDispatcher = (AWTEventDispatcher)this.userAgent.getEventDispatcher();
        if (aWTEventDispatcher != null) {
            try {
                if (this.gvtRoot != null) {
                    this.docBBox = this.transform.createTransformedShape(this.gvtRoot.getBounds(this.getRendererFactory().getRenderContext()));
                }
                aWTEventDispatcher.setBaseTransform(this.transform.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
        }
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.documentTransformed = false;
        this.computeTransform();
        this.rotateAngle = 0.0;
        this.rotateCos = 1.0;
        this.previousRotateTransform = null;
        this.rotateTransform = null;
        this.transform.concatenate(affineTransform);
        this.documentTransformed = true;
        this.updateBaseTransform();
        if (this.zoomHandler != null) {
            this.zoomHandler.zoomChanged((float)(this.transform.getScaleX() / this.rotateCos / this.initialScale));
        }
        this.bufferNeedsRendering = true;
        this.repaint();
        if (this.thumbnailCanvas != null) {
            this.thumbnailCanvas.repaint();
        }
    }

    public void setViewBox(float f, float f2, float f3, float f4) {
        Dimension dimension = this.getSize();
        AffineTransform affineTransform = SVGUtilities.getPreserveAspectRatioTransform(this.document.getRootElement(), dimension.width, dimension.height);
        try {
            affineTransform = affineTransform.createInverse();
            Point2D point2D = affineTransform.transform(new Point2D.Double(dimension.width, dimension.height), null);
            AffineTransform affineTransform2 = AffineTransform.getScaleInstance(point2D.getX() / (double)f3, point2D.getY() / (double)f4);
            affineTransform2.translate(-f, -f2);
            this.setTransform(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    protected void repaintAOI(Renderer renderer, Dimension dimension, BufferedImage bufferedImage) {
        Shape shape = this.getAreaOfInterest(new Rectangle(0, 0, dimension.width, dimension.height));
        Thread thread = new Thread(new RenderBufferAOIRunnable(renderer, shape, bufferedImage, dimension, this));
        thread.setPriority(1);
        if (this.backgroundRenderThread != null && this.backgroundRenderThread.isAlive()) {
            this.backgroundRenderThread.interrupt();
        }
        this.backgroundRenderThread = thread;
        thread.start();
    }

    protected class ThumbnailCanvas
    extends JComponent {
        protected BufferedImage offscreenBuffer;
        protected BufferedImage buffer;
        protected AffineTransform transform = new AffineTransform();
        protected Renderer renderer;
        protected Thread repaintThread;
        protected boolean bufferNeedsRendering;
        protected AffineTransform markerTransform = new AffineTransform();
        private Thread backgroundRenderThread = null;
        protected BasicStroke markerStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);

        public ThumbnailCanvas() {
            this.addComponentListener(new ThumbnailCanvasListener());
            MouseListener mouseListener = new MouseListener();
            this.addMouseListener(mouseListener);
            this.addMouseMotionListener(mouseListener);
        }

        public void fullRepaint() {
            RepaintState repaintState = JSVGCanvas.this.repaintState;
            synchronized (repaintState) {
                JSVGCanvas.this.repaintState.setValue(1);
            }
            this.bufferNeedsRendering = true;
            this.computeTransform();
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            if (!EventQueue.isDispatchThread()) {
                System.err.println("ERROR: Thumbnail paintComponent() called outside AWT thread!");
            }
            super.paintComponent(graphics);
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (n < 1 || n2 < 1) {
                return;
            }
            Renderer renderer = null;
            if (this.repaintThread != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.drawImage(this.buffer, null, 0, 0);
                return;
            }
            this.updateBuffer(n, n2);
            if (this.bufferNeedsRendering) {
                renderer = JSVGCanvas.this.rendererFactory.createRenderer(this.buffer);
                renderer.setTransform(this.transform);
            }
            if (renderer != null && JSVGCanvas.this.gvtRoot != null && renderer.getTree() != JSVGCanvas.this.gvtRoot) {
                renderer.setTree(JSVGCanvas.this.gvtRoot);
                this.bufferNeedsRendering = true;
            }
            if (this.bufferNeedsRendering) {
                this.clearBuffer(n, n2);
                renderer.setTransform(this.transform);
                this.repaintAOI(renderer, dimension, this.buffer);
                this.bufferNeedsRendering = false;
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.drawImage(this.buffer, null, 0, 0);
            this.paintOverlays(graphics);
        }

        public void paintOverlays(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (JSVGCanvas.this.gvtRoot != null) {
                Dimension dimension = JSVGCanvas.this.getSize();
                Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                GeneralPath generalPath = new GeneralPath();
                generalPath.moveTo(0.0f, 0.0f);
                generalPath.lineTo(dimension.width, 0.0f);
                generalPath.lineTo(dimension.width, dimension.height);
                generalPath.lineTo(0.0f, dimension.height);
                generalPath.closePath();
                generalPath.moveTo(0.0f, dimension.height / 24);
                generalPath.lineTo(dimension.width, dimension.height / 24);
                AffineTransform affineTransform = (AffineTransform)this.transform.clone();
                affineTransform.preConcatenate(this.markerTransform);
                Shape shape = JSVGCanvas.this.getAreaOfInterest(generalPath);
                shape = affineTransform.createTransformedShape(shape);
                graphics2D.setColor(Color.black);
                graphics2D.setXORMode(Color.white);
                graphics2D.draw(shape);
                graphics2D.setXORMode(Color.white);
            }
        }

        protected void repaintAOI(Renderer renderer, Dimension dimension, BufferedImage bufferedImage) {
            Shape shape = this.getAreaOfInterest(new Rectangle(0, 0, dimension.width, dimension.height));
            Thread thread = new Thread(new RenderBufferAOIRunnable(renderer, shape, bufferedImage, dimension, this));
            thread.setPriority(1);
            if (this.backgroundRenderThread != null && this.backgroundRenderThread.isAlive()) {
                this.backgroundRenderThread.interrupt();
            }
            this.backgroundRenderThread = thread;
            thread.start();
        }

        protected void clearBuffer(int n, int n2) {
            Graphics2D graphics2D = this.buffer.createGraphics();
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setClip(0, 0, n, n2);
            graphics2D.setPaint(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.dispose();
        }

        protected void clearBuffer(Shape shape) {
            Graphics2D graphics2D = this.buffer.createGraphics();
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setClip(shape.getBounds());
            graphics2D.setPaint(Color.white);
            graphics2D.fill(shape);
            graphics2D.dispose();
        }

        protected void updateBuffer(int n, int n2) {
            if (this.offscreenBuffer == null || this.offscreenBuffer.getWidth() < n || this.offscreenBuffer.getHeight() < n2) {
                if (this.offscreenBuffer != null) {
                    this.offscreenBuffer.flush();
                }
                this.buffer = this.offscreenBuffer = new BufferedImage(n, n2, 1);
                this.bufferNeedsRendering = true;
            } else if (this.buffer.getWidth() != n || this.buffer.getHeight() != n2) {
                this.buffer = this.offscreenBuffer.getSubimage(0, 0, n, n2);
                this.bufferNeedsRendering = true;
            }
        }

        protected void computeTransform() {
            if (JSVGCanvas.this.document == null) {
                this.transform = new AffineTransform();
                return;
            }
            SVGSVGElement sVGSVGElement = JSVGCanvas.this.document.getRootElement();
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height;
            this.transform = SVGUtilities.getPreserveAspectRatioTransform(sVGSVGElement, n, n2);
            if (this.transform.isIdentity()) {
                float f = sVGSVGElement.getWidth().getBaseVal().getValue();
                float f2 = sVGSVGElement.getHeight().getBaseVal().getValue();
                float f3 = Math.max(f, f2);
                this.transform = AffineTransform.getScaleInstance((float)n / f3, (float)n2 / f3);
            }
        }

        protected Shape getAreaOfInterest(Shape shape) {
            AffineTransform affineTransform = null;
            try {
                affineTransform = this.transform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new Error();
            }
            return affineTransform.createTransformedShape(shape);
        }

        public void repaintThumbnail() {
            Dimension dimension = this.getSize();
            try {
                this.renderer.repaint(this.getAreaOfInterest(new Rectangle(0, 0, dimension.width, dimension.height)));
                this.repaint();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        protected class MouseListener
        extends MouseAdapter
        implements MouseMotionListener {
            protected int sx;
            protected int sy;
            protected boolean in;

            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = JSVGCanvas.this.getSize();
                Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                Shape shape = JSVGCanvas.this.getAreaOfInterest(rectangle);
                shape = ThumbnailCanvas.this.transform.createTransformedShape(shape);
                this.sx = mouseEvent.getX();
                this.sy = mouseEvent.getY();
                this.in = shape.contains(this.sx, this.sy);
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (this.in) {
                    ThumbnailCanvas.this.markerTransform = AffineTransform.getTranslateInstance(mouseEvent.getX() - this.sx, mouseEvent.getY() - this.sy);
                    Dimension dimension = ThumbnailCanvas.this.getSize();
                    ThumbnailCanvas.this.paintImmediately(0, 0, dimension.width, dimension.height);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (this.in) {
                    this.in = false;
                    int n = mouseEvent.getX() - this.sx;
                    int n2 = mouseEvent.getY() - this.sy;
                    ThumbnailCanvas.this.markerTransform = AffineTransform.getTranslateInstance(n, n2);
                    Dimension dimension = ThumbnailCanvas.this.getSize();
                    ThumbnailCanvas.this.paintImmediately(0, 0, dimension.width, dimension.height);
                    Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
                    Point2D.Float float_2 = new Point2D.Float(n, n2);
                    try {
                        ThumbnailCanvas.this.transform.inverseTransform(float_, float_);
                        ThumbnailCanvas.this.transform.inverseTransform(float_2, float_2);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    ThumbnailCanvas.this.markerTransform = AffineTransform.getTranslateInstance(((Point2D)float_).getX() - ((Point2D)float_2).getX(), ((Point2D)float_).getY() - ((Point2D)float_2).getY());
                    ((ThumbnailCanvas)ThumbnailCanvas.this).JSVGCanvas.this.transform.concatenate(ThumbnailCanvas.this.markerTransform);
                    JSVGCanvas.this.updateBaseTransform();
                    ((ThumbnailCanvas)ThumbnailCanvas.this).JSVGCanvas.this.bufferNeedsRendering = true;
                    JSVGCanvas.this.repaint();
                    ThumbnailCanvas.this.markerTransform = new AffineTransform();
                }
            }

            public void mouseMoved(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (this.in) {
                    this.in = false;
                    ThumbnailCanvas.this.markerTransform = new AffineTransform();
                    Dimension dimension = ThumbnailCanvas.this.getSize();
                    ThumbnailCanvas.this.paintImmediately(0, 0, dimension.width, dimension.height);
                }
            }
        }

        protected class ThumbnailCanvasListener
        extends ComponentAdapter {
            public void componentResized(ComponentEvent componentEvent) {
                if (((ThumbnailCanvas)ThumbnailCanvas.this).JSVGCanvas.this.gvtRoot == null) {
                    return;
                }
                ThumbnailCanvas.this.computeTransform();
            }
        }
    }

    protected class MouseListener
    implements java.awt.event.MouseListener,
    MouseMotionListener {
        protected Cursor cursor;
        protected int sx;
        protected int sy;
        protected boolean mouseExited;

        public void mouseClicked(MouseEvent mouseEvent) {
            AWTEventDispatcher aWTEventDispatcher = (AWTEventDispatcher)JSVGCanvas.this.userAgent.getEventDispatcher();
            JSVGCanvas.this.clearSelection();
            aWTEventDispatcher.mouseClicked(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AWTEventDispatcher aWTEventDispatcher = (AWTEventDispatcher)JSVGCanvas.this.userAgent.getEventDispatcher();
            aWTEventDispatcher.mouseEntered(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            boolean bl = false;
            if ((n & 0x10) != 0) {
                this.mouseExited = false;
                this.sx = mouseEvent.getX();
                this.sy = mouseEvent.getY();
                if ((n & 1) != 0) {
                    if (this.cursor == null) {
                        this.cursor = JSVGCanvas.this.getCursor();
                    }
                    JSVGCanvas.this.requestCursor(PAN_CURSOR);
                    JSVGCanvas.this.setCursor(PAN_CURSOR);
                    JSVGCanvas.this.panTransform = new AffineTransform();
                    bl = true;
                } else if ((n & 2) != 0) {
                    if (this.cursor == null) {
                        this.cursor = JSVGCanvas.this.getCursor();
                    }
                    JSVGCanvas.this.requestCursor(ZOOM_CURSOR);
                    JSVGCanvas.this.setCursor(ZOOM_CURSOR);
                    bl = true;
                }
            } else if ((n & 4) != 0) {
                this.mouseExited = false;
                this.sx = mouseEvent.getX();
                this.sy = mouseEvent.getY();
                if ((n & 2) != 0) {
                    if (this.cursor == null) {
                        this.cursor = JSVGCanvas.this.getCursor();
                    }
                    JSVGCanvas.this.requestCursor(ROTATE_CURSOR);
                    JSVGCanvas.this.setCursor(ROTATE_CURSOR);
                    JSVGCanvas.this.previousRotateTransform = JSVGCanvas.this.rotateTransform;
                    JSVGCanvas.this.rotateTransform = new AffineTransform();
                    this.paintRotateMarker(this.sx, this.sy);
                    bl = true;
                }
            }
            if (!bl) {
                JSVGCanvas.this.clearSelection();
                AWTEventDispatcher aWTEventDispatcher = (AWTEventDispatcher)JSVGCanvas.this.userAgent.getEventDispatcher();
                if (aWTEventDispatcher != null) {
                    aWTEventDispatcher.mousePressed(mouseEvent);
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            AWTEventDispatcher aWTEventDispatcher;
            int n = mouseEvent.getModifiers();
            boolean bl = false;
            if ((n & 0x10) != 0) {
                if ((n & 1) != 0 && JSVGCanvas.this.panTransform != null) {
                    bl = true;
                    if (!this.mouseExited) {
                        int n2 = mouseEvent.getX();
                        int n3 = mouseEvent.getY();
                        JSVGCanvas.this.panTransform.translate(n2 - this.sx, n3 - this.sy);
                        this.sx = n2;
                        this.sy = n3;
                        JSVGCanvas.this.repaint();
                    }
                } else if ((n & 2) != 0) {
                    bl = true;
                    this.paintZoomMarker(mouseEvent.getX(), mouseEvent.getY());
                }
            } else if ((n & 4) != 0 && (n & 2) != 0) {
                bl = true;
                this.paintRotateMarker(mouseEvent.getX(), mouseEvent.getY());
            }
            if (!bl && (aWTEventDispatcher = (AWTEventDispatcher)JSVGCanvas.this.userAgent.getEventDispatcher()) != null) {
                aWTEventDispatcher.mouseDragged(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AWTEventDispatcher aWTEventDispatcher;
            int n = mouseEvent.getModifiers();
            boolean bl = false;
            if ((n & 0x10) != 0) {
                if (this.cursor != null) {
                    bl = true;
                    this.endOperation(mouseEvent.getX(), mouseEvent.getY());
                }
            } else if ((n & 4) != 0 && this.cursor != null) {
                bl = true;
                this.endOperation(mouseEvent.getX(), mouseEvent.getY());
            }
            if (!bl && (aWTEventDispatcher = (AWTEventDispatcher)JSVGCanvas.this.userAgent.getEventDispatcher()) != null) {
                aWTEventDispatcher.mouseReleased(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            AWTEventDispatcher aWTEventDispatcher = (AWTEventDispatcher)JSVGCanvas.this.userAgent.getEventDispatcher();
            aWTEventDispatcher.mouseMoved(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseExited = true;
            JSVGCanvas.this.markerTop = null;
            JSVGCanvas.this.markerLeft = null;
            JSVGCanvas.this.markerBottom = null;
            JSVGCanvas.this.markerRight = null;
            JSVGCanvas.this.panTransform = null;
            JSVGCanvas.this.repaint();
            AWTEventDispatcher aWTEventDispatcher = (AWTEventDispatcher)JSVGCanvas.this.userAgent.getEventDispatcher();
            aWTEventDispatcher.mouseExited(mouseEvent);
        }

        protected void endOperation(int n, int n2) {
            if (this.cursor != null) {
                JSVGCanvas.this.requestCursor(this.cursor);
                JSVGCanvas.this.setCursor(this.cursor);
            }
            this.cursor = null;
            if (this.mouseExited) {
                JSVGCanvas.this.repaint();
                return;
            }
            if (JSVGCanvas.this.panTransform != null) {
                JSVGCanvas.this.panTransform.translate(n - this.sx, n2 - this.sy);
                JSVGCanvas.this.transform.preConcatenate(JSVGCanvas.this.panTransform);
                JSVGCanvas.this.documentTransformed = true;
                JSVGCanvas.this.updateBaseTransform();
                JSVGCanvas.this.bufferNeedsRendering = true;
                JSVGCanvas.this.repaint();
                if (JSVGCanvas.this.thumbnailCanvas != null) {
                    JSVGCanvas.this.thumbnailCanvas.repaint();
                }
            } else if (JSVGCanvas.this.markerTop != null) {
                float f;
                float f2;
                int n3;
                this.clearZoomMarker();
                Dimension dimension = JSVGCanvas.this.getSize();
                if (n < this.sx) {
                    n3 = n;
                    n = this.sx;
                    this.sx = n3;
                }
                if (n2 < this.sy) {
                    n3 = n2;
                    n2 = this.sy;
                    this.sy = n3;
                }
                float f3 = (f2 = (float)dimension.width / (float)(n - this.sx)) < (f = (float)dimension.height / (float)(n2 - this.sy)) ? f2 : f;
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.scale(f3, f3);
                affineTransform.translate(-this.sx, -this.sy);
                JSVGCanvas.this.transform.preConcatenate(affineTransform);
                JSVGCanvas.this.documentTransformed = true;
                JSVGCanvas.this.updateBaseTransform();
                if (JSVGCanvas.this.zoomHandler != null) {
                    JSVGCanvas.this.zoomHandler.zoomChanged((float)(JSVGCanvas.this.transform.getScaleX() / JSVGCanvas.this.rotateCos / JSVGCanvas.this.initialScale));
                }
                JSVGCanvas.this.bufferNeedsRendering = true;
                JSVGCanvas.this.repaint();
                if (JSVGCanvas.this.thumbnailCanvas != null) {
                    JSVGCanvas.this.thumbnailCanvas.repaint();
                }
            } else if (JSVGCanvas.this.rotateMarker != null) {
                this.clearRotateMarker();
                if (JSVGCanvas.this.previousRotateTransform != null) {
                    try {
                        JSVGCanvas.this.transform.preConcatenate(JSVGCanvas.this.previousRotateTransform.createInverse());
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                    JSVGCanvas.this.previousRotateTransform = null;
                }
                JSVGCanvas.this.transform.preConcatenate(JSVGCanvas.this.rotateTransform);
                JSVGCanvas.this.documentTransformed = true;
                JSVGCanvas.this.updateBaseTransform();
                if (JSVGCanvas.this.zoomHandler != null) {
                    JSVGCanvas.this.zoomHandler.zoomChanged((float)(JSVGCanvas.this.transform.getScaleX() / JSVGCanvas.this.rotateCos / JSVGCanvas.this.initialScale));
                }
                JSVGCanvas.this.bufferNeedsRendering = true;
                JSVGCanvas.this.repaint();
                if (JSVGCanvas.this.thumbnailCanvas != null) {
                    JSVGCanvas.this.thumbnailCanvas.repaint();
                }
            }
        }

        protected void paintRotateMarker(int n, int n2) {
            this.clearRotateMarker();
            if (this.mouseExited) {
                JSVGCanvas.this.rotateMarker = null;
            } else {
                Dimension dimension = JSVGCanvas.this.getSize();
                int n3 = dimension.width / 3;
                int n4 = dimension.height / 3;
                float f = Math.min(n3, n4);
                double d = n - dimension.width / 2;
                double d2 = n2 - dimension.height / 2;
                double d3 = -d2 / Math.sqrt(d * d + d2 * d2);
                float f2 = (float)(dimension.width / 2) - f / 2.0f;
                float f3 = (float)(dimension.height / 2) - f / 2.0f;
                double d4 = d > 0.0 ? Math.acos(d3) : -Math.acos(d3);
                float f4 = (float)Math.toDegrees(-d4);
                Arc2D.Float float_ = new Arc2D.Float(f2, f3, f, f, 90.0f, f4, 2);
                JSVGCanvas.this.rotateAngle = d4;
                JSVGCanvas.this.rotateCos = Math.cos(JSVGCanvas.this.rotateAngle);
                JSVGCanvas.this.rotateTransform = AffineTransform.getRotateInstance(d4, dimension.width / 2, dimension.height / 2);
                JSVGCanvas.this.rotateMarker = float_;
                JSVGCanvas.this.paintOverlays(JSVGCanvas.this.getGraphics());
            }
        }

        protected void clearRotateMarker() {
            JSVGCanvas.this.paintOverlays(JSVGCanvas.this.getGraphics());
            JSVGCanvas.this.rotateMarker = null;
        }

        protected void paintZoomMarker(int n, int n2) {
            Graphics graphics = JSVGCanvas.this.getGraphics();
            this.clearZoomMarker();
            if (this.mouseExited) {
                JSVGCanvas.this.markerTop = null;
                JSVGCanvas.this.markerLeft = null;
                JSVGCanvas.this.markerBottom = null;
                JSVGCanvas.this.markerRight = null;
            } else {
                JSVGCanvas.this.markerTop = new Line2D.Float(this.sx, this.sy, n, this.sy);
                JSVGCanvas.this.markerLeft = new Line2D.Float(this.sx, this.sy, this.sx, n2);
                JSVGCanvas.this.markerBottom = new Line2D.Float(this.sx, n2, n, n2);
                JSVGCanvas.this.markerRight = new Line2D.Float(n, n2, n, this.sy);
                JSVGCanvas.this.paintOverlays(graphics);
            }
        }

        protected void clearZoomMarker() {
            Graphics graphics = JSVGCanvas.this.getGraphics();
            JSVGCanvas.this.paintOverlays(graphics);
            JSVGCanvas.this.markerTop = null;
        }
    }

    public class ZoomOutAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGCanvas.this.transform.preConcatenate(AffineTransform.getScaleInstance(0.5, 0.5));
            JSVGCanvas.this.documentTransformed = true;
            JSVGCanvas.this.updateBaseTransform();
            if (JSVGCanvas.this.zoomHandler != null) {
                JSVGCanvas.this.zoomHandler.zoomChanged((float)(JSVGCanvas.this.transform.getScaleX() / JSVGCanvas.this.rotateCos / JSVGCanvas.this.initialScale));
            }
            JSVGCanvas.this.bufferNeedsRendering = true;
            JSVGCanvas.this.repaint();
            if (JSVGCanvas.this.thumbnailCanvas != null) {
                JSVGCanvas.this.thumbnailCanvas.repaint();
            }
        }
    }

    public class ZoomInAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGCanvas.this.transform.preConcatenate(AffineTransform.getScaleInstance(2.0, 2.0));
            JSVGCanvas.this.documentTransformed = true;
            JSVGCanvas.this.updateBaseTransform();
            if (JSVGCanvas.this.zoomHandler != null) {
                JSVGCanvas.this.zoomHandler.zoomChanged((float)(JSVGCanvas.this.transform.getScaleX() / JSVGCanvas.this.rotateCos / JSVGCanvas.this.initialScale));
            }
            JSVGCanvas.this.bufferNeedsRendering = true;
            JSVGCanvas.this.repaint();
            if (JSVGCanvas.this.thumbnailCanvas != null) {
                JSVGCanvas.this.thumbnailCanvas.repaint();
            }
        }
    }

    public class UnzoomAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            JSVGCanvas.this.documentTransformed = false;
            JSVGCanvas.this.computeTransform();
            JSVGCanvas.this.rotateAngle = 0.0;
            JSVGCanvas.this.rotateCos = 1.0;
            JSVGCanvas.this.previousRotateTransform = null;
            JSVGCanvas.this.rotateTransform = null;
            if (JSVGCanvas.this.zoomHandler != null) {
                JSVGCanvas.this.zoomHandler.zoomChanged(1.0f);
            }
            JSVGCanvas.this.bufferNeedsRendering = true;
            JSVGCanvas.this.repaint();
            if (JSVGCanvas.this.thumbnailCanvas != null) {
                JSVGCanvas.this.thumbnailCanvas.repaint();
            }
        }
    }

    protected class CanvasListener
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            if (JSVGCanvas.this.gvtRoot == null) {
                return;
            }
            if (!JSVGCanvas.this.documentTransformed) {
                JSVGCanvas.this.computeTransform();
                JSVGCanvas.this.rotateAngle = 0.0;
                JSVGCanvas.this.rotateCos = 1.0;
                JSVGCanvas.this.previousRotateTransform = null;
                JSVGCanvas.this.rotateTransform = null;
                if (JSVGCanvas.this.zoomHandler != null) {
                    JSVGCanvas.this.zoomHandler.zoomChanged(1.0f);
                }
                if (JSVGCanvas.this.thumbnailCanvas != null) {
                    JSVGCanvas.this.thumbnailCanvas.repaint();
                }
            }
        }
    }

    protected class RepaintTimer
    extends Thread {
        Component target;
        long interval;

        public RepaintTimer(Component component, long l) {
            this.target = component;
            this.interval = l;
            this.setPriority(2);
        }

        public void run() {
            try {
                Thread.sleep(this.interval);
                while (!Thread.interrupted()) {
                    this.target.repaint();
                    Thread.sleep(this.interval);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class RenderBufferAOIRunnable
    implements Runnable {
        private Shape aoi;
        private Renderer renderer;
        private BufferedImage buffer;
        private Dimension size;
        private Component component;

        RenderBufferAOIRunnable(Renderer renderer, Shape shape, BufferedImage bufferedImage, Dimension dimension, Component component) {
            this.renderer = renderer;
            this.aoi = shape;
            this.buffer = bufferedImage;
            this.size = dimension;
            this.component = component;
        }

        public void run() {
            long l = System.currentTimeMillis();
            JSVGCanvas.this.requestCursor(WAIT_CURSOR);
            RepaintState repaintState = JSVGCanvas.this.repaintState;
            synchronized (repaintState) {
                block21: {
                    if (JSVGCanvas.this.repaintState.getValue() == 1 && !(this.component instanceof ThumbnailCanvas)) {
                        try {
                            JSVGCanvas.this.repaintState.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        JSVGCanvas.this.clearBuffer(this.buffer, (int)this.size.getWidth(), (int)this.size.getHeight());
                        RepaintTimer repaintTimer = null;
                        if (JSVGCanvas.this.progressiveRenderingEnabled) {
                            repaintTimer = new RepaintTimer(this.component, 1000L);
                            repaintTimer.start();
                        }
                        try {
                            try {
                                this.renderer.repaint(this.aoi);
                            }
                            catch (InterruptedException interruptedException) {
                                Object var9_7 = null;
                                if (repaintTimer != null) {
                                    repaintTimer.interrupt();
                                }
                                JSVGCanvas.this.repaintState.setValue(0);
                                JSVGCanvas.this.repaintState.notifyAll();
                                this.renderer.dispose();
                                this.renderer = null;
                                break block21;
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                System.out.println("(AOI repaint did not complete.)");
                                Object var9_8 = null;
                                if (repaintTimer != null) {
                                    repaintTimer.interrupt();
                                }
                                JSVGCanvas.this.repaintState.setValue(0);
                                JSVGCanvas.this.repaintState.notifyAll();
                                this.renderer.dispose();
                                this.renderer = null;
                                break block21;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                Object var9_9 = null;
                                if (repaintTimer != null) {
                                    repaintTimer.interrupt();
                                }
                                JSVGCanvas.this.repaintState.setValue(0);
                                JSVGCanvas.this.repaintState.notifyAll();
                                this.renderer.dispose();
                                this.renderer = null;
                            }
                            Object var9_6 = null;
                            if (repaintTimer != null) {
                                repaintTimer.interrupt();
                            }
                            JSVGCanvas.this.repaintState.setValue(0);
                            JSVGCanvas.this.repaintState.notifyAll();
                            this.renderer.dispose();
                            this.renderer = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            if (repaintTimer != null) {
                                repaintTimer.interrupt();
                            }
                            JSVGCanvas.this.repaintState.setValue(0);
                            JSVGCanvas.this.repaintState.notifyAll();
                            this.renderer.dispose();
                            this.renderer = null;
                            throw throwable;
                        }
                    }
                }
            }
            if (!Thread.currentThread().isInterrupted()) {
                long l2 = System.currentTimeMillis();
                if (!JSVGCanvas.this.isLoadPending()) {
                    JSVGCanvas.this.requestCursor(NORMAL_CURSOR);
                }
                this.component.repaint();
            }
        }
    }

    class RepaintState {
        private int i;

        public RepaintState(int n) {
            this.i = n;
        }

        public void setValue(int n) {
            this.i = n;
        }

        public int getValue() {
            return this.i;
        }
    }

    protected class MutationListener
    implements EventListener {
        BridgeContext bridgeContext;

        public MutationListener(BridgeContext bridgeContext) {
            this.bridgeContext = bridgeContext;
        }

        public void handleEvent(Event event) {
            Element element = (Element)((Object)event.getTarget());
            BridgeMutationEvent bridgeMutationEvent = new BridgeMutationEvent(element, this.bridgeContext, 0);
            MutationEvent mutationEvent = (MutationEvent)event;
            bridgeMutationEvent.setAttrName(mutationEvent.getAttrName());
            bridgeMutationEvent.setAttrNewValue(mutationEvent.getNewValue());
            GraphicsNodeBridge graphicsNodeBridge = (GraphicsNodeBridge)this.bridgeContext.getBridge(element);
            graphicsNodeBridge.update(bridgeMutationEvent);
        }
    }

    class RootNodeChangedRunnable
    implements Runnable {
        GraphicsNode root;
        BridgeContext bridgeContext;
        SVGDocument document;

        public RootNodeChangedRunnable(GraphicsNode graphicsNode, BridgeContext bridgeContext, SVGDocument sVGDocument) {
            this.root = graphicsNode;
            this.bridgeContext = bridgeContext;
            this.document = sVGDocument;
        }

        public void run() {
            JSVGCanvas.this.setRootNode(this.root, this.bridgeContext, this.document);
            JSVGCanvas.this.setIsLoadPending(false);
        }
    }

    public static interface ZoomHandler {
        public void zoomChanged(float var1);
    }
}

