/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.svggen.TestUtil;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlWriter
implements SVGConstants {
    private static String EOL;
    private static String TAG_END;
    private static String TAG_START;
    private static String SPACE;

    XmlWriter() {
    }

    private static void writeXml(Attr attr, IndentWriter indentWriter) throws IOException {
        String string = attr.getName();
        indentWriter.write(string);
        indentWriter.write("=\"");
        XmlWriter.writeChildrenXml(attr, indentWriter);
        indentWriter.write(34);
    }

    private static void writeChildrenXml(Attr attr, IndentWriter indentWriter) throws IOException {
        String string = attr.getValue();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    indentWriter.write("&lt;");
                    break;
                }
                case '>': {
                    indentWriter.write("&gt;");
                    break;
                }
                case '&': {
                    indentWriter.write("&amp;");
                    break;
                }
                case '\'': {
                    indentWriter.write("&apos;");
                    break;
                }
                case '\"': {
                    indentWriter.write("&quot;");
                    break;
                }
                default: {
                    indentWriter.write(c);
                }
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void writeXml(Comment var0, IndentWriter var1_1) throws IOException {
        block4: {
            var2_2 = var0.getData().toCharArray();
            var1_1.write("<!--");
            if (var2_2 == null) break block4;
            var3_3 = false;
            var4_4 = var2_2.length;
            var5_5 = 0;
            while (var5_5 < var4_4) {
                if (var2_2[var5_5] != '-') ** GOTO lbl14
                if (!var3_3) {
                    var3_3 = true;
                    var1_1.write(45);
                } else {
                    var1_1.write(32);
lbl14:
                    // 2 sources

                    var3_3 = false;
                    var1_1.write(var2_2[var5_5]);
                }
                ++var5_5;
            }
            if (var2_2[var2_2.length - 1] == '-') {
                var1_1.write(32);
            }
        }
        var1_1.write("-->");
    }

    /*
     * Unable to fully structure code
     */
    private static void writeXml(Text var0, IndentWriter var1_1) throws IOException {
        var2_2 = var0.getData().toCharArray();
        var3_3 = 0;
        var4_4 = 0;
        if (var2_2 != null) ** GOTO lbl23
        System.err.println("Null text data??");
        return;
lbl-1000:
        // 1 sources

        {
            var5_5 = var2_2[var4_4];
            if (var5_5 == '<') {
                var1_1.write(var2_2, var3_3, var4_4 - var3_3);
                var3_3 = var4_4 + 1;
                var1_1.write("&lt;");
            } else if (var5_5 == '>') {
                var1_1.write(var2_2, var3_3, var4_4 - var3_3);
                var3_3 = var4_4 + 1;
                var1_1.write("&gt;");
            } else if (var5_5 == '&') {
                var1_1.write(var2_2, var3_3, var4_4 - var3_3);
                var3_3 = var4_4 + 1;
                var1_1.write("&amp;");
            }
            ++var4_4;
lbl23:
            // 2 sources

            ** while (var4_4 < var2_2.length)
        }
lbl24:
        // 1 sources

        var1_1.write(var2_2, var3_3, var4_4 - var3_3);
    }

    private static void writeXml(CDATASection cDATASection, IndentWriter indentWriter) throws IOException {
        char[] cArray = cDATASection.getData().toCharArray();
        indentWriter.write("<![CDATA[");
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == ']' && n + 2 < cArray.length && cArray[n + 1] == ']' && cArray[n + 2] == '>') {
                indentWriter.write("]]]]><![CDATA[>");
            } else {
                indentWriter.write(c);
            }
            ++n;
        }
        indentWriter.write("]]>");
    }

    private static void writeXml(Element element, IndentWriter indentWriter) throws IOException {
        indentWriter.write(TAG_START, 0, 1);
        indentWriter.write(element.getTagName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                indentWriter.write(32);
                XmlWriter.writeXml(attr, indentWriter);
                ++n2;
            }
        }
        if (!element.hasChildNodes()) {
            indentWriter.write(TAG_END, 0, 3);
        } else {
            indentWriter.write(TAG_END, 2, 1);
            XmlWriter.writeChildrenXml(element, indentWriter);
            indentWriter.write(TAG_START, 0, 2);
            indentWriter.write(element.getTagName());
            indentWriter.write(TAG_END, 2, 1);
        }
    }

    private static void writeChildrenXml(Element element, IndentWriter indentWriter) throws IOException {
        NodeList nodeList = element.getChildNodes();
        if (nodeList == null) {
            return;
        }
        int n = nodeList.getLength();
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = true;
        n2 = indentWriter.getIndentLevel();
        try {
            indentWriter.setIndentLevel(n2 + 2);
            int n3 = 0;
            while (n3 < n) {
                if (nodeList.item(n3).getNodeType() != 3) {
                    indentWriter.printIndent();
                    bl2 = false;
                }
                XmlWriter.writeXml(nodeList.item(n3), (Writer)indentWriter);
                ++n3;
            }
            Object var9_8 = null;
            indentWriter.setIndentLevel(n2);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            indentWriter.setIndentLevel(n2);
            indentWriter.printIndent();
            throw throwable;
        }
        indentWriter.printIndent();
    }

    private static void writeDocumentHeader(IndentWriter indentWriter) throws IOException {
        String string = null;
        if (indentWriter.getProxied() instanceof OutputStreamWriter) {
            string = XmlWriter.java2std(((OutputStreamWriter)indentWriter.getProxied()).getEncoding());
        }
        indentWriter.write("<?xml version=\"1.0\"");
        if (string != null) {
            indentWriter.write(" encoding=\"");
            indentWriter.write(string);
            indentWriter.write(34);
        }
        indentWriter.write("?>");
        indentWriter.write(EOL);
        indentWriter.write(EOL);
        indentWriter.write("<!DOCTYPE svg PUBLIC '");
        indentWriter.write("-//W3C//DTD SVG 20001102//EN");
        indentWriter.write("' '");
        indentWriter.write("http://www.w3.org/TR/2000/CR-SVG-20001102/DTD/svg-20001102.dtd");
        indentWriter.write("'");
        indentWriter.write(">");
        indentWriter.write(EOL);
    }

    private static void writeXml(Document document, IndentWriter indentWriter) throws IOException {
        XmlWriter.writeDocumentHeader(indentWriter);
        NodeList nodeList = document.getChildNodes();
        XmlWriter.writeXml(nodeList, indentWriter);
    }

    private static void writeXml(NodeList nodeList, IndentWriter indentWriter) throws IOException {
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            XmlWriter.writeXml(node, (Writer)indentWriter);
            indentWriter.write(EOL);
            ++n2;
        }
    }

    static String java2std(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("ISO8859_")) {
            return "ISO-8859-" + string.substring(8);
        }
        if (string.startsWith("8859_")) {
            return "ISO-8859-" + string.substring(5);
        }
        if ("ASCII7".equalsIgnoreCase(string) || "ASCII".equalsIgnoreCase(string)) {
            return "US-ASCII";
        }
        if ("UTF8".equalsIgnoreCase(string)) {
            return "UTF-8";
        }
        if (string.startsWith("Unicode")) {
            return "UTF-16";
        }
        if ("SJIS".equalsIgnoreCase(string)) {
            return "Shift_JIS";
        }
        if ("JIS".equalsIgnoreCase(string)) {
            return "ISO-2022-JP";
        }
        if ("EUCJIS".equalsIgnoreCase(string)) {
            return "EUC-JP";
        }
        return string;
    }

    public static void writeXml(Node node, Writer writer) throws IOException {
        IndentWriter indentWriter = null;
        indentWriter = writer instanceof IndentWriter ? (IndentWriter)writer : new IndentWriter(writer);
        if (node instanceof Attr) {
            XmlWriter.writeXml((Attr)node, indentWriter);
        } else if (node instanceof Comment) {
            XmlWriter.writeXml((Comment)node, indentWriter);
        } else if (node instanceof Text) {
            XmlWriter.writeXml((Text)node, indentWriter);
        } else if (node instanceof CDATASection) {
            XmlWriter.writeXml((CDATASection)node, indentWriter);
        } else if (node instanceof Document) {
            XmlWriter.writeXml((Document)node, indentWriter);
        } else if (node instanceof DocumentFragment) {
            XmlWriter.writeDocumentHeader(indentWriter);
            NodeList nodeList = node.getChildNodes();
            XmlWriter.writeXml(nodeList, indentWriter);
        } else if (node instanceof Element) {
            XmlWriter.writeXml((Element)node, indentWriter);
        } else {
            System.err.println("Unable to write node of type: " + node.getClass().getName());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Document document = TestUtil.getDocumentPrototype();
        Element element = document.createElementNS("http://www.w3.org/2000/svg", "svg");
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element6 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Comment comment = document.createComment("This is the topLevelGroup comment");
        element3.appendChild(comment);
        element3.appendChild(element4);
        element3.appendChild(element5);
        element3.appendChild(element6);
        element.appendChild(element2);
        element.appendChild(element3);
        document.appendChild(element);
        TestUtil.trace(element, System.out);
        System.out.println("\n=======================================");
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            XmlWriter.writeXml((Node)document, outputStreamWriter);
            ((Writer)outputStreamWriter).flush();
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(exception.getMessage());
        }
    }

    static {
        String string;
        TAG_END = " />";
        TAG_START = "</";
        SPACE = " ";
        try {
            string = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException securityException) {
            string = "\n";
        }
        EOL = string;
    }

    static class IndentWriter
    extends Writer {
        private Writer proxied;
        private int indentLevel;

        public IndentWriter(Writer writer) {
            if (writer == null) {
                throw new IllegalArgumentException();
            }
            this.proxied = writer;
        }

        public void setIndentLevel(int n) {
            this.indentLevel = n;
        }

        public int getIndentLevel() {
            return this.indentLevel;
        }

        public void printIndent() throws IOException {
            this.proxied.write(EOL);
            int n = this.indentLevel;
            while (n > 0) {
                this.proxied.write(32);
                --n;
            }
        }

        public Writer getProxied() {
            return this.proxied;
        }

        public void write(int n) throws IOException {
            this.proxied.write(n);
        }

        public void write(char[] cArray) throws IOException {
            this.proxied.write(cArray);
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            this.proxied.write(cArray, n, n2);
        }

        public void write(String string) throws IOException {
            this.proxied.write(string);
        }

        public void write(String string, int n, int n2) throws IOException {
            this.proxied.write(string, n, n2);
        }

        public void flush() throws IOException {
            this.proxied.flush();
        }

        public void close() throws IOException {
            this.proxied.close();
        }
    }
}

