/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Rectangle;
import java.awt.image.BufferedImageOp;
import java.awt.image.RescaleOp;
import org.apache.batik.svggen.AbstractSVGFilterConverter;
import org.apache.batik.svggen.SVGFilterDescriptor;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.TestUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGRescaleOp
extends AbstractSVGFilterConverter {
    public static final String ERROR_SCALE_FACTORS_AND_OFFSETS_MISMATCH = "RescapeOp offsets and scaleFactor array lenght do not match";
    public static final String ERROR_ILLEGAL_BUFFERED_IMAGE_RESCALE_OP = "BufferedImage RescaleOp should have 1, 3 or 4 scale factors";

    public SVGRescaleOp(Document document) {
        super(document);
    }

    public SVGFilterDescriptor toSVG(BufferedImageOp bufferedImageOp, Rectangle rectangle) {
        if (bufferedImageOp instanceof RescaleOp) {
            return this.toSVG((RescaleOp)bufferedImageOp);
        }
        return null;
    }

    public SVGFilterDescriptor toSVG(RescaleOp rescaleOp) {
        SVGFilterDescriptor sVGFilterDescriptor = (SVGFilterDescriptor)this.descMap.get(rescaleOp);
        if (sVGFilterDescriptor == null) {
            CharSequence charSequence;
            float[] fArray;
            Element element = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "filter");
            Element element2 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "feComponentTransfer");
            float[] fArray2 = rescaleOp.getOffsets(null);
            if (fArray2.length != (fArray = rescaleOp.getScaleFactors(null)).length) {
                throw new IllegalArgumentException(ERROR_SCALE_FACTORS_AND_OFFSETS_MISMATCH);
            }
            if (fArray2.length != 1 && fArray2.length != 3 && fArray2.length != 4) {
                throw new IllegalArgumentException(ERROR_ILLEGAL_BUFFERED_IMAGE_RESCALE_OP);
            }
            Element element3 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "feFuncR");
            Element element4 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "feFuncG");
            Element element5 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "feFuncB");
            Element element6 = null;
            String string = "linear";
            if (fArray2.length == 1) {
                charSequence = AbstractSVGFilterConverter.doubleString(fArray[0]);
                String string2 = AbstractSVGFilterConverter.doubleString(fArray2[0]);
                element3.setAttributeNS(null, "type", string);
                element4.setAttributeNS(null, "type", string);
                element5.setAttributeNS(null, "type", string);
                element3.setAttributeNS(null, "slope", (String)charSequence);
                element4.setAttributeNS(null, "slope", (String)charSequence);
                element5.setAttributeNS(null, "slope", (String)charSequence);
                element3.setAttributeNS(null, "intercept", string2);
                element4.setAttributeNS(null, "intercept", string2);
                element5.setAttributeNS(null, "intercept", string2);
            } else if (fArray2.length >= 3) {
                element3.setAttributeNS(null, "type", string);
                element4.setAttributeNS(null, "type", string);
                element5.setAttributeNS(null, "type", string);
                element3.setAttributeNS(null, "slope", AbstractSVGFilterConverter.doubleString(fArray[0]));
                element4.setAttributeNS(null, "slope", AbstractSVGFilterConverter.doubleString(fArray[1]));
                element5.setAttributeNS(null, "slope", AbstractSVGFilterConverter.doubleString(fArray[2]));
                element3.setAttributeNS(null, "intercept", AbstractSVGFilterConverter.doubleString(fArray2[0]));
                element4.setAttributeNS(null, "intercept", AbstractSVGFilterConverter.doubleString(fArray2[1]));
                element5.setAttributeNS(null, "intercept", AbstractSVGFilterConverter.doubleString(fArray2[2]));
                if (fArray2.length == 4) {
                    element6 = this.domFactory.createElementNS("http://www.w3.org/2000/svg", "feFuncA");
                    element6.setAttributeNS(null, "type", string);
                    element6.setAttributeNS(null, "slope", AbstractSVGFilterConverter.doubleString(fArray[3]));
                    element6.setAttributeNS(null, "intercept", AbstractSVGFilterConverter.doubleString(fArray2[3]));
                }
            }
            element2.appendChild(element3);
            element2.appendChild(element4);
            element2.appendChild(element5);
            if (element6 != null) {
                element2.appendChild(element6);
            }
            element.appendChild(element2);
            element.setAttributeNS(null, "id", SVGIDGenerator.generateID("componentTransfer"));
            charSequence = new StringBuffer("url(");
            ((StringBuffer)charSequence).append("#");
            ((StringBuffer)charSequence).append(element.getAttributeNS(null, "id"));
            ((StringBuffer)charSequence).append(")");
            sVGFilterDescriptor = new SVGFilterDescriptor(((StringBuffer)charSequence).toString(), element);
            this.defSet.add(element);
            this.descMap.put(rescaleOp, sVGFilterDescriptor);
        }
        return sVGFilterDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        Element element;
        Object object;
        Document document = TestUtil.getDocumentPrototype();
        RescaleOp[] rescaleOpArray = new RescaleOp[]{new RescaleOp(3.0f, 25.0f, null), new RescaleOp(new float[]{1.0f, 2.0f, 3.0f}, new float[]{10.0f, 20.0f, 30.0f}, null), new RescaleOp(new float[]{1.0f, 2.0f, 3.0f, 4.0f}, new float[]{10.0f, 20.0f, 30.0f, 40.0f}, null)};
        SVGRescaleOp sVGRescaleOp = new SVGRescaleOp(document);
        Element element2 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element3 = document.createElementNS("http://www.w3.org/2000/svg", "defs");
        Element element4 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        Element element5 = document.createElementNS("http://www.w3.org/2000/svg", "g");
        int n = 0;
        while (n < rescaleOpArray.length) {
            SVGFilterDescriptor sVGFilterDescriptor = sVGRescaleOp.toSVG(rescaleOpArray[n]);
            object = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            object.setAttributeNS(null, "filter", sVGFilterDescriptor.getFilterValue());
            element4.appendChild((Node)object);
            ++n;
        }
        int n2 = 0;
        while (n2 < rescaleOpArray.length) {
            object = sVGRescaleOp.toSVG(rescaleOpArray[n2]);
            element = document.createElementNS("http://www.w3.org/2000/svg", "rect");
            element.setAttributeNS(null, "filter", ((SVGFilterDescriptor)object).getFilterValue());
            element5.appendChild(element);
            ++n2;
        }
        object = sVGRescaleOp.getDefinitionSet().iterator();
        while (object.hasNext()) {
            element = (Element)object.next();
            element3.appendChild(element);
        }
        element2.appendChild(element3);
        element2.appendChild(element4);
        element2.appendChild(element5);
        TestUtil.trace(element2, System.out);
    }
}

