/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.filter.GraphicsNodeRableFactory;

public class GraphicsNodeRenderContext
extends RenderContext {
    public static RenderingHints.Key KEY_FONT_RENDER_CONTEXT = new RenderingHints.Key(100){

        public boolean isCompatibleValue(Object object) {
            boolean bl = true;
            if (object != null && !(object instanceof FontRenderContext)) {
                bl = false;
            }
            return bl;
        }
    };
    public static RenderingHints.Key KEY_TEXT_PAINTER = new RenderingHints.Key(101){

        public boolean isCompatibleValue(Object object) {
            boolean bl = true;
            if (object != null && !(object instanceof TextPainter)) {
                bl = false;
            }
            return bl;
        }
    };
    public static RenderingHints.Key KEY_GRAPHICS_NODE_RABLE_FACTORY = new RenderingHints.Key(102){

        public boolean isCompatibleValue(Object object) {
            boolean bl = true;
            if (object != null && !(object instanceof GraphicsNodeRableFactory)) {
                bl = false;
            }
            return bl;
        }
    };

    public FontRenderContext getFontRenderContext() {
        RenderingHints renderingHints = this.getRenderingHints();
        return (FontRenderContext)renderingHints.get(KEY_FONT_RENDER_CONTEXT);
    }

    public void setFontRenderContext(FontRenderContext fontRenderContext) {
        RenderingHints renderingHints = this.getRenderingHints();
        renderingHints.put(KEY_FONT_RENDER_CONTEXT, fontRenderContext);
    }

    public TextPainter getTextPainter() {
        RenderingHints renderingHints = this.getRenderingHints();
        return (TextPainter)renderingHints.get(KEY_TEXT_PAINTER);
    }

    public void setTextPainter(TextPainter textPainter) {
        RenderingHints renderingHints = this.getRenderingHints();
        renderingHints.put(KEY_TEXT_PAINTER, textPainter);
        this.setRenderingHints(renderingHints);
        renderingHints = this.getRenderingHints();
    }

    public GraphicsNodeRableFactory getGraphicsNodeRableFactory() {
        RenderingHints renderingHints = this.getRenderingHints();
        return (GraphicsNodeRableFactory)renderingHints.get(KEY_GRAPHICS_NODE_RABLE_FACTORY);
    }

    public void setGraphicsNodeRableFactory(GraphicsNodeRableFactory graphicsNodeRableFactory) {
        RenderingHints renderingHints = this.getRenderingHints();
        renderingHints.put(KEY_GRAPHICS_NODE_RABLE_FACTORY, graphicsNodeRableFactory);
    }

    public static GraphicsNodeRenderContext getGraphicsNodeRenderContext(RenderContext renderContext) {
        GraphicsNodeRenderContext graphicsNodeRenderContext = null;
        graphicsNodeRenderContext = renderContext instanceof GraphicsNodeRenderContext ? (GraphicsNodeRenderContext)renderContext : new GraphicsNodeRenderContext(renderContext);
        return graphicsNodeRenderContext;
    }

    public static GraphicsNodeRenderContext getGraphicsNodeRenderContext(Graphics2D graphics2D) {
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (renderingHints == null) {
            return new GraphicsNodeRenderContext(graphics2D.getTransform(), graphics2D.getClip(), null, null, null, null);
        }
        return new GraphicsNodeRenderContext(graphics2D.getTransform(), graphics2D.getClip(), renderingHints, (FontRenderContext)renderingHints.get(KEY_FONT_RENDER_CONTEXT), (TextPainter)renderingHints.get(KEY_TEXT_PAINTER), (GraphicsNodeRableFactory)renderingHints.get(KEY_GRAPHICS_NODE_RABLE_FACTORY));
    }

    public GraphicsNodeRenderContext(RenderContext renderContext) {
        this(renderContext.getTransform(), renderContext.getAreaOfInterest(), renderContext.getRenderingHints(), renderContext.getRenderingHints() != null ? (FontRenderContext)renderContext.getRenderingHints().get(KEY_FONT_RENDER_CONTEXT) : null, renderContext.getRenderingHints() != null ? (TextPainter)renderContext.getRenderingHints().get(KEY_TEXT_PAINTER) : null, renderContext.getRenderingHints() != null ? (GraphicsNodeRableFactory)renderContext.getRenderingHints().get(KEY_GRAPHICS_NODE_RABLE_FACTORY) : null);
    }

    public GraphicsNodeRenderContext(AffineTransform affineTransform, Shape shape, RenderingHints renderingHints, FontRenderContext fontRenderContext, TextPainter textPainter, GraphicsNodeRableFactory graphicsNodeRableFactory) {
        super(affineTransform, shape, renderingHints);
        if (textPainter != null) {
            this.setTextPainter(textPainter);
        }
        if (fontRenderContext != null) {
            this.setFontRenderContext(fontRenderContext);
        }
        this.setGraphicsNodeRableFactory(graphicsNodeRableFactory);
        if (graphicsNodeRableFactory == null) {
            throw new IllegalArgumentException();
        }
    }
}

