/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TileCache;
import org.apache.batik.ext.awt.image.rendered.TileGenerator;
import org.apache.batik.ext.awt.image.rendered.TileStore;

public class TileRed
extends AbstractRed
implements TileGenerator {
    static final AffineTransform IDENTITY = new AffineTransform();
    Rectangle tiledRegion;
    int xStep;
    int yStep;
    TileStore tiles;
    private RenderingHints hints;
    RenderedImage tile = null;
    WritableRaster raster = null;

    public TileRed(RenderedImage renderedImage, Rectangle rectangle) {
        this(renderedImage, rectangle, renderedImage.getWidth(), renderedImage.getHeight(), null);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, RenderingHints renderingHints) {
        this(renderedImage, rectangle, renderedImage.getWidth(), renderedImage.getHeight(), renderingHints);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, int n, int n2) {
        this(renderedImage, rectangle, n, n2, null);
    }

    public TileRed(RenderedImage renderedImage, Rectangle rectangle, int n, int n2, RenderingHints renderingHints) {
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        if (renderedImage == null) {
            throw new IllegalArgumentException();
        }
        this.tiledRegion = rectangle;
        this.tile = renderedImage;
        this.xStep = n;
        this.yStep = n2;
        this.hints = renderingHints;
        SampleModel sampleModel = TileRed.fixSampleModel(renderedImage, rectangle);
        ColorModel colorModel = renderedImage.getColorModel();
        if (2.0 * (double)sampleModel.getWidth() * (double)sampleModel.getHeight() > (double)n * (double)n2) {
            sampleModel = sampleModel.createCompatibleSampleModel(n, n2);
            this.raster = Raster.createWritableRaster(sampleModel, new Point(renderedImage.getMinX(), renderedImage.getMinY()));
        }
        this.init((CachableRed)null, rectangle, colorModel, sampleModel, renderedImage.getMinX(), renderedImage.getMinY(), null);
        if (this.raster != null) {
            this.fillRasterFrom(this.raster, renderedImage);
        } else {
            this.tiles = TileCache.getTileMap(this);
        }
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        int n = this.getXTile(writableRaster.getMinX());
        int n2 = this.getYTile(writableRaster.getMinY());
        int n3 = this.getXTile(writableRaster.getMinX() + writableRaster.getWidth() - 1);
        int n4 = this.getYTile(writableRaster.getMinY() + writableRaster.getHeight() - 1);
        boolean bl = GraphicsUtil.is_INT_PACK_Data(this.getSampleModel(), false);
        int n5 = n2;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n3) {
                Raster raster = this.getTile(n6, n5);
                if (bl) {
                    GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
                } else {
                    GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
                }
                ++n6;
            }
            ++n5;
        }
        return writableRaster;
    }

    public Raster getTile(int n, int n2) {
        if (this.raster != null) {
            int n3 = this.tileGridXOff + n * this.tileWidth;
            int n4 = this.tileGridYOff + n2 * this.tileHeight;
            return this.raster.createTranslatedChild(n3, n4);
        }
        return this.tiles.getTile(n, n2);
    }

    public Raster genTile(int n, int n2) {
        int n3 = this.tileGridXOff + n * this.tileWidth;
        int n4 = this.tileGridYOff + n2 * this.tileHeight;
        Point point = new Point(n3, n4);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sm, point);
        this.fillRasterFrom(writableRaster, this.tile);
        return writableRaster;
    }

    /*
     * Unable to fully structure code
     */
    public WritableRaster fillRasterFrom(WritableRaster var1_1, RenderedImage var2_2) {
        var3_3 = this.getColorModel();
        var4_4 = new BufferedImage(var3_3, var1_1.createWritableTranslatedChild(0, 0), var3_3.isAlphaPremultiplied(), null);
        var5_5 = GraphicsUtil.createGraphics(var4_4, this.hints);
        var6_6 = var1_1.getMinX();
        var7_7 = var1_1.getMinY();
        var8_8 = var1_1.getHeight();
        var9_9 = var1_1.getWidth();
        var5_5.setComposite(AlphaComposite.Clear);
        var5_5.setColor(new Color(0, 0, 0, 0));
        var5_5.fillRect(0, 0, var9_9, var8_8);
        var5_5.setComposite(AlphaComposite.SrcOver);
        var5_5.translate(-var6_6, -var7_7);
        var14_10 = var2_2.getMinX() + var2_2.getWidth() - 1;
        var15_11 = var2_2.getMinY() + var2_2.getHeight() - 1;
        var10_12 = Math.ceil((var6_6 - var14_10) / this.xStep) * (double)this.xStep;
        var12_13 = Math.ceil((var7_7 - var15_11) / this.yStep) * (double)this.yStep;
        var5_5.translate(var10_12, var12_13);
        var16_14 = var10_12 - (double)var1_1.getMinX() + (double)var2_2.getMinX();
        var18_15 = var12_13 - (double)var1_1.getMinY() + (double)var2_2.getMinY();
        var20_16 = 0;
        ** GOTO lbl32
        {
            GraphicsUtil.drawImage(var5_5, var2_2);
            var16_14 += (double)this.xStep;
            var5_5.translate(this.xStep, 0);
            ++var20_16;
            do {
                if (var16_14 <= (double)var9_9) continue block0;
                var18_15 += (double)this.yStep;
                var5_5.translate(-var20_16 * this.xStep, this.yStep);
                var16_14 -= (double)(var20_16 * this.xStep);
                var20_16 = 0;
lbl32:
                // 2 sources

            } while (var18_15 <= (double)var8_8);
        }
        return var1_1;
    }

    protected static SampleModel fixSampleModel(RenderedImage renderedImage, Rectangle rectangle) {
        int n;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getWidth();
        if (n2 < 256) {
            n2 = 256;
        }
        if (n2 > rectangle.width) {
            n2 = rectangle.width;
        }
        if ((n = sampleModel.getHeight()) < 256) {
            n = 256;
        }
        if (n > rectangle.height) {
            n = rectangle.height;
        }
        return sampleModel.createCompatibleSampleModel(n2, n);
    }
}

