/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterResRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;

public class FilterResRable8Bit
extends AbstractRable
implements FilterResRable {
    private int filterResolutionX = -1;
    private int filterResolutionY = -1;

    public Filter getSource() {
        return (Filter)this.srcs.get(0);
    }

    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    public int getFilterResolutionX() {
        return this.filterResolutionX;
    }

    public void setFilterResolutionX(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.filterResolutionX = n;
    }

    public int getFilterResolutionY() {
        return this.filterResolutionY;
    }

    public void setFilterResolutionY(int n) {
        this.filterResolutionY = n;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        AffineTransform affineTransform = renderContext.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        float f = this.filterResolutionX;
        float f2 = this.filterResolutionY;
        Rectangle2D rectangle2D = this.getBounds2D();
        Rectangle rectangle = affineTransform.createTransformedShape(rectangle2D).getBounds();
        if (f > 1.0f) {
            float f3 = 1.0f;
            float f4 = 1.0f;
            if (f < (float)rectangle.width) {
                f3 = f / (float)rectangle.width;
            }
            if (f2 != 0.0f) {
                if (f2 < 0.0f) {
                    f2 = f3 * (float)rectangle.height;
                }
                if (f2 < (float)rectangle.height) {
                    f4 = f2 / (float)rectangle.height;
                }
                Filter filter = this.getSource();
                RenderContext renderContext2 = renderContext;
                if (f3 < 1.0f || f4 < 1.0f) {
                    f4 = f3 = f3 < f4 ? f3 : f4;
                    AffineTransform affineTransform2 = AffineTransform.getScaleInstance(f3, f4);
                    affineTransform2.concatenate(affineTransform);
                    RenderContext renderContext3 = (RenderContext)renderContext.clone();
                    renderContext3.setTransform(affineTransform2);
                    Shape shape = renderContext.getAreaOfInterest();
                    if (shape == null) {
                        shape = this.getBounds2D();
                    }
                    Rectangle2D rectangle2D2 = shape.getBounds2D();
                    rectangle2D2 = new Rectangle2D.Double(rectangle2D2.getX() - (double)f3, rectangle2D2.getY() - (double)f4, rectangle2D2.getWidth() + (double)(2.0f * f3), rectangle2D2.getHeight() + (double)(2.0f * f4));
                    renderContext3.setAreaOfInterest(rectangle2D2);
                    AffineTransform affineTransform3 = AffineTransform.getScaleInstance(1.0f / f3, 1.0f / f4);
                    RenderedImage renderedImage = null;
                    renderedImage = filter.createRendering(renderContext3);
                    if (renderedImage != null) {
                        renderedImage = new AffineRed(RenderedImageCachableRed.wrap(renderedImage), affineTransform3, renderContext.getRenderingHints());
                    }
                    return renderedImage;
                }
                return filter.createRendering(renderContext2);
            }
        }
        return null;
    }
}

