/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.batik.dom.util.HashTable;
import org.apache.batik.util.XMLCharacters;
import org.apache.batik.util.XMLUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtilities
extends XMLUtilities {
    protected DOMUtilities() {
    }

    public static void writeDocument(Document document, Writer writer) throws IOException {
        Node node = document.getFirstChild();
        while (node != null) {
            DOMUtilities.writeNode(node, writer);
            node = node.getNextSibling();
        }
    }

    public static void writeNode(Node node, Writer writer) throws IOException {
        switch (node.getNodeType()) {
            case 1: {
                Object object;
                writer.write("<");
                writer.write(node.getNodeName());
                if (node.hasAttributes()) {
                    object = node.getAttributes();
                    int n = object.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        Attr attr = (Attr)object.item(n2);
                        writer.write(" ");
                        writer.write(attr.getNodeName());
                        writer.write("=\"");
                        writer.write(DOMUtilities.contentToString(attr.getNodeValue()));
                        writer.write("\"");
                        ++n2;
                    }
                }
                if ((object = node.getFirstChild()) != null) {
                    writer.write(">");
                    while (object != null) {
                        DOMUtilities.writeNode((Node)object, writer);
                        object = object.getNextSibling();
                    }
                    writer.write("</");
                    writer.write(node.getNodeName());
                    writer.write(">");
                    break;
                }
                writer.write("/>");
                break;
            }
            case 3: {
                writer.write(DOMUtilities.contentToString(node.getNodeValue()));
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                writer.write(node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 5: {
                writer.write("&");
                writer.write(node.getNodeName());
                writer.write(";");
                break;
            }
            case 7: {
                writer.write("<?");
                writer.write(node.getNodeName());
                writer.write(node.getNodeValue());
                writer.write("?>");
                break;
            }
            case 8: {
                writer.write("<!--");
                writer.write(node.getNodeValue());
                writer.write("-->");
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new Error("Internal error (" + node.getNodeType() + ")");
            }
        }
    }

    public static String contentToString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Document deepCloneDocument(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getDocumentElement();
        Document document2 = dOMImplementation.createDocument(element.getNamespaceURI(), element.getNodeName(), null);
        Element element2 = document2.getDocumentElement();
        boolean bl = true;
        Node node = document.getFirstChild();
        while (node != null) {
            if (node == element) {
                bl = false;
                if (element.hasAttributes()) {
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = namedNodeMap.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        element2.setAttributeNode((Attr)DOMUtilities.deepCloneNode(namedNodeMap.item(n2), document2));
                        ++n2;
                    }
                }
                DOMUtilities.deepCloneChildren(element, element2, document2);
            } else if (node.getNodeType() != 10) {
                if (bl) {
                    document2.insertBefore(DOMUtilities.deepCloneNode(node, document2), element2);
                } else {
                    document2.appendChild(DOMUtilities.deepCloneNode(node, document2));
                }
            }
            node = node.getNextSibling();
        }
        return document2;
    }

    protected static Node deepCloneNode(Node node, Document document) {
        switch (node.getNodeType()) {
            case 1: {
                Element element = document.createElementNS(node.getNamespaceURI(), node.getNodeName());
                DOMUtilities.deepCloneChildren(node, element, document);
                if (node.hasAttributes()) {
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    int n = namedNodeMap.getLength();
                    Element element2 = element;
                    int n2 = 0;
                    while (n2 < n) {
                        element2.setAttributeNode((Attr)DOMUtilities.deepCloneNode(namedNodeMap.item(n2), document));
                        ++n2;
                    }
                }
                return element;
            }
            case 2: {
                Attr attr = document.createAttributeNS(node.getNamespaceURI(), node.getNodeName());
                DOMUtilities.deepCloneChildren(node, attr, document);
                return attr;
            }
            case 3: {
                return document.createTextNode(node.getNodeValue());
            }
            case 4: {
                return document.createCDATASection(node.getNodeValue());
            }
            case 5: {
                EntityReference entityReference = document.createEntityReference(node.getNodeName());
                DOMUtilities.deepCloneChildren(node, entityReference, document);
                return entityReference;
            }
            case 7: {
                return document.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
            }
            case 8: {
                return document.createComment(node.getNodeValue());
            }
        }
        throw new Error("Internal error (" + node.getNodeType() + ")");
    }

    protected static void deepCloneChildren(Node node, Node node2, Document document) {
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            node2.appendChild(DOMUtilities.deepCloneNode(node3, document));
            node3 = node3.getNextSibling();
        }
    }

    public static boolean isValidName(String string) {
        int n;
        char c = string.charAt(0);
        int n2 = c / 32;
        if ((XMLCharacters.NAME_FIRST_CHARACTER[n2] & 1 << (n = c % 32)) == 0) {
            return false;
        }
        int n3 = string.length();
        int n4 = 1;
        while (n4 < n3) {
            c = string.charAt(n4);
            n2 = c / 32;
            if ((XMLCharacters.NAME_CHARACTER[n2] & 1 << (n = c % 32)) == 0) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static boolean isValidPrefix(String string) {
        return string.indexOf(58) == -1;
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? null : string.substring(0, n);
    }

    public static String getLocalName(String string) {
        int n = string.indexOf(58);
        return n == -1 || n == string.length() - 1 ? string : string.substring(n + 1);
    }

    /*
     * Unable to fully structure code
     */
    public static void parseStyleSheetPIData(String var0, HashTable var1_1) {
        var3_2 = 0;
        while (var3_2 < var0.length()) {
            var2_3 = var0.charAt(var3_2);
            if (!XMLUtilities.isXMLSpace(var2_3)) break;
            ++var3_2;
        }
        block1: while (var3_2 < var0.length()) {
            var2_3 = var0.charAt(var3_2);
            var4_4 = var2_3 / 32;
            if ((XMLCharacters.NAME_FIRST_CHARACTER[var4_4] & 1 << (var5_5 = var2_3 % 32)) == 0) {
                throw new DOMException(5, "Wrong name initial:  " + var2_3);
            }
            var6_6 = new StringBuffer();
            var6_6.append(var2_3);
            while (++var3_2 < var0.length()) {
                var2_3 = var0.charAt(var3_2);
                var4_4 = var2_3 / 32;
                if ((XMLCharacters.NAME_CHARACTER[var4_4] & 1 << (var5_5 = var2_3 % 32)) == 0) break;
                var6_6.append(var2_3);
            }
            if (var3_2 < var0.length()) ** GOTO lbl26
            throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            while (XMLUtilities.isXMLSpace(var2_3 = var0.charAt(var3_2))) {
                ++var3_2;
lbl26:
                // 2 sources

                if (var3_2 < var0.length()) continue;
            }
            if (var3_2 >= var0.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            }
            if (var0.charAt(var3_2) != '=') {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            }
            ++var3_2;
            while (var3_2 < var0.length()) {
                var2_3 = var0.charAt(var3_2);
                if (!XMLUtilities.isXMLSpace(var2_3)) break;
                ++var3_2;
            }
            if (var3_2 >= var0.length()) {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            }
            var2_3 = var0.charAt(var3_2);
            ++var3_2;
            var7_7 = new StringBuffer();
            if (var2_3 == '\'') {
                while (var3_2 < var0.length()) {
                    var2_3 = var0.charAt(var3_2);
                    if (var2_3 == '\'') break;
                    var7_7.append(var2_3);
                    ++var3_2;
                }
                if (var3_2 >= var0.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
                }
            } else if (var2_3 == '\"') {
                while (var3_2 < var0.length()) {
                    var2_3 = var0.charAt(var3_2);
                    if (var2_3 == '\"') break;
                    var7_7.append(var2_3);
                    ++var3_2;
                }
                if (var3_2 >= var0.length()) {
                    throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
                }
            } else {
                throw new DOMException(12, "Wrong xml-stylesheet data: " + var0);
            }
            var1_1.put(var6_6.toString().intern(), var7_7.toString());
            ++var3_2;
            while (var3_2 < var0.length()) {
                var2_3 = var0.charAt(var3_2);
                if (!XMLUtilities.isXMLSpace(var2_3)) continue block1;
                ++var3_2;
            }
        }
    }
}

