/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.ModificationHandler;
import org.apache.batik.dom.svg.SVGList;
import org.apache.batik.dom.svg.SVGOMNumber;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGNumberList;

public class SVGOMNumberList
implements SVGNumberList,
LiveAttributeValue,
ModificationHandler {
    protected SVGList list = new SVGList();
    protected ModificationHandler modificationHandler;
    protected boolean internalChange;

    public void setModificationHandler(ModificationHandler modificationHandler) {
        this.modificationHandler = modificationHandler;
    }

    public int getNumberOfItems() {
        return this.list.getNumberOfItems();
    }

    public void clear() throws DOMException {
        this.list.clear();
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, "");
            this.internalChange = false;
        }
    }

    public SVGNumber initialize(SVGNumber sVGNumber) throws DOMException, SVGException {
        SVGOMNumber sVGOMNumber = (SVGOMNumber)this.list.initialize(sVGNumber);
        sVGOMNumber.setModificationHandler(this);
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, Float.toString(sVGNumber.getValue()));
            this.internalChange = false;
        }
        return sVGOMNumber;
    }

    public SVGNumber getItem(int n) throws DOMException {
        return (SVGNumber)this.list.getItem(n);
    }

    public SVGNumber insertItemBefore(SVGNumber sVGNumber, int n) throws DOMException, SVGException {
        SVGOMNumber sVGOMNumber = (SVGOMNumber)this.list.insertItemBefore(sVGNumber, n);
        sVGOMNumber.setModificationHandler(this);
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, this.getStringRepresentation());
            this.internalChange = false;
        }
        return sVGOMNumber;
    }

    public SVGNumber replaceItem(SVGNumber sVGNumber, int n) throws DOMException, SVGException {
        SVGOMNumber sVGOMNumber = (SVGOMNumber)this.list.replaceItem(sVGNumber, n);
        sVGOMNumber.setModificationHandler(this);
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, this.getStringRepresentation());
            this.internalChange = false;
        }
        return sVGOMNumber;
    }

    public SVGNumber removeItem(int n) throws DOMException {
        SVGOMNumber sVGOMNumber = (SVGOMNumber)this.list.removeItem(n);
        sVGOMNumber.setModificationHandler(this);
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, this.getStringRepresentation());
            this.internalChange = false;
        }
        return sVGOMNumber;
    }

    public SVGNumber appendItem(SVGNumber sVGNumber) throws DOMException, SVGException {
        SVGOMNumber sVGOMNumber = (SVGOMNumber)this.list.appendItem(sVGNumber);
        sVGOMNumber.setModificationHandler(this);
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, this.getStringRepresentation());
            this.internalChange = false;
        }
        return sVGOMNumber;
    }

    public String getStringRepresentation() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.list.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(((SVGNumber)iterator.next()).getValue());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(' ');
            stringBuffer.append(((SVGNumber)iterator.next()).getValue());
        }
        return stringBuffer.toString();
    }

    public void valueChanged(Attr attr, Attr attr2) {
        if (!this.internalChange) {
            if (attr == null) {
                this.parseValue(attr2.getValue());
            } else {
                this.parseValue(attr.getValue(), attr2.getValue());
            }
        }
    }

    public void parseValue(String string) {
        this.parseValue("", string);
    }

    protected void parseValue(String string, String string2) {
        if (!string.equals(string2)) {
            this.list.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                SVGOMNumber sVGOMNumber = new SVGOMNumber();
                sVGOMNumber.parseValue(stringTokenizer.nextToken());
                sVGOMNumber.setModificationHandler(this);
                this.list.appendItem(sVGOMNumber);
            }
        }
    }

    public void valueChanged(Object object, String string) {
        if (this.modificationHandler != null) {
            this.internalChange = true;
            this.modificationHandler.valueChanged(this, this.getStringRepresentation());
            this.internalChange = false;
        }
    }

    public Object getObject(Object object) {
        return null;
    }
}

