/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.css.event.CSSPropertyChangeEvent;
import org.apache.batik.css.event.CSSPropertyChangeListener;
import org.apache.batik.css.event.CSSRuleEvent;
import org.apache.batik.css.event.CSSStyleDeclarationChangeEvent;
import org.apache.batik.css.event.CSSStyleDeclarationChangeListener;
import org.apache.batik.css.event.CSSStyleRuleChangeEvent;
import org.apache.batik.css.event.CSSStyleRuleChangeListener;
import org.apache.batik.css.event.CSSStyleSheetChangeListener;
import org.apache.batik.css.event.SelectorListChangeEvent;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSValue;

public class CSSStyleSheetChangeSupport {
    protected Object source;
    protected List listeners;

    public CSSStyleSheetChangeSupport(Object object) {
        this.source = object;
    }

    public void addCSSStyleSheetChangeListener(CSSStyleSheetChangeListener cSSStyleSheetChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(3);
        }
        this.listeners.add(cSSStyleSheetChangeListener);
    }

    public void removeCSSStyleSheetChangeListener(CSSStyleSheetChangeListener cSSStyleSheetChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(cSSStyleSheetChangeListener);
    }

    public void fireCSSRuleAdded(CSSRule cSSRule) {
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            CSSRuleEvent cSSRuleEvent = new CSSRuleEvent(this.source, cSSRule);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleSheetChangeListener)iterator.next()).cssRuleAdded(cSSRuleEvent);
            }
        }
    }

    public void fireCSSRuleRemoved(CSSRule cSSRule) {
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            CSSRuleEvent cSSRuleEvent = new CSSRuleEvent(this.source, cSSRule);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleSheetChangeListener)iterator.next()).cssRuleRemoved(cSSRuleEvent);
            }
        }
    }

    public void fireCSSStyleDeclarationChangeStart(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleDeclarationChangeListener)iterator.next()).cssStyleDeclarationChangeStart(cSSStyleDeclarationChangeEvent);
            }
        }
    }

    public void fireCSSStyleDeclarationChangeCancel(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleDeclarationChangeListener)iterator.next()).cssStyleDeclarationChangeCancel(cSSStyleDeclarationChangeEvent);
            }
        }
    }

    public void fireCSSStyleDeclarationChangeEnd(CSSStyleDeclarationChangeEvent cSSStyleDeclarationChangeEvent) {
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleDeclarationChangeListener)iterator.next()).cssStyleDeclarationChangeEnd(cSSStyleDeclarationChangeEvent);
            }
        }
    }

    public void fireCSSPropertyChange(CSSPropertyChangeEvent cSSPropertyChangeEvent) {
        CSSValue cSSValue = cSSPropertyChangeEvent.getOldValue();
        if (cSSValue != null && cSSValue.equals(cSSPropertyChangeEvent.getNewValue())) {
            return;
        }
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSPropertyChangeListener)iterator.next()).cssPropertyChange(cSSPropertyChangeEvent);
            }
        }
    }

    public void fireCSSStyleRuleChangeStart(CSSStyleRuleChangeEvent cSSStyleRuleChangeEvent) {
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleRuleChangeListener)iterator.next()).cssStyleRuleChangeStart(cSSStyleRuleChangeEvent);
            }
        }
    }

    public void fireCSSStyleRuleChangeCancel(CSSStyleRuleChangeEvent cSSStyleRuleChangeEvent) {
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleRuleChangeListener)iterator.next()).cssStyleRuleChangeCancel(cSSStyleRuleChangeEvent);
            }
        }
    }

    public void fireCSSStyleRuleChangeEnd(CSSStyleRuleChangeEvent cSSStyleRuleChangeEvent) {
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleRuleChangeListener)iterator.next()).cssStyleRuleChangeEnd(cSSStyleRuleChangeEvent);
            }
        }
    }

    public void fireSelectorListChange(SelectorListChangeEvent selectorListChangeEvent) {
        SelectorList selectorList = selectorListChangeEvent.getOldValue();
        if (selectorList != null && selectorList.equals(selectorListChangeEvent.getNewValue())) {
            return;
        }
        ArrayList arrayList = null;
        if (this.listeners != null) {
            arrayList = new ArrayList(this.listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CSSStyleRuleChangeListener)iterator.next()).selectorListChange(selectorListChangeEvent);
            }
        }
    }
}

