/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.StringReader;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.MissingAttributeException;
import org.apache.batik.bridge.SVGDecoratedShapeElementBridge;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.apache.batik.util.UnitProcessor;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGElement;

public class SVGPathElementBridge
extends SVGDecoratedShapeElementBridge {
    protected void buildShape(BridgeContext bridgeContext, SVGElement sVGElement, ShapeNode shapeNode, CSSStyleDeclaration cSSStyleDeclaration, UnitProcessor.Context context) {
        CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSStyleDeclaration.getPropertyCSSValue("fill-rule");
        int n = CSSUtilities.rule(cSSPrimitiveValue) == 0 ? 1 : 0;
        String string = sVGElement.getAttributeNS(null, "d");
        if (string.length() == 0) {
            throw new MissingAttributeException(Messages.formatMessage("path.d.required", null));
        }
        PathParser pathParser = new PathParser();
        AWTPathProducer aWTPathProducer = new AWTPathProducer();
        aWTPathProducer.setWindingRule(n);
        pathParser.setPathHandler(aWTPathProducer);
        try {
            try {
                pathParser.parse(new StringReader(string));
            }
            catch (ParseException parseException) {
                throw new IllegalAttributeValueException(Messages.formatMessage("path.d.invalid", new Object[]{parseException.getMessage()}), shapeNode);
            }
            Object var13_11 = null;
            shapeNode.setShape(aWTPathProducer.getShape());
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            shapeNode.setShape(aWTPathProducer.getShape());
            throw throwable;
        }
    }
}

