/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DefaultUnitProcessorContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.IllegalAttributeValueException;
import org.apache.batik.bridge.SVGLightElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.resources.Messages;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.Light;
import org.apache.batik.ext.awt.image.renderable.SpecularLightingRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.GraphicsNodeRenderContext;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SVGFeSpecularLightingElementBridge
implements FilterPrimitiveBridge,
SVGConstants {
    public Filter create(GraphicsNode graphicsNode, BridgeContext bridgeContext, Element element, Element element2, Filter filter, Rectangle2D rectangle2D, Map map) {
        SpecularLightingRable8Bit specularLightingRable8Bit = null;
        GraphicsNodeRenderContext graphicsNodeRenderContext = bridgeContext.getGraphicsNodeRenderContext();
        DocumentLoader documentLoader = bridgeContext.getDocumentLoader();
        String string = element.getAttributeNS(null, "in");
        filter = CSSUtilities.getFilterSource(graphicsNode, string, bridgeContext, element2, filter, map);
        if (filter == null) {
            return null;
        }
        Filter filter2 = (Filter)map.get("SourceGraphic");
        Rectangle2D rectangle2D2 = filter.getBounds2D();
        if (filter == filter2) {
            rectangle2D2 = rectangle2D;
        }
        CSSStyleDeclaration cSSStyleDeclaration = CSSUtilities.getComputedStyle(element);
        DefaultUnitProcessorContext defaultUnitProcessorContext = new DefaultUnitProcessorContext(bridgeContext, cSSStyleDeclaration);
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, rectangle2D2, rectangle2D, graphicsNode, graphicsNodeRenderContext, defaultUnitProcessorContext, documentLoader);
        Color color = CSSUtilities.convertLightingColor(element, cSSStyleDeclaration, bridgeContext);
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        if (n < 1) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feSpecularLighting.child.missing", null));
        }
        Node node = nodeList.item(0);
        if (node == null || node.getNodeType() != 1) {
            throw new IllegalAttributeValueException(Messages.formatMessage("feSpecularLighting.child.missing", null));
        }
        Light light = SVGLightElementBridge.createLight((Element)node, color);
        String string2 = element.getAttributeNS(null, "specularConstant");
        double d = SVGUtilities.convertSVGNumber("specularConstant", string2);
        String string3 = element.getAttributeNS(null, "specularExponent");
        double d2 = SVGUtilities.convertSVGNumber("specularExponent", string3);
        String string4 = element.getAttributeNS(null, "surfaceScale");
        double d3 = SVGUtilities.convertSVGNumber("surfaceScale", string4);
        specularLightingRable8Bit = new SpecularLightingRable8Bit(filter, rectangle2D3, light, d, d2, d3);
        String string5 = element.getAttributeNS(null, "result");
        if (string5 != null && string5.trim().length() > 0) {
            map.put(string5, specularLightingRable8Bit);
        }
        return specularLightingRable8Bit;
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
    }
}

