/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.regard;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Calendar;
import org.apache.batik.ext.awt.image.ImageLoader;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.XMLAbstractTranscoder;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;

public class Main {
    static final String REGARD_DIRECTORY_NAME = "regard";
    static final String REGARD_REF_DIRECTORY_NAME = "ref";
    static final String REGARD_NEW_DIRECTORY_NAME = "new";
    static final String REGARD_SVG_DIRECTORY_NAME = "svg";
    static final String REGARD_DIFF_DIRECTORY_NAME = "diff";
    static final String REGARD_REPORT_FILE_NAME = "report";
    static final String REGARD_REPORT_FILE_EXT = "html";
    static final String REGARD_REPORT_HEAD_STRING = "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\"> <html> <body> <center>Batik Regression Guard Tool(Regard) Report</center>";
    static final String REGARD_REPORT_END_STRING = "</body> </html>";
    static final String REGARD_REPORT_NO_REGRESSION_STRING = "<p>There's no file that has regression.<br>";

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            Main.usage(System.err);
            Main.exit(1);
        }
        if (stringArray[0].equals("-help")) {
            Main.usage(System.out);
            Main.exit(0);
        } else if (stringArray[0].equals("-init")) {
            Main.init();
        } else if (stringArray[0].equals("-reset")) {
            Main.reset();
        } else if (stringArray[0].equals("-ref")) {
            Main.generateRefImages();
        } else if (stringArray[0].equals("-new")) {
            Main.generateNewImages();
        } else if (stringArray[0].equals("-diff")) {
            Main.diffImage();
        } else {
            Main.usage(System.err);
            Main.exit(1);
        }
    }

    public static void init() {
        File file = new File(REGARD_DIRECTORY_NAME);
        if (!file.exists()) {
            Main.display("Creating " + file.getAbsolutePath());
            file.mkdir();
            File file2 = new File(file, REGARD_NEW_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating " + file2.getAbsolutePath());
            file2 = new File(file, REGARD_REF_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating " + file2.getAbsolutePath());
            file2 = new File(file, REGARD_SVG_DIRECTORY_NAME);
            file2.mkdir();
            Main.display("Creating " + file2.getAbsolutePath());
            Main.exit(0);
        } else {
            Main.error(file.getAbsolutePath() + " already exists");
            Main.exit(2);
        }
    }

    public static void reset() {
        int n;
        File file = new File(Main.getRefDirectory());
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            n = 0;
            while (n < fileArray.length) {
                Main.display("Deleting reference image " + fileArray[n].getName());
                fileArray[n].delete();
                ++n;
            }
        }
        if ((fileArray = (file = new File(Main.getNewDirectory())).listFiles()) != null) {
            n = 0;
            while (n < fileArray.length) {
                Main.display("Deleting new image " + fileArray[n].getName());
                fileArray[n].delete();
                ++n;
            }
        }
        if ((fileArray = (file = new File(Main.getDiffDirectory())).listFiles()) != null) {
            n = 0;
            while (n < fileArray.length) {
                Main.display("Deleting diff image " + fileArray[n].getName());
                fileArray[n].delete();
                ++n;
            }
        }
        Main.exit(0);
    }

    public static void generateRefImages() {
        File file;
        String[] stringArray;
        File file2 = new File(REGARD_DIRECTORY_NAME);
        if (!file2.exists()) {
            Main.error("regard is not initialized. use -init first");
        }
        if ((stringArray = (file = new File(file2, REGARD_REF_DIRECTORY_NAME)).list()) != null && stringArray.length != 0) {
            Main.error("The reference directory " + file.getAbsolutePath() + " is not empty. Use -reset first.");
            Main.exit(3);
        }
        Main.generateImages(Main.getRefDirectory(), "reference image for");
        Main.exit(0);
    }

    public static void generateNewImages() {
        File file = new File(REGARD_DIRECTORY_NAME);
        if (!file.exists()) {
            Main.error("regard is not initialized. use -init first");
        }
        Main.generateImages(Main.getNewDirectory(), "new image for");
        Main.exit(0);
    }

    static void generateImages(String string, String string2) {
        File file = new File(string);
        File file2 = new File(Main.getSamplesDirectory());
        ImageTranscoder imageTranscoder = Main.getTranscoder();
        File[] fileArray = file2.listFiles();
        if (fileArray == null) {
            Main.error("No SVG files has been found in " + file2.getAbsolutePath());
            Main.exit(2);
        }
        System.out.println("Generating images for " + fileArray.length + " samples");
        int n = 0;
        while (n < fileArray.length) {
            File file3 = fileArray[n];
            if (file3.getName().endsWith(".svg")) {
                File file4 = new File(file, Main.getImageName(file3.getName()));
                Main.display("Generating " + string2 + " " + file3.getName());
                try {
                    Main.writeImage(imageTranscoder, file3.toURL().toString(), file4.getAbsolutePath());
                }
                catch (MalformedURLException malformedURLException) {
                    Main.error("Bad URL for " + file3.getAbsolutePath() + " or " + file4.getAbsolutePath());
                }
            }
            ++n;
        }
    }

    static String getImageName(String string) {
        if (string.endsWith(".svg")) {
            string = string.substring(0, string.lastIndexOf(".svg"));
            string = string + ".png";
        }
        return string;
    }

    public static void diffImage() {
        File file = new File(REGARD_DIRECTORY_NAME);
        if (!file.exists()) {
            Main.error("regard is not initialized. use -init first");
        }
        File file2 = new File(Main.getRefDirectory());
        File file3 = new File(Main.getNewDirectory());
        File[] fileArray = file2.listFiles();
        int[] nArray = new int[fileArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file4 = fileArray[n2];
            File file5 = new File(file3, file4.getName());
            boolean bl = Main.diffImage(file4.getAbsolutePath(), file5.getAbsolutePath());
            if (bl) {
                Main.display("Diff: " + file4.getName() + " ok");
            } else {
                nArray[n] = n2;
                Main.display("Diff: " + file4.getName() + " has regression");
                ++n;
            }
            ++n2;
        }
        Main.display("Total: " + n + "/" + fileArray.length + " corrupted");
        if (n > 0) {
            Main.generateReport(fileArray, nArray, n);
        } else {
            Main.generateReport();
        }
        Main.exit(0);
    }

    public static void generateReport() {
        String string = Main.computeTimeStamp();
        String string2 = "report_" + string + "." + REGARD_REPORT_FILE_EXT;
        File file = new File(REGARD_DIRECTORY_NAME);
        File file2 = new File(file, string2);
        Main.display("Creating report...");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
            String string3 = new String();
            string3 = string3 + REGARD_REPORT_HEAD_STRING;
            string3 = string3 + REGARD_REPORT_NO_REGRESSION_STRING;
            string3 = string3 + "<p>Reported On:";
            string3 = string3 + string;
            string3 = string3 + REGARD_REPORT_END_STRING;
            printWriter.print(string3);
            printWriter.close();
            Main.display("Report finished");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void generateReport(File[] fileArray, int[] nArray, int n) {
        Object object;
        File file = new File(REGARD_DIRECTORY_NAME);
        String string = Main.computeTimeStamp();
        String string2 = "report_" + string + "." + REGARD_REPORT_FILE_EXT;
        File file2 = new File(file, string2);
        File file3 = new File(file, REGARD_DIFF_DIRECTORY_NAME);
        file3.mkdir();
        Main.display("Creating " + file3.getAbsolutePath());
        File file4 = new File(Main.getNewDirectory());
        Main.display("Creating report...");
        String string3 = new String();
        string3 = string3 + REGARD_REPORT_HEAD_STRING;
        string3 = string3 + "<p>There're ";
        string3 = string3 + String.valueOf(n);
        string3 = string3 + " file(s) that has/have regression:<p>";
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            Object object2;
            object = fileArray[nArray[n3]];
            File file5 = new File(file4, ((File)object).getName());
            File file6 = new File(file3, ((File)object).getName());
            BufferedImage bufferedImage = ImageLoader.loadImage((File)object, 2);
            if (bufferedImage == null) {
                Main.display("Fatal error, reference image unreadable!");
                object2 = "<br>" + n2 + ".  " + ((File)object).getName() + ": Reference Image unreadable!";
                string3 = string3 + (String)object2;
                ++n2;
            } else {
                Object object3;
                object2 = ImageLoader.loadImage(file5, 2);
                if (object2 == null) {
                    Main.display("Fatal error, new image unreadable!");
                    object3 = "<br>" + n2 + ".  " + file5.getName() + ": New Image unreadable!";
                    string3 = string3 + (String)object3;
                    ++n2;
                } else if (bufferedImage.getWidth() != ((BufferedImage)object2).getWidth() || bufferedImage.getHeight() != ((BufferedImage)object2).getHeight()) {
                    Main.display("Fatal error, image size changed!");
                    object3 = "<br>" + n2 + ".  " + ((File)object).getName() + ": image size changed!";
                    string3 = string3 + (String)object3;
                    ++n2;
                } else {
                    object3 = Main.getTranscoder();
                    BufferedImage bufferedImage2 = ((ImageTranscoder)object3).createImage(2 * bufferedImage.getWidth(), 2 * bufferedImage.getHeight());
                    Main.display(String.valueOf(n3 + 1) + ". " + "Creating the difference image file of " + ((File)object).getName());
                    boolean bl = Main.diffBufferedImage(bufferedImage.getRaster(), ((BufferedImage)object2).getRaster(), bufferedImage2.getRaster());
                    if (!bl) {
                        Main.display("   No difference in image content");
                    } else {
                        try {
                            ((ImageTranscoder)object3).writeImage(bufferedImage2, new TranscoderOutput(new FileOutputStream(file6)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            String string4 = file6.toURL().toString();
                            string3 = string3 + "<br>" + n2 + ". " + "<a href=" + "\"" + string4 + "\"" + ">" + "<img border=\"0\" hspace=\"0\" vspace=\"0\" " + "align=\"middle\" src=" + "\"" + string4 + "\"" + " height=100 width=90" + " />" + "</a>";
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
            }
            ++n3;
        }
        string3 = string3 + "<p>Reported On: ";
        string3 = string3 + string;
        string3 = string3 + REGARD_REPORT_END_STRING;
        try {
            object = new PrintWriter(new FileWriter(file2));
            ((PrintWriter)object).print(string3);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Main.display("Report finished");
    }

    public static boolean diffBufferedImage(Raster raster, Raster raster2, Raster raster3) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
        DataBufferInt dataBufferInt3 = (DataBufferInt)raster3.getDataBuffer();
        int n3 = dataBufferInt.getOffset();
        int n4 = dataBufferInt2.getOffset();
        int n5 = dataBufferInt3.getOffset();
        int n6 = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int n7 = ((SinglePixelPackedSampleModel)raster2.getSampleModel()).getScanlineStride();
        int n8 = ((SinglePixelPackedSampleModel)raster3.getSampleModel()).getScanlineStride();
        int[] nArray = dataBufferInt.getBankData()[0];
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int[] nArray3 = dataBufferInt3.getBankData()[0];
        boolean bl = false;
        int n9 = 0;
        while (n9 < n2) {
            int n10 = n3 + n9 * n6;
            int n11 = n4 + n9 * n7;
            int n12 = n5 + n9 * n8;
            int n13 = n5 + n9 * n8 + n;
            int n14 = n5 + (n9 + n2) * n8;
            int n15 = 0;
            while (n15 < n) {
                int n16 = nArray[n10];
                int n17 = nArray2[n11];
                int n18 = n17 - n16;
                nArray3[n12] = n16;
                nArray3[n13] = n17;
                nArray3[n14] = n18;
                if (n18 != 0) {
                    bl = true;
                }
                ++n10;
                ++n11;
                ++n12;
                ++n13;
                ++n14;
                ++n15;
            }
            ++n9;
        }
        return bl;
    }

    public static String computeTimeStamp() {
        String string = "";
        Calendar calendar = Calendar.getInstance();
        string = string + String.valueOf(calendar.get(10));
        string = string + "_";
        string = string + String.valueOf(calendar.get(12));
        string = string + "_";
        string = string + String.valueOf(calendar.get(2));
        string = string + "_";
        string = string + String.valueOf(calendar.get(5));
        string = string + "_";
        string = string + String.valueOf(calendar.get(1));
        return string;
    }

    public static void writeImage(ImageTranscoder imageTranscoder, String string, String string2) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            imageTranscoder.transcode(new TranscoderInput(string), new TranscoderOutput(bufferedOutputStream));
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            Main.error("while writing " + string + " to " + string2 + "\n" + exception.getMessage());
        }
    }

    public static boolean diffImage(String string, String string2) {
        try {
            int n;
            int n2;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(string2));
            do {
                n2 = ((InputStream)bufferedInputStream).read();
                n = ((InputStream)bufferedInputStream2).read();
            } while (n2 != -1 && n != -1 && n2 == n);
            ((InputStream)bufferedInputStream).close();
            ((InputStream)bufferedInputStream2).close();
            return n2 == n;
        }
        catch (IOException iOException) {
            System.out.println("Error while diffing " + string + " and " + string2);
            return false;
        }
    }

    public static ImageTranscoder getTranscoder() {
        PNGTranscoder pNGTranscoder = new PNGTranscoder();
        pNGTranscoder.addTranscodingHint(XMLAbstractTranscoder.KEY_XML_PARSER_CLASSNAME, "org.apache.crimson.parser.XMLReaderImpl");
        return pNGTranscoder;
    }

    public static void error(String string) {
        System.err.println("ERROR: " + string);
    }

    public static void display(String string) {
        System.out.println(string);
    }

    public static void usage(PrintStream printStream) {
        printStream.println("usage: regard [-help|-init|-reset|-ref|-new|-diff]");
        printStream.println("-help   Display this message");
        printStream.println("-init   Initialize regard");
        printStream.println("-reset  Removes the reference and new images");
        printStream.println("-ref    Produces reference images");
        printStream.println("-new    Produces new images");
        printStream.println("-diff   Diff the reference and the new images");
    }

    public static void exit(int n) {
        System.exit(n);
    }

    public static String getRefDirectory() {
        File file = new File(REGARD_DIRECTORY_NAME);
        return new File(file, REGARD_REF_DIRECTORY_NAME).getAbsolutePath();
    }

    public static String getNewDirectory() {
        File file = new File(REGARD_DIRECTORY_NAME);
        return new File(file, REGARD_NEW_DIRECTORY_NAME).getAbsolutePath();
    }

    public static String getSamplesDirectory() {
        File file = new File(REGARD_DIRECTORY_NAME);
        return new File(file, REGARD_SVG_DIRECTORY_NAME).getAbsolutePath();
    }

    public static String getDiffDirectory() {
        File file = new File(REGARD_DIRECTORY_NAME);
        return new File(file, REGARD_DIFF_DIRECTORY_NAME).getAbsolutePath();
    }
}

