/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Access;
import org.hsqldb.Channel;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Result;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;

class DatabaseInformation {
    private Database dDatabase;
    private Access aAccess;
    private Vector tTable;
    static final String META_SCHEM = "SCHEM";
    static final String META_CAT = "CAT";
    static final String META_COLUMN_SIZE = "COLUMN_SIZE";
    static final String META_BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String META_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String META_NUM_PREC_RADIX = "NUM_PREC_RADIX";
    static final String META_FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    static final String META_ORDINAL_POSITON = "ORDINAL_POSITON";
    static final String META_ASC_OR_DESC = "ASC_OR_DESC";

    DatabaseInformation(Database database, Vector vector, Access access) {
        this.dDatabase = database;
        this.tTable = vector;
        this.aAccess = access;
    }

    private void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private Table createTable(String string) {
        return new Table(this.dDatabase, false, string, false);
    }

    private String getColumnList(Table table, int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(table.getColumnName(nArray[n2]));
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        return stringBuffer.append(')').toString();
    }

    Result getScript(boolean bl, boolean bl2, boolean bl3, Channel channel) throws SQLException {
        Object object;
        Object object2;
        int n;
        StringBuffer stringBuffer;
        Object object3;
        channel.checkAdmin();
        Result result = new Result(1);
        result.iType[0] = 12;
        result.sTable[0] = "SYSTEM_SCRIPT";
        result.sLabel[0] = "COMMAND";
        result.sName[0] = "COMMAND";
        int n2 = 0;
        while (n2 < this.tTable.size()) {
            int n3;
            Object object4;
            Object object5;
            Object object6;
            object3 = (Table)this.tTable.elementAt(n2);
            if (bl) {
                this.addRow(result, "DROP TABLE " + ((Table)object3).getName());
            }
            stringBuffer = new StringBuffer("CREATE ");
            if (((Table)object3).isCached()) {
                stringBuffer.append("CACHED ");
            }
            stringBuffer.append("TABLE ");
            stringBuffer.append(((Table)object3).getName());
            stringBuffer.append('(');
            n = ((Table)object3).getColumnCount();
            object2 = ((Table)object3).getIndex("SYSTEM_PK");
            int n4 = object2 == null ? -1 : ((Index)object2).getColumns()[0];
            int n5 = 0;
            while (n5 < n) {
                stringBuffer.append(((Table)object3).getColumnName(n5));
                stringBuffer.append(' ');
                stringBuffer.append(Column.getType(((Table)object3).getType(n5)));
                if (!((Table)object3).getColumnIsNullable(n5)) {
                    stringBuffer.append(" NOT NULL");
                }
                if (n5 == ((Table)object3).getIdentityColumn()) {
                    stringBuffer.append(" IDENTITY");
                }
                if (n5 == n4) {
                    stringBuffer.append(" PRIMARY KEY");
                }
                if (n5 < n - 1) {
                    stringBuffer.append(',');
                }
                ++n5;
            }
            object = ((Table)object3).getConstraints();
            int n6 = 0;
            while (n6 < ((Vector)object).size()) {
                object6 = (Constraint)((Vector)object).elementAt(n6);
                if (((Constraint)object6).getType() == 0) {
                    stringBuffer.append(",FOREIGN KEY");
                    object5 = ((Constraint)object6).getRefColumns();
                    stringBuffer.append(this.getColumnList(((Constraint)object6).getRef(), (int[])object5, ((int[])object5).length));
                    stringBuffer.append("REFERENCES ");
                    stringBuffer.append(((Constraint)object6).getMain().getName());
                    object5 = ((Constraint)object6).getMainColumns();
                    stringBuffer.append(this.getColumnList(((Constraint)object6).getMain(), (int[])object5, ((Object)object5).length));
                } else if (((Constraint)object6).getType() == 2) {
                    stringBuffer.append(",UNIQUE");
                    object5 = ((Constraint)object6).getMainColumns();
                    stringBuffer.append(this.getColumnList(((Constraint)object6).getMain(), (int[])object5, ((Object)object5).length));
                }
                ++n6;
            }
            stringBuffer.append(')');
            this.addRow(result, stringBuffer.toString());
            object6 = null;
            while ((object6 = ((Table)object3).getNextIndex((Index)object6)) != null) {
                object5 = ((Index)object6).getName();
                if (((String)object5).equals("SYSTEM_PK") || ((String)object5).startsWith("SYSTEM_FOREIGN_KEY") || ((String)object5).startsWith("SYSTEM_CONSTRAINT")) continue;
                stringBuffer = new StringBuffer("CREATE ");
                if (((Index)object6).isUnique()) {
                    stringBuffer.append("UNIQUE ");
                }
                stringBuffer.append("INDEX ");
                stringBuffer.append((String)object5);
                stringBuffer.append(" ON ");
                stringBuffer.append(((Table)object3).getName());
                object4 = ((Index)object6).getColumns();
                n3 = ((Object)object4).length;
                if (!((Index)object6).isUnique()) {
                    --n3;
                }
                stringBuffer.append(this.getColumnList((Table)object3, (int[])object4, n3));
                this.addRow(result, stringBuffer.toString());
            }
            if (bl2) {
                object5 = ((Table)object3).getPrimaryIndex();
                object4 = ((Index)object5).first();
                n3 = 1;
                if (object4 != null) {
                    n3 = 0;
                    this.addRow(result, "SET REFERENTIAL_INTEGRITY FALSE");
                }
                while (object4 != null) {
                    this.addRow(result, ((Table)object3).getInsertStatement(((Node)object4).getData()));
                    object4 = ((Index)object5).next((Node)object4);
                }
                if (n3 == 0) {
                    this.addRow(result, "SET REFERENTIAL_INTEGRITY TRUE");
                }
            }
            if (bl3 && ((Table)object3).isCached()) {
                stringBuffer = new StringBuffer("SET TABLE ");
                stringBuffer.append(((Table)object3).getName());
                stringBuffer.append(" INDEX '");
                stringBuffer.append(((Table)object3).getIndexRoots());
                stringBuffer.append("'");
                this.addRow(result, stringBuffer.toString());
            }
            int n7 = TriggerDef.numTrigs();
            int n8 = 0;
            while (n8 < n7) {
                Vector vector = ((Table)object3).vTrigs[n8];
                int n9 = vector.size();
                int n10 = 0;
                while (n10 < n9) {
                    stringBuffer = ((TriggerDef)vector.elementAt(n10)).toBuf();
                    this.addRow(result, stringBuffer.toString());
                    ++n10;
                }
                ++n8;
            }
            ++n2;
        }
        object3 = this.aAccess.getUsers();
        n = 0;
        while (n < ((Vector)object3).size()) {
            object2 = (User)((Vector)object3).elementAt(n);
            if (object2 != null) {
                Hashtable hashtable;
                String string = ((User)object2).getName();
                if (!string.equals("PUBLIC")) {
                    stringBuffer = new StringBuffer("CREATE USER ");
                    stringBuffer.append(string);
                    stringBuffer.append(" PASSWORD ");
                    stringBuffer.append("\"" + ((User)object2).getPassword() + "\"");
                    if (((User)object2).isAdmin()) {
                        stringBuffer.append(" ADMIN");
                    }
                    this.addRow(result, stringBuffer.toString());
                }
                if ((hashtable = ((User)object2).getRights()) != null) {
                    object = hashtable.keys();
                    while (object.hasMoreElements()) {
                        String string2 = (String)object.nextElement();
                        int n11 = (Integer)hashtable.get(string2);
                        if (n11 == 0) continue;
                        stringBuffer = new StringBuffer("GRANT ");
                        stringBuffer.append(Access.getRight(n11));
                        stringBuffer.append(" ON ");
                        stringBuffer.append(string2);
                        stringBuffer.append(" TO ");
                        stringBuffer.append(((User)object2).getName());
                        this.addRow(result, stringBuffer.toString());
                    }
                }
            }
            ++n;
        }
        if (this.dDatabase.isIgnoreCase()) {
            this.addRow(result, "SET IGNORECASE TRUE");
        }
        object2 = this.dDatabase.getAlias();
        Enumeration enumeration = ((Hashtable)object2).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = (String)((Hashtable)object2).get(string);
            this.addRow(result, "CREATE ALIAS " + string + " FOR \"" + (String)object + "\"");
        }
        return result;
    }

    Table getSystemTable(String string, Channel channel) throws SQLException {
        if (string.equals("SYSTEM_PROCEDURES")) {
            Table table = this.createTable(string);
            table.addColumn("PROCEDURE_CAT", 12);
            table.addColumn("PROCEDURE_SCHEM", 12);
            table.addColumn("PROCEDURE_NAME", 12);
            table.addColumn("NUM_INPUT_PARAMS", 4);
            table.addColumn("NUM_OUTPUT_PARAMS", 4);
            table.addColumn("NUM_RESULT_SETS", 4);
            table.addColumn("REMARKS", 12);
            table.addColumn("PROCEDURE_TYPE", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_PROCEDURECOLUMNS")) {
            Table table = this.createTable(string);
            table.addColumn("PROCEDURE_CAT", 12);
            table.addColumn("PROCEDURE_SCHEM", 12);
            table.addColumn("PROCEDURE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("COLUMN_TYPE", 5);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("PRECISION", 4);
            table.addColumn("LENGTH", 4);
            table.addColumn("SCALE", 5);
            table.addColumn("RADIX", 5);
            table.addColumn("NULLABLE", 5);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLES")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("TABLE_TYPE", 12);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table2 = (Table)this.tTable.elementAt(n);
                Object[] objectArray = table.getNewRow();
                objectArray[2] = table2.getName();
                objectArray[3] = "TABLE";
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_SCHEMAS")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_SCHEM", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CATALOGS")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLETYPES")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_TYPE", 12);
            table.createPrimaryKey();
            Object[] objectArray = table.getNewRow();
            objectArray[0] = "TABLE";
            table.insert(objectArray, null);
            return table;
        }
        if (string.equals("SYSTEM_COLUMNS")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 4);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 4);
            table.addColumn(META_NUM_PREC_RADIX, 4);
            table.addColumn("NULLABLE", 4);
            table.addColumn("REMARKS", 12);
            table.addColumn("COLUMN_DEF", 12);
            table.addColumn("SQL_DATA_TYPE", 12);
            table.addColumn("SQL_DATETIME_SUB", 4);
            table.addColumn("CHAR_OCTET_LENGTH", 4);
            table.addColumn("ORDINAL_POSITION", 12);
            table.addColumn("IS_NULLABLE", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table3 = (Table)this.tTable.elementAt(n);
                int n2 = table3.getColumnCount();
                int n3 = 0;
                while (n3 < n2) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[2] = table3.getName();
                    objectArray[3] = table3.getColumnName(n3);
                    objectArray[4] = new Short((short)table3.getColumnType(n3));
                    objectArray[5] = Column.getType(table3.getColumnType(n3));
                    int n4 = table3.getColumnIsNullable(n3) ? 1 : 0;
                    objectArray[10] = new Integer(n4);
                    if (table3.getIdentityColumn() == n3) {
                        objectArray[11] = "IDENTITY";
                    }
                    table.insert(objectArray, null);
                    ++n3;
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_COLUMNPRIVILEGES")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("GRANTOR", 12);
            table.addColumn("GRANTEE", 12);
            table.addColumn("PRIVILEGE", 12);
            table.addColumn("IS_GRANTABLE", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLEPRIVILEGES")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("GRANTOR", 12);
            table.addColumn("GRANTEE", 12);
            table.addColumn("PRIVILEGE", 12);
            table.addColumn("IS_GRANTABLE", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table4 = (Table)this.tTable.elementAt(n);
                Object[] objectArray = table.getNewRow();
                objectArray[2] = table4.getName();
                objectArray[3] = "sa";
                objectArray[5] = "FULL";
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_BESTROWIDENTIFIER")) {
            Table table = this.createTable(string);
            table.addColumn("SCOPE", 5);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 4);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 5);
            table.addColumn("PSEUDO_COLUMN", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_VERSIONCOLUMNS")) {
            Table table = this.createTable(string);
            table.addColumn("SCOPE", 4);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 5);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 5);
            table.addColumn("PSEUDO_COLUMN", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_PRIMARYKEYS")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("PK_NAME", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table5 = (Table)this.tTable.elementAt(n);
                Index index = table5.getIndex("SYSTEM_PK");
                int[] nArray = index.getColumns();
                int n5 = nArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[2] = table5.getName();
                    objectArray[3] = table5.getColumnName(nArray[n6]);
                    objectArray[4] = new Short((short)(n6 + 1));
                    objectArray[5] = "SYSTEM_PK";
                    table.insert(objectArray, null);
                    ++n6;
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_IMPORTEDKEYS")) {
            Table table = this.createTable(string);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_EXPORTEDKEYS")) {
            Table table = this.createTable(string);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CROSSREFERENCE")) {
            Table table = this.createTable(string);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 4);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TYPEINFO")) {
            Table table = this.createTable(string);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("PRECISION", 4);
            table.addColumn("LITERAL_PREFIX", 12);
            table.addColumn("LITERAL_SUFFIX", 12);
            table.addColumn("CREATE_PARAMS", 12);
            table.addColumn("NULLABLE", 5);
            table.addColumn("CASE_SENSITIVE", 12);
            table.addColumn("SEARCHABLE", 5);
            table.addColumn("UNSIGNED_ATTRIBUTE", -7);
            table.addColumn(META_FIXED_PREC_SCALE, -7);
            table.addColumn("AUTO_INCREMENT", -7);
            table.addColumn("LOCAL_TYPE_NAME", 12);
            table.addColumn("MINIMUM_SCALE", 5);
            table.addColumn("MAXIMUM_SCALE", 5);
            table.addColumn("SQL_DATE_TYPE", 4);
            table.addColumn("SQL_DATETIME_SUB", 4);
            table.addColumn(META_NUM_PREC_RADIX, 4);
            table.createPrimaryKey();
            int n = 0;
            while (n < Column.TYPES.length) {
                Object[] objectArray = table.getNewRow();
                int n7 = Column.TYPES[n];
                objectArray[0] = Column.getType(n7);
                objectArray[1] = new Short((short)n7);
                objectArray[2] = new Integer(0);
                objectArray[6] = new Short(1);
                objectArray[7] = new Boolean(true);
                objectArray[8] = new Short(3);
                objectArray[9] = new Boolean(false);
                objectArray[10] = new Boolean(n7 == 2 || n7 == 3);
                objectArray[11] = new Boolean(n7 == 4);
                objectArray[12] = objectArray[0];
                objectArray[13] = new Short(0);
                objectArray[14] = new Short(0);
                objectArray[15] = new Integer(0);
                objectArray[16] = objectArray[15];
                objectArray[17] = new Integer(10);
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_INDEXINFO")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("NON_UNIQUE", -7);
            table.addColumn("INDEX_QUALIFIER", 12);
            table.addColumn("INDEX_NAME", 12);
            table.addColumn("TYPE", 5);
            table.addColumn(META_ORDINAL_POSITON, 5);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn(META_ASC_OR_DESC, 12);
            table.addColumn("CARDINALITY", 4);
            table.addColumn("PAGES", 4);
            table.addColumn("FILTER_CONDITION", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table6 = (Table)this.tTable.elementAt(n);
                Index index = null;
                while ((index = table6.getNextIndex(index)) != null) {
                    int[] nArray = index.getColumns();
                    int n8 = nArray.length;
                    if (!index.isUnique()) {
                        --n8;
                    }
                    int n9 = 0;
                    while (n9 < n8) {
                        Object[] objectArray = table.getNewRow();
                        objectArray[2] = table6.getName();
                        objectArray[3] = new Boolean(index.isUnique() ^ true);
                        objectArray[5] = index.getName();
                        objectArray[6] = new Short(3);
                        objectArray[7] = new Short((short)(n9 + 1));
                        objectArray[8] = table6.getColumnName(nArray[n9]);
                        objectArray[9] = "A";
                        table.insert(objectArray, null);
                        ++n9;
                    }
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_UDTS")) {
            Table table = this.createTable(string);
            table.addColumn("TYPE_CAT", 12);
            table.addColumn("TYPE_SCHEM", 12);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("CLASS_NAME", -7);
            table.addColumn("DATA_TYPE", 12);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CONNECTIONINFO")) {
            Table table = this.createTable(string);
            table.addColumn("KEY", 12);
            table.addColumn("VALUE", 12);
            table.createPrimaryKey();
            Object[] objectArray = table.getNewRow();
            objectArray[0] = "USER";
            objectArray[1] = channel.getUsername();
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "READONLY";
            objectArray[1] = channel.isReadOnly() ? "TRUE" : "FALSE";
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "MAXROWS";
            objectArray[1] = String.valueOf(channel.getMaxRows());
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "DATABASE";
            objectArray[1] = String.valueOf(channel.getDatabase().getName());
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "IDENTITY";
            objectArray[1] = String.valueOf(channel.getLastIdentity());
            table.insert(objectArray, null);
            return table;
        }
        if (string.equals("SYSTEM_USERS")) {
            Table table = this.createTable(string);
            table.addColumn("USER", 12);
            table.addColumn("ADMIN", -7);
            table.createPrimaryKey();
            Vector vector = this.aAccess.getUsers();
            int n = 0;
            while (n < vector.size()) {
                String string2;
                User user = (User)vector.elementAt(n);
                if (user != null && !(string2 = user.getName()).equals("PUBLIC")) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[0] = string2;
                    objectArray[1] = new Boolean(user.isAdmin());
                    table.insert(objectArray, null);
                }
                ++n;
            }
            return table;
        }
        return null;
    }
}

