/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemExtensionDecl;
import org.apache.xalan.templates.ElemExtensionScript;
import org.apache.xalan.templates.ElemFallback;
import org.apache.xalan.templates.ElemLiteralResult;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElemExtensionCall
extends ElemLiteralResult {
    String m_extns;
    String m_lang;
    String m_srcURL;
    String m_scriptSrc;
    ElemExtensionDecl m_decl = null;

    public void compose() {
        this.m_extns = this.getNamespace();
        StylesheetRoot stylesheetRoot = this.getStylesheetRoot();
        this.m_decl = this.getElemExtensionDecl(stylesheetRoot, this.m_extns);
        if (this.m_decl != null) {
            ElemTemplateElement elemTemplateElement = this.m_decl.getFirstChildElem();
            while (elemTemplateElement != null) {
                if (elemTemplateElement.getXSLToken() == 86) {
                    ElemExtensionScript elemExtensionScript = (ElemExtensionScript)elemTemplateElement;
                    this.m_lang = elemExtensionScript.getLang();
                    this.m_srcURL = elemExtensionScript.getSrc();
                    ElemTemplateElement elemTemplateElement2 = elemExtensionScript.getFirstChildElem();
                    if (elemTemplateElement2 == null || elemTemplateElement2.getXSLToken() != 78) break;
                    ElemTextLiteral elemTextLiteral = (ElemTextLiteral)elemTemplateElement2;
                    char[] cArray = elemTextLiteral.getChars();
                    this.m_scriptSrc = new String(cArray);
                    break;
                }
                elemTemplateElement = elemTemplateElement.getNextSiblingElem();
            }
        }
    }

    public void execute(TransformerImpl transformerImpl, Node node, QName qName) throws TransformerException {
        try {
            transformerImpl.getResultTreeHandler().flushPending();
            XPathContext xPathContext = transformerImpl.getXPathContext();
            ExtensionsTable extensionsTable = xPathContext.getExtensionsTable();
            ExtensionHandler extensionHandler = extensionsTable.get(this.m_extns);
            if (extensionHandler == null) {
                extensionHandler = extensionsTable.makeJavaNamespace(this.m_extns);
                if (extensionHandler != null) {
                    extensionsTable.addExtensionNamespace(this.m_extns, extensionHandler);
                } else {
                    this.executeFallbacks(transformerImpl, node, qName);
                    return;
                }
            }
            try {
                extensionHandler.processElement(this.getLocalName(), this, transformerImpl, this.getStylesheet(), node.getOwnerDocument(), node, qName, this);
            }
            catch (Exception exception) {
                String string = exception.getMessage();
                TransformerException transformerException = exception instanceof TransformerException ? (TransformerException)exception : (string != null ? new TransformerException(exception) : new TransformerException("Unknown error when calling extension!", exception));
                if (transformerException.getLocator() == null) {
                    transformerException.setLocator(this);
                }
                if (string != null) {
                    if (string.indexOf("fatal") >= 0) {
                        transformerImpl.getErrorListener().fatalError(transformerException);
                    } else if (exception instanceof RuntimeException) {
                        transformerImpl.getErrorListener().error(transformerException);
                    } else {
                        transformerImpl.getErrorListener().warning(transformerException);
                    }
                } else {
                    transformerImpl.getErrorListener().error(transformerException);
                }
                this.executeFallbacks(transformerImpl, node, qName);
            }
        }
        catch (SAXException sAXException) {
            transformerImpl.getErrorListener().fatalError(new TransformerException(sAXException));
        }
    }

    public void executeFallbacks(TransformerImpl transformerImpl, Node node, QName qName) throws TransformerException {
        ElemTemplateElement elemTemplateElement = this.m_firstChild;
        while (elemTemplateElement != null) {
            if (elemTemplateElement.getXSLToken() == 57) {
                try {
                    transformerImpl.pushElemTemplateElement(elemTemplateElement);
                    ((ElemFallback)elemTemplateElement).executeFallback(transformerImpl, node, qName);
                }
                finally {
                    Object var6_5 = null;
                    transformerImpl.popElemTemplateElement();
                }
            }
            elemTemplateElement = elemTemplateElement.m_nextSibling;
        }
    }

    public String getAttribute(String string) {
        AVT aVT = this.getLiteralResultAttribute(string);
        if (aVT != null && aVT.getRawName().equals(string)) {
            return aVT.getSimpleString();
        }
        return null;
    }

    public String getAttribute(String string, Node node, TransformerImpl transformerImpl) throws TransformerException {
        AVT aVT = this.getLiteralResultAttribute(string);
        if (aVT != null && aVT.getRawName().equals(string)) {
            XPathContext xPathContext = transformerImpl.getXPathContext();
            return aVT.evaluate(xPathContext, node, this);
        }
        return null;
    }

    private ElemExtensionDecl getElemExtensionDecl(StylesheetRoot stylesheetRoot, String string) {
        ElemExtensionDecl elemExtensionDecl = null;
        int n = stylesheetRoot.getGlobalImportCount();
        int n2 = 0;
        while (n2 < n) {
            StylesheetComposed stylesheetComposed = stylesheetRoot.getGlobalImport(n2);
            ElemTemplateElement elemTemplateElement = stylesheetComposed.getFirstChildElem();
            while (elemTemplateElement != null) {
                String string2;
                String string3;
                if (elemTemplateElement.getXSLToken() == 85 && string.equals(string3 = elemTemplateElement.getNamespaceForPrefix(string2 = (elemExtensionDecl = (ElemExtensionDecl)elemTemplateElement).getPrefix()))) {
                    return elemExtensionDecl;
                }
                elemTemplateElement = elemTemplateElement.getNextSiblingElem();
            }
            ++n2;
        }
        return elemExtensionDecl;
    }

    public int getXSLToken() {
        return 79;
    }
}

