/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Component;
import java.awt.Font;
import org.apache.fop.layout.FontMetric;
import org.apache.fop.render.awt.AWTFontMetrics;

public class FontMetricsMapper
implements FontMetric {
    private static final int FIRST_CHAR = 32;
    private static final int LAST_CHAR = 255;
    private static AWTFontMetrics metric = null;
    private final String family;
    private final int style;

    public FontMetricsMapper(String string, int n, Component component) {
        this.family = string;
        this.style = n;
        if (metric == null) {
            metric = new AWTFontMetrics(component);
        }
    }

    public int getAscender(int n) {
        return metric.getAscender(this.family, this.style, n);
    }

    public int getCapHeight(int n) {
        return metric.getCapHeight(this.family, this.style, n);
    }

    public int getDescender(int n) {
        return metric.getDescender(this.family, this.style, n);
    }

    public int getFirstChar() {
        return 32;
    }

    public Font getFont(int n) {
        return metric.getFont(this.family, this.style, n);
    }

    public int getLastChar() {
        return 255;
    }

    public int[] getWidths(int n) {
        return metric.getWidths(this.family, this.style, n);
    }

    public int getXHeight(int n) {
        return metric.getXHeight(this.family, this.style, n);
    }

    public int width(int n, int n2) {
        return metric.width(n, this.family, this.style, n2);
    }
}

