/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

class DataFlowBitSet {
    private int[] itsBits;
    int itsSize;

    DataFlowBitSet(int n) {
        this.itsSize = n;
        this.itsBits = new int[(n >> 5) + 1];
    }

    void clear() {
        int n = this.itsBits.length;
        int n2 = 0;
        while (n2 < n) {
            this.itsBits[n2] = 0;
            ++n2;
        }
    }

    void clear(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] & ~(1 << (n & 0x1F));
    }

    boolean df(DataFlowBitSet dataFlowBitSet, DataFlowBitSet dataFlowBitSet2, DataFlowBitSet dataFlowBitSet3) {
        int n = this.itsBits.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.itsBits[n2];
            this.itsBits[n2] = (dataFlowBitSet.itsBits[n2] | dataFlowBitSet2.itsBits[n2]) & dataFlowBitSet3.itsBits[n2];
            bl |= n3 != this.itsBits[n2];
            ++n2;
        }
        return bl;
    }

    boolean df2(DataFlowBitSet dataFlowBitSet, DataFlowBitSet dataFlowBitSet2, DataFlowBitSet dataFlowBitSet3) {
        int n = this.itsBits.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.itsBits[n2];
            this.itsBits[n2] = dataFlowBitSet.itsBits[n2] & dataFlowBitSet3.itsBits[n2] | dataFlowBitSet2.itsBits[n2];
            bl |= n3 != this.itsBits[n2];
            ++n2;
        }
        return bl;
    }

    void not() {
        int n = this.itsBits.length;
        int n2 = 0;
        while (n2 < n) {
            this.itsBits[n2] = ~this.itsBits[n2];
            ++n2;
        }
    }

    void or(DataFlowBitSet dataFlowBitSet) {
        int n = this.itsBits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            this.itsBits[n3] = this.itsBits[n3] | dataFlowBitSet.itsBits[n2];
            ++n2;
        }
    }

    void set(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] | 1 << (n & 0x1F);
    }

    int size() {
        return this.itsSize;
    }

    boolean test(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        return (this.itsBits[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataFlowBitSet, size = " + this.itsSize + "\n");
        int n = 0;
        while (n < this.itsBits.length) {
            stringBuffer.append(String.valueOf(Integer.toHexString(this.itsBits[n])) + " ");
            ++n;
        }
        return stringBuffer.toString();
    }
}

