/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FlattenedObject;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.GetterSlot;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public abstract class ScriptableObject
implements Scriptable {
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    private static final int SLOT_NOT_FOUND = -1;
    protected Scriptable prototype;
    protected Scriptable parent;
    private static final Object HAS_STATIC_ACCESSORS = Void.TYPE;
    private static final Slot REMOVED = new Slot();
    private static Hashtable exclusionList = null;
    private Slot[] slots;
    private int count;
    private String lastName;
    private int lastHash;
    private Object lastValue = REMOVED;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$mozilla$javascript$Function;
    static /* synthetic */ Class class$org$mozilla$javascript$FunctionObject;
    static /* synthetic */ Class class$org$mozilla$javascript$ScriptableObject;

    synchronized void addPropertyAttribute(int n) {
        if (this.slots == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.slots.length) {
            Slot slot = this.slots[n2];
            if (slot != null && slot != REMOVED && ((slot.flags & 2) == 0 || n != 1)) {
                slot.attributes = (short)(slot.attributes | n);
            }
            ++n2;
        }
    }

    private synchronized int addSlot(String string, int n, boolean bl) {
        int n2;
        if (this.count == -1) {
            throw Context.reportRuntimeError(Context.getMessage("msg.add.sealed", null));
        }
        int n3 = n2 = (n & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot;
            if ((slot = this.slots[n3]) == null || slot == REMOVED) {
                ++this.count;
                if (4 * this.count > 3 * this.slots.length) {
                    this.grow();
                    return this.getSlotToSet(string, n, bl);
                }
                slot = bl ? new GetterSlot() : new Slot();
                slot.stringKey = string;
                slot.intKey = n;
                this.slots[n3] = slot;
                return n3;
            }
            if (slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                return n3;
            }
            if (++n3 != this.slots.length) continue;
            n3 = 0;
        } while (n3 != n2);
        throw new RuntimeException("Hashtable internal error");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void defineClass(Scriptable scriptable, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        ScriptableObject.defineClass(scriptable, clazz, false);
    }

    public static void defineClass(Scriptable scriptable, Class clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        Object object;
        Object object2;
        Object[] objectArray;
        Object object3;
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals("init") && ((Class<?>[])(object3 = methodArray[n].getParameterTypes())).length == 1 && object3[0] == ScriptRuntime.ScriptableClass && Modifier.isStatic(methodArray[n].getModifiers())) {
                Object[] objectArray2 = new Object[]{scriptable};
                methodArray[n].invoke(null, objectArray2);
                return;
            }
            ++n;
        }
        object3 = ScriptableObject.getExclusionList();
        Constructor<?>[] constructorArray = clazz.getConstructors();
        Constructor<?> constructor = null;
        int n2 = 0;
        while (n2 < constructorArray.length) {
            if (constructorArray[n2].getParameterTypes().length == 0) {
                constructor = constructorArray[n2];
                break;
            }
            ++n2;
        }
        if (constructor == null) {
            Object[] objectArray3 = new Object[]{clazz.getName()};
            throw new ClassDefinitionException(Context.getMessage("msg.zero.arg.ctor", objectArray3));
        }
        Scriptable scriptable2 = (Scriptable)constructor.newInstance(ScriptRuntime.emptyArgs);
        scriptable2.setPrototype(ScriptableObject.getObjectPrototype(scriptable));
        String string = scriptable2.getClassName();
        String string2 = "js_";
        String string3 = "jsFunction_";
        String string4 = "jsStaticFunction_";
        String string5 = "jsProperty_";
        String string6 = "jsGet_";
        String string7 = "jsSet_";
        String string8 = "jsConstructor";
        Method[] methodArray2 = FunctionObject.findMethods(clazz, "jsConstructor");
        Executable executable = null;
        if (methodArray2 != null) {
            if (methodArray2.length > 1) {
                Object[] objectArray4 = new Object[]{methodArray2[0], methodArray2[1]};
                throw new ClassDefinitionException(Context.getMessage("msg.multiple.ctors", objectArray4));
            }
            executable = methodArray2[0];
        }
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < methodArray.length) {
            objectArray = methodArray[n3].getName();
            object2 = null;
            if (!objectArray.startsWith("js")) {
                object2 = null;
            } else if (objectArray.startsWith("js_")) {
                object2 = "js_";
            } else if (objectArray.startsWith("jsFunction_")) {
                object2 = "jsFunction_";
            } else if (objectArray.startsWith("jsStaticFunction_")) {
                object2 = "jsStaticFunction_";
            } else if (objectArray.startsWith("jsProperty_")) {
                object2 = "jsProperty_";
            } else if (objectArray.startsWith("jsGet_")) {
                object2 = "jsGet_";
            } else if (objectArray.startsWith("jsSet_")) {
                object2 = "jsSet_";
            }
            if (object2 != null) {
                bl2 = true;
                objectArray = objectArray.substring(((String)object2).length());
            }
            if (objectArray.equals(string)) {
                if (executable != null) {
                    Object[] objectArray5 = new Object[]{executable, methodArray[n3]};
                    throw new ClassDefinitionException(Context.getMessage("msg.multiple.ctors", objectArray5));
                }
                executable = methodArray[n3];
            }
            ++n3;
        }
        if (executable == null) {
            if (constructorArray.length == 1) {
                executable = constructorArray[0];
            } else if (constructorArray.length == 2) {
                if (constructorArray[0].getParameterTypes().length == 0) {
                    executable = constructorArray[1];
                } else if (constructorArray[1].getParameterTypes().length == 0) {
                    executable = constructorArray[0];
                }
            }
            if (executable == null) {
                objectArray = new Object[]{clazz.getName()};
                throw new ClassDefinitionException(Context.getMessage("msg.ctor.multiple.parms", objectArray));
            }
        }
        if ((objectArray = new FunctionObject(string, executable, scriptable)).isVarArgsMethod()) {
            object2 = new Object[]{executable.getName()};
            String string9 = Context.getMessage("msg.varargs.ctor", (Object[])object2);
            throw Context.reportRuntimeError(string9);
        }
        objectArray.addAsConstructor(scriptable, scriptable2);
        if (!bl2 && object3 == null) {
            object3 = ScriptableObject.getExclusionList();
        }
        object2 = null;
        int n4 = 0;
        while (n4 < methodArray.length) {
            block58: {
                Object object4;
                block67: {
                    block60: {
                        block62: {
                            block66: {
                                block65: {
                                    block64: {
                                        block63: {
                                            block61: {
                                                block59: {
                                                    if (!bl2 && methodArray[n4].getDeclaringClass() != clazz) break block58;
                                                    object = methodArray[n4].getName();
                                                    if (!((String)object).equals("finishInit") || ((Class<?>[])(object4 = methodArray[n4].getParameterTypes())).length != 3 || object4[0] != ScriptRuntime.ScriptableClass || object4[1] != (class$org$mozilla$javascript$FunctionObject != null ? class$org$mozilla$javascript$FunctionObject : ScriptableObject.class$("org.mozilla.javascript.FunctionObject")) || object4[2] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(methodArray[n4].getModifiers())) break block59;
                                                    object2 = methodArray[n4];
                                                    break block58;
                                                }
                                                if (((String)object).equals("jsConstructor")) break block58;
                                                object4 = null;
                                                if (!bl2) break block60;
                                                if (!((String)object).startsWith("js_")) break block61;
                                                object4 = "js_";
                                                break block62;
                                            }
                                            if (!((String)object).startsWith("jsFunction_")) break block63;
                                            object4 = "jsFunction_";
                                            break block62;
                                        }
                                        if (!((String)object).startsWith("jsStaticFunction_")) break block64;
                                        object4 = "jsStaticFunction_";
                                        if (!Modifier.isStatic(methodArray[n4].getModifiers())) {
                                            throw new ClassDefinitionException("jsStaticFunction must be used with static method.");
                                        }
                                        break block62;
                                    }
                                    if (!((String)object).startsWith("jsProperty_")) break block65;
                                    object4 = "jsProperty_";
                                    break block62;
                                }
                                if (!((String)object).startsWith("jsGet_")) break block66;
                                object4 = "jsGet_";
                                break block62;
                            }
                            if (!((String)object).startsWith("jsSet_")) break block58;
                            object4 = "jsSet_";
                        }
                        object = ((String)object).substring(((String)object4).length());
                        break block67;
                    }
                    if (((Hashtable)object3).get(object) != null) break block58;
                }
                if (!(methodArray[n4] == executable || object4 != null && ((String)object4).equals("jsSet_"))) {
                    Object object5;
                    Object object6;
                    if (object4 != null && ((String)object4).equals("jsGet_")) {
                        if (!(scriptable2 instanceof ScriptableObject)) {
                            object6 = new Object[]{scriptable2.getClass().toString(), object};
                            throw new PropertyException(Context.getMessage("msg.extend.scriptable", (Object[])object6));
                        }
                        object6 = FunctionObject.findMethods(clazz, "jsSet_" + (String)object);
                        if (object6 != null && ((Object)object6).length != 1) {
                            Object[] objectArray6 = new Object[]{object, clazz.getName()};
                            throw new PropertyException(Context.getMessage("msg.no.overload", objectArray6));
                        }
                        int n5 = 6 | (object6 != null ? 0 : 1);
                        object5 = object6 == null ? null : object6[0];
                        ((ScriptableObject)scriptable2).defineProperty((String)object, null, methodArray[n4], (Method)object5, n5);
                    } else if (!(!((String)object).startsWith("get") && !((String)object).startsWith("set") || ((String)object).length() <= 3 || bl2 && (((String)object4).equals("jsFunction_") || ((String)object4).equals("jsStaticFunction_")))) {
                        if (!(scriptable2 instanceof ScriptableObject)) {
                            object6 = new Object[]{scriptable2.getClass().toString(), object};
                            throw new PropertyException(Context.getMessage("msg.extend.scriptable", (Object[])object6));
                        }
                        if (!((String)object).startsWith("set")) {
                            object6 = new StringBuffer();
                            char c = ((String)object).charAt(3);
                            ((StringBuffer)object6).append(Character.toLowerCase(c));
                            if (((String)object).length() > 4) {
                                ((StringBuffer)object6).append(((String)object).substring(4));
                            }
                            object5 = ((StringBuffer)object6).toString();
                            ((StringBuffer)object6).setCharAt(0, c);
                            ((StringBuffer)object6).insert(0, "set");
                            String string10 = ((StringBuffer)object6).toString();
                            Method[] methodArray3 = FunctionObject.findMethods(clazz, bl2 ? "js_" + string10 : string10);
                            if (methodArray3 != null && methodArray3.length != 1) {
                                Object[] objectArray7 = new Object[]{object, clazz.getName()};
                                throw new PropertyException(Context.getMessage("msg.no.overload", objectArray7));
                            }
                            if (methodArray3 == null && bl2) {
                                methodArray3 = FunctionObject.findMethods(clazz, "jsProperty_" + string10);
                            }
                            int n6 = 6 | (methodArray3 != null ? 0 : 1);
                            Method method = methodArray3 == null ? null : methodArray3[0];
                            ((ScriptableObject)scriptable2).defineProperty((String)object5, null, methodArray[n4], method, n6);
                        }
                    } else {
                        Object object7;
                        object6 = new FunctionObject((String)object, methodArray[n4], scriptable2);
                        if (((FunctionObject)object6).isVarArgsConstructor()) {
                            Object[] objectArray8 = new Object[]{executable.getName()};
                            object5 = Context.getMessage("msg.varargs.fun", objectArray8);
                            throw Context.reportRuntimeError((String)object5);
                        }
                        Object object8 = object7 = object4 == "jsStaticFunction_" ? objectArray : scriptable2;
                        if (object7 instanceof ScriptableObject) {
                            ((ScriptableObject)object7).defineProperty((String)object, object6, 2);
                        } else {
                            object7.put((String)object, (Scriptable)object7, object6);
                        }
                        if (bl) {
                            ((ScriptableObject)object6).sealObject();
                            ((ScriptableObject)object6).addPropertyAttribute(1);
                        }
                    }
                }
            }
            ++n4;
        }
        if (object2 != null) {
            object = new Object[]{scriptable, objectArray, scriptable2};
            ((Method)object2).invoke(null, (Object[])object);
        }
        if (bl) {
            objectArray.sealObject();
            objectArray.addPropertyAttribute(1);
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
                ((ScriptableObject)scriptable2).addPropertyAttribute(1);
            }
        }
    }

    public void defineFunctionProperties(String[] stringArray, Class clazz, int n) throws PropertyException {
        int n2 = 0;
        while (n2 < stringArray.length) {
            Object[] objectArray;
            String string = stringArray[n2];
            Method[] methodArray = FunctionObject.findMethods(clazz, string);
            if (methodArray == null) {
                objectArray = new Object[]{string, clazz.getName()};
                throw new PropertyException(Context.getMessage("msg.method.not.found", objectArray));
            }
            if (methodArray.length > 1) {
                objectArray = new Object[]{string, clazz.getName()};
                throw new PropertyException(Context.getMessage("msg.no.overload", objectArray));
            }
            objectArray = new FunctionObject(string, methodArray[0], this);
            this.defineProperty(string, objectArray, n);
            ++n2;
        }
    }

    public void defineProperty(String string, Class clazz, int n) throws PropertyException {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(string.charAt(0)));
        String string2 = stringBuffer.toString();
        Method[] methodArray = FunctionObject.findMethods(clazz, "get" + string2);
        Method[] methodArray2 = FunctionObject.findMethods(clazz, "set" + string2);
        if (methodArray2 == null) {
            n |= 1;
        }
        if (methodArray.length != 1 || methodArray2 != null && methodArray2.length != 1) {
            Object[] objectArray = new Object[]{string, clazz.getName()};
            throw new PropertyException(Context.getMessage("msg.no.overload", objectArray));
        }
        this.defineProperty(string, null, methodArray[0], methodArray2 == null ? null : methodArray2[0], n);
    }

    public void defineProperty(String string, Object object, int n) {
        this.put(string, (Scriptable)this, object);
        try {
            this.setAttributes(string, (Scriptable)this, n);
        }
        catch (PropertyException propertyException) {
            throw new RuntimeException("Cannot create property");
        }
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) throws PropertyException {
        Class<?>[] classArray;
        int n2 = 1;
        if (object == null && Modifier.isStatic(method.getModifiers())) {
            object = HAS_STATIC_ACCESSORS;
        }
        if ((classArray = method.getParameterTypes()).length != 0) {
            if (classArray.length != 1 || classArray[0] != (class$org$mozilla$javascript$ScriptableObject != null ? class$org$mozilla$javascript$ScriptableObject : (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")))) {
                Object[] objectArray = new Object[]{method.toString()};
                throw new PropertyException(Context.getMessage("msg.bad.getter.parms", objectArray));
            }
        } else if (object != null) {
            Object[] objectArray = new Object[]{method.toString()};
            throw new PropertyException(Context.getMessage("msg.obj.getter.parms", objectArray));
        }
        if (method2 != null) {
            n2 = (short)(n2 | 2);
            if (object == HAS_STATIC_ACCESSORS != Modifier.isStatic(method2.getModifiers())) {
                throw new PropertyException(Context.getMessage("msg.getter.static", null));
            }
            classArray = method2.getParameterTypes();
            if (classArray.length == 2) {
                if (classArray[0] != (class$org$mozilla$javascript$ScriptableObject != null ? class$org$mozilla$javascript$ScriptableObject : (class$org$mozilla$javascript$ScriptableObject = ScriptableObject.class$("org.mozilla.javascript.ScriptableObject")))) {
                    throw new PropertyException(Context.getMessage("msg.setter2.parms", null));
                }
                if (object == null) {
                    Object[] objectArray = new Object[]{method2.toString()};
                    throw new PropertyException(Context.getMessage("msg.setter1.parms", objectArray));
                }
            } else if (classArray.length == 1) {
                if (object != null) {
                    Object[] objectArray = new Object[]{method2.toString()};
                    throw new PropertyException(Context.getMessage("msg.setter2.expected", objectArray));
                }
            } else {
                throw new PropertyException(Context.getMessage("msg.setter.parms", null));
            }
        }
        int n3 = this.getSlotToSet(string, string.hashCode(), true);
        GetterSlot getterSlot = (GetterSlot)this.slots[n3];
        getterSlot.delegateTo = object;
        getterSlot.getter = method;
        getterSlot.setter = method2;
        getterSlot.value = null;
        getterSlot.attributes = (short)n;
        getterSlot.flags = (short)n2;
    }

    public void delete(int n) {
        this.removeSlot(null, n);
    }

    public void delete(String string) {
        if (string.equals(this.lastName)) {
            this.lastValue = REMOVED;
        }
        this.removeSlot(string, string.hashCode());
    }

    public Object get(int n, Scriptable scriptable) {
        int n2 = this.getSlot(null, n);
        if (n2 == -1) {
            return Scriptable.NOT_FOUND;
        }
        return this.slots[n2].value;
    }

    public Object get(String string, Scriptable scriptable) {
        int n;
        if (string == this.lastName) {
            if (this.lastValue != REMOVED) {
                return this.lastValue;
            }
            n = this.lastHash;
        } else {
            n = string.hashCode();
        }
        int n2 = this.getSlot(string, n);
        if (n2 == -1) {
            return Scriptable.NOT_FOUND;
        }
        Slot slot = this.slots[n2];
        if ((slot.flags & 1) != 0) {
            GetterSlot getterSlot = (GetterSlot)slot;
            try {
                if (getterSlot.delegateTo == null) {
                    Class<?> clazz = getterSlot.getter.getDeclaringClass();
                    while (!clazz.isInstance(scriptable)) {
                        if ((scriptable = scriptable.getPrototype()) != null) continue;
                        scriptable = this;
                        break;
                    }
                    return getterSlot.getter.invoke((Object)scriptable, ScriptRuntime.emptyArgs);
                }
                Object[] objectArray = new Object[]{this};
                return getterSlot.getter.invoke(getterSlot.delegateTo, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw WrappedException.wrapException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw WrappedException.wrapException(illegalAccessException);
            }
        }
        this.lastValue = REMOVED;
        this.lastName = string;
        this.lastHash = n;
        this.lastValue = slot.value;
        return this.lastValue;
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public int getAttributes(int n, Scriptable scriptable) throws PropertyException {
        int n2 = this.getSlot(null, n);
        if (n2 == -1) {
            throw new PropertyException(Context.getMessage("msg.prop.not.found", null));
        }
        return this.slots[n2].attributes;
    }

    public int getAttributes(String string, Scriptable scriptable) throws PropertyException {
        int n = this.getSlot(string, string.hashCode());
        if (n == -1) {
            throw new PropertyException(Context.getMessage("msg.prop.not.found", null));
        }
        return this.slots[n].attributes;
    }

    public abstract String getClassName();

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object = ScriptRuntime.getTopLevelProp(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object == Scriptable.NOT_FOUND || !(object instanceof Scriptable)) {
            return null;
        }
        Scriptable scriptable2 = (Scriptable)object;
        if (!scriptable2.has("prototype", scriptable2)) {
            return null;
        }
        Object object2 = scriptable2.get("prototype", scriptable2);
        if (!(object2 instanceof Scriptable)) {
            return null;
        }
        return (Scriptable)object2;
    }

    public Object getDefaultValue(Class clazz) {
        Object object;
        FlattenedObject flattenedObject = new FlattenedObject(this);
        Context context = null;
        try {
            int n = 0;
            while (n < 2) {
                block26: {
                    Object object2;
                    block27: {
                        Object[] objectArray;
                        block25: {
                            block23: {
                                boolean bl;
                                block24: {
                                    block22: {
                                        if (clazz != ScriptRuntime.StringClass) break block22;
                                        if (n == 0) break block23;
                                        bl = false;
                                        break block24;
                                    }
                                    if (n == 1) break block23;
                                    bl = false;
                                }
                                if (!bl) break block25;
                            }
                            if ((object = this.getFunctionProperty(flattenedObject, "toString")) == null) break block26;
                            if (context == null) {
                                context = Context.getContext();
                            }
                            object2 = object.call(context, object.getParentScope(), flattenedObject.getObject(), ScriptRuntime.emptyArgs);
                            break block27;
                        }
                        if (clazz == null) {
                            object = "undefined";
                        } else if (clazz == ScriptRuntime.StringClass) {
                            object = "string";
                        } else if (clazz == ScriptRuntime.ScriptableClass) {
                            object = "object";
                        } else if (clazz == ScriptRuntime.FunctionClass) {
                            object = "function";
                        } else if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
                            object = "boolean";
                        } else if (clazz == ScriptRuntime.NumberClass || clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE || clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE || clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE || clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
                            object = "number";
                        } else {
                            objectArray = new Object[]{clazz.toString()};
                            throw Context.reportRuntimeError(Context.getMessage("msg.invalid.type", objectArray));
                        }
                        objectArray = this.getFunctionProperty(flattenedObject, "valueOf");
                        if (objectArray == null) break block26;
                        Object[] objectArray2 = new Object[]{object};
                        if (context == null) {
                            context = Context.getContext();
                        }
                        object2 = objectArray.call(context, objectArray.getParentScope(), flattenedObject.getObject(), objectArray2);
                    }
                    if (!(object2 == null || object2 != Undefined.instance && object2 instanceof Scriptable && clazz != (class$org$mozilla$javascript$Scriptable != null ? class$org$mozilla$javascript$Scriptable : ScriptableObject.class$("org.mozilla.javascript.Scriptable")) && clazz != (class$org$mozilla$javascript$Function != null ? class$org$mozilla$javascript$Function : ScriptableObject.class$("org.mozilla.javascript.Function")))) {
                        return object2;
                    }
                    if (object2 instanceof NativeJavaObject && (object = ((Wrapper)object2).unwrap()) instanceof String) {
                        return object;
                    }
                }
                ++n;
            }
        }
        catch (JavaScriptException javaScriptException) {}
        String string = clazz == null ? "undefined" : clazz.toString();
        object = new Object[]{string};
        throw NativeGlobal.constructError(Context.getContext(), "TypeError", ScriptRuntime.getMessage("msg.default.value", object), this);
    }

    private static Hashtable getExclusionList() {
        if (exclusionList != null) {
            return exclusionList;
        }
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>(17);
        Method[] methodArray = ScriptRuntime.FunctionClass.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            hashtable.put(methodArray[n].getName(), Boolean.TRUE);
            ++n;
        }
        exclusionList = hashtable;
        return hashtable;
    }

    private Function getFunctionProperty(FlattenedObject flattenedObject, String string) {
        Object object = flattenedObject.getProperty(string);
        if (object == null || !(object instanceof FlattenedObject)) {
            return null;
        }
        Scriptable scriptable = ((FlattenedObject)object).getObject();
        if (scriptable instanceof Function) {
            return (Function)scriptable;
        }
        return null;
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Function");
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    private Object[] getIds(boolean bl) {
        Object object;
        if (this.slots == null) {
            return ScriptRuntime.emptyArgs;
        }
        int n = 0;
        int n2 = this.slots.length - 1;
        while (n2 >= 0) {
            object = this.slots[n2];
            if (object != null && object != REMOVED && (bl || (object.attributes & 2) == 0)) {
                ++n;
            }
            --n2;
        }
        object = new Object[n];
        int n3 = this.slots.length - 1;
        while (n3 >= 0) {
            Slot slot = this.slots[n3];
            if (slot != null && slot != REMOVED && (bl || (slot.attributes & 2) == 0)) {
                object[--n] = slot.stringKey != null ? slot.stringKey : new Integer(slot.intKey);
            }
            --n3;
        }
        return object;
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Object");
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    private int getSlot(String string, int n) {
        int n2;
        if (this.slots == null) {
            return -1;
        }
        int n3 = n2 = (n & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot;
            if ((slot = this.slots[n3]) == null) {
                return -1;
            }
            if (slot != REMOVED && slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                return n3;
            }
            if (++n3 != this.slots.length) continue;
            n3 = 0;
        } while (n3 != n2);
        return -1;
    }

    private int getSlotToSet(String string, int n, boolean bl) {
        int n2;
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        int n3 = n2 = (n & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot;
            if ((slot = this.slots[n3]) == null) {
                return this.addSlot(string, n, bl);
            }
            if (slot != REMOVED && slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                return n3;
            }
            if (++n3 != this.slots.length) continue;
            n3 = 0;
        } while (n3 != n2);
        throw new RuntimeException("Hashtable internal error");
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2 = scriptable;
        while ((scriptable2 = (scriptable = scriptable2).getParentScope()) != null) {
        }
        return scriptable;
    }

    private synchronized void grow() {
        Slot[] slotArray = new Slot[this.slots.length * 2 + 1];
        int n = this.slots.length - 1;
        while (n >= 0) {
            Slot slot = this.slots[n];
            if (slot != null && slot != REMOVED) {
                int n2 = (slot.intKey & Integer.MAX_VALUE) % slotArray.length;
                while (slotArray[n2] != null) {
                    if (++n2 != slotArray.length) continue;
                    n2 = 0;
                }
                slotArray[n2] = slot;
            }
            --n;
        }
        this.slots = slotArray;
    }

    public boolean has(int n, Scriptable scriptable) {
        return this.getSlot(null, n) != -1;
    }

    public boolean has(String string, Scriptable scriptable) {
        return this.getSlot(string, string.hashCode()) != -1;
    }

    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    public boolean isSealed() {
        return this.count == -1;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        int n2 = this.getSlot(null, n);
        if (n2 == -1) {
            if (scriptable != this) {
                scriptable.put(n, scriptable, object);
                return;
            }
            n2 = this.getSlotToSet(null, n, false);
        }
        Slot slot = this.slots[n2];
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(n, scriptable, object);
        }
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n = string.hashCode();
        int n2 = this.getSlot(string, n);
        if (n2 == -1) {
            if (scriptable != this) {
                scriptable.put(string, scriptable, object);
                return;
            }
            n2 = this.getSlotToSet(string, n, false);
        }
        Slot slot = this.slots[n2];
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if ((slot.flags & 2) != 0) {
            GetterSlot getterSlot = (GetterSlot)slot;
            try {
                Class<?>[] classArray = getterSlot.setter.getParameterTypes();
                Class<?> clazz = classArray[classArray.length - 1];
                Object object2 = FunctionObject.convertArg(scriptable, object, clazz);
                if (getterSlot.delegateTo == null) {
                    Object[] objectArray = new Object[]{object2};
                    Class<?> clazz2 = getterSlot.setter.getDeclaringClass();
                    while (!clazz2.isInstance(scriptable)) {
                        if ((scriptable = scriptable.getPrototype()) != null) continue;
                        scriptable = this;
                        break;
                    }
                    getterSlot.setter.invoke((Object)scriptable, objectArray);
                    return;
                }
                Object[] objectArray = new Object[]{this, object2};
                getterSlot.setter.invoke(getterSlot.delegateTo, objectArray);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw WrappedException.wrapException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw WrappedException.wrapException(illegalAccessException);
            }
        }
        if (this == scriptable) {
            slot.value = object;
            this.lastValue = string == this.lastName ? object : REMOVED;
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    private synchronized void removeSlot(String string, int n) {
        if (this.count == -1) {
            throw Context.reportRuntimeError(Context.getMessage("msg.remove.sealed", null));
        }
        int n2 = this.getSlot(string, n);
        if (n2 == -1) {
            return;
        }
        if ((this.slots[n2].attributes & 4) != 0) {
            return;
        }
        this.slots[n2] = REMOVED;
        --this.count;
    }

    public void sealObject() {
        this.count = -1;
    }

    public void setAttributes(int n, Scriptable scriptable, int n2) throws PropertyException {
        int n3 = this.getSlot(null, n);
        if (n3 == -1) {
            throw new PropertyException(Context.getMessage("msg.prop.not.found", null));
        }
        this.slots[n3].attributes = (short)n2;
    }

    public void setAttributes(String string, Scriptable scriptable, int n) throws PropertyException {
        int n2 = 7;
        n &= 7;
        int n3 = this.getSlot(string, string.hashCode());
        if (n3 == -1) {
            throw new PropertyException(Context.getMessage("msg.prop.not.found", null));
        }
        this.slots[n3].attributes = (short)n;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parent = scriptable;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototype = scriptable;
    }
}

