/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.configuration.Configuration;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceFactory;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoaderFactory;

public class ResourceManager {
    public static final int RESOURCE_TEMPLATE = 1;
    public static final int RESOURCE_CONTENT = 2;
    private static Hashtable globalCache = new Hashtable();
    private static ArrayList resourceLoaders = new ArrayList();
    private static ArrayList sourceInitializerList = new ArrayList();
    private static Hashtable sourceInitializerMap = new Hashtable();
    private static boolean resourceLoaderInitializersActive = false;

    public static void initialize() throws Exception {
        ResourceManager.assembleResourceLoaderInitializers();
        int i = 0;
        while (i < sourceInitializerList.size()) {
            Configuration configuration = (Configuration)sourceInitializerList.get(i);
            String loaderClass = configuration.getString("class");
            ResourceLoader resourceLoader = ResourceLoaderFactory.getLoader(loaderClass);
            resourceLoader.commonInit(configuration);
            resourceLoader.init(configuration);
            resourceLoaders.add(resourceLoader);
            ++i;
        }
    }

    private static void assembleResourceLoaderInitializers() {
        if (resourceLoaderInitializersActive) {
            return;
        }
        Vector resourceLoaderNames = Runtime.getConfiguration().getVector("resource.loader");
        int i = 0;
        while (i < resourceLoaderNames.size()) {
            String loaderID = resourceLoaderNames.get(i) + "." + "resource.loader";
            Configuration loaderConfiguration = Runtime.getConfiguration().subset(loaderID);
            sourceInitializerList.add(loaderConfiguration);
            ++i;
        }
        resourceLoaderInitializersActive = true;
    }

    public static Resource getResource(String resourceName, int resourceType) throws ResourceNotFoundException, ParseErrorException, Exception {
        Resource resource = null;
        if (globalCache.containsKey(resourceName)) {
            resource = (Resource)globalCache.get(resourceName);
            if (resource.requiresChecking()) {
                resource.touch();
                if (resource.isSourceModified()) {
                    try {
                        long howOldItWas = resource.getResourceLoader().getLastModified(resource);
                        resource.process();
                        resource.setLastModified(howOldItWas);
                    }
                    catch (ResourceNotFoundException rnfe) {
                        Runtime.error("ResourceManager.getResource() exception: " + rnfe);
                        throw rnfe;
                    }
                    catch (ParseErrorException pee) {
                        Runtime.error("ResourceManager.getResource() exception: " + pee);
                        throw pee;
                    }
                    catch (Exception eee) {
                        Runtime.error("ResourceManager.getResource() exception: " + eee);
                        throw eee;
                    }
                }
            }
            return resource;
        }
        try {
            resource = ResourceFactory.getResource(resourceName, resourceType);
            resource.setName(resourceName);
            long howOldItWas = 0L;
            ResourceLoader resourceLoader = null;
            int i = 0;
            while (i < resourceLoaders.size()) {
                resourceLoader = (ResourceLoader)resourceLoaders.get(i);
                resource.setResourceLoader(resourceLoader);
                try {
                    if (resource.process()) {
                        Runtime.info("ResourceManager : found " + resourceName + " with loader " + resourceLoader.getClassName());
                        howOldItWas = resourceLoader.getLastModified(resource);
                        break;
                    }
                }
                catch (ResourceNotFoundException rnfe) {
                    // empty catch block
                }
                ++i;
            }
            if (resource.getData() == null) {
                throw new ResourceNotFoundException("Unable to find resource '" + resourceName + "'");
            }
            resource.setLastModified(howOldItWas);
            resource.setModificationCheckInterval(resourceLoader.getModificationCheckInterval());
            resource.touch();
            if (resourceLoader.isCachingOn()) {
                globalCache.put(resourceName, resource);
            }
        }
        catch (ResourceNotFoundException rnfe2) {
            Runtime.error("ResourceManager : unable to find resource '" + resourceName + "' in any resource loader.");
            throw rnfe2;
        }
        catch (ParseErrorException pee) {
            Runtime.error("ResourceManager.getResource() parse exception: " + pee);
            throw pee;
        }
        catch (Exception ee) {
            Runtime.error("ResourceManager.getResource() exception: " + ee);
            throw ee;
        }
        return resource;
    }
}

