/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;

public class VAJBuildInfo {
    private String vajProjectName = "";
    private String buildFileName = "";
    private Vector projectTargets = new Vector();
    private String target = "";
    private int outputMessageLevel = 2;
    private transient Project project;
    private transient boolean projectInitialized = false;
    protected transient PropertyChangeSupport propertyChange;

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().addPropertyChangeListener(propertyChangeListener);
    }

    public String asDataString() {
        String string = String.valueOf(this.getOutputMessageLevel()) + "|" + this.getBuildFileName() + "|" + this.getTarget();
        Enumeration enumeration = this.getProjectTargets().elements();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + "|" + enumeration.nextElement();
        }
        return string;
    }

    public void executeProject(BuildListener buildListener) {
        Throwable throwable = null;
        try {
            try {
                if (!this.isProjectInitialized()) {
                    this.project = new Project();
                }
                this.project.addBuildListener(buildListener);
                if (!this.isProjectInitialized()) {
                    this.initProject();
                }
                this.project.executeTarget(this.target);
            }
            catch (RuntimeException runtimeException) {
                throwable = runtimeException;
                throw runtimeException;
            }
            catch (Error error) {
                throwable = error;
                throw error;
            }
            Object var4_5 = null;
        }
        catch (Throwable throwable2) {
            Object var4_6 = null;
            this.project.removeBuildListener(buildListener);
            throw throwable2;
        }
        this.project.removeBuildListener(buildListener);
    }

    private static int findTargetPosition(Vector vector, String string) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < vector.size() && n == vector.size()) {
            if (string.compareTo((String)vector.elementAt(n2)) < 0) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChange().firePropertyChange(string, object, object2);
    }

    public String getBuildFileName() {
        return this.buildFileName;
    }

    public int getOutputMessageLevel() {
        return this.outputMessageLevel;
    }

    private Project getProject() {
        return this.project;
    }

    public Vector getProjectTargets() {
        return this.projectTargets;
    }

    protected PropertyChangeSupport getPropertyChange() {
        if (this.propertyChange == null) {
            this.propertyChange = new PropertyChangeSupport(this);
        }
        return this.propertyChange;
    }

    public String getTarget() {
        return this.target;
    }

    public String getVAJProjectName() {
        return this.vajProjectName;
    }

    private void initProject() {
        try {
            this.project.init();
            File file = new File(this.getBuildFileName());
            this.project.setUserProperty("ant.file", file.getAbsolutePath());
            ProjectHelper.configureProject((Project)this.project, (File)file);
            this.setProjectInitialized(true);
        }
        catch (RuntimeException runtimeException) {
            this.setProjectInitialized(false);
            throw runtimeException;
        }
        catch (Error error) {
            this.setProjectInitialized(false);
            throw error;
        }
    }

    public boolean isProjectInitialized() {
        return this.projectInitialized;
    }

    public static VAJBuildInfo parse(String string) {
        VAJBuildInfo vAJBuildInfo = new VAJBuildInfo();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            vAJBuildInfo.setOutputMessageLevel(stringTokenizer.nextToken());
            vAJBuildInfo.setBuildFileName(stringTokenizer.nextToken());
            vAJBuildInfo.setTarget(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                vAJBuildInfo.projectTargets.addElement(stringTokenizer.nextToken());
            }
        }
        catch (Throwable throwable) {}
        return vAJBuildInfo;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChange().removePropertyChangeListener(propertyChangeListener);
    }

    public void setBuildFileName(String string) {
        String string2 = this.buildFileName;
        this.buildFileName = string;
        this.setProjectInitialized(false);
        this.firePropertyChange("buildFileName", string2, this.buildFileName);
    }

    public void setOutputMessageLevel(int n) {
        int n2 = this.outputMessageLevel;
        this.outputMessageLevel = n;
        this.firePropertyChange("outputMessageLevel", new Integer(n2), new Integer(this.outputMessageLevel));
    }

    private void setOutputMessageLevel(String string) {
        int n = Integer.parseInt(string);
        this.setOutputMessageLevel(n);
    }

    private void setProjectInitialized(boolean bl) {
        Boolean bl2 = new Boolean(this.projectInitialized);
        this.projectInitialized = bl;
        this.firePropertyChange("projectInitialized", bl2, new Boolean(this.projectInitialized));
    }

    public void setTarget(String string) {
        String string2 = this.target;
        this.target = string;
        this.firePropertyChange("target", string2, this.target);
    }

    public void setVAJProjectName(String string) {
        String string2 = this.vajProjectName;
        this.vajProjectName = string;
        this.firePropertyChange("VAJProjectName", string2, this.vajProjectName);
    }

    public void updateTargetList() {
        this.project = new Project();
        this.initProject();
        this.projectTargets.removeAllElements();
        Enumeration enumeration = this.project.getTargets().elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            if (target.getDescription() == null) continue;
            String string = target.getName();
            int n = VAJBuildInfo.findTargetPosition(this.projectTargets, string);
            this.projectTargets.insertElementAt(string, n);
        }
    }
}

