/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.ejb.EJBDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.WeblogicDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.WeblogicTOPLinkDeploymentTool;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.xml.sax.SAXException;

public class EjbJar
extends MatchingTask {
    private Config config = new Config();
    private File destDir;
    private String genericJarSuffix = "-generic.jar";
    private ArrayList deploymentTools = new ArrayList();

    public WeblogicDeploymentTool createWeblogic() {
        WeblogicDeploymentTool weblogicDeploymentTool = new WeblogicDeploymentTool();
        weblogicDeploymentTool.setTask((Task)this);
        this.deploymentTools.add(weblogicDeploymentTool);
        return weblogicDeploymentTool;
    }

    public WeblogicTOPLinkDeploymentTool createWeblogictoplink() {
        WeblogicTOPLinkDeploymentTool weblogicTOPLinkDeploymentTool = new WeblogicTOPLinkDeploymentTool();
        weblogicTOPLinkDeploymentTool.setTask((Task)this);
        this.deploymentTools.add(weblogicTOPLinkDeploymentTool);
        return weblogicTOPLinkDeploymentTool;
    }

    public Path createClasspath() {
        if (this.config.classpath == null) {
            this.config.classpath = new Path(((Task)this).project);
        }
        return this.config.classpath.createPath();
    }

    public DTDLocation createDTD() {
        DTDLocation dTDLocation = new DTDLocation();
        this.config.dtdLocations.add(dTDLocation);
        return dTDLocation;
    }

    public FileSet createSupport() {
        FileSet fileSet = new FileSet();
        this.config.supportFileSets.add(fileSet);
        return fileSet;
    }

    public void setSrcdir(File file) {
        this.config.srcDir = file;
    }

    public void setDescriptordir(File file) {
        this.config.descriptorDir = file;
    }

    public void setBasejarname(String string) {
        this.config.baseJarName = string;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setClasspath(Path path) {
        this.config.classpath = path;
    }

    public void setFlatdestdir(boolean bl) {
        this.config.flatDestDir = bl;
    }

    public void setGenericjarsuffix(String string) {
        this.genericJarSuffix = string;
    }

    public void setBasenameterminator(String string) {
        this.config.baseNameTerminator = string;
    }

    private void validateConfig() {
        if (this.config.srcDir == null) {
            throw new BuildException("The srcDir attribute must be specified");
        }
        if (this.config.descriptorDir == null) {
            this.config.descriptorDir = this.config.srcDir;
        }
    }

    public void execute() throws BuildException {
        Object object;
        Object object2;
        this.validateConfig();
        if (this.deploymentTools.size() == 0) {
            object2 = new GenericDeploymentTool();
            ((GenericDeploymentTool)object2).setTask((Task)this);
            ((GenericDeploymentTool)object2).setDestdir(this.destDir);
            ((GenericDeploymentTool)object2).setGenericJarSuffix(this.genericJarSuffix);
            this.deploymentTools.add(object2);
        }
        object2 = ((AbstractList)this.deploymentTools).iterator();
        while (object2.hasNext()) {
            object = (EJBDeploymentTool)object2.next();
            object.configure(this.config);
            object.validateConfigured();
        }
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setValidating(true);
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            DirectoryScanner directoryScanner = this.getDirectoryScanner(this.config.descriptorDir);
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            this.log(stringArray.length + " deployment descriptors located.", 3);
            int n = 0;
            while (n < stringArray.length) {
                Iterator iterator = ((AbstractList)this.deploymentTools).iterator();
                while (iterator.hasNext()) {
                    EJBDeploymentTool eJBDeploymentTool = (EJBDeploymentTool)iterator.next();
                    eJBDeploymentTool.processDescriptor(stringArray[n], sAXParser);
                }
                ++n;
            }
        }
        catch (SAXException sAXException) {
            String string = "SAXException while creating parser.  Details: " + sAXException.getMessage();
            throw new BuildException(string, (Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "ParserConfigurationException while creating parser. Details: " + parserConfigurationException.getMessage();
            throw new BuildException(string, (Throwable)parserConfigurationException);
        }
    }

    static class Config {
        public File srcDir;
        public File descriptorDir;
        public String baseNameTerminator = "-";
        public String baseJarName;
        public boolean flatDestDir = false;
        public Path classpath;
        public List supportFileSets = new ArrayList();
        public ArrayList dtdLocations = new ArrayList();

        Config() {
        }
    }

    public static class DTDLocation {
        private String publicId;
        private String location;

        public void setPublicId(String string) {
            this.publicId = string;
        }

        public void setLocation(String string) {
            this.location = string;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getLocation() {
            return this.location;
        }
    }
}

