/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.turbine.util.Log;

public class DBConnection {
    private Connection connection = null;
    private String url = null;
    private long timestamp;

    protected DBConnection(Connection connection, String url) {
        this.connection = connection;
        this.url = url;
        this.timestamp = System.currentTimeMillis();
    }

    public void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
    }

    public Statement createStatement() {
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
        return stmt;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUrl() {
        return this.url;
    }

    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
    }

    public void setAutoCommit(boolean b) {
        try {
            this.connection.setAutoCommit(b);
        }
        catch (SQLException e) {
            e.printStackTrace();
            Log.error(e);
        }
    }
}

