/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSPResponseLibrary {
    public static void addDateHeader(HttpServletResponse response, String name, long date) {
        response.addDateHeader(name, date);
    }

    public static void addDateHeader(HttpServletResponse response, String name, String date) throws ParseException {
        XSPResponseLibrary.addDateHeader(response, name, date, DateFormat.getDateInstance());
    }

    public static void addDateHeader(HttpServletResponse response, String name, String date, String format) throws ParseException {
        XSPResponseLibrary.addDateHeader(response, name, date, new SimpleDateFormat(format));
    }

    public static void addDateHeader(HttpServletResponse response, String name, String date, DateFormat format) throws ParseException {
        response.addDateHeader(name, format.parse(date).getTime());
    }

    public static void addDateHeader(HttpServletResponse response, String name, Date date) {
        response.addDateHeader(name, date.getTime());
    }

    public static Element containsHeader(HttpServletResponse response, String name, Document document) {
        Element element = document.createElement("response:contains-header");
        element.appendChild(document.createTextNode(String.valueOf(response.containsHeader(name))));
        return element;
    }

    public static Element encodeRedirectURL(HttpServletResponse response, String url, Document document) {
        Element element = document.createElement("response:encode-redirect-url");
        element.appendChild(document.createTextNode(response.encodeRedirectUrl(url)));
        return element;
    }

    public static Element encodeURL(HttpServletResponse response, String url, Document document) {
        Element element = document.createElement("response:encode-url");
        element.appendChild(document.createTextNode(response.encodeUrl(url)));
        return element;
    }

    public static Element getCharacterEncoding(HttpServletResponse response, Document document) {
        Element element = document.createElement("response:get-character-encoding");
        element.appendChild(document.createTextNode(response.getCharacterEncoding()));
        return element;
    }

    public static Element getLocale(HttpServletResponse response, Document document) {
        Element property = null;
        Locale locale = response.getLocale();
        Element element = document.createElement("response:locale");
        property = document.createElement("locale:language");
        property.appendChild(document.createTextNode(locale.getLanguage()));
        element.appendChild(property);
        property = document.createElement("locale:country");
        property.appendChild(document.createTextNode(locale.getCountry()));
        element.appendChild(property);
        property = document.createElement("locale:variant");
        property.appendChild(document.createTextNode(locale.getVariant()));
        element.appendChild(property);
        return element;
    }

    public static void setDateHeader(HttpServletResponse response, String name, long date) {
        response.setDateHeader(name, date);
    }

    public static void setDateHeader(HttpServletResponse response, String name, String date) throws ParseException {
        XSPResponseLibrary.setDateHeader(response, name, date, DateFormat.getDateInstance());
    }

    public static void setDateHeader(HttpServletResponse response, String name, String date, String format) throws ParseException {
        XSPResponseLibrary.setDateHeader(response, name, date, new SimpleDateFormat(format));
    }

    public static void setDateHeader(HttpServletResponse response, String name, String date, DateFormat format) throws ParseException {
        response.setDateHeader(name, format.parse(date).getTime());
    }

    public static void setDateHeader(HttpServletResponse response, String name, Date date) {
        response.setDateHeader(name, date.getTime());
    }
}

