/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.framework;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.cocoon.framework.Actor;
import org.apache.cocoon.framework.Configurable;
import org.apache.cocoon.framework.Configurations;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.framework.Factory;

public class Manager
extends Hashtable
implements Actor,
Factory,
Director {
    private ClassLoader classloader;

    public Object create(String name) {
        return this.create(name, null);
    }

    public Object create(String name, Configurations conf) throws RuntimeException {
        try {
            Object object = null;
            ClassLoader cl = this.getClass().getClassLoader();
            object = cl != null ? cl.loadClass(name).newInstance() : Class.forName(name).newInstance();
            if (object instanceof Actor) {
                ((Actor)object).init(this);
            }
            if (object instanceof Configurable && conf != null) {
                ((Configurable)object).init(conf);
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Error creating " + name + ": class is not found");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Error creating " + name + ": does not have access");
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error creating " + name + ": could not instantiate " + e.getMessage());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Error creating " + name + ": make sure the needed classes can be found in the classpath (" + e.getMessage() + ")");
        }
        catch (Throwable e) {
            throw new RuntimeException("Factory error:  unknown exception creating \" " + name + "\" : " + e);
        }
    }

    public Vector create(Vector names) {
        return this.create(names, null);
    }

    public Vector create(Vector names, Configurations conf) {
        Vector<Object> v = new Vector<Object>(names.size());
        Enumeration e = names.elements();
        while (e.hasMoreElements()) {
            v.addElement(this.create((String)e.nextElement(), conf));
        }
        return v;
    }

    public Object getActor(String role) {
        return this.get(role);
    }

    public Enumeration getRoles() {
        return this.keys();
    }

    public void init(Director director) {
        this.classloader = this.getClass().getClassLoader();
    }

    public void setRole(String role, Object actor) {
        this.put(role, actor);
    }
}

