/***************************************************************************
    messages.cpp

    This file is part of the CBE Dictionary package

    Copyright (c) 2001 Antoby - antoby@mail.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


    $Id: messages.cpp,v 1.3 2001/06/20 15:48:06 bbi Exp $

****************************************************************************/


#include <stdlib.h>
#include <stdio.h>

#include "messages.h"


struct lang_elem {
    char *name;
    char **msgs;
};

char *bg1251_msgs[] = {
    "",
    "",
    " ",
    "  ",
    "  ",
    "  HTML",
    "   ",
    "EN->BG ",
    "BG->EN ",
    "    ",
    "    ",
    "    ",
    "       ",
    "        EN->BG ",
    "        BG->EN ",
    "   ",
    "   .",
    ".",
    NULL
};

char *bglatin_msgs[] = {
    "ne",
    "da",
    "Razdeleni znacheniq",
    "Wywejdane na latinica",
    "Izwejdane na latinica",
    "Izwejdane w HTML",
    "Tochno sywpadenie na dumata",
    "EN->BG baza",
    "BG->EN baza",
    "Koj parametyr jelaete da promenite",
    "Zapis na parametrite i izhod",
    "Izhod bez zapiswane na parametrite",
    "Molq naprawete izbor w ramkite na izbroenite wyzmojnosti",
    "Wywedete pylniqt pyt i imeto na fajla sydyrjasht EN-<BG bazata",
    "Wywedete pylniqt pyt i imeto na fajla sydyrjasht BG->EN bazata",
    "Startirane w interaktiwen rejim",
    "Konfiguracionniqt file zapisan uspeshno",
    "Izhod.",
    NULL
};

char *bgkoi8r_msgs[] = {
    "",
    "",
    " ",
    "  ",
    "  ",
    "  HTML",
    "   ",
    "EN->BG ",
    "BG->EN ",
    "    ",
    "    ",
    "    ",
    "       ",
    "        EN->BG ",
    "        BG->EN ",
    "   ",
    "   .",
    ".",
    NULL
};

char *en_msgs[] = {
    "no",
    "yes",
    "Separated meanings",
    "Latin input",
    "Latin output",
    "HTML output",
    "Exact match",
    "EN-BG database",
    "BG->EN database",
    "Which parameter would you like to change",
    "Save the parameters and quit",
    "Quit without saving the parameters",
    "Please make your choise in the listed options",
    "Enter the full path and filename of the EN->BG database",
    "Enter the full path and filename of the BG->EN database",
    "Start in interactive mode",
    "Configuration file saved successfully.",
    "Quitting.",
    NULL
};


struct lang_elem lang[] = {
    { "Bulgarian (cp1251)",	bg1251_msgs },
    { "Bulgarian (latin)",	bglatin_msgs },
    { "Bulgarian (koi8r)",	bgkoi8r_msgs },
    { "English",		en_msgs },
    { NULL, NULL }
};


char **select_language(void)
{
    int lang_number = sizeof(lang)/sizeof(lang[0]);
    int lang_idx, i;

    do {
        lang_idx = 1;
        printf("Available languages (1-%d):\n", lang_number-1);
        for(i=0; lang[i].name; i++){
            printf("%d) %s\n", i+1, lang[i].name);
        }
        printf("select language: ");
        fflush(stdin);
        scanf("%d", &lang_idx);
    } while( (lang_idx < 1) || (lang_idx >= lang_number) );

    return lang[lang_idx-1].msgs;
}
